# TW Core Immunization - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Immunization 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreImmunization |

 
此臺灣核心-疫苗接種 (TW Core Immunization) Profile 說明本 IG 如何進一步定義 FHIR 的 Immunization Resource 以呈現疫苗接種資料。 

**Usages:**

* Refer to this Profile: [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md), [TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md), [TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md)...Show 12 more,[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)and[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)
* Examples for this Profile: [Immunization/imm-example](Immunization-imm-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Immunization-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Immunization-twcore.csv), [Excel](StructureDefinition-Immunization-twcore.xlsx), [Schematron](StructureDefinition-Immunization-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Immunization-patient.md)**查詢所有Immunization：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Immunization?patient={Type/}[id]`例子：
(1) GET [base]/Immunization?patient=Patient/pat-example

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Immunization-patient.md)**及**[`date`](SearchParameter-Immunization-date.md)**查詢所有Immunization：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Immunization?patient={Type/}[id]&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Immunization?patient=Patient/pat-example&date=ge2024-08-31T00:00:00Z
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Immunization-patient.md)**及**[`status`](SearchParameter-Immunization-status.md)**查詢所有Immunization：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Immunization?patient={Type/}[id]&status={system|}[code]`例子：
(1) GET [base]/Immunization?patient=Patient/pat-example&status=completed



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Immunization-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreImmunization",
  "title" : "TW Core Immunization",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-疫苗接種 (TW Core Immunization) Profile 說明本 IG 如何進一步定義 FHIR 的 Immunization Resource 以呈現疫苗接種資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization",
        "short" : "疫苗接種",
        "definition" : "疫苗接種的記錄，包含接種的疫苗及事件的相關資訊。",
        "constraint" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice",
                "valueBoolean" : true
              }
            ],
            "key" : "tw-core-10",
            "severity" : "warning",
            "human" : "SHOULD have a translation to the NDC value set",
            "expression" : "vaccineCode.coding.where(system='http://hl7.org/fhir/sid/cvx').exists() implies vaccineCode.coding.where(system='http://hl7.org/fhir/sid/ndc').exists()",
            "xpath" : "(exists(f:vaccineCode/f:coding/f:system[@value='http://hl7.org/fhir/sid/ndc']) and exists(f:vaccineCode/f:coding/f:system[@value='http://hl7.org/fhir/sid/cvx'])) or exists(f:vaccineCode/f:coding/f:system[@value='http://hl7.org/fhir/sid/cvx'])not()",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Immunization.implicitRules",
        "path" : "Immunization.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建 resource 時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對 IG 所定義之特殊規則及其他 profiles 的參照。"
      },
      {
        "id" : "Immunization.modifierExtension",
        "path" : "Immunization.modifierExtension",
        "short" : "擴充內容可能會改變資源解釋方式",
        "definition" : "可以修改標準資源解釋的擴充內容。擴展內容通常會增加其他屬性，但不會更改基本解釋。在理解修改擴展內容之前不應該解釋此疫苗接種資源。"
      },
      {
        "id" : "Immunization.status",
        "path" : "Immunization.status",
        "definition" : "疫苗接種事件的狀態，表示是否完成接種、記錄有誤或未接種。",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.statusReason",
        "path" : "Immunization.statusReason",
        "short" : "接種未完成的原因",
        "definition" : "表示為什麼疫苗接種未完成的原因，例如：禁忌症、病患拒絕等。",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.vaccineCode",
        "path" : "Immunization.vaccineCode",
        "short" : "疫苗產品類型 (綁定到 CVX 疫苗代碼系統)",
        "definition" : "用於識別施打的疫苗種類或類型。",
        "condition" : ["tw-core-10"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/vaccine-code"
        }
      },
      {
        "id" : "Immunization.patient",
        "path" : "Immunization.patient",
        "short" : "接種疫苗的病患",
        "definition" : "接受疫苗接種的患者參照。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.encounter",
        "path" : "Immunization.encounter",
        "short" : "與疫苗接種相關的就醫事件",
        "definition" : "表示疫苗接種發生時的就醫事件參照。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.occurrence[x]",
        "path" : "Immunization.occurrence[x]",
        "short" : "疫苗接種的發生日期/時間",
        "definition" : "疫苗接種發生的日期與時間，或以字串描述的大概時間。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.primarySource",
        "path" : "Immunization.primarySource",
        "short" : "資料來源是否為主要來源",
        "definition" : "指示記錄的資訊是否來自主要來源 (如接種疫苗的人員)，或是從次要來源 (如病患本人回報) 取得。",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.location",
        "path" : "Immunization.location",
        "short" : "疫苗接種的地點",
        "definition" : "進行疫苗接種的實際地點，如醫療院所、診所等。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.manufacturer",
        "path" : "Immunization.manufacturer",
        "short" : "疫苗製造商",
        "definition" : "疫苗製造商的參照。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.performer.actor",
        "path" : "Immunization.performer.actor",
        "short" : "執行疫苗接種的人員或組織",
        "definition" : "參與疫苗接種的醫療人員、醫療人員角色或組織的參照。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.reasonReference",
        "path" : "Immunization.reasonReference",
        "short" : "接種疫苗的原因",
        "definition" : "進行此次疫苗接種的醫療原因參照，例如：特定疾病、臨床觀察或診斷報告。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.isSubpotent",
        "path" : "Immunization.isSubpotent",
        "short" : "疫苗效價是否低於標準",
        "definition" : "表明接種的疫苗劑量是否已知低於建議量的標示，例如：部分劑量因患者移動而造成施打不完整、或完整劑量分成多次施打。",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.reaction.detail",
        "path" : "Immunization.reaction.detail",
        "short" : "接種後反應的細節",
        "definition" : "疫苗接種後發生的不良反應參照，例如：過敏反應、發燒等臨床結果觀察。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.protocolApplied.authority",
        "path" : "Immunization.protocolApplied.authority",
        "short" : "疫苗接種計劃的權責組織",
        "definition" : "提供或授權此疫苗接種計劃的組織參照。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
