# TW Core ImagingStudy - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core ImagingStudy 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreImagingStudy |

 
此臺灣核心-影像檢查（TW Core ImagingStudy） Profile說明本IG如何進一步定義FHIR的ImagingStudy Resource以呈現影像檢查的詳細資料。 

## Resource ImagingStudy - 內容

在DICOM影像檢查（study）中，我們會產生一至多個系列（`series`）的影像或資料。每一個「`series`」包含一組特定的影像或資料，這些都是在相同的條件下收集的，都專屬於一種造影儀器，比如X光、CT、MR或超音波。這就意味著在一次影像檢查中，我們可以從多種不同的造影儀器取得資訊，每種儀器提供的影像或資料組成一個`series`。因此，一次影像檢查可能包含多個`serie`，每個`series`展示了從一種特定儀器得到的視角或資訊，共同構成了對病人狀態的全面了解。

每個`series`由多個SOP實例（Service-Object Pair instances）」組成，這些SOP實例共同描述了某一部分的檢查或治療過程。它是DICOM標準中最基本的資料單元。每個SOP實例代表一個具體的影像或資料項目，例如一張CT掃描影像或一個檢查報告。它們是在某個特定`series`下被創建和管理的，每個實例都有唯一的標識符（Unique Identifiers，UID）以便於存取和參照。

因此，SOP實例與其所屬的`series`之間是隸屬關係，即一組SOP實例屬於特定的`series`，這些`series`再進一步組成整個影像檢查的完整畫面。透過這樣的結構，DICOM確保醫療影像資料的有序性及易於管理的特性。

### 範圍與使用

ImagingStudy是一種用來提供DICOM影像檢查相關資訊的工具，它包含了檢查中的每一組系列（`series`）和影像物件。這個工具還告訴我們怎麼去取得這些資料，不管是以原本的DICOM格式，還是轉換成其他格式，比如JPEG圖片。簡而言之，ImagingStudy幫助我們獲取和了解一次完整影像檢查的所有細節，讓這些資訊變得可用。

這個resource就像是一本字典，幫助我們理解DICOM影像檢查中的資料項目與DICOM屬性之間的關聯。每一個DICOM屬性都有一個特殊的標籤，這個標籤用一串特定的數字和字母來表示，比如（0008,103E）。如果你想知道每一個屬性代表什麼，以及它的數據類型是什麼，你可以在[DICOM第6部分資料字典](http://medical.nema.org/medical/dicom/current/output/html/part06.html)中找到答案。更詳細地關於這些屬性如何在影像資訊中被使用的說明，可以在[DICOM第3部分資訊物件定義](http://medical.nema.org/medical/dicom/current/output/html/part03.html)裡找到。 想像我們有一個DICOM屬性叫做「影像標題」，在DICOM中，它有一個特定的標籤（0008,103E），它可以存放的資料類型是文字。這個「影像標題」屬性是如何被使用的呢？在一次DICOM影像檢查中，每一個影像都可以有一個標題，用來描述該影像的內容或者是拍攝的具體情況。比如一個胸部X光的影像標題可能是「胸部正位」。這個標題幫助醫生快速了解影像的關鍵信息，而不需要打開影像就能得知一些基本情況。 而一些在DICOM查詢中特別用到的屬性，像是「影像檢查中的實例數量」，則在[DICOM第4部分附錄C](http://medical.nema.org/medical/dicom/current/output/html/part04.html#chapter_C)中有說明。

ImagingStudy的作用是讓我們能夠方便地獲取DICOM影像檢查中重要的資訊，這種情況只適用於非常簡單的案例，它並不能完全取代所有的DICOM查詢功能，比如QIDO-RS。QIDO-RS（Query based on ID for DICOM Objects by RESTful Services）是一種基於RESTful服務的DICOM標準查詢協議，它讓我們能夠透過網路，以一種簡單且標準化的方式，查詢DICOM伺服器上存儲的影像檢查資料。要注意的是：DICOM的影像或資料並不直接儲存在ImagingStudy resource裡，如果需要存取這些影像或資料，還是要透過DICOM WADO-RS服務器或其他的存儲方式。

簡單來說，一個ImagingStudy會對應到一次DICOM影像檢查，可能只包含該檢查的一部分資料。有時，多個ImagingStudy可能會參照同一次DICOM影像檢查，或者是該檢查的不同部分。

### 界限與關聯

TW Core IG繼承FHIR R4版，ImagingStudy用於DICOM影像及相關資訊的管理。對於非DICOM的影像、影片或音檔，則使用[Media](StructureDefinition-Media-twcore.md) resource來追踪、[Binary](https://hl7.org/fhir/R4/binary.html)resource可用於儲存任意內容、[DocumentReference](StructureDefinition-DocumentReference-twcore.md)允許對具有相關metadata的臨床「文件（document）」進行索引和查詢。

FHIR R4版中ImagingStudy resource被[ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)、[ClinicalImpression](https://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)、[DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)和[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)參照。

**未來若有FHIR版本異動規畫的實作者可能須留意，FHIR R5版中已無Media resource，對於有相關metadata的非DICOM影像、影片及音檔使用[DocumentReference](StructureDefinition-DocumentReference-twcore.md)resource、使用[Binary](https://hl7.org/fhir/r4/binary.html)resource於儲存任意內容、並使用[ImagingSelection](https://hl7.org/fhir/r5/imagingselection.html)resource來存儲特定一組DICOM影像、影格或其他DICOM實例的參照。**

**Usages:**

* Refer to this Profile: [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md), [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md), [TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md)...Show 16 more,[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)and[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)
* Examples for this Profile: [ImagingStudy/img-ct-example](ImagingStudy-img-ct-example.md), [ImagingStudy/img-example](ImagingStudy-img-example.md), [ImagingStudy/img-mr-example](ImagingStudy-img-mr-example.md), [ImagingStudy/img-pet-example](ImagingStudy-img-pet-example.md) and [ImagingStudy/img-sm-example](ImagingStudy-img-sm-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/ImagingStudy-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ImagingStudy-twcore.csv), [Excel](StructureDefinition-ImagingStudy-twcore.xlsx), [Schematron](StructureDefinition-ImagingStudy-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-ImagingStudy-id.md)**查詢所有ImagingStudy：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/ImagingStudy?_id=[id]`
`GET [base]/ImagingStudy/[id]`例子：
(1) GET [base]/ImagingStudy?_id=img-example
(2) GET [base]/ImagingStudy/img-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-ImagingStudy-status.md)**查詢所有ImagingStudy：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/ImagingStudy?status=[code]`例子：
(1) GET [base]/ImagingStudy?status=available
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-ImagingStudy-subject.md)**查詢所有ImagingStudy：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/ImagingStudy?subject={Type/}[id]`例子：:
(1) GET [base]/ImagingStudy?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`encounter`](SearchParameter-ImagingStudy-encounter.md)**查詢所有ImagingStudy：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/ImagingStudy?encounter={Type/}[id]`例子：:
(1) GET [base]/ImagingStudy?encounter=Encounter/enc-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`started`](SearchParameter-ImagingStudy-started.md)**查詢所有ImagingStudy：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/ImagingStudy?started={gt|lt|ge|le}[date]`例子：
(1) GET [base]/ImagingStudy?started=gt2022-08-01



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImagingStudy-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreImagingStudy",
  "title" : "TW Core ImagingStudy",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-影像檢查（TW Core ImagingStudy） Profile說明本IG如何進一步定義FHIR的ImagingStudy Resource以呈現影像檢查的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ImagingStudy",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ImagingStudy",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ImagingStudy",
        "path" : "ImagingStudy",
        "short" : "在單一檢查中產生的一組影像【一個或多個系列(series)的參照影像】",
        "definition" : "DICOM影像檢查中產生的內容。每項檢查包含若干系列(series)，每一系列只使用一種影像儀器（例如X光、電腦斷層掃描CT、核磁共振MR、超音波等），每個系列由在相同背景下獲得或製作的服務-物件對實例（Service-Object Pair Instances，簡稱SOP實例，包含影像或其他類型的資料）所組成。但一項檢查中可能包括多個使用不同影像儀器的系列。"
      },
      {
        "id" : "ImagingStudy.id",
        "path" : "ImagingStudy.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的ImagingStudy紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "ImagingStudy.meta",
        "path" : "ImagingStudy.meta",
        "short" : "此ImagingStudy Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "ImagingStudy.implicitRules",
        "path" : "ImagingStudy.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "ImagingStudy.language",
        "path" : "ImagingStudy.language",
        "short" : "用以表述ImagingStudy Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "ImagingStudy.text",
        "path" : "ImagingStudy.text",
        "short" : "ImagingStudy Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "ImagingStudy.identifier",
        "path" : "ImagingStudy.identifier",
        "short" : "整項影像檢查的識別碼",
        "definition" : "ImagingStudy的識別碼，如DICOM檢查實例UID (Study Instance UID)和檢查單號(Accession Number)。",
        "comment" : "有關DICOM檢查實例UID的編碼，請參閱「影像檢查實作說明(Imaging Study Implementation Notes)」下的討論。檢查單號(Accession Number)應使用ACSN識別碼類型 (Identifier type)。",
        "requirements" : "如果此 ImagingStudy 中存在一個或多個 series 資料項目，那麼就應該有一個DICOM Study UID識別碼（見[DICOM PS 3.3 C.7.2 .](https://dicom.nema.org/medical/dicom/current/output/chtml/part03/sect_C.7.2.html)",
        "mustSupport" : true
      },
      {
        "id" : "ImagingStudy.status",
        "path" : "ImagingStudy.status",
        "definition" : "影像檢查的當前狀態。",
        "comment" : "「未知」並不意味著「其他」類型；必須符合已確定的某種狀態。當創建系統不確定當前狀態時，會使用「未知」這一選項。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ImagingStudyStatus"
            }
          ],
          "strength" : "required",
          "description" : "影像檢查的當前狀態；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/imagingstudy-status|4.0.1"
        }
      },
      {
        "id" : "ImagingStudy.modality",
        "path" : "ImagingStudy.modality",
        "short" : "列出所有系列中用於實際影像獲取的儀器類型",
        "definition" : "列出所有系列中用於實際影像獲取的儀器類型，即在DICOM Context Group 29（值集的唯一識別碼為1.2.840.10008.6.1.19）中定義的類型。",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/AcquisitionModality"
        }
      },
      {
        "id" : "ImagingStudy.subject",
        "path" : "ImagingStudy.subject",
        "short" : "誰或什麼是影像檢查的對象",
        "definition" : "影像檢查的對象，通常是病人。",
        "comment" : "影像檢查的對象，若為品質保證的標準對照物（QA幻影）可用 Device 作記錄。若其檢查對象是多隻小動物（如多隻老鼠），則可以將它們作為 Group 來進行記錄。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ImagingStudy.encounter",
        "path" : "ImagingStudy.encounter",
        "short" : "與此影像檢查有關的就醫事件(Encounter)",
        "definition" : "進行此影像檢查的健康照護事件（例如：病人與健康照護服務提供者的互動）。",
        "comment" : "病人接受影像檢查時所在的就醫情境。不過，有些相關事件可能在病人就醫前或完成就醫後發生，但這些事件仍與就醫情境有關（例如：病人入院前的檢查）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.started",
        "path" : "ImagingStudy.started",
        "short" : "影像檢查何時開始",
        "definition" : "檢查開始的日期和時間",
        "mustSupport" : true
      },
      {
        "id" : "ImagingStudy.basedOn",
        "path" : "ImagingStudy.basedOn",
        "short" : "要求執行此影像檢查的依據",
        "definition" : "導致進行此影像檢查的診斷報告清單",
        "requirements" : "支援分組處置（一項影像檢查支援多個醫令處置，如胸腔/腹部/骨盆CT）。"
      },
      {
        "id" : "ImagingStudy.referrer",
        "path" : "ImagingStudy.referrer",
        "short" : "轉診醫師",
        "definition" : "請求/轉診的醫師",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.interpreter",
        "path" : "ImagingStudy.interpreter",
        "short" : "誰解讀了影像",
        "definition" : "誰閱讀了檢查報告並解讀了影像或其他內容",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.endpoint",
        "path" : "ImagingStudy.endpoint",
        "short" : "影像檢查存取的端點(endpoint)",
        "definition" : "提供影像檢查資料存取的網路服務，包括查詢、觀看或下載影像檢查資料。更多有關如何使用DICOM端點的詳細資訊，請查看實作指引。整體檢查的網絡連接設定（端點）適用於檢查中的每一個影像系列。但如果某個影像系列有自己特定的網路連接設定(稱為系統端點)，且這個設定的類型（Endpoint.connectionType）與整體檢查的端點相同，則該系列將依據其自身的設定進行連接。",
        "comment" : "常見的端點類型包括：DICOM WADO-RS，它透過RESTful API以原始或轉換後的格式（如JPG、PNG）來查DICOM影像檔案；DICOM WADO-URI，這也能查詢原始或轉換後的影像，但它是透過HTTP查詢方式實現；DICOM QIDO-RS，它允許使用RESTful查詢方式來獲取DICOM資訊，而無需下載影像檔案本身；還有IHE Invoke Image Display（IID），這是一種標準的網路影像查看器(viewer)啟動方式。",
        "requirements" : "說明了如何查看（例如：使用IHE的IID profile）或查詢（例如：使用DICOM的WADO-URI和WADO-RS）影像檢查、其影像系列或單個影像的方法。整體檢查的基礎位置設定（baseLocation）通常適用於檢查中的所有影像系列。但如果某個影像系列有自己的基礎位置設定（稱為系列級baseLocation），且這個設定與整體檢查的設定類型相同，則該系列將按照自己的設定進行操作。"
      },
      {
        "id" : "ImagingStudy.numberOfSeries",
        "path" : "ImagingStudy.numberOfSeries",
        "short" : "影像檢查相關Series的數量",
        "definition" : "在醫學影像檢查中，顯示的series數量有時會比Resource實際包含的更多。這可能是由於Resource的限制、安全問題或其他因素所致。如果Resource中包含至少一個series的資料項目，那麼這個series數量就應當被明確標出。"
      },
      {
        "id" : "ImagingStudy.numberOfInstances",
        "path" : "ImagingStudy.numberOfInstances",
        "short" : "影像檢查相關Instances的數量",
        "definition" : "在醫學影像檢查中，顯示的SOP instances數量有時會比Resource實際包含的更多。這可能是由於instance的限制、安全問題或其他因素所致。如果Resource中包含至少一個instance的資料項目，那麼這個資料項目就應該被包含在內。"
      },
      {
        "id" : "ImagingStudy.procedureReference",
        "path" : "ImagingStudy.procedureReference",
        "short" : "所執行的處置(Procedure)參照",
        "definition" : "此影像檢查是此處置(Procedure)的一部分",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.procedureCode",
        "path" : "ImagingStudy.procedureCode",
        "short" : "執行的處置代碼",
        "definition" : "執行的處置類型代碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ImagingProcedureCode"
            }
          ],
          "strength" : "extensible",
          "description" : "此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
          "valueSet" : "http://www.rsna.org/RadLex_Playbook.aspx"
        }
      },
      {
        "id" : "ImagingStudy.procedureCode.coding",
        "path" : "ImagingStudy.procedureCode.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。"
      },
      {
        "id" : "ImagingStudy.procedureCode.coding:radLex-radiology-lexicon",
        "path" : "ImagingStudy.procedureCode.coding",
        "sliceName" : "radLex-radiology-lexicon",
        "short" : "應填入所綁定值集中的其中一個代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://www.rsna.org/RadLex_Playbook.aspx"
        }
      },
      {
        "id" : "ImagingStudy.procedureCode.coding:icd10-pcs-2021",
        "path" : "ImagingStudy.procedureCode.coding",
        "sliceName" : "icd10-pcs-2021",
        "short" : "此為臺灣健保署2021年中文版ICD-10-PCS，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2021-tw"
        }
      },
      {
        "id" : "ImagingStudy.procedureCode.coding:icd10-pcs-2023",
        "path" : "ImagingStudy.procedureCode.coding",
        "sliceName" : "icd10-pcs-2023",
        "short" : "此為臺灣健保署2023年中文版ICD-10-PCS，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2023-tw"
        }
      },
      {
        "id" : "ImagingStudy.location",
        "path" : "ImagingStudy.location",
        "short" : "影像檢查發生的地點",
        "definition" : "進行影像檢查的主要實體地點",
        "requirements" : "將事件與可能保存記錄的地點相關聯，並提供圍繞事件發生的背景資訊（例如：事件是發生在專門的醫療環境內或外）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.reasonCode",
        "path" : "ImagingStudy.reasonCode",
        "short" : "為什麼進行此影像檢查",
        "definition" : "說明為什麼要求進行影像檢查的臨床情況",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-reason"
        }
      },
      {
        "id" : "ImagingStudy.reasonReference",
        "path" : "ImagingStudy.reasonReference",
        "short" : "為什麼進行此影像檢查",
        "definition" : "這表示有另外一個Resource，其存在是進行這項檢查的合理原因。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore",
              "http://hl7.org/fhir/StructureDefinition/Media",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.note",
        "path" : "ImagingStudy.note",
        "short" : "用戶自定義的評論",
        "definition" : "按照建議的DICOM對應關係，這個資料項目是來自影像檢查描述屬性（0008,1030）。有關影像檢查的觀察或發現應該記錄在別的Resource裡，比如說Observation，而不是在這個資料項目。"
      },
      {
        "id" : "ImagingStudy.description",
        "path" : "ImagingStudy.description",
        "short" : "機構產生的描述",
        "definition" : "影像管理員(Imaging Manager)對此影像檢查的描述，它是由醫療機構自己生成的，用來描述或分類此影像檢查（元件）的內容。"
      },
      {
        "id" : "ImagingStudy.series",
        "path" : "ImagingStudy.series",
        "short" : "每項影像檢查有一個或多個系列(series)的實例",
        "definition" : "每項影像檢查有一個或多個系列的影像或其他內容",
        "mustSupport" : true
      },
      {
        "id" : "ImagingStudy.series.uid",
        "path" : "ImagingStudy.series.uid",
        "short" : "此系列的DICOM系列實例UID",
        "definition" : "此系列的DICOM系列實例UID",
        "comment" : "[見DICOM PS3.3 C.7.3](http://dicom.nema.org/medical/dicom/current/output/chtml/part03/sect_C.7.3.html)",
        "requirements" : "此系列的DICOM系列實例UID",
        "mustSupport" : true
      },
      {
        "id" : "ImagingStudy.series.number",
        "path" : "ImagingStudy.series.number",
        "short" : "此系列的數字識別碼",
        "definition" : "此影像檢查中此系列的數字識別碼"
      },
      {
        "id" : "ImagingStudy.series.modality",
        "path" : "ImagingStudy.series.modality",
        "short" : "此系列實例所使用的成像儀器",
        "definition" : "用於此系列（series）的成像儀器。",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/AcquisitionModality"
        }
      },
      {
        "id" : "ImagingStudy.series.description",
        "path" : "ImagingStudy.series.description",
        "short" : "對此系列的一個簡短且易於閱讀的摘要",
        "definition" : "對此系列的描述"
      },
      {
        "id" : "ImagingStudy.series.numberOfInstances",
        "path" : "ImagingStudy.series.numberOfInstances",
        "short" : "此Series相關Instances的數量",
        "definition" : "在醫學影像檢查中，顯示的SOP instances數量有時會比Resource實際包含的更多。這可能是由於instance的限制、安全問題或其他因素所致。如果Resource中包含至少一個instance的資料項目，那麼這個資料項目就應該被包含在內。"
      },
      {
        "id" : "ImagingStudy.series.endpoint",
        "path" : "ImagingStudy.series.endpoint",
        "short" : "此系列的存取端點",
        "definition" : "提供影像檢查資料存取的網路服務，包括查詢、觀看或下載影像檢查資料。更多有關如何使用DICOM端點的詳細資訊，請查看實作指引。整體檢查的網絡連接設定（端點）適用於檢查中的每一個影像系列。但如果某個影像系列有自己特定的網路連接設定(稱為系統端點)，且這個設定的類型（Endpoint.connectionType）與整體檢查的端點相同，則該系列將依據其自身的設定進行連接。",
        "comment" : "常見的端點類型包括：DICOM WADO-RS，它透過RESTful API以原始或轉換後的格式（如JPG、PNG）來查DICOM影像檔案；DICOM WADO-URI，這也能查詢原始或轉換後的影像，但它是透過HTTP查詢方式實現；DICOM QIDO-RS，它允許使用RESTful查詢方式來獲取DICOM資訊，而無需下載影像檔案本身；還有IHE Invoke Image Display（IID），這是一種標準的網路影像查看器(viewer)啟動方式。",
        "requirements" : "說明了如何查詢（例如：使用DICOM的WADO-URI和WADO-RS）其影像系列或單個系列的方法。整體檢查的基礎位置設定（baseLocation）通常適用於檢查中的所有影像系列。但如果某個影像系列有自己的基礎位置設定（稱為系列級baseLocation），且這個設定與整體檢查的設定類型相同，則該系列將按照自己的設定進行操作。"
      },
      {
        "id" : "ImagingStudy.series.bodySite",
        "path" : "ImagingStudy.series.bodySite",
        "short" : "被檢查的身體部位",
        "definition" : "所檢查的解剖結構。參見DICOM第16部分附件L（http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html），瞭解DICOM與SNOMED-CT的對應關係。bodySite可指示成像的身體部位的橫向性；如果是這樣，它應與ImagingStudy.series.siderality的任何內容一致。",
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "ImagingStudy.series.laterality",
        "path" : "ImagingStudy.series.laterality",
        "short" : "身體部位的側性",
        "definition" : "影像檢查中所掃描的身體結構部位。要了解DICOM與SNOMED-CT的對應關係，可以查閱DICOM標準的第16部分[附件L](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html)。在這裡提到的bodySite可能會表明被掃描的身體部位是左側還是右側；如果有指明側性，那麼這個資訊應該與ImagingStudy.series.laterality中的內容一致。",
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/bodysite-laterality"
        }
      },
      {
        "id" : "ImagingStudy.series.specimen",
        "path" : "ImagingStudy.series.specimen",
        "short" : "要進行影像檢查的檢體",
        "definition" : "要進行影像檢查的檢體，例如：活體組織切片的整片掃描成像的檢體。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.series.started",
        "path" : "ImagingStudy.series.started",
        "short" : "此系列何時開始的",
        "definition" : "此系列開始的日期和時間"
      },
      {
        "id" : "ImagingStudy.series.performer",
        "path" : "ImagingStudy.series.performer",
        "short" : "誰執行了此系列",
        "definition" : "指明誰或什麼執行了這個系列，以及他們是如何參與的。",
        "comment" : "如果不確定是誰執行了此系列，可以記錄這位執行者所在的機構。有時，病人本人或與病人有關的人士也可能是影像的拍攝者，比如在病人自己拍攝的影像。",
        "requirements" : "執行者的資訊是記錄在每個系列的層面上，因為在一次檢查中，不同的系列可能會由不同的執行者在不同的時間點使用不同的設備來進行。而且一個系列有可能由多位執行者共同完成。"
      },
      {
        "id" : "ImagingStudy.series.performer.function",
        "path" : "ImagingStudy.series.performer.function",
        "short" : "執行的類型",
        "definition" : "區分執行者在此系列中的參與類型",
        "requirements" : "可以區分不同執行者參與的類型",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EventPerformerFunction"
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/series-performer-function"
        }
      },
      {
        "id" : "ImagingStudy.series.performer.actor",
        "path" : "ImagingStudy.series.performer.actor",
        "short" : "誰執行了此系列",
        "definition" : "表示誰或什麼人執行了該系列",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "ImagingStudy.series.instance",
        "path" : "ImagingStudy.series.instance",
        "short" : "系列中的一個SOP實例",
        "definition" : "系列中的單一SOP實例，例如：影像或表現狀態。",
        "mustSupport" : true
      },
      {
        "id" : "ImagingStudy.series.instance.uid",
        "path" : "ImagingStudy.series.instance.uid",
        "short" : "DICOM SOP實例的UID",
        "definition" : "此影像或其他DICOM內容的DICOM SOP實例UID",
        "comment" : "[見DICOM PS3.3 C.12.1](http://dicom.nema.org/medical/dicom/current/output/chtml/part03/sect_C.12.html#sect_C.12.1)",
        "requirements" : "DICOM SOP實例的UID",
        "mustSupport" : true
      },
      {
        "id" : "ImagingStudy.series.instance.sopClass",
        "path" : "ImagingStudy.series.instance.sopClass",
        "short" : "DICOM class 類型",
        "definition" : "DICOM實例類型",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "sopClass"
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://dicom.nema.org/medical/dicom/current/output/chtml/part04/sect_B.5.html#table_B.5-1"
        }
      },
      {
        "id" : "ImagingStudy.series.instance.number",
        "path" : "ImagingStudy.series.instance.number",
        "short" : "此系列中該實例的序號",
        "definition" : "此系列中該實例的序號"
      },
      {
        "id" : "ImagingStudy.series.instance.title",
        "path" : "ImagingStudy.series.instance.title",
        "short" : "實例的描述",
        "definition" : "實例的描述",
        "comment" : "特別是對於取得後的分析物件，例如：SR、表現狀態、值對應等。"
      }
    ]
  }
}

```
