# TW Core Goal - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Goal 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Goal-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreGoal |

 
此臺灣核心-目標（TW Core Goal） Profile說明本IG如何進一步定義FHIR的Goal Resource以呈現目標資料。 

**Usages:**

* Examples for this Profile: [Goal/goa-example](Goal-goa-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Goal-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Goal-twcore.csv), [Excel](StructureDefinition-Goal-twcore.xlsx), [Schematron](StructureDefinition-Goal-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Goal-patient.md)**查詢所有Goal：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Goal?patient={Type/}[id]`例子：
(1) GET [base]/Goal?patient=Patient/pat-example

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Goal-patient.md)**及**[`lifecycle-status`](SearchParameter-Goal-lifecycle-status.md)**查詢所有Goal：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Goal?patient={Type/}[id]&lifecycle-status={system|}[code]`例子：
(1) GET [base]/Goal?patient=Patient/pat-example&lifecycle-status=active
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Goal-patient.md)**及**[`target-date`](SearchParameter-Goal-target-date.md)**查詢所有Goal：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Goal?patient={Type/}[id]&target-date={gt|lt|ge|le}[date]{&target-date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Goal?patient=Patient/pat-example&target-date=ge2015-01-14&target-date=le2019-01-14
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Goal-patient.md)**及**[`description`](SearchParameter-Goal-description.md)**查詢所有Goal：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Goal?patient={Type/}[id]&description={system|}[code]`例子：
(1) GET [base]/Goal?patient=Patient/pat-example&description=http://snomed.info/sct|1078229009



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Goal-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Goal-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreGoal",
  "title" : "TW Core Goal",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-目標（TW Core Goal） Profile說明本IG如何進一步定義FHIR的Goal Resource以呈現目標資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Goal",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Goal",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Goal",
        "path" : "Goal",
        "short" : "病人健康照護中預期達成的結果或目標",
        "definition" : "在健康照護過程中，描述某患者或團體預期達成的結果或目標，是照護計畫的一部分，此目標可由患者、醫師或其他相關人員所提出。"
      },
      {
        "id" : "Goal.id",
        "path" : "Goal.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Goal紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Goal.lifecycleStatus",
        "path" : "Goal.lifecycleStatus",
        "definition" : "表示目標的當前狀態，例如正在進行中或已完成。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "GoalLifecycleStatus"
            }
          ],
          "strength" : "required",
          "description" : "表示目標當前狀態的代碼，必須使用所綁定的值集中的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/goal-status|4.0.1"
        }
      },
      {
        "id" : "Goal.description",
        "path" : "Goal.description",
        "short" : "目標的文字敘述",
        "definition" : "人可讀的目標敘述，描述要達成的目標。",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/clinical-findings"
        }
      },
      {
        "id" : "Goal.subject",
        "path" : "Goal.subject",
        "short" : "此目標的對象是誰或什麼？",
        "definition" : "此目標針對的對象，可以是個人、群體或組織。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Goal.start[x]",
        "path" : "Goal.start[x]",
        "short" : "設定此目標的日期或事件",
        "definition" : "目標被識別或創建的日期或事件，表示何時開始追蹤此目標。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "date"
          },
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Goal.target",
        "path" : "Goal.target",
        "short" : "目標的測量內容和預期完成日期",
        "definition" : "目標的具體測量內容，包括目標值和預期完成日期。",
        "mustSupport" : true
      },
      {
        "id" : "Goal.target.due[x]",
        "path" : "Goal.target.due[x]",
        "short" : "完成目標的期限日期或持續時間",
        "definition" : "完成目標的預期日期或從目標創建起計算的持續時間。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "date"
          },
          {
            "code" : "Duration"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Goal.expressedBy",
        "path" : "Goal.expressedBy",
        "short" : "誰記錄或負責此目標",
        "definition" : "表明誰負責創建、記錄或負責此目標，可能是病人本人、醫師、其他照護人員或相關人士。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Goal.addresses",
        "path" : "Goal.addresses",
        "short" : "此目標所針對的問題",
        "definition" : "此目標所要解決或處理的健康狀況、藥物使用、檢查結果或其他臨床問題。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/RiskAssessment"
            ]
          }
        ]
      },
      {
        "id" : "Goal.outcomeReference",
        "path" : "Goal.outcomeReference",
        "short" : "追蹤目標結果的觀察紀錄",
        "definition" : "參照用於監測目標進展或最終結果的觀察紀錄。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
