# TW Core Encounter - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Encounter 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreEncounter |

 
此臺灣核心-就醫事件（TW Core Encounter） Profile說明本IG如何進一步定義FHIR的Encounter Resource以呈現就醫事件。 

## Resource Encounter - 內容

涉及病人和健康照護服務提供者之間的互動，目的是為了提供健康照護服務或評估病人的健康狀況。

### 範圍與使用

病人的就醫事件根據發生的環境有所不同，包括門診、急診、家庭健康照護、住院和虛擬就醫。一次就醫事件涵蓋從入院前、實際的就醫事件（門診情況下）、入院、住院到出院的全過程（住院情況下）。期間，病人可能會接受不同健康照護服務提供者的照顧，並可能轉移至不同的地點。

由於就醫事件的範疇非常廣泛，不是所有資料項目在所有情況下都適用。因此，與入院/出院相關的資訊被分開存放在就醫事件的`hospitalization`。利用 `class` 資料項目來區分這些不同的就醫環境，進而指導相關的驗證和業務規則的應用。

不同的機構（以及不同的行政管轄區和國家）在決定哪些業務事件應該視為一個新的Encounter的開始，或者如何聚合 Encounter，存在著顯著的差異。例如：在住院期間，每一次醫生的看診可能會記錄為一個新的 Encounter 實例，但根據當地的實務和系統的不同，也可能會將這些看診聚合為整個住院期間的單一事件。在一些行政管轄區，出於財務或其他原因，可能會對就醫事件進行更多的聚合。可以使用`Encounter.partOf` 資料項目將就醫事件聚合或分組於其他Encounter之下。參考下方（[below](https://hl7.org/fhir/R4/encounter.html#examples)）提供的範例。

Encounter 實例也可能在實際就醫發生之前就已經存在，用來傳達入院前資訊，包括計劃的開始日期或預計的就醫地點。在這種情況下，`Encounter.status`資料項目會設定為 `planned`。

`Encounter.hospitalization`旨在存儲與住院相關的更多資訊。這些資訊通常與就醫事件本身的期間相同。如果住院期間與Encounter期間有所不同時，則應使用另一個就醫事件實例來記錄這些資訊，並將其作為這個就醫事件實例的一部分。

Procedure 和 Encounter相互參照，這些參照應該指向不同的 Procedures。一種情況是指在 Encounter 期間進行的 Procedure，這會儲存在`Procedure.encounter`（Encounter）中；另一種情況是Encounter是另一個 Procedure 的結果，這會被記錄在`Encounter.reasonReference`（Procedure），例如：為了解決之前 Procedure 出現的併發症而進行的後續 Encounter。

#### 狀態管理（Status Management）

在一個就醫事件的生命週期內，它會經歷多個階段，這些階段通常是根據健康照護服務提供者的工作流程來排列的，比如「`planned`」、「`in-progress`」和「`finished` / `cancelled`」。這些階段的資訊經常被用於其他目的，而且分析這些階段的歷史紀錄經常是必要的。這個分析可以透過檢查就醫事件的所有版本，確認每個版本的持續時間，然後進行一些後期的處理來完成。為了減輕這個負擔（或在系統不支援 resources 歷史紀錄的情況下），可善用 status 歷史紀錄元件（status history component）。

單靠`Encounter.status`欄位本身，我們無法直接判斷一次就醫事件是否被視為「已入院（`admitted`）」。就醫事件的具體情況和健康照護服務提供者的業務實務、政策、工作流程、類型都可能影響這一定義（例如：在急性照護機構、老人照護中心、門診診所、急診室或社區診所中）。「已到達（`arrived`）」、「已檢傷分類（`triaged`）」或「進行中（`in progress`）」等狀態可能被視為入院的開始，此時還會引入填寫`Encounter.hospitalization`。

「外出（`onleave`）」狀態可能被包含在入院階段內，也可能不被包含，例如：如果病人被允許在周末或一些其他外出事件期間回家。此外，`Encounter.location.status` 通常會被更新為「在場（`active`）」的狀態，如下範例。就如同在門診就醫的例子中，比如進行日間手術（如結腸鏡檢查），病人也可能被視為已入院，因此「已入院」的定義並不固定。但最起碼，我們認為當`Encounter.status`為「進行中（`in-progres`）」時，病人應被視為已入院。

```
{
  "resourceType": "Encounter",
  "status": "in-progress",
  "location": [
    {
      "location": {
        "display": "病房A"
      },
      "status": "active"
    }
  ]
}

```

### 界限與關聯

在FHIR中，Encounter resource不應被用來儲存有關預約的資訊；相反地，應該使用Appointmentresource 來處理這類資訊。值得一提的是，在許多系統裡，「門診就醫事件」（這是 Encounter resource 所涵蓋的範疇）和「Appointment」常常會被一起使用。在FHIR裡面，「Appointment」被用於安排就醫事件的日期，而「Encounter」則適用於關於實際就醫事件的資訊，也就是說，當病人真正到達時。

因此，一個處於「計劃中（`planned`）」`Encounter.status` 的就醫事件與安排它的預約並不相同。它代表在實際就醫事件發生之前的階段，並帶有期望該就醫事件隨著時間進展而更新到完成（`finished`）的意圖。病人抵達某地並不一定意味著就醫事件的開始。例如：病人可能比他實際被健康照護服務提供者看診的時間提早一小時到達。

Appointment resource 通常用於預約的規劃階段，包括尋找、確定一個可用的時間，然後進行預約。當這一流程完成且預約即將開始時，則會將該預約（`Encounter.appointment`（Appointment）之`Appointment.status`標記為已完成（`fulfilled`），並將其與新創建的Encounter關聯起來。這個新的Encounter可能在病人被接收到機構的某一地點時，以`Encounter.status` 為「已到達（`arrived`）」開始，之後可能會轉移到病房，此時另一部分的Encounter也許就會開始。

Communicationresource 用於在健康照護服務提供者與病人之間沒有直接接觸的情況下發生的即時互動。例如：透過電話留言或傳輸某些文件。雖然 Communication resource 不記錄持續時間，但它可能包含發送和接收的時間點。

標準擴充資料項目「相關就醫事件（[`Associated Encounter`](https://www.hl7.org/fhir/2016May/extension-encounter-associatedencounter.html)）」應當被用來參照一個Encounter，特別是在沒有其他屬性已經定義這種關聯的情況下。

Medication resource 被以下 resources 所參照：醫療不良事件（[AdverseEvent](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)）、過敏或不耐症（[AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md)）、照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、照護團隊（[CareTeam](https://hl7.org/fhir/R4/careteam.html#CareTeam)）、費用項目（[ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)）、理賠申請（[Claim](https://hl7.org/fhir/R4/claim.html#Claim)）、臨床臆斷（[ClinicalImpression](https://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)）、通訊（[Communication](https://hl7.org/fhir/R4/communication.html#Communication)）、通訊請求（[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html#CommunicationRequest)）、臨床文件架構（[Composition](StructureDefinition-Composition-twcore.md)）、病情、問題或診斷（[Condition](StructureDefinition-Condition-twcore.md)）、合約（[Contract](https://hl7.org/fhir/R4/contract.html#Contract)）、設備請求（[DeviceRequest](https://hl7.org/fhir/R4/devicerequest.html#DeviceRequest)）、診斷報告（[DiagnosticReport](https://hl7.org/fhir/R4/diagnosticreport.html#DiagnosticReport)）、文件參照（[DocumentReference](StructureDefinition-DocumentReference-twcore.md)）、藥品（[Medication](StructureDefinition-Medication-twcore.md)）、利益說明（[ExplanationOfBenefit](https://hl7.org/fhir/R4/explanationofbenefit.html#ExplanationOfBenefit)）、標記（[Flag](https://hl7.org/fhir/R4/flag.html#Flag)）、指導回應[GuidanceResponse](https://hl7.org/fhir/R4/guidanceresponse.html#GuidanceResponse)）、影像檢查（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、疫苗接種（[Immunization](https://hl7.org/fhir/R4/immunization.html#Immunization)）、清單（[List](https://hl7.org/fhir/R4/list.html#List)）、多媒體（[Media](StructureDefinition-Media-twcore.md)）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、配藥或藥品調劑（[MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)）、藥品請求（[MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、營養醫令（[NutritionOrder](https://hl7.org/fhir/R4/nutritionorder.html#NutritionOrder)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）、處置（[Procedure](StructureDefinition-Procedure-twcore.md)）、問卷題目回覆（[QuestionnaireResponse](https://hl7.org/fhir/R4/questionnaireresponse.html#QuestionnaireResponse)）、一組請求（[RequestGroup](https://hl7.org/fhir/R4/requestgroup.html#RequestGroup)）、風險評估（[RiskAssessment](https://hl7.org/fhir/R4/riskassessment.html#RiskAssessment)）、服務請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）、任務（[Task](https://hl7.org/fhir/R4/task.html#Task)）及視力處方（[VisionPrescription](https://hl7.org/fhir/R4/visionprescription.html#VisionPrescription)）。

**Usages:**

* Refer to this Profile: [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md), [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md)...Show 32 more,[TW Core Condition](StructureDefinition-Condition-twcore.md),[TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md),[TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md),[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Immunization](StructureDefinition-Immunization-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [Encounter/enc-example](Encounter-enc-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Encounter-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Encounter-twcore.csv), [Excel](StructureDefinition-Encounter-twcore.xlsx), [Schematron](StructureDefinition-Encounter-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Encounter-id.md)**查詢所有Encounter：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Encounter?_id=[id]`
`GET [base]/Encounter/[id]`例子：
(1) GET [base]/Encounter?_id=enc-example
(2) GET [base]/Encounter/enc-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`class`](SearchParameter-Encounter-class.md)**查詢所有Encounter：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Encounter?class=[code]`例子：
(1) GET [base]/Encounter?class=PRENC
1. **建議應該（SHOULD）**支援透過查詢參數**[`date`](SearchParameter-Encounter-date.md)**查詢所有Encounter：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Encounter?date={gt|lt|ge|le}[date]`例子：
(1) GET [base]/Encounter?date=gt2022-08-01
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Encounter-identifier.md)**查詢所有Encounter：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Encounter?identifier={system|}[code]`
`GET [base]/Encounter?identifier=[code]`例子：
(1) GET [base]/Encounter?identifier=http://healthcare.example.org/identifiers/enocunter|E22081702
(2) GET [base]/Encounter?identifier=E22081702
1. **建議應該（SHOULD）**支援透過查詢參數**[`location`](SearchParameter-Encounter-location.md)**查詢所有Encounter：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Encounter?location={Type/}[id]`例子：
(1) GET [base]/Encounter?location=Location/hospital-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Encounter-subject.md)**查詢所有Encounter：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Encounter?subject={Type/}[id]`例子：
(1) GET [base]/Encounter?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Encounter-status.md)**查詢所有Encounter：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Encounter?status=[code]`例子：
(1) GET [base]/Encounter?status=finished

### 實作注意事項

* Encounter.class 資料項目用於描述就醫事件發生的環境（如門診/住院等）。由於這對於理解就醫事件的背景、選擇適當的業務規則以執行和管理過程都非常重要，因此該資料項目是必須的。
* 在未來的 FHIR 版本中，將會加入某種形式的收費記錄工具（例如：Account）。

### 範例使用 Example usage

如上所述，Encounter 允許透過「partOf」資料項目來靈活組織嵌套就醫事件。這麼做的例子包括：

* 假設有一位病人入院兩週：這可用 Encounter 來表示，其中指定了整個住院時間的開始和持續時間。透過`participant`來指定負責入院的醫生和住院期間的負責醫生。
* 在病人的就醫期間，他從住院病房移動到加護病房（Intensive Care unit，ICU），然後再移回來：可創建三個更詳細的額外Encounter，每個代表病人停留的其中一個位置。這些Encounter每個都有一個`location`（兩次是住院病房，一次是加護病房）和該地點的一位或多位`participant`。這些 Encounter 可能使用`partOf`資料項目來表示這些移動發生在更長的整體就醫事件期間。
* 在住院的最後階段，病人被治療他的跨專科團隊成員問診，以進行最後評估：如有必要，對於這些短暫的問診，可以創建一個有一位`participant`的Encounter。由於這些問診發生在住院的最後階段，`partOf`資料項目可用來將這些短暫問診關聯到第三次病人移動或是整體的大型Encounter。

Encounter 的具體使用方式取決於來源系統中的可用資訊、每個 Encounter 層級的交換相關性以及訊息交換夥伴的具體需求，期望透過使用特定交換領域的 profiles 來限制 Encounter 的靈活性，以滿足使用案例的要求。



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Encounter-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreEncounter",
  "title" : "TW Core Encounter",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-就醫事件（TW Core Encounter） Profile說明本IG如何進一步定義FHIR的Encounter Resource以呈現就醫事件。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "short" : "提供病人服務的一種互動",
        "definition" : "病人和健康照護服務提供者之間的互動，目的是提供健康照護服務或評估病人的健康狀況。"
      },
      {
        "id" : "Encounter.id",
        "path" : "Encounter.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Encounter紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Encounter.meta",
        "path" : "Encounter.meta",
        "short" : "此Encounter Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Encounter.implicitRules",
        "path" : "Encounter.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Encounter.language",
        "path" : "Encounter.language",
        "short" : "用以表述Encounter Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Encounter.text",
        "path" : "Encounter.text",
        "short" : "Encounter Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Encounter.identifier",
        "path" : "Encounter.identifier",
        "short" : "此就醫事件的識別碼",
        "definition" : "此就醫事件的識別碼",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.identifier.use",
        "path" : "Encounter.identifier.use",
        "short" : "usual ｜ official ｜ temp ｜ secondary ｜ old （如果知道）",
        "definition" : "這個唯一識別碼（identifier）的用途",
        "comment" : "應用程式可以假定一個識別碼是永久的，除非它明確說它是暫時的。",
        "requirements" : "允許從一組識別碼中為特定的使用情境選擇適當的識別碼",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierUse"
            }
          ],
          "strength" : "required",
          "description" : "如果知道，請說明此識別碼的用途；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use|4.0.1"
        }
      },
      {
        "id" : "Encounter.identifier.type",
        "path" : "Encounter.identifier.type",
        "short" : "識別碼（identifier）的型別說明",
        "definition" : "識別碼的代碼型別，用於決定特定目的適用的識別碼。",
        "comment" : "這個資料項目只涉及識別碼的一般類別。它 **必須沒有（SHALL NOT）** 被用於與Identifier.system 1..1對應的代碼。一些識別碼可能由於常見的用法而屬於多個類別。在系統是已知的情況下，型別是不必要的，因為型別總是系統定義的一部分。然而，系統經常需要處理系統不為人知的識別碼。型別和系統之間不是1:1的關係，因為許多不同的系統有相同的型別。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "IdentifierType"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-type"
        }
      },
      {
        "id" : "Encounter.identifier.system",
        "path" : "Encounter.identifier.system",
        "short" : "識別碼（identifier）的命名空間（namespace）",
        "definition" : "建立值的命名空間－即一個描述一組值的唯一URL",
        "comment" : "Identifier.system總是區分大小寫",
        "requirements" : "有許多識別碼的集合。為了進行兩個識別碼的對應，我們需要知道我們處理的是哪一組。系統指明了一個特定的唯一識別碼集。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.identifier.value",
        "path" : "Encounter.identifier.value",
        "short" : "唯一值",
        "definition" : "識別碼中通常與使用者有關的部分，在系統情境內是唯一的。",
        "comment" : "如果此值是一個完整的URI，那麼此系統 **必須（SHALL）** 是urn:ietf:rfc:3986。此值的主要目的是為了可運算的對應。因此，為了比較的目的，它可能會被正規化（例如：去除不重要的空白、破折號等）。一個為人顯示的格式化的值可以使用[Rendered Value]（http://hl7.org/fhir/R4/extension-rendered-value.html）擴充來傳達。除非對Identifier.system的了解使處理者確信不區分大小寫的處理是安全的，否則Identifier.value應被視為區分大小寫。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Encounter.identifier.period",
        "path" : "Encounter.identifier.period",
        "short" : "此就醫事件識別碼（identifier）的使用效期",
        "definition" : "識別碼有效／曾經有效使用的時段或期間"
      },
      {
        "id" : "Encounter.identifier.assigner",
        "path" : "Encounter.identifier.assigner",
        "short" : "簽發identifier的機構（可以只是文字表述）",
        "definition" : "簽發／管理識別碼的機構",
        "comment" : "Identifier.assigner可以省略.reference資料項目，只包含一個.display資料項目，反映指定機構的名稱或其他文字表述資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "comment" : "請注意，內部業務規則將決定於狀態（也包括類別）間可能發生的適當轉換。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterStatus"
            }
          ],
          "strength" : "required",
          "description" : "就醫現況的代碼；應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-status|4.0.1"
        }
      },
      {
        "id" : "Encounter.statusHistory",
        "path" : "Encounter.statusHistory",
        "short" : "過去的就醫狀態清單",
        "definition" : "Encounter resource包含狀態歷史，因而不需閱讀resource的歷史版本，甚至不需讓伺服器儲存這些版本。",
        "comment" : "總是可在resource的目前版本找到目前狀態，而不是在狀態歷史中找到。"
      },
      {
        "id" : "Encounter.statusHistory.status",
        "path" : "Encounter.statusHistory.status",
        "definition" : "planned | arrived | triaged | in-progress | onleave | finished | cancelled +",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterStatus"
            }
          ],
          "strength" : "required",
          "description" : "就醫現狀的代碼；應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-status|4.0.1"
        }
      },
      {
        "id" : "Encounter.statusHistory.period",
        "path" : "Encounter.statusHistory.period",
        "short" : "該事件處於特定狀態的時間",
        "definition" : "該事件處於特定狀態的時間"
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "short" : "病人就醫的分類",
        "definition" : "病人就醫分類的概念，例如：門診病人、住院病人、急診病人、居家照護或其他因地方不同而產生的概念。",
        "type" : [
          {
            "code" : "Coding",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coding-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterClass"
            }
          ],
          "strength" : "extensible",
          "description" : "就醫的分類；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"
        }
      },
      {
        "id" : "Encounter.classHistory",
        "path" : "Encounter.classHistory",
        "short" : "過去就醫類別的列表",
        "definition" : "可透過類別歷史而不需要透過resource歷史紀錄來追蹤就醫的轉變，這將用於一個案例，即住院急診，然後轉住院的情況。這樣做而不重新啟動一個新的就醫，可以確保任何實驗室/診斷結果可以更容易地跟隨病人，不需要重新處理，也不會在從急診到住院的出院過程中丟失或取消。"
      },
      {
        "id" : "Encounter.classHistory.class",
        "path" : "Encounter.classHistory.class",
        "short" : "inpatient ｜ outpatient ｜ ambulatory ｜ emergency +",
        "definition" : "inpatient ｜ outpatient ｜ ambulatory ｜ emergency +.\n住院病人 ｜ 門診病人 ｜ 非臥床（可行走）病人醫療服務 ｜ 急診 +",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterClass"
            }
          ],
          "strength" : "extensible",
          "description" : "就醫類別；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"
        }
      },
      {
        "id" : "Encounter.classHistory.period",
        "path" : "Encounter.classHistory.period",
        "short" : "此就醫事件處於特定類別的時間",
        "definition" : "此就醫事件處於特定類別的時間"
      },
      {
        "id" : "Encounter.type",
        "path" : "Encounter.type",
        "short" : "就醫的特定型別",
        "definition" : "就醫的特定型別（如電子郵件諮詢、手術日間照護、專業護理、復健）。",
        "comment" : "由於有許多方法可以對就醫進行進一步的分類，所以這個資料項目的基數是0...* ，意即可不填寫或填寫數筆。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterType"
            }
          ],
          "strength" : "example",
          "description" : "就醫的型別；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-type"
        }
      },
      {
        "id" : "Encounter.serviceType",
        "path" : "Encounter.serviceType",
        "short" : "服務的特定型別",
        "definition" : "對所提供的服務進行廣泛的分類（如心臟科）",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterServiceType"
            }
          ],
          "strength" : "example",
          "description" : "對提供的服務進行廣泛分類；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/service-type"
        }
      },
      {
        "id" : "Encounter.serviceType.coding",
        "path" : "Encounter.serviceType.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalDepartmentSCT",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalDepartmentSCT",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-department-sct-tw"
        }
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalDepartmentSCT.system",
        "path" : "Encounter.serviceType.coding.system",
        "min" : 1,
        "patternUri" : "http://snomed.info/sct"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalConsultationDepartment",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalConsultationDepartment",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-consultation-department-tw"
        }
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalConsultationDepartment.system",
        "path" : "Encounter.serviceType.coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw"
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalTreatmentDepartment",
        "path" : "Encounter.serviceType.coding",
        "sliceName" : "TWMedicalTreatmentDepartment",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-treatment-department-tw"
        }
      },
      {
        "id" : "Encounter.serviceType.coding:TWMedicalTreatmentDepartment.system",
        "path" : "Encounter.serviceType.coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw"
      },
      {
        "id" : "Encounter.priority",
        "path" : "Encounter.priority",
        "short" : "表明就醫的急迫性",
        "definition" : "表明就醫的急迫性",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Priority"
            }
          ],
          "strength" : "example",
          "description" : "表明就醫的迫切性；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActPriority"
        }
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "short" : "在場就醫的病人或實體集合（Group）",
        "definition" : "在場就醫的病人或實體集合（Group）",
        "comment" : "雖然就醫總是關於病人，但在所有的使用情境中，病人實際上可能並不為人所知及可能有一群病人是匿名的（例如：匿名酗酒者的團體治療中—就醫紀錄是以人數/工作人員數計費，而具體病人的情境並不重要）；或者在獸醫照護中，一群羊接受治療（動物沒有被單獨追蹤）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.episodeOfCare",
        "path" : "Encounter.episodeOfCare",
        "short" : "此次就醫應記錄的照護事件",
        "definition" : "當某一特定就醫應被歸類為某一特定照護事件的一部分時，應使用這一個資料項目。這種關聯可方便地將相關的就醫分類，以達到特定的目的，如政府報告、問題追蹤、透過共同的問題進行關聯，關聯通常會在照護事件之後記錄在就醫紀錄上，並在紀錄上分類；而不是將另一個就醫（照護事件可能橫跨多年）附件到照護事件紀錄。"
      },
      {
        "id" : "Encounter.basedOn",
        "path" : "Encounter.basedOn",
        "short" : "開始此次就醫的服務請求（ServiceRequest）",
        "definition" : "此就醫事件所要滿足的請求（例如：轉診或手術請求）",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "short" : "參與就醫的健康照護服務提供者之名單",
        "definition" : "負責提供健康照護服務的人員名單",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant.type",
        "path" : "Encounter.participant.type",
        "short" : "參與者在病人就醫事件中的角色",
        "definition" : "參與者在病人就醫事件中的角色",
        "comment" : "參與者的型別表明個人如何參與病人的就醫事件。它包括非執業醫師的參與者，而對於執業醫師來說，這是為了描述在這次就醫中的活動型別（例如：住院醫生、主治醫生、翻譯者、諮詢醫生）。這與執業醫師的角色不同，執業醫師是功能性的角色，衍生自來僱用、教育、執照等。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ParticipantType"
            }
          ],
          "strength" : "extensible",
          "description" : "參與者在病人就醫事件中的角色；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-participant-type"
        }
      },
      {
        "id" : "Encounter.participant.period",
        "path" : "Encounter.participant.period",
        "short" : "參與者在病人就醫期間參與的時段",
        "definition" : "指定的參與者參與病人就醫的時段。這些時段可以是重疊的，也可以是整個就醫的時段的子集。",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "short" : "除病人外，參與病人就醫事件的人。",
        "definition" : "除病人外，參與病人就醫事件的人。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.appointment",
        "path" : "Encounter.appointment",
        "short" : "這次就醫的預約紀錄",
        "definition" : "這次就醫的預約紀錄"
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "short" : "就醫的開始和結束時間",
        "definition" : "就醫的開始和結束時間",
        "comment" : "如果（尚）不知道，可以省略「期間」裡的結束日期時間。",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.length",
        "path" : "Encounter.length",
        "short" : "就醫持續的時間（扣除缺席時間）",
        "definition" : "就醫持續的時間，這不包括請假缺席的時間。",
        "comment" : "由於請假，可能與就醫的開始和結束時間（Encounter.period）不同。"
      },
      {
        "id" : "Encounter.reasonCode",
        "path" : "Encounter.reasonCode",
        "short" : "就醫發生的編碼原因",
        "definition" : "就醫發生的原因，以代碼表示。對於住院，這可用於住院診斷代碼。",
        "comment" : "對於需要知道哪個是主要診斷的系統來說，這些將用標準擴充primaryDiagnosis（這是一個序列值而不是一個標誌，1=主要診斷）來標記。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterReason"
            }
          ],
          "strength" : "preferred",
          "description" : "發生此就醫事件的原因；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-reason"
        }
      },
      {
        "id" : "Encounter.reasonReference",
        "path" : "Encounter.reasonReference",
        "short" : "就醫發生的原因（參照）",
        "definition" : "就醫發生的原因，以代碼表示。對於住院，這可用於住院診斷代碼。",
        "comment" : "對於需要知道哪個是主要診斷的系統來說，這些將用標準擴充primaryDiagnosis（這是一個序列值而不是一個標誌，1=主要診斷）來標記。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "short" : "與此就醫相關的診斷清單",
        "definition" : "與此就醫相關的診斷清單"
      },
      {
        "id" : "Encounter.diagnosis.condition",
        "path" : "Encounter.diagnosis.condition",
        "short" : "與就醫事件相關的診斷或處置",
        "definition" : "就醫的原因，使用其他resource的資訊以具體說明。對於住院，這就是住院診斷。指示通常是一個病情、問題或診斷（Condition）（在evidence.detail中參照其他resource），或一個處置（Procedure）。",
        "comment" : "對於需要知道哪個是主要診斷的系統來說，這些將用標準擴充primaryDiagnosis（這是一個序列值而不是一個標誌，1=主要診斷）來標記。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis.use",
        "path" : "Encounter.diagnosis.use",
        "short" : "此診斷在病人就醫事件中的作用（例如：住院、收費、出院...）。",
        "definition" : "此診斷在病人就醫事件中的作用（例如：住院、收費、出院...）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DiagnosisRole"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "此情況所代表的診斷型別；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnosis-role"
        }
      },
      {
        "id" : "Encounter.diagnosis.rank",
        "path" : "Encounter.diagnosis.rank",
        "short" : "診斷的排序（針對每個角色型別）",
        "definition" : "診斷的排序（針對每個角色型別）"
      },
      {
        "id" : "Encounter.account",
        "path" : "Encounter.account",
        "short" : "可用於為此病人就醫事件計費的一組帳戶",
        "definition" : "可用於為此病人就醫事件計費的一組帳戶",
        "comment" : "計費系統可依據內部業務規則，選擇將與就醫（Encounter）相關的應計費項目分配給不同的參照帳戶。"
      },
      {
        "id" : "Encounter.hospitalization",
        "path" : "Encounter.hospitalization",
        "short" : "關於入院接受健康照護服務的細節",
        "definition" : "關於入院接受健康照護服務的細節",
        "comment" : "就醫可能不僅僅包括住院治療。其他情境像是門診病人、社區診所和老年照護機構等情況也包括在內。在此就醫期間記錄的持續時間含概此住院紀錄的整個範圍。",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.hospitalization.preAdmissionIdentifier",
        "path" : "Encounter.hospitalization.preAdmissionIdentifier",
        "short" : "住院前識別碼",
        "definition" : "住院前識別碼"
      },
      {
        "id" : "Encounter.hospitalization.origin",
        "path" : "Encounter.hospitalization.origin",
        "short" : "病人住院前來自的地點／機構",
        "definition" : "病人住院前來自的地點／機構",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.hospitalization.admitSource",
        "path" : "Encounter.hospitalization.admitSource",
        "short" : "病人從哪裡住院（醫生轉介、轉院）？",
        "definition" : "病人從哪裡住院（醫生轉介、轉院）？",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AdmitSource"
            }
          ],
          "strength" : "preferred",
          "description" : "病人從哪裡住院；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-admit-source"
        }
      },
      {
        "id" : "Encounter.hospitalization.reAdmission",
        "path" : "Encounter.hospitalization.reAdmission",
        "short" : "已發生的醫院再入院型別（如果有的話）。如果該值不存在，則不被認定為再入院。",
        "definition" : "此次住院是否為再入院，如果知道的話，請說明原因。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ReAdmissionType"
            }
          ],
          "strength" : "example",
          "description" : "這次住院就醫的再入院原因；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0092"
        }
      },
      {
        "id" : "Encounter.hospitalization.dietPreference",
        "path" : "Encounter.hospitalization.dietPreference",
        "short" : "病人報告的飲食偏好",
        "definition" : "病人報告的飲食偏好",
        "comment" : "例如：一個病人可能同時要求無乳製品和無堅果的飲食偏好（不相互排斥）。",
        "requirements" : "用於追蹤病人的飲食限制和／或偏好。如果要完整描述病人在住院期間的營養需求，應該使用與Encounter連結的nutritionOrder resource。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "PatientDiet"
            }
          ],
          "strength" : "example",
          "description" : "醫療、文化或道德方面的食物偏好，以幫助滿足飲食要求；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-diet"
        }
      },
      {
        "id" : "Encounter.hospitalization.specialCourtesy",
        "path" : "Encounter.hospitalization.specialCourtesy",
        "short" : "特別禮遇（貴賓、董事會成員）",
        "definition" : "特別禮遇（貴賓、董事會成員）",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Courtesies"
            }
          ],
          "strength" : "preferred",
          "description" : "特別禮遇；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-special-courtesy"
        }
      },
      {
        "id" : "Encounter.hospitalization.specialArrangement",
        "path" : "Encounter.hospitalization.specialArrangement",
        "short" : "輪椅、翻譯人員、擔架等。",
        "definition" : "對此次住院就醫提出的任何特殊要求，如提供特定設備或其他東西。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Arrangements"
            }
          ],
          "strength" : "preferred",
          "description" : "特殊安排；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-special-arrangements"
        }
      },
      {
        "id" : "Encounter.hospitalization.destination",
        "path" : "Encounter.hospitalization.destination",
        "short" : "病人出院地點／機構",
        "definition" : "病人出院地點／機構",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.hospitalization.dischargeDisposition",
        "path" : "Encounter.hospitalization.dischargeDisposition",
        "short" : "出院後的地點類別或種類",
        "definition" : "出院後的地點類別或種類",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DischargeDisp"
            }
          ],
          "strength" : "example",
          "description" : "出院處置；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-discharge-disposition"
        }
      },
      {
        "id" : "Encounter.location",
        "path" : "Encounter.location",
        "short" : "病人曾去過的一個或多個地點",
        "definition" : "此次就醫期間，病人曾去過的一個或多個地點",
        "comment" : "透過指定一個型別「種類（kind）」的地點參照，例如「客戶的家」，以及encounter.class =「虛擬（virtual）」。",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location.location",
        "path" : "Encounter.location.location",
        "short" : "就醫發生的地點",
        "definition" : "就醫發生的地點",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location.status",
        "path" : "Encounter.location.status",
        "definition" : "參與者在指定期間於特定地點的狀態。如果參與者已不在此地點，那麼其期間將有一個結束日期/時間。",
        "comment" : "當病人不再在某一地點活動時，則要輸入期間結束日期，狀態可改為完成。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterLocationStatus"
            }
          ],
          "strength" : "required",
          "description" : "就醫地點的狀態；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/encounter-location-status|4.0.1"
        }
      },
      {
        "id" : "Encounter.location.physicalType",
        "path" : "Encounter.location.physicalType",
        "short" : "地點的實體型別（通常是地點的層級—床位、房間、病房等）。",
        "definition" : "這將被用來指定所需的地點層級（床位／病房／房間／等），以簡化訊息傳遞或查詢。",
        "comment" : "此資訊是從Location resource中反正規化(de-normalized)，以較易理解Encounter resource及支持訊息傳遞或查詢的處理。地點的層級結構中可能有許多層級，這可能只挑選特定使用情境所需的特定層級。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "PhysicalType"
            }
          ],
          "strength" : "example",
          "description" : "地點的實體型別；可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/location-physical-type"
        }
      },
      {
        "id" : "Encounter.location.period",
        "path" : "Encounter.location.period",
        "short" : "病人出現在此地點的時段",
        "definition" : "病人出現在此地點的時段"
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "short" : "負責這次就醫的機構",
        "definition" : "對此次就醫的服務負主要責任的機構。這可能與病人紀錄中的機構相同，但也可能不同，例如：如果執行服務的人員來自外部機構（可單獨計費）的外部諮詢。請參考Bundle範例顯示結腸鏡檢查就醫縮略集。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.partOf",
        "path" : "Encounter.partOf",
        "short" : "此就醫是哪次就醫的一部份？",
        "definition" : "此就醫是哪次就醫的一部分（行政上或時間上）",
        "comment" : "這也用於將小孩的就醫與母親的就醫作關聯。 詳情請參考Patient resource中的Notes小節。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
