# TW Core DiagnosticReport - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core DiagnosticReport 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreDiagnosticReport |

 
此臺灣核心-診斷報告（TW Core DiagnosticReport） Profile說明本IG如何進一步定義FHIR的DiagnosticReport Resource以呈現診斷報告。 

## Resource DiagnosticReport - 內容

對病人、病人群體、設備、地點，以及/或從這些來源獲得的檢體進行的診斷性檢查的結果和解釋。報告包含了諸如請求和健康照護服務提供者資訊這樣的臨床背景，以及一些無法再細分的結果、影像、文字和編碼的解釋，還有診斷報告的格式化呈現。

### 範圍及使用

**從 FHIR 工作流的觀點來看，resources 依其性質被區分為三類：定義、請求及事件。DiagnosticReport resource 被歸類為「事件」類 resource。有關更多資訊，請查看[工作流程（workflow）](https://hl7.org/fhir/R4/workflow.html)。Orders 和 Observation 工作小組的目標是讓 DiagnosticReport resource 在概念上和實作上都符合工作流標準中所認定的「[事件 resource](https://hl7.org/fhir/R4/workflow.html#event)」。**

DiagnosticReport 是診斷服務在調查完成後通常提供的資訊集，可能由無法再細分的結果、文字報告、影像和代碼所組成。根據診斷程序的不同，以及某些情況下調查結果的特性，這此組成會有所不同。在 FHIR 中，報告可以透過多種方式傳達，包括[Document （文件）](https://hl7.org/fhir/R4/documents.html)、[RESTful API](https://hl7.org/fhir/R4/http.html) 或[訊息 （Message）](https://hl7.org/fhir/R4/messaging.html) 框架。在這些方式中，都會包含 DiagnosticReport resource 本身。

DiagnosticReport resource 包含診斷報告本身的資訊，關於報告對象的資訊，在實驗室檢驗案例中還包括檢體資訊。它也可以照請求細節和無法再細分的檢驗檢查細節或影像實例。報告結論可以以簡單的文本形式、結構化編碼資料，或作為一個附加的完整格式化報告（如 PDF）來表達。

DiagnosticReport resource 適用於以下類型的診斷報告：

* 實驗室（如臨床化學、血液學、微生物學等）
* 病理學/組織病理學及相關學科
* 影像檢查（如 X 光、CT、MRI 等）
* 其他診斷 - 如心臟病學、胃腸病學等

DiagnosticReport resource 並不是用來支援累積結果呈現（在 resource 中表格形式展示過去和現在的結果），而且，DiagnosticReport resouce 目前還不完全支援詳細結構化的序列報告，這一功能預計將在未來的版本中實現。

### 背景

**Diagnostic Report 的一些名稱** 在討論 Diagnostic Report 的各部分時，「tests」、「results」、「observations」、「panels」 和 「batteries」 等詞彙經常被互換使用，這造成了不少混淆。這種命名混淆之所以加劇，是因為 Diagnostic investigation 的結果形式多樣，正如前面所描述的那樣。而且，非英語的語言中對這一主題也各有其變體。

這個 resource 採用了一套特定的術語。一位醫療專業人員「請求」一系列的「tests」。隨後，診斷服務返回一份「report」，這份 report 可能包含一個「narrative」— 結果的文字總結，和/或一些「results」— 每個 result 都是一個「observation」。這些 results 被組織在各組的檢驗檢查中，各組檢驗檢查是嵌套的 Observations 結構（傳統上實驗室稱為「panels」或「batteries」），用於表示個別資料項目之間的關係。

### 界限與關聯

請注意，許多診斷過程本質上都是進行觀察和生成診斷報告的程序。在很多情況下，這類檢驗檢查並不需要明確表示用於創建檢驗檢查的過程。但是，如果對於診斷程序的具體執行細節感興趣，那麼可以使用 [Procedure](StructureDefinition-Procedure-twcore.md) resource 來詳細描述這一活動。

與 [Observation](StructureDefinition-Observation-laboratoryResult-twcore.md) resource 相比，DiagnosticReport resource 通常會包含更多的臨床背景資訊，以及各種形式的結果，如無分再細分的結果、影像、影像報告、文字和編碼的解釋，以及診斷報告的格式化表示。無論是實驗室報告、病理報告還是影像報告，都應該使用 DiagnosticReport resource 來進行表示。透過參照 Observation resource，DiagnosticReport 為特定調查提供了無法再細分的結果。

如果你擁有一個高度結構化的報告，那麼就應該使用 DiagnosticReport — 它為資料和工作流提供了支持。診斷調查的請求細節被記錄在各種「請求」 resources 中（例如：[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html)），這使得報告能夠與臨床工作流相連接。對於更注重敘述、工作流較少的報告（比如組織學/解剖學等），[Composition](StructureDefinition-Composition-twcore.md) resource 更為合適。

報告及其支援影像的影像和多媒體表示方式在 DiagnosticReport resource 中有所參照。這些細節和實際的影像實例可以直接在 DiagnosticReport 中透過「`media`」資料項目參照，或者透過「`imagingStudy`」 [ImagingStudy](StructureDefinition-ImagingStudy-twcore.md) resources 間接參照，後者代表了在 DICOM 影像學檢查中產生的內容或病人的一組 DICOM 實例。

Patient Resource被以下Resources所參照：照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、費用項目（[ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)）、臨床臆斷（[ClinicalImpression](https://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)）、通訊（[Communication](https://hl7.org/fhir/R4/communication.html#Communication)）、通訊請求（[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html#CommunicationRequest)）、病情、問題或診斷（[Condition](StructureDefinition-Condition-twcore.md)）、合約（[Contract](https://hl7.org/fhir/R4/contract.html#Contract)）、設備請求（[DeviceRequest](https://hl7.org/fhir/R4/devicerequest.html#DeviceRequest)）、設備使用聲明（[DeviceUseStatement](https://hl7.org/fhir/R4/deviceusestatement.html#DeviceUseStatement)）、家庭成員病史（[FamilyMemberHistory](https://hl7.org/fhir/R4/familymemberhistory.html#FamilyMemberHistory)）、指導回應（[GuidanceResponse](https://hl7.org/fhir/R4/guidanceresponse.html#GuidanceResponse)）、影像檢查（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、疫苗接種（[Immunization](https://hl7.org/fhir/R4/immunization.html#Immunization)）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、處置（[Procedure](StructureDefinition-Procedure-twcore.md)）、一組請求（[RequestGroup](https://hl7.org/fhir/R4/requestgroup.html#RequestGroup)）、風險評估（[RiskAssessment](https://hl7.org/fhir/R4/riskassessment.html#RiskAssessment)）、服務請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）及供應品請求（[SupplyRequest](https://hl7.org/fhir/R4/supplyrequest.html#SupplyRequest)）。

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core Condition](StructureDefinition-Condition-twcore.md), [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md), [TW Core Immunization](StructureDefinition-Immunization-twcore.md)...Show 3 more,[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [DiagnosticReport/dia-example](DiagnosticReport-dia-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/DiagnosticReport-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DiagnosticReport-twcore.csv), [Excel](StructureDefinition-DiagnosticReport-twcore.xlsx), [Schematron](StructureDefinition-DiagnosticReport-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-DiagnosticReport-id.md)**查詢所有DiagnosticReport：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/DiagnosticReport?_id=[id]`
`GET [base]/DiagnosticReport/[id]`例子：
(1) GET [base]/DiagnosticReport?_id=dia-example
(2) GET [base]/DiagnosticReport/dia-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-DiagnosticReport-status.md)**查詢所有DiagnosticReport：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/DiagnosticReport?status=[code]`例子：
(1) GET [base]/DiagnosticReport?status=registered
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-DiagnosticReport-subject.md)**查詢所有DiagnosticReport：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/DiagnosticReport?subject={Type/}[id]`例子：
(1) GET [base]/DiagnosticReport?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`category`](SearchParameter-DiagnosticReport-category.md)**查詢所有DiagnosticReport：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/DiagnosticReport?category={system|}[code]`
`GET [base]/DiagnosticReport?category=[code]`例子：
(1) GET [base]/DiagnosticReport?identifier=http://terminology.hl7.org/CodeSystem/v2-0074|LAB
1. **建議應該（SHOULD）**支援透過查詢參數**[`code`](SearchParameter-DiagnosticReport-code.md)**查詢所有DiagnosticReport：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/DiagnosticReport?code={system|}[code]`
`GET [base]/DiagnosticReport?code=[code]`例子：
(1) GET [base]/DiagnosticReport?code=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw|09002C
1. **建議應該（SHOULD）**支援透過查詢參數**[`date`](SearchParameter-DiagnosticReport-date.md)**查詢所有DiagnosticReport：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/DiagnosticReport?date={gt|lt|ge|le}[date]`例子：
(1) GET [base]/DiagnosticReport?date=gt2022-08-01



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DiagnosticReport-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreDiagnosticReport",
  "title" : "TW Core DiagnosticReport",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-診斷報告（TW Core DiagnosticReport） Profile說明本IG如何進一步定義FHIR的DiagnosticReport Resource以呈現診斷報告。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport",
        "short" : "診斷報告—由請求資訊、不可被中斷的一個或一系列結果（atomic results）、影像、解釋以及格式化報告所組成。",
        "definition" : "對病人、一群病人、設備和地點、和／或由這些所產生的檢體進行診斷測試的發現與解釋，報告包括臨床情境，如請求和服務提供者的資訊，以及一些混合的不可被中斷的一個或一系列結果、影像、文字和編碼的解釋，以及格式化的診斷報告。",
        "comment" : "這是為了捕捉單一的報告資訊，不適合用於顯示涵蓋多個報告的摘要資訊。例如：此resource沒有為實驗室累積報告格式設計，也沒有為排序的詳細結構化報告設計。"
      },
      {
        "id" : "DiagnosticReport.id",
        "path" : "DiagnosticReport.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的DiagnosticReport紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "DiagnosticReport.meta",
        "path" : "DiagnosticReport.meta",
        "short" : "此DiagnosticReport Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "DiagnosticReport.implicitRules",
        "path" : "DiagnosticReport.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "DiagnosticReport.language",
        "path" : "DiagnosticReport.language",
        "short" : "用以表述DiagnosticReport Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "DiagnosticReport.text",
        "path" : "DiagnosticReport.text",
        "short" : "DiagnosticReport Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "DiagnosticReport.identifier",
        "path" : "DiagnosticReport.identifier",
        "short" : "報告的業務用識別碼",
        "definition" : "由執行者或其他系統指定給該報告的業務用識別碼",
        "comment" : "此識別碼通常由診斷服務提供者的資訊系統指定",
        "requirements" : "當從來源實驗室查詢此報告以及在FHIR情境之外連接到此報告時，需要知道在應使用什麼識別碼。"
      },
      {
        "id" : "DiagnosticReport.basedOn",
        "path" : "DiagnosticReport.basedOn",
        "short" : "此報告是基於什麼服務的請求",
        "definition" : "有關請求的服務的細節",
        "comment" : "注意：通常每個結果有一個檢驗服務請求，但是在某些情況下，多個檢驗服務請求可以用同一個檢驗結果resource來表示。請注意，也存在一個服務請求導致多個報告的情況。",
        "requirements" : "允許追蹤報告的授權，並追蹤提案／建議是否被採納。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "definition" : "診斷報告的狀態",
        "requirements" : "診斷服務通常會發布臨時／不完整的報告，有時候也會撤銷之前已發布的報告。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DiagnosticReportStatus"
            }
          ],
          "strength" : "required",
          "description" : "診斷報告狀態；應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-report-status|4.0.1"
        }
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "short" : "服務類別",
        "definition" : "對建立報告的臨床科、部門或診斷服務進行分類的代碼（例如：心臟病學、生物化學、血液學、MRI）。主要為了搜尋、排序和顯示時使用。",
        "comment" : "允許使用各種分類方案的多個類別。精細度由值集中的類別概念來定義。可使用DiagnosticReport.code中的metadata和（或）專門術語層次結構進行更細微的過濾。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "診斷報告分類；應填入所綁定值集值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-service-sections"
        }
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "short" : "此診斷報告的名稱／代碼",
        "definition" : "描述該診斷報告的代碼或名稱",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding",
        "path" : "DiagnosticReport.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding:LOINCObservationCode",
        "path" : "DiagnosticReport.code.coding",
        "sliceName" : "LOINCObservationCode",
        "short" : "LOINC®為Regenstrief Institute, Inc.維護的檢驗事件描述代碼，可免費使用，可優先選用此代碼。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-observation-code"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding:LOINCObservationCode.system",
        "path" : "DiagnosticReport.code.coding.system",
        "patternUri" : "http://loinc.org",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding:LOINCObservationCode.code",
        "path" : "DiagnosticReport.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding:TWLaboratoryCategory",
        "path" : "DiagnosticReport.code.coding",
        "sliceName" : "TWLaboratoryCategory",
        "short" : "此為中央健康保險署(NHI)維護之醫療服務給付項目-檢驗相關代碼，主要針對申報使用，更新頻率相對頻繁，可免費使用，可依情境選用此代碼。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/laboratory-category-tw"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding:TWLaboratoryCategory.system",
        "path" : "DiagnosticReport.code.coding.system",
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding:TWLaboratoryCategory.code",
        "path" : "DiagnosticReport.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding:TW2021ICD10PCS",
        "path" : "DiagnosticReport.code.coding",
        "sliceName" : "TW2021ICD10PCS",
        "short" : "此為臺灣健保署2021年中文版ICD-10-PCS，可免費使用，可依情境選用此代碼。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2021-tw"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding:TW2021ICD10PCS.system",
        "path" : "DiagnosticReport.code.coding.system",
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding:TW2021ICD10PCS.code",
        "path" : "DiagnosticReport.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding:TW2023ICD10PCS",
        "path" : "DiagnosticReport.code.coding",
        "sliceName" : "TW2023ICD10PCS",
        "short" : "此為臺灣健保署2023年中文版ICD-10-PCS，可免費使用，可依情境選用此代碼。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2023-tw"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding:TW2023ICD10PCS.system",
        "path" : "DiagnosticReport.code.coding.system",
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding:TW2023ICD10PCS.code",
        "path" : "DiagnosticReport.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.subject",
        "path" : "DiagnosticReport.subject",
        "short" : "報告的對象—通常但不總是病人",
        "definition" : "報告的對象體，通常但不總是病人。然而，診斷服務也對從其他各種來源收集的檢體進行分析。",
        "requirements" : " **必須（SHALL）** 知道對象的背景",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.encounter",
        "path" : "DiagnosticReport.encounter",
        "short" : "請求檢驗時的健康照護事件",
        "definition" : "此DiagnosticReport所涉及的健康照護事件（例如：病人和健康照護服務提供者的互動）。",
        "comment" : "這通常是事件發生的就醫，但有些事件可能是在就醫完成之前或之後開始，但仍與就醫的情境有關（如住院前的實驗室檢驗）。",
        "requirements" : "將此服務請求連接就醫（Encounter）情境",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "short" : "與臨床相關的時間／報告的時段",
        "definition" : "觀察值與之相關的時間或時段。當報告的對象是病人時，這通常是處置的時間或檢體採集的時間，但往往不知道日期／時間的來源，只知道日期／時間本身。",
        "comment" : "如果對病人進行診斷處置，這就是進行該處置的時間。如果有檢體，可以從檢體採集時間得出診斷相關時間，但檢體資訊並不總是可用，而且檢體和診斷相關時間之間並不總是自動的確切關係。",
        "requirements" : "需要知道在病歷的什麼地方儲存檔案／呈現此報告",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.issued",
        "path" : "DiagnosticReport.issued",
        "short" : "此版本完成的日期時間",
        "definition" : "這個版本的報告提供給健康照護提供者的日期和時間，通常是在報告被審查和核實之後。",
        "comment" : "可能與resource本身的更新時間不同，因為那是紀錄的狀態（可能是第二個副本），而不是發報告的實際時間。",
        "requirements" : "臨床醫師需要確認報告的發布日期",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.performer",
        "path" : "DiagnosticReport.performer",
        "short" : "對診斷服務負責者",
        "definition" : "負責發此報告的診斷服務",
        "comment" : "這不一定是一些混合的不可被中斷的一個或一系列資料項目的來源或解釋結果的實體，它是對臨床報告負責的實體。",
        "requirements" : "如果對結果有疑問，需要知道應與誰聯絡；還可能需要追蹤次級資料分析的報告來源。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.resultsInterpreter",
        "path" : "DiagnosticReport.resultsInterpreter",
        "short" : "主要結果的解釋者",
        "definition" : "對報告的結論和解釋負責的健康照護服務提供者或組織",
        "comment" : "可能不是對臨床報告負責的同一個實體",
        "requirements" : "如果對結果有疑問，需要知道應與誰聯絡；還可能需要追蹤次級資料分析的報告來源。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.specimen",
        "path" : "DiagnosticReport.specimen",
        "short" : "此報告所依據的檢體",
        "definition" : "關於此診斷報告所依據的檢體的詳細資訊",
        "comment" : "如果在檢驗結果名稱中充分指明檢體的代碼，那麼此附加資料就可能是多餘的。如果有多個檢體，可在每個檢驗檢查或檢驗檢查套組中表示。",
        "requirements" : "需要能夠報告已收集檢體之資訊，這些資訊是報告的基礎。"
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "short" : "檢驗檢查",
        "definition" : "[檢驗檢查](observation.html)為此診斷報告的一部分",
        "comment" : "Observations可包含檢驗檢查值",
        "requirements" : "需支援單一結果或一組結果，結果分組是隨機但有意義的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.imagingStudy",
        "path" : "DiagnosticReport.imagingStudy",
        "short" : "參照至與診斷報告相關的成像之全部細節",
        "definition" : "一個或多個連結指向診斷調查期間進行的任何成像的全部細節。一般情況下，這是由支援DICOM的儀器進行的成像，但這並不是必須的。一個完整的PACS viewer可以使用這些資訊來提供來源影像的視圖。",
        "comment" : "影像檢查（ImagingStudy）和影像（image）資料項目在某種程度上是重疊的—通常，影像（image）資料項目的影像參照清單也會在某個影像檢查（ImagingStudy） resource中找到。然而，每一種都迎合了不同類型的目的的顯示。兩者都不提供，或者兩者都提供。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.media",
        "path" : "DiagnosticReport.media",
        "short" : "與此報告相關的關鍵影像",
        "definition" : "與此報告相關的關鍵影像的清單。這些影像一般是在診斷過程中產生的，可以直接是病人的，也可以是經過處理的檢體（即感興趣的玻片）。",
        "requirements" : "許多診斷服務包含將報告中的影像作為服務的一部份"
      },
      {
        "id" : "DiagnosticReport.media.comment",
        "path" : "DiagnosticReport.media.comment",
        "short" : "關於影像的意見（例如：解釋）。",
        "definition" : "關於影像的意見，一般情況下，這是用來解釋為什麼影像被包括在內，或請瀏覽者注意重要特徵。",
        "comment" : "此意見應與影像一起顯示，報告中通常會在其他部分（如結論）對影像內容進行補充討論。",
        "requirements" : "此報告的健康照護提供者應該對報告中每張影像做出意見"
      },
      {
        "id" : "DiagnosticReport.media.link",
        "path" : "DiagnosticReport.media.link",
        "short" : "參照的影像來源",
        "definition" : "參照的影像來源",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.conclusion",
        "path" : "DiagnosticReport.conclusion",
        "short" : "檢驗結果的臨床結論（解釋）",
        "definition" : "此診斷報告的簡要及臨床情境的摘要結論（解釋／臆斷）",
        "requirements" : "需要能夠提供一個不會在基本結果資料中丟失結論",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.conclusionCode",
        "path" : "DiagnosticReport.conclusionCode",
        "short" : "檢驗結果的臨床結論的代碼；應填入所綁定值集值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
        "definition" : "代表診斷報告的摘要結論（解釋／臆斷）的一個或多個代碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/clinical-findings"
        }
      },
      {
        "id" : "DiagnosticReport.presentedForm",
        "path" : "DiagnosticReport.presentedForm",
        "short" : "已發佈的整個報告",
        "definition" : "診斷服務發佈之含豐富文字的整個結果，允許多種格式，但它們在語義上 **必須（SHALL）** 是相同的。",
        "comment" : "在這種情況下，「application／pdf 」被推薦為最可靠及最可互操作的格式。",
        "requirements" : "讓實驗室有能力為臨床真實性提供自己的完全格式化報告"
      }
    ]
  }
}

```
