# TW Core Implantable Device - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Implantable Device 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreImplantableDevice |

 
此臺灣核心-植入式裝置（TW Core Implantable Device） Profile說明本IG如何進一步定義FHIR的Device Resource以呈現植入式裝置資料。 

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core Implantable Device](StructureDefinition-Device-twcore.md), [TW Core Pediatric Weight for Height Observation](StructureDefinition-Observation-pediatric-weight-height-twcore.md), [TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md) and [TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [Device/dev-example](Device-dev-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Device-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Device-twcore.csv), [Excel](StructureDefinition-Device-twcore.xlsx), [Schematron](StructureDefinition-Device-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須應該支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Device-patient.md)**查詢所有Device：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Device?patient={Type/}[id]`例子：
(1) GET [base]/Device?patient=Patient/pat-example

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Device-patient.md)**及**[`type`](SearchParameter-Device-type.md)**查詢所有Device：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Device?patient={Type/}[id]&type={system|}[code]`例子：
(1) GET [base]/Device?patient=Patient/pat-example&type=http://snomed.info/sct|468063009
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Device-patient.md)**及**[`status`](SearchParameter-Device-status.md)**查詢所有Device：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Device?patient={Type/}[id]&status=[code]`例子：
(1) GET [base]/Device?patient=Patient/pat-example&status=active



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Device-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreImplantableDevice",
  "title" : "TW Core Implantable Device",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-植入式裝置（TW Core Implantable Device） Profile說明本IG如何進一步定義FHIR的Device Resource以呈現植入式裝置資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "udi",
      "uri" : "http://fda.gov/UDI",
      "name" : "UDI Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Device",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Device",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Device",
        "path" : "Device",
        "short" : "植入式醫療器材"
      },
      {
        "id" : "Device.identifier",
        "path" : "Device.identifier",
        "short" : "植入式醫療器材識別代碼，可為機構內器材代碼或為醫療器材單一識別碼之產品識別碼(UDI-DI)",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier",
        "path" : "Device.udiCarrier",
        "short" : "醫療器材單一識別標示，詳細規定可參考「醫療器材標籤應刊載單一識別碼規定」。",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.deviceIdentifier",
        "path" : "Device.udiCarrier.deviceIdentifier",
        "short" : "醫療器材單一識別碼之產品識別碼(UDI-DI)。可於食品藥物管理署「醫療器材單一識別系統資訊管理平台(udid.fda.gov.tw)」查詢相關資訊。",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueString" : "08436569590324"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.carrierHRF",
        "path" : "Device.udiCarrier.carrierHRF",
        "short" : "醫療器材單一識別標示之人眼可識別資訊(HRI)",
        "alias" : ["UDI", "Barcode String"],
        "example" : [
          {
            "label" : "General",
            "valueString" : "(01)08436569590324(17)250101(10)PT13254"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Device.manufacturer",
        "path" : "Device.manufacturer",
        "short" : "製造商",
        "mustSupport" : true
      },
      {
        "id" : "Device.expirationDate",
        "path" : "Device.expirationDate",
        "short" : "有效期限。格式：YYYY-MM-DD",
        "example" : [
          {
            "label" : "General",
            "valueDateTime" : "2025-01-01"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Device.lotNumber",
        "path" : "Device.lotNumber",
        "short" : "批號",
        "example" : [
          {
            "label" : "General",
            "valueString" : "250101"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Device.serialNumber",
        "path" : "Device.serialNumber",
        "short" : "序號",
        "example" : [
          {
            "label" : "S1538501",
            "valueString" : "S1538501"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Device.type",
        "path" : "Device.type",
        "short" : "醫療器材產品類別",
        "mustSupport" : true
      },
      {
        "id" : "Device.patient",
        "path" : "Device.patient",
        "short" : "病人資訊",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Device.owner",
        "path" : "Device.owner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Device.location",
        "path" : "Device.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Device.parent",
        "path" : "Device.parent",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
