# TW Core Coverage - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Coverage 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coverage-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreCoverage |

 
此臺灣核心-給付範圍(TW Core Coverage) Profile 說明本 IG 如何進一步定義 FHIR 的 Coverage Resource 以呈現給付範圍資料。 

**Usages:**

* Refer to this Profile: [TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [Coverage/coverage-example](Coverage-coverage-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Coverage-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Coverage-twcore.csv), [Excel](StructureDefinition-Coverage-twcore.xlsx), [Schematron](StructureDefinition-Coverage-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Coverage-patient.md)**查詢所有Coverage：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Coverage?patient={Type/}[id]`例子：
(1) GET [base]/Coverage?patient=Patient/pat-example



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Coverage-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coverage-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreCoverage",
  "title" : "TW Core Coverage",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-給付範圍(TW Core Coverage) Profile 說明本 IG 如何進一步定義 FHIR 的 Coverage Resource 以呈現給付範圍資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage",
        "short" : "保險、醫療計畫或付款協議",
        "constraint" : [
          {
            "key" : "tw-core-9",
            "severity" : "error",
            "human" : "Member Id in Coverage.identifier or Coverage.subscriberId SHALL be present",
            "expression" : "identifier.type.coding.where(system='http://terminology.hl7.org/CodeSystem/v2-0203' and code='MB').exists() or subscriberId.exists()",
            "xpath" : "f:identifier or f:subscriberId",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coverage-twcore"
          }
        ]
      },
      {
        "id" : "Coverage.implicitRules",
        "path" : "Coverage.implicitRules",
        "short" : "本資源內容的處理規則"
      },
      {
        "id" : "Coverage.modifierExtension",
        "path" : "Coverage.modifierExtension",
        "short" : "擴充內容可能會改變資源解釋方式"
      },
      {
        "id" : "Coverage.identifier",
        "path" : "Coverage.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "short" : "會員 ID 及其他識別碼",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.identifier:memberid",
        "path" : "Coverage.identifier",
        "sliceName" : "memberid",
        "short" : "會員 ID",
        "min" : 0,
        "max" : "1",
        "condition" : ["tw-core-3"],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.identifier:memberid.type",
        "path" : "Coverage.identifier.type",
        "short" : "會員號碼識別碼類型",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "MB"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Coverage.identifier:memberid.assigner",
        "path" : "Coverage.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.status",
        "path" : "Coverage.status",
        "comment" : "`Coverage.status` 本身並不表示個人的保險是否已終止或個人未被保險。也需要考慮 `Coverage.period`。",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.type",
        "path" : "Coverage.type",
        "short" : "保險類型",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/coverage-type"
        }
      },
      {
        "id" : "Coverage.policyHolder",
        "path" : "Coverage.policyHolder",
        "short" : "保單持有人",
        "comment" : "保單的擁有者，可以是個人或組織",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.subscriber",
        "path" : "Coverage.subscriber",
        "short" : "被保險人 (訂閱者)",
        "comment" : "保單中的主要被保險人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.subscriberId",
        "path" : "Coverage.subscriberId",
        "short" : "被保險人 (訂閱者) ID",
        "comment" : "支付者在訂閱者 ID 卡上分配的識別碼",
        "condition" : ["tw-core-3"],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.beneficiary",
        "path" : "Coverage.beneficiary",
        "short" : "受益人",
        "comment" : "支付者分配給會員的識別碼。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.relationship",
        "path" : "Coverage.relationship",
        "short" : "與被保險人關係",
        "comment" : "會員與被保險人 (訂閱者) 的關係",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Coverage.period",
        "path" : "Coverage.period",
        "short" : "保險期間",
        "comment" : "合約生效日期和合約終止或保險變更的日期。",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.payor",
        "path" : "Coverage.payor",
        "short" : "保險給付者",
        "comment" : "保單的發行機構",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class",
        "path" : "Coverage.class",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "description" : "基於值模式的切片",
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "保險分類資訊",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:group",
        "path" : "Coverage.class",
        "sliceName" : "group",
        "short" : "群組",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:group.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "group"
            }
          ]
        }
      },
      {
        "id" : "Coverage.class:group.value",
        "path" : "Coverage.class.value",
        "short" : "群組編號",
        "comment" : "雇主帳戶識別碼",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:group.name",
        "path" : "Coverage.class.name",
        "short" : "群組名稱",
        "comment" : "雇主帳戶名稱 (135)",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:plan",
        "path" : "Coverage.class",
        "sliceName" : "plan",
        "short" : "計畫",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:plan.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "plan"
            }
          ]
        }
      },
      {
        "id" : "Coverage.class:plan.value",
        "path" : "Coverage.class.value",
        "short" : "計畫編號",
        "comment" : "健康計畫用來描述其福利項目的商業概念",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:plan.name",
        "path" : "Coverage.class.name",
        "short" : "計畫名稱",
        "comment" : "分配給計畫識別碼的健康計畫福利項目名稱",
        "mustSupport" : true
      }
    ]
  }
}

```
