# TW Core Bundle - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Bundle 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreBundle |

 
此臺灣核心-資料交換基本單位（TW Core Bundle） Profile說明本IG如何進一步定義FHIR的Bundle Resource以呈現資料交換基本單位的詳細資料。 

## Resource Bundle - 內容

一個用於儲存一組resources的容器（container）。

### 範圍與使用

常見的操作是將一堆 resources 集合在一起，放到一個單獨的地方，同時保留它們的相關訊息。在 FHIR 中，這個操作叫做「bundling resources」。這樣做對於很多不同的情境都很有用，例如：

* 在伺服器操作中返回符合某些準則的一組 resources（參見 [RESTful Search](http://hl7.org/fhir/R4/http.html#search)）
* 在伺服器上的歷史紀錄操作中返回 resources 的一組版本（參見 [History](http://hl7.org/fhir/R4/http.html#history)）
* 將一組 resources 作為訊息交換的一部分發送（參見 [Messaging](http://hl7.org/fhir/R4/messaging.html)）
* 將一組內嵌（self-contained）的 resources 集合在一起，形成可互換且可保存的集合，具有臨床完整性，例如臨床文件。（參見 [Documents](http://hl7.org/fhir/R4/documents.html)）
* 在伺服器上作為單一操作創建/更新/刪除一組 resources（包括作為單個原子交易進行，意即一個不可再分的、不可切分的交易，它要麼完全執行，要麼完全不執行。）（參見 [Transactions](http://hl7.org/fhir/R4/http.html#transaction)）
* 儲存一組resources

### 界限與關聯

有兩種方式可以將 resources 聚集在一起以便於傳輸和永久化：分別為「[內嵌的resources](http://hl7.org/fhir/R4/references.html#contained)」和「bundles」。兩者之間有一個重要的區別：

* 內嵌的 resources 是「在」容器內部：它們只能在容器的上下文中被解釋和/或改變。
* bundle是一組可以獨立存在的 resources ：例如，它們也可能直接透過[RESTful API](http://hl7.org/fhir/R4/http.html)被存取

除了這兩種技術機制之外，還有三種行政和基礎建設的 resources ，也支援內容的分組（grouping）。這些 resources 不直接包含其他 resources ，而是使用「Reference」來指向被分組的resources：

* [List（清單）](http://hl7.org/fhir/R4/list.html) resource — 列舉一組平面的 resources 並提供管理這組 resources 的功能。雖然一個特定的List實例可能代表某一個時刻的一個「快照（snapshot）」為這個清單提供一個內容視圖，但從業務過程的角度來看，「List」的概念是動態的 ，它會隨著時間的流逝，項目會被增加和移除。这种動態性使得List成为一个靈活的工具，可以用来跟踪和管理隨著時間變化的 resources 集合．List resource參照其他 resources ，它的使用可能有特定的業務意義。
* [Group（群體）](http://hl7.org/fhir/R4/group.html) resource — 透過列舉或描述群組成員的特質來定義特定的人員、動物、裝置等的Group。Group resource 可能會隱式地參照其他 resources 。Group旨在作為一個整體被操作或觀察；例如：對一個Group進行治療、計算一個群體的風險等。這個 resource 通常用於公共衛生（例如：描述一個高風險人群）、臨床試驗（例如：定義一個試驗對象）和類似目的。
* [Composition（臨床文件架構）](StructureDefinition-Composition-twcore.md) resource — 定義了一組健康相關的資訊，這些資訊被組合在一起形成一份單一邏輯的文件，提供了一個連貫的意義聲明，建立了其自身的上下文，並對於誰在做出聲明提供臨床證明。Composition resource 提供了一個FHIR [文件（document）](https://hl7.org/fhir/R4/documents.html)的基本結構。文件的全部內容使用Bundle來表達，Compositions經常參照Lists作為特定小節（`sections`）的焦點（`focus`）。

這三個 resources 代表它們所參照的 resources 的有意義的分組（例如：一個出院用藥的List，一個臨床試驗參與者的Group，一組已簽名文件的resources），而一個bundle僅僅是用於傳輸和儲存的 resources 的容器。這些未必詳盡，其他的 resources 也提供了群組功能。

**Usages:**

* Derived from this Profile: [TW Core Bundle Document](StructureDefinition-Bundle-document-twcore.md) and [TW Core Bundle Message](StructureDefinition-Bundle-message-twcore.md)
* Examples for this Profile: [Bundle/bun-example](Bundle-bun-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Bundle-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Bundle-twcore.csv), [Excel](StructureDefinition-Bundle-twcore.xlsx), [Schematron](StructureDefinition-Bundle-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Bundle-id.md)**查詢所有Bundle：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Bundle?_id=[id]`
`GET [base]/Bundle/[id]`例子：
(1) GET [base]/Bundle?_id=bun-example
(2) GET [base]/Bundle/bun-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Bundle-identifier.md)**查詢所有Bundle：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Bundle?identifier={system|}[code]`例子：
(1) GET [base]/Bundle?identifier=https://www.cdc.gov.tw/|01014857930415100059403



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Bundle-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreBundle",
  "title" : "TW Core Bundle",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-資料交換基本單位（TW Core Bundle） Profile說明本IG如何進一步定義FHIR的Bundle Resource以呈現資料交換基本單位的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "包含resourceBundle",
        "definition" : "用於存於一組Resources的結構或物件"
      },
      {
        "id" : "Bundle.id",
        "path" : "Bundle.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Bundle紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Bundle.meta",
        "path" : "Bundle.meta",
        "short" : "此Bundle Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Bundle.implicitRules",
        "path" : "Bundle.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Bundle.language",
        "path" : "Bundle.language",
        "short" : "用以表述Bundle Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "short" : "一組Resources的資料交換基本單位（Bundle）的識別碼。",
        "definition" : "Bundle的永久識別碼，識別碼不會因為Bundle從一個伺服器複製到另一個伺服器而改變。。",
        "comment" : "永久的識別通常只對Document、Message和Collection的批次處理是重要。它通常不會被填入到searh和history的結果中，伺服器在處理batches和transactions時會忽略Bundle.identifier。但對於Documents的identifier **必須（SHALL）** 被填入，其為全球唯一的識別碼。",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "definition" : "表明這個Bundle的目的-期望如何使用。",
        "comment" : "Bundle也可以用於其他目的（例如，document可以作為transaction被接受）。這主要是為了給某些Bundle類型制定特定的規則。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "BundleType"
            }
          ],
          "strength" : "required",
          "description" : "Bundle類型；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/bundle-type|4.0.1"
        }
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "short" : "組成Bundle的時間。",
        "definition" : "Bundle組裝的日期/時間 - 也就是resources被放入Bundle的時間。",
        "comment" : "對很多Bundle而言，時間戳記同等於.meta.lastUpdated，因為它們不會被儲存（例如：查詢結果）。當一個Bundl被放置在一個持久化存儲中（a persistent store）時，.meta.lastUpdated通常會被伺服器改變。當Bundle是一個Message時，中介軟體（即使沒有存儲）**建議應該（SHOULD）**更新.meta.lastUpdated。.timestamp用於追踪Bundle的原始時間，並且**建議應該（SHOULD）**被填入。\n\n使用方法：\n* document : 文件的創建日期。注意：composition的創建可能早於Bundle的創鍵，或者composition會與多個文件相關聯。composition的編輯日期可能早於Bundle的組成時間。\n* mssage：訊息內容被組成的日期。這個日期不會被中介軟體引擎改變，除非他們增加了額外的資料，改變了訊息的時間含義。\n* history : 歷史紀錄被組成的日期。這個時間將被用於查詢_since（自此）時間後的後續更新紀錄。\n* searchset : 查詢結果集：是指查詢結果組合起來的時間。要注意的是，不同的頁面**可能（MAY）**會有不同的時間標記，但不是必須的。即使時間標記不同，也不代表隨後的頁面會顯示或包含從最初查詢後所做的變更。\n\ntransaction | transaction-response | batch | batch-response | collection : 沒有特別指定的含義。\n時間戳記的值應該比Bundle中的resources的 lastUpdated 和其他時間戳記還要新，而且應該等於或早於Bundle本身的 .meta.lastUpdated 相同或更早。",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.total",
        "path" : "Bundle.total",
        "short" : "查詢時符合條件的總筆數",
        "definition" : "如果有一組查詢結果相符，這個數字代表所有頁面中 type「match」條目的總數。這個總數不包括search.mode=「include」 或 「outcome」的查詢結果，也不表示Bundle內全部條目的數量。",
        "comment" : "只在Bundle是查詢結果集時使用。這個總數不包括像是OperationOutcome和Bundle中包含的resources等，只計算匹配的resources的總數。"
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "short" : "與此Bundle相關的連結",
        "definition" : "一系列連結，為這個Bundle提供上下文。",
        "comment" : "Bundle.link和Bundle.entry.link的設計是為了在使用Bundle時（例如實現HATEOAS時）提供更多的上下文資訊。\n\n如果entry中的resource是直接被讀取的，那麼Bundle.entry.link就對應於HTTP header中的連結。\n\n雖然這個規範對於查詢和分頁有一些Bundle.link的特定使用方式，但對於Bundle.entry.link沒有特定的使用方式，也沒有在transaction過程中定義其功能 - 它的具體意義取決於實際的應用方式。"
      },
      {
        "id" : "Bundle.link.relation",
        "path" : "Bundle.link.relation",
        "short" : "參見 [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1)",
        "definition" : "詳細說明該連結功能用途的名稱 - 參見[http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1)"
      },
      {
        "id" : "Bundle.link.url",
        "path" : "Bundle.link.url",
        "short" : "連結的參照細節",
        "definition" : "連結的參照細節"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "short" : "在bundle中的條目 - 將會有一個resource或資訊，這個重複的資料項目順序：對於type為「document」和「message」的bundles，第一個resource是特殊的（必須分別是Composition或MessageHeader）。對於所有bundles，條目順序的意義取決於bundle的type。",
        "definition" : "Bundle resource中的條目 - 將包含一個resource或是關於resource的資訊（僅限transactions和history）。"
      },
      {
        "id" : "Bundle.entry.link",
        "path" : "Bundle.entry.link",
        "short" : "與本條目相關的連結",
        "definition" : "為本條目提供情境背景的一系列連結。"
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "short" : "Resource的 URI（絕對 URL 伺服器地址或 UUID/OID 的 URI）",
        "definition" : "resource的絕對URL。fullUrl **必須沒有(SHALL NOT)**與resource中的 id 不一致，也就是說如果 fullUrl 不是 urn:uuid，則 URL 應為與 Resource.id 一致的不分版本的URL。fullUrl 是對resource的不分版本參照。fullUrl 資料項目必須有一個值，但以下情況除外：\n\n在 POST 時，fullUrl 可以為空（雖然在 bundle 中包含暫時 id 時，fullUrl 不需要為空）\n操作結果可能涉及未被識別的resources。",
        "comment" : "fullUrl 在resource上下文中可能不是唯一的。請注意：由於 FHIR resource不需要透過 FHIR API 提供服務，因此 fullURL 可能是一個 URN 或絕對 URL，而不是以resource的邏輯 id（Resource.id）結尾。但是，如果 fullUrl 看起來確實像 RESTful 伺服器 URL（例如：符合正則表達式regex，則 fullUrl 的 「id」部分 **必須（SHALL）** 以 Resource.id 結尾。\n\n請注意：fullUrl 與 canonical URL（正準URL） 並不相同，fullUrl是為resource提供服務的端點的絕對 URL（這些在為 resource 帶有 canonical URL 的 Canonical 伺服器上將具有相同的值）。"
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "short" : "Bundle中的resource",
        "definition" : "Bundle中的resource。resource的目的/含義由 Bundle.type 決定。"
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "short" : "查詢有關的資訊",
        "definition" : "有關如何進行查詢才能創建此條目的解釋資訊。"
      },
      {
        "id" : "Bundle.entry.search.mode",
        "path" : "Bundle.entry.search.mode",
        "short" : "match | include | outcome",
        "definition" : "此條目出現在結果集中的原因--是因為符合match要求還是因為 _include 要求，或者是為了傳達有關查詢過程的資訊或警告資訊。 ",
        "comment" : "只有一種模式。在某些情況下，一個resource可能會被包含，因為它既是match也是include的resource。在這種情況下，「match」優先。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SearchEntryMode"
            }
          ],
          "strength" : "required",
          "description" : "Resource出現在Bundle中的原因；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/search-entry-mode|4.0.1"
        }
      },
      {
        "id" : "Bundle.entry.search.score",
        "path" : "Bundle.entry.search.score",
        "short" : "查詢排名（0至1之間）",
        "definition" : "查詢時，該條目在伺服器上的查詢排名得分。",
        "comment" : "伺服器無需返回排名得分，1 表示最相關，0 表示最不相關。通常情況下，查詢結果按得分排序，但用戶可指定不同的排序順序。\n\n請參閱「病人匹配（Patient Match）」以了解與此資料項目相關的 EMPI 查詢。請參閱[Patient Match]（http://hl7.org/fhir/R4/patient-operation-match.html），了解與此要素相關的 EMPI 查詢。"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "short" : "其他執行資訊（transaction/batch/history）",
        "definition" : "關於如何將條目作為transaction或batch的一部分進行處理的附加資訊。對於history，它顯示如何處理條目以創建條目中包含的版本。"
      },
      {
        "id" : "Bundle.entry.request.method",
        "path" : "Bundle.entry.request.method",
        "definition" : "在 transaction 或 batch 中，這是此條目要執行的 HTTP 操作。在history Bundle中，這表示發生的 HTTP 操作。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "HTTPVerb"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/http-verb|4.0.1"
        }
      },
      {
        "id" : "Bundle.entry.request.url",
        "path" : "Bundle.entry.request.url",
        "short" : "此Bundle HTTP 對應的 URL",
        "definition" : "此條目相對於根地址（請求發布的地址）的 URL。",
        "comment" : "例如：對於 病人創建（Patient Create），方法是 「POST」，URL 是 「Patient」。對於病人更新（Patient Update），方法是 「PUT」，URL 是 「Patient/[id]」。"
      },
      {
        "id" : "Bundle.entry.request.ifNoneMatch",
        "path" : "Bundle.entry.request.ifNoneMatch",
        "short" : "用於管理緩存當前狀態",
        "definition" : "如果 ETag 值匹配，則返回 304 未修改狀態（Not Modified）。請參閱「[有條件讀取（Conditional Read）]（http://hl7.org/fhir/R4/http.html#cread）」的 API 文件。"
      },
      {
        "id" : "Bundle.entry.request.ifModifiedSince",
        "path" : "Bundle.entry.request.ifModifiedSince",
        "short" : "用於管理緩存當前狀態",
        "definition" : "僅在最後更新日期匹配時執行操作。請參閱 「[有條件讀取（Conditional Read）]（http://hl7.org/fhir/R4/http.html#cread）」的 API 文件。"
      },
      {
        "id" : "Bundle.entry.request.ifMatch",
        "path" : "Bundle.entry.request.ifMatch",
        "short" : "用於管理更新衝突",
        "definition" : "只有在 Etag 值匹配時才執行操作。有關詳細資訊，請參閱 API 部分 「[管理resource衝突]（http://hl7.org/fhir/R4/http.html#concurrency）」。"
      },
      {
        "id" : "Bundle.entry.request.ifNoneExist",
        "path" : "Bundle.entry.request.ifNoneExist",
        "short" : "用於有條件建立",
        "definition" : "如果指定的resource已經存在，則指示伺服器不執行創建。有關詳細資訊，請參閱 「[有條件創建 （Conditional Creage）]（http://hl7.org/fhir/R4/http.html#ccreate）」的 API 文件。這只是 URL 的查詢部分，即「? 」後面的內容（不包括「?」）。"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "short" : "執行結果（transaction/batch/history）",
        "definition" : "表表示 batch 或 transaction 中相應「請求」條目的處理結果，或返回history時的操作結果。"
      },
      {
        "id" : "Bundle.entry.response.status",
        "path" : "Bundle.entry.response.status",
        "short" : "狀態回應代碼（文字選填）",
        "definition" : "處理此條目時返回的狀態編碼。狀態 **必須（SHALL）** 以三位 HTTP 編碼（如 404）開頭，並可包含與狀態編碼相關的標準 HTTP 描述。"
      },
      {
        "id" : "Bundle.entry.response.location",
        "path" : "Bundle.entry.response.location",
        "short" : "位置（如果操作返回位置）",
        "definition" : "處理該操作時創建的位置表頭（location header），如果該操作返回位置，則填入該位地置表頭。"
      },
      {
        "id" : "Bundle.entry.response.etag",
        "path" : "Bundle.entry.response.etag",
        "short" : "resource的 Etag（如果有相關）",
        "definition" : "resource的 Etag，如果條目的操作產生了版本化resource（請參閱 「[Resource Metadata及版本化和管理resource衝突」]（http://hl7.org/fhir/R4/http.html#versioning））。",
        "comment" : "Etag 與 Resource.meta.versionId 匹配。如果包含resource，ETag 必須與表頭中的版本 ID 相匹配。"
      },
      {
        "id" : "Bundle.entry.response.lastModified",
        "path" : "Bundle.entry.response.lastModified",
        "short" : "修改時之伺服器日期時間",
        "definition" : "此resource在伺服器上被修改的日期/時間。",
        "comment" : "如果包含resource，則必須與meta.lastUpdated中的時間一致。"
      },
      {
        "id" : "Bundle.entry.response.outcome",
        "path" : "Bundle.entry.response.outcome",
        "short" : "帶提示和警告的OperationOutcome（用於batch/transaction）",
        "definition" : "操作結果（OperationOutcome），包含在batch或transaction中處理此條目時產生的提示和警告。",
        "comment" : "對於 POST/PUT 操作，這是 prefer = operationoutcome 將返回的等價結果，但無論是否返回結果，resource都會被返回。此結果不用於批次處理/異動處理中的錯誤響應，僅用於提示和警告。在批次處理操作中，錯誤將出現在 Bundle.entry.response 中，而在異動處理中，如果出現錯誤，將只有一個 OperationOutcome 而不是一個 bundle。"
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "數位簽章",
        "definition" : "數位簽章 - base64 編碼。XML-DSig 或 JWT。",
        "comment" : "簽章可以由bundle的「作者（author）」或是發起的設備所創建。關於是否要包含簽章、如何驗證簽章，以及如何處理已簽章與未簽章的bundle，這些要求會根據實作的環境而有所不同。",
        "requirements" : "簽章（Signature）以 FHIR 可存取的形式保存簽章及其支持上下文的電子表述。簽章可以是加密類型（XML DigSig 或 JWS），能夠提供不可否認性證明，也可以是表示簽章或簽章過程的圖形化圖像。該資料項目允許截取 document、message、transation甚至search回應上的簽章，以支持內容驗證、不可否認性或其他業務情況。這主要適用於Bundle可能透過多節點傳輸或其他機制傳輸的情況，因為 HTTPS 的不可否認性是不夠的。"
      }
    ]
  }
}

```
