# TW Core Bundle Document - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Bundle Document 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-document-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreBundleDocument |

 
此臺灣核心-資料交換基本單位-文件（TW Core Bundle Document） Profile說明本IG如何進一步定義臺灣核心-資料交換基本單位(TW Core Bundle） Profile以呈現 Bundle 文件 的詳細資料。 

**Usages:**

* Examples for this Profile: [Bundle/bun-document-example](Bundle-bun-document-example.md) and [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Bundle-document-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Bundle-document-twcore.csv), [Excel](StructureDefinition-Bundle-document-twcore.xlsx), [Schematron](StructureDefinition-Bundle-document-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Bundle-id.md)**查詢所有Bundle：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Bundle?_id=[id]`
`GET [base]/Bundle/[id]`例子：
(1) GET [base]/Bundle?_id=bun-document-example
(2) GET [base]/Bundle/bun-document-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Bundle-identifier.md)**查詢所有Bundle：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Bundle?identifier={system|}[code]`例子：
(1) GET [base]/Bundle?identifier=https://www.cdc.gov.tw/|01010905170415100000000



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Bundle-document-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-document-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreBundleDocument",
  "title" : "TW Core Bundle Document",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-資料交換基本單位-文件（TW Core Bundle Document） Profile說明本IG如何進一步定義臺灣核心-資料交換基本單位(TW Core Bundle） Profile以呈現 Bundle 文件 的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "patternCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Bundle.entry:TWCoreComposition",
        "path" : "Bundle.entry",
        "sliceName" : "TWCoreComposition",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:TWCoreComposition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
