# TW Core AllergyIntolerance - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core AllergyIntolerance 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreAllergyIntolerance |

 
此臺灣核心-過敏或不耐症（TW Core AllergyIntolerance） Profile說明本IG如何進一步定義FHIR的AllergyIntolerance Resource以呈現過敏與不耐症的詳細資料。 

## Resource AllergyIntolerance - 內容

這是指一個人在接觸某種物質後，可能會出現的對該個人來說獨有的有害或不想要的生理反應的風險。

### 範圍與使用

這是一份關於臨床評估過敏或不耐症的紀錄；一個人對於在未來接觸特定物質或類別物質時，可能出現不良反應的傾向或潛在風險。

當這種傾向被識別出來時，會記錄有關反應事件的資訊或證據，該事件是由於個人接觸已識別的物質或類別物質而觸發的，特點是對該個人來說特有的有害或不希望的生理反應。

物質包括但不限於：對個人以適當劑量正確施用的治療性物質、食物、從植物或動物中提取的材料（material）、或昆蟲叮咬的毒液。

**國際HL7給FHIR審稿人的注意事項，實作者亦可留意**

目前這個 resource （R4版） 面臨的開放性問題包括：

* 這個 resource 代表一種對某些物質的過敏狀態，包含支援事件和（或）症狀的清單，但與事件通報沒有直接關係；當 FHIR 中加入不良事件通報 resource（s）和（或） profiles 時，將重新評估此事。
* 其他的 HL7 模型和 openEHR archetype 包含了「暴露日期（exposure date）」，但在調查的任何系統中都未發現此資料項目，因此它將被當作一個擴充資料項目（更適合於不良事件通報）。

### 界限與關聯

這個 resource 提供一個統一的位置，在健康紀錄中記錄關於對某些物質或產品的不良反應的各種臨床描述，包括：

* 評估個人在再次接觸時可能會有的潛在反應
* 紀錄每次接觸後反應的詳細資訊，如果沒有反應也要記錄下來

使用這個 resource 來記錄有關不良反應風險存在的資訊，目的是：

* 支援個人的直接臨床照護
* 作為管理不良反應或過敏/不耐症清單的一部分
* 促進有關不良反應傾向和事件的資訊交流
* 幫助通報不良反應
* 支援如臨床決策支援和警示等電腦化的基於知識的活動

用於記錄對廣泛物質的不良反應資訊，包括：生物和血品、藥物製劑中的賦形劑（Excipients）、食物、金屬鹽、以及有機化學化合物。

不良反應可能是：

* 過敏（通常是I型過敏反應，加上其他「類過敏」反應，包括偽過敏）
* 不耐症（通常是非免疫性的不良反應，這些反應沒有被確定或認為是過敏或「類過敏」的，並且在某種程度上是特異性的或個別特有的[即在類似情況下，並非預期會在大多數或所有病人中發生的反應]）

在臨床實務中，區分過敏或不耐症是困難的，可能也不實際。通常「過敏」一詞被相當泛化地使用，可能與「不耐症」重疊，這兩個概念之間的界限可能不是很明確或被理解。如上所述，「不耐症」一詞通常應用於不良反應的傾向，這種傾向要麼被確定（在可能的範圍內），要麼被認為不是過敏或「類過敏」的。如果無法確定某個特定的傾向狀態是過敏還是不耐症，那麼應該從 resource 中省略該類型（`type`）資料項目。識別反應的`type`不代表對病人的嚴重性或傷害風險的評估，若要進行這類的評估，應該透過記錄臨床表現和評估危急程度來明確表達。

每個人對過敏或不耐症的敏感性是獨特的，這與食物或藥物的毒性、過量、藥物間的交互作用等情況引起的反應不同（這些是在相同情況下任何人都可能發生的反應）。

在沒有識別出可能導致的物質（包括藥品產品）或物質類別的情況下，不應記錄不良反應事件或表現的風險。如果不確定某一特定物質是原因，可以使用「`verificationStatus`」資料項目來記錄這種不確定性。如果有多個可能的物質可能導致反應/表現，則應為每種物質使用這個 resource 的單獨實例進行記錄，並將「`verificationStatus`」設定為「未確認（`unconfirmed`）」，以便在臨床系統中支援不良反應檢查。如果後來證明某種物質、劑量或類別不是某一反應的原因，則「`verificationStatus`」可以修改為「否認其正確性/已駁斥（`refuted`）」。

這個 resource 旨在允許記錄關於特定物質（例如：阿莫西林、牡蠣或蜜蜂蜇傷毒素）或藥品產品，或者物質的類別（例如：青霉素）的資訊。如果記錄了物質類別，則可以根據每次接觸的情況記錄確切的物質。

這個 FHIR resource 的範圍專注於識別一個在大多數臨床系統中使用或適合大多數常見臨床情境的實用資料集；如果需要，可以使用擴充資料項目來添加更多細節。在需要擴充的臨床情況包括：詳細的過敏科/免疫科評估、通報給監管機構、或在臨床試驗中使用等。

在健康記錄裡記錄任何不良反應涉及臨床評估，評估的是如果個人將來再次接觸到相同的物質/產品/類別時，可能會面臨的潛在風險。換句話說，這相當於一個相對的不宜使用提示，如果沒有更多資訊顯示更高的潛在風險，則應將預設的「危急程度（`criticality`）」設定為「低風險（Low Risk）」。如果醫生認為讓個人再次接觸該物質/產品不安全，比如發生生命威脅的過敏性休克，那麼「危急程度（`criticality`）」應該改為「高風險（High Risk）」。

向監管機構提交的正式不良事件報告是一份包含了除了不良反應具體細節外還有廣泛資訊的文件。這份報告可以使用這個 resource 的部分內容，並根據不同地區的要求添加額外資料。

不良反應或過敏/不耐症清單是記錄了個人對未來接觸某物質、產品、類別時所有已識別的不良反應傾向，並提供了查看每次反應事件細節（例如：反應表現）的機會。

當臨床醫生需要評估未來反應的可能性時，第一手重要資訊包括：

* 關於之前接觸後臨床表現的聲明
* 資訊/報告來源
* 「危急程度」標記

從每次接觸事件中，我們可以獲得更進一步的資訊，並且如果記錄中有的話，還可以連接到其他的詳細資訊，如病史、檢查和診斷等。

**過敏不耐症與風險評估**

AllergyIntolerance 描述的是對某種物質或產品有反應的特定風險類型，而[風險評估（RiskAssessment）](https://hl7.org/fhir/R4/riskassessment.html) 則是針對個人的一般風險，這種風險通常不是基於某種反應。

**過敏或不耐症與免疫接種反應**

[疫描接種反應（`Immunization.reaction`）](https://hl7.org/fhir/R4/immunization-definitions.html#Immunization.reaction) 可能表示某人對某物質過敏或不耐症。如果確定是這樣的情況，應該另外創建一筆過敏或不耐症（AllergyIntolerance）紀錄來指出這一點，因為大部分系統不會去查詢過去的疫苗接種反應。

**注意誤用的情況**

* 過敏或不耐症清單是為了保障病人安全而設，用來在開藥和安排飲食時提供決策支援，並指導臨床治療。但是那些由如光、熱、冷、壓力、振動等物理刺激引發的反應，這些可能看起來像是過敏或不耐症反應，應該在問題清單中作為[病情、問題或診斷（Condition）](StructureDefinition-Condition-twcore.md)紀錄，而不是用過敏或不耐症（AllergyIntolerance）來記錄。
* 不應該用來記錄不良事件，這包括臨床流程、介入措施或產品的失敗情況。例如：錯誤使用藥物或物質、給藥劑量不正確、標籤錯誤、因介入措施或處置導致的傷害、藥品過量/中毒等情況。
* 不應作為不良事件報告的代用品。如上所述，它可以作為不良事件報告的一部分使用。
* 不適合用來記錄警示。警示應該使用[標記（Flag）](https://hl7.org/fhir/R4/flag.html) 或在涉及特定事件時，使用[檢測到的問題（DetectedIssue）](https://hl7.org/fhir/R4/detectedissue.html)。
* 不應用於記錄治療無效的情況。

這個 resource 被 [醫療不良事件（AdverseEvent）](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)、[臨床臆斷（ClinicalImpression）](https://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)、[家庭成員病史（FamilyMemberHistory）](https://hl7.org/fhir/R4/familymemberhistory.html#FamilyMemberHistory) 和 [營養醫令（NutritionOrder）](https://hl7.org/fhir/R4/nutritionorder.html#NutritionOrder)參照。

**Usages:**

* Examples for this Profile: [AllergyIntolerance/all-medication-example](AllergyIntolerance-all-medication-example.md), [AllergyIntolerance/all-nut-example](AllergyIntolerance-all-nut-example.md) and [AllergyIntolerance/all-seafood-example](AllergyIntolerance-all-seafood-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/AllergyIntolerance-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AllergyIntolerance-twcore.csv), [Excel](StructureDefinition-AllergyIntolerance-twcore.xlsx), [Schematron](StructureDefinition-AllergyIntolerance-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-AllergyIntolerance-id.md)**查詢所有AllergyIntolerance：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/AllergyIntolerance?_id=[id]`
`GET [base]/AllergyIntolerance/[id]`例子：
(1) GET [base]/AllergyIntolerance?_id=all-nut-example
(2) GET [base]/AllergyIntolerance/all-nut-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`clinical-status`](SearchParameter-AllergyIntolerance-clinical-status.md)**查詢所有AllergyIntolerance：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/AllergyIntolerance?clinical-status=[code]`例子：
(1) GET [base]/AllergyIntolerance?clinical-status=active



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AllergyIntolerance-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreAllergyIntolerance",
  "title" : "TW Core AllergyIntolerance",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-過敏或不耐症（TW Core AllergyIntolerance） Profile說明本IG如何進一步定義FHIR的AllergyIntolerance Resource以呈現過敏與不耐症的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance",
        "short" : "過敏或不耐症（通常指：對某種物質有不良反應的風險）",
        "definition" : "可能對個人產生有害或不希望的生理反應的風險，這種反應是與暴露於某種物質相關的，並且對每個人來說都是獨特的。",
        "comment" : "物質包括但不限於：適合個人的劑量正確使用的治療性物質、食品、來自植物或動物的材質、或昆蟲叮咬所釋放的毒液。"
      },
      {
        "id" : "AllergyIntolerance.id",
        "path" : "AllergyIntolerance.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的AllergyIntolerance紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "AllergyIntolerance.meta",
        "path" : "AllergyIntolerance.meta",
        "short" : "此AllergyIntolerance Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "AllergyIntolerance.implicitRules",
        "path" : "AllergyIntolerance.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "AllergyIntolerance.language",
        "path" : "AllergyIntolerance.language",
        "short" : "用以表述AllergyIntolerance Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "AllergyIntolerance.text",
        "path" : "AllergyIntolerance.text",
        "short" : "AllergyIntolerance Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "AllergyIntolerance.identifier",
        "path" : "AllergyIntolerance.identifier",
        "short" : "過敏或不耐症之外部識別碼",
        "definition" : "由執行者或其他系統指定給這個AllergyIntolerance的業務識別碼，隨著resource更新和從伺服器到伺服器的傳送，這些識別碼保持不變。",
        "comment" : "這是過敏或不耐症紀錄的業務識別碼，不是一個 resource 識別碼（請參見討論小節）。最好的做法是該識別碼只出現在單一個resource實例上，但是實務上有時會要求具有相同識別碼的多個resource實例共存，這些 resources 實例甚至可能屬於不同的resource類型。例如：多個 Patient及一個Person resource實例可能共用同一個社會保險碼(此處是指美國民眾會有唯一可識別的社會保險碼)。",
        "requirements" : "允許各參與系統按照一致的方式，在不同伺服器之間確認並識別 AllergyIntolerance。"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus",
        "path" : "AllergyIntolerance.clinicalStatus",
        "short" : "active | inactive | resolved ，過敏或不耐症的臨床狀態。",
        "definition" : "過敏或不耐症的臨床狀態",
        "comment" : "如果 clincalStatus 缺少資料，請查閱討論小節。其資料類型是CodeableConcept，這是因為clinicalStatus涉及到一些臨床判斷，可能需要的具體性超過FHIR值集所要求的範圍。例如：SNOMED代碼可能提供額外的的具體性。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AllergyIntoleranceClinicalStatus"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/allergyintolerance-clinical|4.0.1"
        }
      },
      {
        "id" : "AllergyIntolerance.verificationStatus",
        "path" : "AllergyIntolerance.verificationStatus",
        "short" : "unconfirmed | confirmed | refuted | entered-in-error ，一個人對特定物質產生反應的可能性或風險有多確定的陳述。",
        "definition" : "一個人對某已識別物質（包括醫藥產品）產生反應的可能性或風險有多確定的陳述",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AllergyIntoleranceVerificationStatus"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/allergyintolerance-verification|4.0.1"
        }
      },
      {
        "id" : "AllergyIntolerance.type",
        "path" : "AllergyIntolerance.type",
        "short" : "allergy | intolerance - 根本原因或運作機制（如果知道）。",
        "definition" : "為什麼某人對特定物質（如藥物或食物）會有反應的生理根本原因",
        "comment" : "過敏反應通常是我們身體免疫系統的一種反應，它被認為可能預示著未來有更嚴重的健康風險。然而，現代醫學研究顯示，有些過去被認為是免疫反應的情況實際上可能並不是，但仍然可能對生命造成危害。有時候，醫生難以確定一個特定反應的機制是免疫相關還是非免疫相關的。此外，「過敏」這個詞經常被廣泛地使用，並且可能與「不耐症」這個詞的使用有所重疊。在實際應用中，這兩個概念的界限可能不太清晰或不容易理解。儘管如此，醫療紀錄中仍然包含了有關過敏反應的資訊，因為許多既有的醫療系統都已經收集了這些資料。免疫學檢測可以提供一些證據幫助確定反應的基礎和引起反應的物質，但這些檢測並不總是百分之百準確，無法100％確定對特定物質的敏感性。如果不清楚反應是否由過敏引起還是由不耐症引起，那麼在醫療紀錄中最好不要具體指定反應的類型，即可忽略及不填寫此資料項目。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AllergyIntoleranceType"
            }
          ],
          "strength" : "required",
          "description" : "確定反應風險的基本生理機制；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/allergy-intolerance-type|4.0.1"
        }
      },
      {
        "id" : "AllergyIntolerance.category",
        "path" : "AllergyIntolerance.category",
        "definition" : "被識別的物質的類別",
        "comment" : "這個資料資料項目被包括在內，因為它目前正在一些臨床系統中被採集。這個資料可以從使用編碼系統的物質中得到，在這種情況下實際上是多餘的。當按類別查詢時，考慮沒有類別的AllergyIntoleranceresource的影響。例如，當查詢類別=藥品時，沒有類別價值的藥品過敏將不會被返回。關於如何用:缺失修飾符查詢類別以獲得沒有類別的過敏，請參考查詢的更多資訊。此外，類別應謹慎使用，因為類別可能是基於寄件者的主觀因素。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AllergyIntoleranceCategory"
            }
          ],
          "strength" : "required",
          "description" : "確定的物質的類別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/allergy-intolerance-category|4.0.1"
        }
      },
      {
        "id" : "AllergyIntolerance.criticality",
        "path" : "AllergyIntolerance.criticality",
        "definition" : "對已識別物質的反應的潛在臨床危害程度，或稱嚴重性估計。",
        "comment" : "對於任何對可能引發不良反應的傾向，預設的危險程度應該設定為「低風險」，這表示 **至少相對不建議** 有意或自願接觸這種物質。如果醫生識別出對更嚴重或可能危及生命的反應，如過敏性休克的傾向，則將其標記為「高風險」，這表示 **絕對不建議** 有意或自願接觸這種物質。如果缺少這個資料項目，則表示危險程度未知（雖然在其他地方可能已知）。取得疾病層次(condition level)危險性(criticality))的現有系統實際上是在表示危險性的概念，而在反應層次(reaction level)記錄的嚴重性(severity)表示真正的反應嚴重性。現有系統同時記錄疾病危險性和反應嚴重性，可能使用「嚴重性(severity)」一詞來表示兩者。危險性是未來可能出現的最糟糕情況（即不考慮具體情境），而嚴重性則依賴於特定情境。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AllergyIntoleranceCriticality"
            }
          ],
          "strength" : "required",
          "description" : "對已識別物質的反應的潛在臨床危害程度，或稱嚴重性估計；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/allergy-intolerance-criticality|4.0.1"
        }
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "short" : "表明此過敏或不耐症的代碼",
        "definition" : "此資料項目是用來代碼化表示有關過敏或不耐症的資訊。它可以表示對某種物質或藥物產品引發不良反應風險的代碼（例如：「乳膠」），也可以表示有關過敏或不耐症的代碼（例如：「乳膠過敏」），或者是表示對特定物質或類別的否定或排除情況的代碼（例如：「無乳膠過敏」），還可以表示一般性的否定性聲明（例如：「無已知過敏」，「無已知藥品過敏」）。需要注意的是：特定反應的物質可能不同於被認為引發風險的物質，但它們之間必須是一致的，在處理這些資訊時，只處理「code」而忽略「reaction.substance」在臨床上必須在是安全的。如果接收系統無法確認AllergyIntolerance.reaction.substance是否符合AllergyIntolerance.code的語義範圍，則應該忽略AllergyIntolerance.reaction.substance。",
        "comment" : "建議在填寫過敏或不耐症相關資料時，儘量使用專業術語。常用的專門術語包括RxNorm、SNOMED CT、DM+D、NDFRT、ICD-9、IDC-10、UNII和ATC等。如果找不到合適的專業術語，則可以用文字表述。文字表述還可以提供更多詳細資訊。\n\n當我們為「code」資料項目指定特定物質或產品代碼時，通常意味著該病人對這種物質或產品有過敏或不耐受反應。在SNOMED CT的過敏模型中，這些物質或產品被視為「過敏物質(Causative agent)」。\n\n另外，還有一個名為「substanceExposureRisk」的擴充資料項目，它比「code」資料項目提供更多靈活性，可以用來描述對特定物質或產品的過敏或不耐受反應，無論是正面還是負面。這個擴充資料項目特別有用於表達「沒有已知過敏」或「沒有不良反應風險」的情況，即使對於那些沒有預先確定「無過敏」概念的物質或產品也適用。如果使用了「substanceExposureRisk」擴充資料項目，則應該省略AllergyIntolerance.code資料項目。",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/allergyintolerance-code"
        }
      },
      {
        "id" : "AllergyIntolerance.patient",
        "path" : "AllergyIntolerance.patient",
        "short" : "誰有此過敏或不耐受？",
        "definition" : "患有過敏或不耐症的病人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.encounter",
        "path" : "AllergyIntolerance.encounter",
        "short" : "過敏或不耐症被確認時的就醫事件(Encounter)",
        "definition" : "過敏症或不耐症被確認的就醫事件(Encounter)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.onset[x]",
        "path" : "AllergyIntolerance.onset[x]",
        "short" : "過敏或不耐症被識別的時間",
        "definition" : "過敏或不耐症被識別的估計或實際日期、日期時間或年齡。"
      },
      {
        "id" : "AllergyIntolerance.recordedDate",
        "path" : "AllergyIntolerance.recordedDate",
        "short" : "resource實例的第一個版本被記錄的日期",
        "definition" : "recordedDate指的是這個特定的過敏不耐症紀錄在系統中建立的日期，通常是由系統產生的日期。",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.recorder",
        "path" : "AllergyIntolerance.recorder",
        "short" : "誰記錄了過敏或不耐受",
        "definition" : "記錄此紀錄並對其內容負責的個人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.asserter",
        "path" : "AllergyIntolerance.asserter",
        "short" : "關於過敏的資訊來源",
        "definition" : "有關過敏紀錄的資訊來源",
        "comment" : "記錄者要對內容負有責任，但可以參照他們獲得資訊的來源。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.lastOccurrence",
        "path" : "AllergyIntolerance.lastOccurrence",
        "short" : "最後一次已知反應發生的日期（/時間）",
        "definition" : "表示最後已知的過敏反應事件發生的日期和/或時間。",
        "comment" : "這個日期可能會與某個反應開始日期重複。如果需要以文字表述最後發生的日期，例如：「在童年時」或「10年前」，應該使用 Comment 資料項目。"
      },
      {
        "id" : "AllergyIntolerance.note",
        "path" : "AllergyIntolerance.note",
        "short" : "其他欄位中沒有記錄的額外文字陳述",
        "definition" : "有關不良反應的可能性，這些資訊是未被記錄在其他資料項目中的補充敘述。",
        "comment" : "例如：包括標記為「高風險」的原因，以及與將來接觸或使用該物質相關的指示，比如在重症照護病房內使用或在使用時需要皮質類固醇保護。這些註釋應該與過敏或不耐症作為一般狀況有關，而不是特定事件。對於特定事件的描述和註釋，請使用 AllergyIntolerance.event.description 和 AllergyIntolerance.event.notes。",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction",
        "path" : "AllergyIntolerance.reaction",
        "short" : "暴露於此過敏或不耐症物質的不良反應",
        "definition" : "關於每次接觸特定物質所引起的不良反應事件的細節",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction.substance",
        "path" : "AllergyIntolerance.reaction.substance",
        "short" : "被認為是事件原因的特定物質或醫藥產品",
        "definition" : "確定與不良反應事件有關的特定物質（或藥品）。注意：對於特定反應而言，所涉及的物質可能與被認為是風險原因的物質不同，但它必須與之一致。例如：它可能是一種更具體的物質（例如：品牌藥物）或包含被確認的物質的複合產品。在臨床上，僅處理「code」而忽略「reaction.substance」必須是安全的。如果接收系統無法確定 AllergyIntolerance.reaction.substance 是否在 AllergyIntolerance.code 的語義範圍內，則接收系統應忽略 AllergyIntolerance.reaction.substance。",
        "comment" : "表現形式可以用一個詞、短語或簡短的描述來表達。例如：噁心、皮疹或無反應。在可能的情況下，最好用專門術語對表現形式進行編碼。這裡輸入的值可作為不良反應清單的一部分顯示在應用螢幕上，正如英國國家醫療服務體系CUI 指南中所建議的那樣，常用的專門術語包括，但不限於SNOMED CT或ICD10。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/substance-code"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "path" : "AllergyIntolerance.reaction.manifestation",
        "short" : "與此事件相關的臨床症狀/體徵",
        "definition" : "觀察到的或與不良反應事件相關的臨床症狀和/或體徵",
        "comment" : "表現形式可以用一個詞、短語或簡短的描述來表達。例如：噁心、皮疹或無反應。在可能的情況下，最好用術語對表現形式進行編碼。這裡輸入的數值可作為不良反應清單的一部分顯示在應用螢幕上，正如英國國家醫療服務體系CUI指南中所建議的那樣。常用的術語包括，但不限於SNOMED CT或ICD10。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/clinical-findings"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.description",
        "path" : "AllergyIntolerance.reaction.description",
        "short" : "對整個活動的描述",
        "definition" : "關於整個反應的文字描述，如果必要則包括表現形式的細節。",
        "comment" : "使用描述來提供發生反應的特定事件的任何細節，如情況、反應細節、之前/之後發生了什麼。與事件有關的資訊，但不描述特定的照護應在comment資料項目中記錄。例如：病人在四歲時因鏈球菌感染被注射青黴素，隨後出現嚴重的蕁麻疹。"
      },
      {
        "id" : "AllergyIntolerance.reaction.onset",
        "path" : "AllergyIntolerance.reaction.onset",
        "short" : "症狀顯現的日期（/時間）",
        "definition" : "記錄反應開始的日期和/或時間"
      },
      {
        "id" : "AllergyIntolerance.reaction.severity",
        "path" : "AllergyIntolerance.reaction.severity",
        "short" : "mild | moderate | severe",
        "definition" : "對整個反應事件的臨床評估，可能會考慮多個不同的表現，以確定反應的嚴重程度。",
        "comment" : "這種評估是非常主觀的。可能有一些特定的實務領域已經應用了客觀的評分標準，客觀的評分標準可以作為擴充資料項目包含在這個模型中。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AllergyIntoleranceSeverity"
            }
          ],
          "strength" : "required",
          "description" : "整個事件的程度，應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/reaction-event-severity|4.0.1"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.exposureRoute",
        "path" : "AllergyIntolerance.reaction.exposureRoute",
        "short" : "此對象如何接觸到該物質",
        "definition" : "確認此對象是透過哪種途徑接觸到該物質",
        "comment" : "應盡可能使用專門術語對接觸途徑進行編碼。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/route-codes"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.note",
        "path" : "AllergyIntolerance.reaction.note",
        "short" : "其他資料項目未記錄之關於事件的文字表述",
        "definition" : "其他關於不良反應事件的文字表述，這些資訊未在其他資料項目中記錄。",
        "comment" : "使用此資料項目記錄與特定事件間接相關的資訊，但在其他資料項目未記錄的資訊。例如：如果臨床紀錄不再可用，則可根據病人母親提供的資訊來紀錄，儘管病人的母親已經過世。"
      }
    ]
  }
}

```
