# TW Core Address - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Data Type Profile: TW Core Address 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:AddressTW |

 
此臺灣核心-地址（TW Core Address） Profile說明本IG如何進一步定義FHIR的Address資料類型以呈現臺灣地址。
本Profile之擴充的資料項目（Extension）為參照[初診基本資料表](https://www.eck.org.tw/wp-content/uploads/2019/10/ECK_FIRSTVIEW_INFOR.pdf)之欄位與[中華郵政地址英譯寫法](https://www.post.gov.tw/post/internet/Postal/sz_a_e_ta1.jsp)，若貴機構有詳細地址資訊之需求，可依情況填選；若無需區分詳細地址資訊，可使用原生欄位`text`、`line`、`district`呈現。 

**Usages:**

* Use this DataType Profile: [TW Core Location](StructureDefinition-Location-twcore.md), [TW Core Organization](StructureDefinition-Organization-twcore.md), [TW Core Patient](StructureDefinition-Patient-twcore.md) and [TW Core Practitioner](StructureDefinition-Practitioner-twcore.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Address-tw)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Address-tw.csv), [Excel](StructureDefinition-Address-tw.xlsx), [Schematron](StructureDefinition-Address-tw.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Address-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Address-tw",
  "version" : "1.0.0",
  "name" : "AddressTW",
  "title" : "TW Core Address",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-地址（TW Core Address） Profile說明本IG如何進一步定義FHIR的Address資料類型以呈現臺灣地址。  \n本Profile之擴充的資料項目（Extension）為參照[初診基本資料表](https://www.eck.org.tw/wp-content/uploads/2019/10/ECK_FIRSTVIEW_INFOR.pdf)之欄位與[中華郵政地址英譯寫法](https://www.post.gov.tw/post/internet/Postal/sz_a_e_ta1.jsp)，若貴機構有詳細地址資訊之需求，可依情況填選；若無需區分詳細地址資訊，可使用原生欄位`text`、`line`、`district`呈現。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "vcard",
      "uri" : "http://w3.org/vcard",
      "name" : "vCard Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Address",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Address",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Address",
        "path" : "Address",
        "short" : "使用郵政規範表達的地址（相對於GPS或其他位置定義格式）",
        "definition" : "使用郵政規範表達的地址（相對於GPS或其他位置定義格式）。這種data type可用於傳達投遞郵件的位址，以及用於訪問可能對郵件投遞無效的位置，這世界定義了各種郵政地址格式。",
        "comment" : "注意：地址的目的是描述用於管理目的之郵政地址，而不是描述絕對的地理座標。郵政地址經常被用作實體位置的代表（亦可見[Location](http://hl7.org/fhir/R4/location.html#)resource）。"
      },
      {
        "id" : "Address.id",
        "path" : "Address.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Address.extension:room",
        "path" : "Address.extension",
        "sliceName" : "room",
        "short" : "室",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-room"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.extension:floor",
        "path" : "Address.extension",
        "sliceName" : "floor",
        "short" : "樓",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-floor"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.extension:number",
        "path" : "Address.extension",
        "sliceName" : "number",
        "short" : "號",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.extension:alley",
        "path" : "Address.extension",
        "sliceName" : "alley",
        "short" : "弄",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-alley"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.extension:lane",
        "path" : "Address.extension",
        "sliceName" : "lane",
        "short" : "巷/衖",
        "alias" : ["巷", "衖"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-lane"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.extension:section",
        "path" : "Address.extension",
        "sliceName" : "section",
        "short" : "段",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-section"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.extension:neighborhood",
        "path" : "Address.extension",
        "sliceName" : "neighborhood",
        "short" : "鄰",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-neighborhood"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.extension:village",
        "path" : "Address.extension",
        "sliceName" : "village",
        "short" : "村(里)",
        "alias" : ["村", "里"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-village"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.use",
        "path" : "Address.use",
        "short" : "home ｜ work ｜ temp ｜ old ｜ billing － 此地址的用途",
        "definition" : "此地址的用途",
        "comment" : "應用程式可假定一個地址是目前使用中，除非它明確說它是暫時的或舊的。",
        "requirements" : "允許從清單中挑選適當的地址用途",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AddressUse"
            }
          ],
          "strength" : "required",
          "description" : "應填入AddressUse值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/address-use|4.0.1"
        }
      },
      {
        "id" : "Address.type",
        "path" : "Address.type",
        "short" : "postal ｜ physical ｜ both",
        "definition" : "區分實際地址（你可以拜訪的地址）和郵寄地址（如郵政信箱和轉遞地址），大多數地址都是這兩種。",
        "comment" : "地址的定義指出「地址旨在描述郵政地址，而不是實體位置」。但許多應用程式追蹤一個地址是否具有雙重目的，既是一個可以拜訪的地點，亦是一個有效的投遞目的地，郵政地址經常被用作實體位置的代表（亦可見[Location](http://hl7.org/fhir/R4/location.html#)resource）。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AddressType"
            }
          ],
          "strength" : "required",
          "description" : "應填入AddressType值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/address-type|4.0.1"
        }
      },
      {
        "id" : "Address.text",
        "path" : "Address.text",
        "short" : "地址的文字表述",
        "definition" : "具體說明整個地址，因為它應該顯示在郵政標籤上，這可替代或與特定的部分一起提供。",
        "comment" : "可以同時提供文字表述和各部分的地址資料項目內容。更新地址的應用程式 **必須（SHALL）** 確保當文字表述和各部分的地址資料項目內容都存在時，文字表述不包括各部分的地址資料項目內容中沒有的內容，意即兩者內容會一致。",
        "requirements" : "一個可呈現的、未編碼的形式。"
      },
      {
        "id" : "Address.line",
        "path" : "Address.line",
        "short" : "路/街",
        "definition" : "此部分包含門牌號碼、公寓號碼、街道名稱、街道方向、郵政信箱號碼、送貨提示以及類似的地址資訊。",
        "alias" : ["路", "街"],
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Address.city",
        "path" : "Address.city",
        "short" : "鄉/鎮/市/區，定義上與國際的等級一致。原文為：Name of city, town etc.。",
        "definition" : "市、鄉、鎮、村或其他社區或配送中心的名稱。",
        "alias" : ["鄉", "鎮", "市", "區"],
        "mustSupport" : true
      },
      {
        "id" : "Address.district",
        "path" : "Address.district",
        "short" : "縣/市，定義上與國際的等級一致。原文為：District name (aka county)。",
        "definition" : "行政區域（縣）的名稱",
        "comment" : "區（district）有時被稱為縣（country），但在一些區域（regions），「縣（country）」被用來代替市（直轄市），所以縣名應該用市名來代替傳達。",
        "alias" : ["市"],
        "mustSupport" : true
      },
      {
        "id" : "Address.state",
        "path" : "Address.state",
        "short" : "國家的子單位（縮寫也可以）。原文為：Sub-unit of country (abbreviations ok)。",
        "definition" : "一個國家的子單位，在聯邦組織的國家中擁有有限的主權。如果代碼被普遍使用，可使用代碼（例如：美國2個字母的州代碼）。"
      },
      {
        "id" : "Address.postalCode",
        "path" : "Address.postalCode",
        "short" : "郵遞區號",
        "definition" : "指定一個由郵政服務定義的區域之郵遞區號",
        "mustSupport" : true
      },
      {
        "id" : "Address.postalCode.id",
        "path" : "Address.postalCode.id",
        "short" : "xml：id（或JSON格式）。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Address.postalCode.extension",
        "path" : "Address.postalCode.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "擴充的資料項目",
        "definition" : "擴充的資料項目"
      },
      {
        "id" : "Address.postalCode.extension:PostalCode",
        "path" : "Address.postalCode.extension",
        "sliceName" : "PostalCode",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Address.postalCode.extension:PostalCode.value[x]",
        "path" : "Address.postalCode.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Address.postalCode.extension:PostalCode.value[x].coding",
        "path" : "Address.postalCode.extension.value[x].coding",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。"
      },
      {
        "id" : "Address.postalCode.extension:PostalCode.value[x].coding:PostalCode3",
        "path" : "Address.postalCode.extension.value[x].coding",
        "sliceName" : "PostalCode3",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。"
      },
      {
        "id" : "Address.postalCode.extension:PostalCode.value[x].coding:PostalCode5",
        "path" : "Address.postalCode.extension.value[x].coding",
        "sliceName" : "PostalCode5",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。"
      },
      {
        "id" : "Address.postalCode.extension:PostalCode.value[x].coding:PostalCode6",
        "path" : "Address.postalCode.extension.value[x].coding",
        "sliceName" : "PostalCode6",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。"
      },
      {
        "id" : "Address.postalCode.value",
        "path" : "Address.postalCode.value",
        "short" : "郵遞區號",
        "definition" : "實際值"
      },
      {
        "id" : "Address.country",
        "path" : "Address.country",
        "short" : "國家（例如：ISO 3166的2個或3個字母代碼）。",
        "definition" : "國家—通常被理解為或普遍被接受的一個國家。",
        "comment" : "可用ISO 3166的3個字母代碼來代替人類可讀的國家名",
        "mustSupport" : true
      },
      {
        "id" : "Address.period",
        "path" : "Address.period",
        "short" : "此地址曾經／正在使用的時間區間",
        "definition" : "此地址曾經／正在使用的時間區間",
        "requirements" : "允許將地址依時間排放"
      }
    ]
  }
}

```
