# 糞便檢體 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Specimen: 糞便檢體

### 糞便樣本

**檢體狀態**：Available ([SpecimenStatus](http://hl7.org/fhir/specimen-status)#available)

**檢體類型**：Stool specimen ([SpecimenType](http://snomed.info/sct)#119339001)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**病人採檢前禁食狀況**：The patient indicated they did not fast prior to the procedure. ([v2 Relevant Clincial Information](http://terminology.hl7.org/CodeSystem/v2-0916)#NF)

**檢驗檢查者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

> **檢體資料****採集檢體的時間**：2023-11-05T08:30:08
**執行檢體採集的技術**：糞便採集(Collection of stool specimen)([SNOMED CT](http://snomed.info/sct)#225105004)
**解剖採集部位**：肛門(Anus part)([SNOMED CT](http://snomed.info/sct)#123956007)
**採集檢體的數量**：10 g

> **檢體處理資料****處理步驟**：糞便隱血試驗
**檢體處理的日期和時間**：2023-11-05T09:30:00
**檢體容器資料****容器類型**：Fecal specimen container([SNOMED CT](http://snomed.info/sct)#706047007)
**容器說明**：糞便標本容器
**容器的大小**：20 mL
**容器內的檢體量**：10 g

**備註**：此糞便樣本來自患者的排便觀察



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "spe-stool-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
    ]
  },
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "119339001",
        "display" : "Stool specimen"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-example",
    "display" : "陳加玲"
  },
  "receivedTime" : "2023-11-05T09:00:00.000Z",
  "collection" : {
    "collector" : {
      "reference" : "Practitioner/pra-dr-example",
      "display" : "王依昇"
    },
    "collectedDateTime" : "2023-11-05T08:30:08.000Z",
    "quantity" : {
      "value" : 10,
      "unit" : "g"
    },
    "method" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "225105004",
          "display" : "Collection of stool specimen"
        }
      ],
      "text" : "糞便採集"
    },
    "bodySite" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "123956007",
          "display" : "Anus part"
        }
      ],
      "text" : "肛門"
    },
    "fastingStatusCodeableConcept" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0916",
          "code" : "NF",
          "display" : "The patient indicated they did not fast prior to the procedure."
        }
      ]
    }
  },
  "processing" : [
    {
      "description" : "糞便隱血試驗",
      "timeDateTime" : "2023-11-05T09:30:00Z"
    }
  ],
  "container" : [
    {
      "description" : "糞便標本容器",
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "706047007",
            "display" : "Fecal specimen container"
          }
        ]
      },
      "capacity" : {
        "value" : 20,
        "unit" : "mL"
      },
      "specimenQuantity" : {
        "value" : 10,
        "unit" : "g"
      }
    }
  ],
  "note" : [
    {
      "text" : "此糞便樣本來自患者的排便觀察"
    }
  ]
}

```
