# 血液檢體 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Specimen: 血液檢體

### 血液檢體

**檢體狀態**：Available ([SpecimenStatus](http://hl7.org/fhir/specimen-status)#available)

**檢體識別碼**：1a3f5b7d-9e2c-4f6a-8c1e-0b2d4e6f8a9c

**實驗室識別碼**：20150816-0001

**檢體類型**：Blood, Autopsy ([SNOMED CT](http://snomed.info/sct)#119297000)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**病人採檢前禁食狀況**：Patient was fasting prior to the procedure. ([v2 Relevant Clincial Information](http://terminology.hl7.org/CodeSystem/v2-0916)#F)

**檢查者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

> **檢體資料****採集檢體的時間**：2023-11-03T08:30:08.000Z
**執行檢體採集的技術**：Finger-prick sampling([SNOMED CT](http://snomed.info/sct)#278450005)
**解剖採集部位**：Venous Blood([SNOMED CT](http://snomed.info/sct)#53130003)
**採集檢體的數量**：4 mL([UCUM](http://unitsofmeasure.org)#mL)

> **檢體處理資料****處理步驟(一)**：Centrifugation([SNOMED CT](http://snomed.info/sct)#85457002)
**檢體處理的日期和時間(一)**：2023-11-04T09:30:00.000Z
**處理步驟(二)**：Freezing([SNOMED CT](http://snomed.info/sct)#48103003)
**檢體處理的日期和時間(二)**：2023-11-04T10:00:00.000Z
**檢體容器資料****容器類別**：Evacuated blood collection tube transport container([SNOMED CT](http://snomed.info/sct)#701516009)
**容器說明**：真空採血管
**容器的大小**：6 mL([UCUM](http://unitsofmeasure.org)#mL)
**容器內的檢體量**：4 mL([UCUM](http://unitsofmeasure.org)#mL)

**備註**：此血液檢體來自患者的最後一次例行檢查



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "spe-blood-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
    ]
  },
  "identifier" : [
    {
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "1a3f5b7d-9e2c-4f6a-8c1e-0b2d4e6f8a9c"
    }
  ],
  "accessionIdentifier" : {
    "value" : "20150816-0001"
  },
  "status" : "available",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "119297000",
        "display" : "Blood specimen"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-example",
    "display" : "陳加玲"
  },
  "receivedTime" : "2023-11-04T09:00:00.000Z",
  "collection" : {
    "collector" : {
      "reference" : "Practitioner/pra-dr-example",
      "display" : "王依昇"
    },
    "collectedDateTime" : "2023-11-03T08:30:08.000Z",
    "quantity" : {
      "value" : 4,
      "unit" : "mL",
      "system" : "http://unitsofmeasure.org",
      "code" : "mL"
    },
    "method" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "278450005",
          "display" : "Finger-prick sampling"
        }
      ],
      "text" : "Phlebotomy"
    },
    "bodySite" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "53130003",
          "display" : "Venous Blood"
        }
      ],
      "text" : "Venous Blood"
    },
    "fastingStatusCodeableConcept" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0916",
          "code" : "F",
          "display" : "Patient was fasting prior to the procedure."
        }
      ]
    }
  },
  "processing" : [
    {
      "description" : "Centrifugation",
      "procedure" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "85457002",
            "display" : "Centrifugation"
          }
        ],
        "text" : "Centrifugation"
      },
      "timeDateTime" : "2023-11-04T09:30:00.000Z"
    },
    {
      "description" : "Freezing",
      "procedure" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "48103003",
            "display" : "Freezing"
          }
        ],
        "text" : "Freezing"
      },
      "timeDateTime" : "2023-11-04T10:00:00.000Z"
    }
  ],
  "container" : [
    {
      "description" : "真空採血管",
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "701516009",
            "display" : "Evacuated blood collection tube transport container"
          }
        ]
      },
      "capacity" : {
        "value" : 6,
        "unit" : "mL",
        "system" : "http://unitsofmeasure.org",
        "code" : "mL"
      },
      "specimenQuantity" : {
        "value" : 4,
        "unit" : "mL",
        "system" : "http://unitsofmeasure.org",
        "code" : "mL"
      }
    }
  ],
  "note" : [
    {
      "text" : "此血液檢體來自患者的最後一次例行檢查"
    }
  ]
}

```
