# Goal target date - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## SearchParameter: Goal target date 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Goal-target-date | *Version*:1.0.0 | |
| Active as of 2022-08-31 | *Responsible:*[HL7 International](https://www.mohw.gov.tw/) | *Computable Name*:GoalTargetDate |

 
目標的預計達成時間(target.dueDate) 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "Goal-target-date",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Goal-target-date",
  "version" : "1.0.0",
  "name" : "GoalTargetDate",
  "status" : "active",
  "date" : "2022-08-31",
  "publisher" : "HL7 International",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "目標的預計達成時間(target.dueDate)",
  "code" : "target-date",
  "base" : ["Goal"],
  "type" : "date",
  "expression" : "(Goal.target.due.ofType(date))",
  "comparator" : [
    "eq",
    "ne",
    "gt",
    "ge",
    "lt",
    "le",
    "sa",
    "eb",
    "ap"
  ],
  "_comparator" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    }
  ]
}

```
