# 護士 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example PractitionerRole: 護士

### 護士角色基本資料

**識別碼型別**：Medical License number （[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MD）
**員工編號（official）**：KP00019 （https://www.tph.mohw.gov.tw）

**紀錄狀態（active）**：使用中

**授權可執業時間範圍**：2022-07-31 ～ 2024-07-31

**健康照護服務提供者**：[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md) "陳莉"

**地點**：[Location/loc-er-example](Location-loc-er-example.md) "衛生福利部臺北醫院急救室"

**角色**：護士(Registered nurse) （[SNOMED CT](http://snomed.info/sct)#224535009）

**角色專業**：急診醫學科(Emergency medicine)（[SNOMED CT](http://snomed.info/sct)#773568002）

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0993547828（[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡時間**：週一 ～ 週五 ， 08:00-16:00
**聯絡注意事項**：若遇到緊急狀況可能會影響工作日。

**此期間無提供服務**：2023-08-01 ～ 2023-08-15
**無法提供原因**：家中有事請假。



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "praro-nurse-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MD"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "KP00019"
    }
  ],
  "active" : true,
  "period" : {
    "start" : "2022-07-31",
    "end" : "2024-07-31"
  },
  "practitioner" : {
    "reference" : "Practitioner/pra-nurse-example",
    "display" : "陳莉"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "224535009",
          "display" : "Registered nurse"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "773568002",
          "display" : "Emergency medicine"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/loc-er-example",
      "display" : "衛生福利部臺北醫院急救室"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0993547828",
      "use" : "mobile"
    }
  ],
  "availableTime" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
      "allDay" : false,
      "availableStartTime" : "08:00:00",
      "availableEndTime" : "16:00:00"
    }
  ],
  "notAvailable" : [
    {
      "description" : "家中有事請假",
      "during" : {
        "start" : "2023-08-01",
        "end" : "2023-08-15"
      }
    }
  ],
  "availabilityExceptions" : "若遇到緊急狀況可能會影響工作日"
}

```
