# 醫師 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example PractitionerRole: 醫師

### 醫師角色基本資料

**識別碼型別**：Medical License number （[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MD）
**員工編號（official）**：KP00017 （https://www.tph.mohw.gov.tw）

**紀錄狀態（active）**：使用中

**授權可執業時間範圍**：2022-07-31 ～ 2024-07-31

**健康照護服務提供者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**地點**：[Location/loc-ent-example](Location-loc-ent-example.md) "衛生福利部臺北醫院耳鼻喉科"

**角色**：西醫師(General medicine) （[SNOMED CT](http://snomed.info/sct)#394802001）

**角色專業**：耳鼻喉科(Otolaryngology (qualifier value)) （[SNOMED CT](http://snomed.info/sct)#418960008）

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0993277826（[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡時間**：週一 ～ 週五 ， 08:00-16:00
**聯絡注意事項**：若遇到緊急狀況可能會影響工作日。

**此期間無提供服務**：2023-08-01 ～ 2023-08-15
**無法提供原因**：家中有事請假。



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "praro-dr-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MD"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "KP00017"
    }
  ],
  "active" : true,
  "period" : {
    "start" : "2022-07-31",
    "end" : "2024-07-31"
  },
  "practitioner" : {
    "reference" : "Practitioner/pra-dr-example",
    "display" : "王依昇"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "394802001",
          "display" : "General medicine"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "418960008",
          "display" : "Otolaryngology (qualifier value)"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/loc-ent-example",
      "display" : "衛生福利部臺北醫院耳鼻喉科"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0993277826",
      "use" : "mobile"
    }
  ],
  "availableTime" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
      "allDay" : false,
      "availableStartTime" : "08:00:00",
      "availableEndTime" : "16:00:00"
    }
  ],
  "notAvailable" : [
    {
      "description" : "家中有事請假",
      "during" : {
        "start" : "2023-08-01",
        "end" : "2023-08-15"
      }
    }
  ],
  "availabilityExceptions" : "若遇到緊急狀況可能會影響工作日"
}

```
