# 醫事放射師 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Practitioner: 醫事放射師

### 醫事放射師基本資料

**識別碼型別**：Medical License number （[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MD）
**員工編號（official）**：KP00018 （https://www.tph.mohw.gov.tw）

**健康照護服務提供者的紀錄（active）**：使用中

**姓名（official）**：王曉明 Wang, Xiao Ming

**性別**：男性

**出生日期**：1988-01-16

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0993277827（[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2022-07-31至2024-07-31

**聯絡地址**：(330)桃園市桃園區五福五街31號
**郵遞區號（postalCode）**[extension: [tw-postal-code](StructureDefinition-tw-postal-code.md)]： ([330](CodeSystem-postal-code3-tw.md)#
**縣/市（district）**：桃園市
**鄉/鎮/市/區（city）**：桃園區
**路/街（line）**：五福五街
**號（number）**[extension: [tw-number](StructureDefinition-tw-number.md)]：31號
**國家（country）**：臺灣

**資格證書的型別**：醫事放射師(Radiologist) （[SNOMED CT](http://snomed.info/sct)#66862007）
**資格證書的開始日期**：2005-01-01

**照護服務提供人員影像**： [https://1.bp.blogspot.com/-aee3S1fF82s/Xtt6fVkK9rI/AAAAAAABZQk/YEZzdVTp_w4kHSLtq4oZt8z6qyrqagC1wCNcBGAsYHQ/s1600/medical_scrub_man_darkblue.png](https://1.bp.blogspot.com/-aee3S1fF82s/Xtt6fVkK9rI/AAAAAAABZQk/YEZzdVTp_w4kHSLtq4oZt8z6qyrqagC1wCNcBGAsYHQ/s1600/medical_scrub_man_darkblue.png)
![](https://1.bp.blogspot.com/-aee3S1fF82s/Xtt6fVkK9rI/AAAAAAABZQk/YEZzdVTp_w4kHSLtq4oZt8z6qyrqagC1wCNcBGAsYHQ/s1600/medical_scrub_man_darkblue.png)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "pra-radio-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MD"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "KP00018"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "王曉明",
      "family" : "Wang",
      "given" : ["Xiao Ming"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0993277827",
      "use" : "mobile",
      "period" : {
        "start" : "2022-07-31",
        "end" : "2024-07-31"
      }
    }
  ],
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
          "valueString" : "31號"
        }
      ],
      "text" : "桃園市桃園區五福五街31號",
      "line" : ["五福五街"],
      "city" : "桃園區",
      "district" : "桃園市",
      "_postalCode" : {
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                  "code" : "330"
                }
              ]
            }
          }
        ]
      },
      "country" : "TW"
    }
  ],
  "gender" : "male",
  "birthDate" : "1988-01-16",
  "photo" : [
    {
      "contentType" : "image/jpeg",
      "data" : "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=",
      "url" : "https://1.bp.blogspot.com/-aee3S1fF82s/Xtt6fVkK9rI/AAAAAAABZQk/YEZzdVTp_w4kHSLtq4oZt8z6qyrqagC1wCNcBGAsYHQ/s1600/medical_scrub_man_darkblue.png"
    }
  ],
  "qualification" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "66862007",
            "display" : "Radiologist"
          }
        ]
      },
      "period" : {
        "start" : "2005-01-01"
      }
    }
  ]
}

```
