# 藥師 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Practitioner: 藥師

### 藥師基本資料

**識別碼型別**：Medical License number （[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MD）
**員工編號（official）**：KP00020 （https://www.tph.mohw.gov.tw）

**健康照護服務提供者的紀錄（active）**：使用中

**姓名（official）**：陳耀詩 Chen, Yao shi

**性別**：男性

**出生日期**：1988-12-08

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0912475693（[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2022-07-31至2024-12-31

**聯絡地址**：(330)桃園市桃園區五福三街1號
**郵遞區號（postalCode）**[extension: [tw-postal-code](StructureDefinition-tw-postal-code.md)]： ([330](CodeSystem-postal-code3-tw.md)#
**縣/市（district）**：桃園市
**鄉/鎮/市/區（city）**：桃園區
**路/街（line）**：五福三街
**號（number）**[extension: [tw-number](StructureDefinition-tw-number.md)]：1號
**國家（country）**：臺灣

**資格證書的型別**：藥師 （[SNOMED CT](http://snomed.info/sct)#46255001）
**資格證書的開始日期**：2005-05-25

**照護服務提供人影像**： [https://3.bp.blogspot.com/--puyGLwGGDI/VbnRxTNap3I/AAAAAAAAwRU/5WyDLwhKguo/s800/yakuzaishi_man.png](https://3.bp.blogspot.com/--puyGLwGGDI/VbnRxTNap3I/AAAAAAAAwRU/5WyDLwhKguo/s800/yakuzaishi_man.png)
![](https://3.bp.blogspot.com/--puyGLwGGDI/VbnRxTNap3I/AAAAAAAAwRU/5WyDLwhKguo/s800/yakuzaishi_man.png)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "pra-phc-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MD"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "KP00020"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "陳耀詩",
      "family" : "Chen",
      "given" : ["Yao shi"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0912475693",
      "use" : "mobile",
      "period" : {
        "start" : "2022-01-31",
        "end" : "2024-12-31"
      }
    }
  ],
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
          "valueString" : "1號"
        }
      ],
      "text" : "桃園市桃園區五福三街1號",
      "line" : ["五福三街"],
      "city" : "桃園區",
      "district" : "桃園市",
      "_postalCode" : {
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                  "code" : "330"
                }
              ]
            }
          }
        ]
      },
      "country" : "TW"
    }
  ],
  "gender" : "male",
  "birthDate" : "1988-12-08",
  "photo" : [
    {
      "contentType" : "image/jpeg",
      "data" : "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=",
      "url" : "https://3.bp.blogspot.com/--puyGLwGGDI/VbnRxTNap3I/AAAAAAAAwRU/5WyDLwhKguo/s800/yakuzaishi_man.png"
    }
  ],
  "qualification" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "46255001",
            "display" : "Pharmacist"
          }
        ]
      },
      "period" : {
        "start" : "2006-08-14"
      }
    }
  ]
}

```
