# 病人基本資料-居留證號碼及病歷號 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Patient: 病人基本資料-居留證號碼及病歷號

### 病人基本資料-居留證號碼及病歷號

> **識別碼型別**：Permanent Resident Card Number（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#PRC）
**身分證字號（official）**：Z596839485 （http://www.immigration.gov.tw）

> **識別碼型別**：Medical record number（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MR）
**病歷號（official）**：4958603 （https://www.tph.mohw.gov.tw）

**病人的紀錄（active）**：使用中

**姓名（official）**：陳曉明 Chan, Xiao Ming

**性別**：男性

**出生日期**：1999-04-20

**聯絡方式**：Phone （[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0939405869 （[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2023-01-01至2026-01-01



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "pat-residentNumber-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PRC"
          }
        ]
      },
      "system" : "http://www.immigration.gov.tw",
      "value" : "Z596839485"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "4958603"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "陳曉明",
      "family" : "Chen",
      "given" : ["Xiao Ming"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0939405869",
      "use" : "mobile",
      "period" : {
        "start" : "2023-01-01",
        "end" : "2026-01-01"
      }
    }
  ],
  "gender" : "male",
  "birthDate" : "1999-04-20"
}

```
