# 病人(兒童)基本資料-身分證字號及病歷號 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Patient: 病人(兒童)基本資料-身分證字號及病歷號

### 病人基本資料-身分證字號及病歷號

> **識別碼型別**：National Person Identifier（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#NNxxx**[extension:[Identifier Suffix](StructureDefinition-identifier-suffix.md)]：**TWN）
**身分證字號（official）**：H122345678 （http://www.moi.gov.tw）

> **識別碼型別**：Medical record number（[Identifier Type Codes](http://terminology.hl7.org/CodeSystem/v2-0203)#MR）
**病歷號（official）**：8862200 （https://www.tph.mohw.gov.tw）

**病人的紀錄（active）**：使用中

**姓名（official）**：李貝拉

**性別**：女性

**出生日期**：2019-11-26

**年齡[extension:[person-age](StructureDefinition-person-age.md)]**：4

**國籍[extension:[patient-nationality](http://hl7.org/fhir/StructureDefinition/patient-nationality)]**：（[ISO3166Part1](https://terminology.hl7.org/CodeSystem-ISO3166Part1.html)#TW）

**聯絡方式**：Phone （[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0911327999 （[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2022-07-31至2024-07-31

**聯絡地址**：(330)桃園市桃園區成功路三段38號
**郵遞區號（postalCode） [extension:[tw-postal-code](StructureDefinition-tw-postal-code.md)]**： [330](CodeSystem-postal-code3-tw.md)
**縣/市（district）**：桃園市
**鄉/鎮/市/區（city）**：桃園區
**路/街（line）**：成功路
**段(section) [extension:[tw-section](StructureDefinition-tw-section.md)]**：三段
**號（number） [extension:[tw-number](StructureDefinition-tw-number.md)]**：38號
**國家（country）**：臺灣


**聯絡人（official）**：陳加玲 Chan, Chia Lin
**關係**：mother （[PatientRelationshipType](http://terminology.hl7.org/CodeSystem/v3-RoleCode)#MTH）
**聯絡方式**：Phone （[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：（Mobile）0911327999 （[ContactPointUse](https://build.fhir.org/codesystem-contact-point-use.html)#mobile）
**聯絡電話使用效期**：2022-07-31至2024-07-31

**向病人說明健康狀態時所使用的語言**：中文

**紀錄的保管機構**： [Organization/org-hosp-example](Organization-org-hosp-example.md) "衛生福利部臺北醫院"



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "pat-child-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
    ]
  },
  "extension" : [
    {
      "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age",
      "valueAge" : {
        "value" : 4,
        "system" : "http://unitsofmeasure.org",
        "code" : "a"
      }
    },
    {
      "extension" : [
        {
          "url" : "code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "TW"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NNxxx",
            "_code" : {
              "extension" : [
                {
                  "extension" : [
                    {
                      "url" : "suffix",
                      "valueString" : "TWN"
                    },
                    {
                      "url" : "valueSet",
                      "valueCanonical" : "http://hl7.org/fhir/ValueSet/iso3166-1-3"
                    }
                  ],
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
                }
              ]
            }
          }
        ]
      },
      "system" : "http://www.moi.gov.tw",
      "value" : "H122345678"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ]
      },
      "system" : "https://www.tph.mohw.gov.tw",
      "value" : "8862200"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "李貝拉",
      "family" : "Lee",
      "given" : ["Bella Lee"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "03-5555555",
      "use" : "home",
      "period" : {
        "start" : "2020-07-31",
        "end" : "2024-07-31"
      }
    }
  ],
  "gender" : "female",
  "birthDate" : "2019-11-26",
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-section",
          "valueString" : "三段"
        },
        {
          "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
          "valueString" : "38號"
        }
      ],
      "text" : "桃園市桃園區成功路三段38號",
      "line" : ["成功路"],
      "city" : "桃園區",
      "district" : "桃園市",
      "_postalCode" : {
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                  "code" : "330"
                }
              ]
            }
          }
        ]
      },
      "country" : "TW"
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "MTH"
            }
          ]
        }
      ],
      "name" : {
        "use" : "official",
        "text" : "陳加玲",
        "family" : "Chen",
        "given" : ["Chia Lin"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "0911327999",
          "use" : "mobile",
          "period" : {
            "start" : "2022-07-31",
            "end" : "2024-07-31"
          }
        }
      ]
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "zh-TW"
          }
        ]
      }
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/org-hosp-example"
  }
}

```
