# 醫事機構基本資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Organization: 醫事機構基本資料

### 醫事機構基本資料

**機構名稱**：衛生福利部臺北醫院

**識別碼型別**：Provider number（[IdentifierType](http://terminology.hl7.org/CodeSystem/v2-0203)#PRN）
**機構代碼（official）**：0131060029 (https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw)

**機構種類**：Healthcare Provider ([OrganizationType](http://hl7.org/fhir/R4/codesystem-organization-type.html)#prov)

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）
**聯絡電話**：0222765566



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "org-hosp-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-hosp-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PRN"
          }
        ]
      },
      "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw",
      "value" : "0131060029"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "prov"
        }
      ]
    }
  ],
  "name" : "衛生福利部臺北醫院",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0222765566"
    }
  ]
}

```
