# 政府機構基本資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Organization: 政府機構基本資料

### 政府機構基本資料

**機構名稱**：衛生福利部

**識別碼型別**：Government Organization Identifier（[臺灣識別碼類型值集](CodeSystem-v2-0203.md)#GOI）
**機關代號（official）**：A21000000I (https://oid.nat.gov.tw/)

**機構種類**：Government ([OrganizationType](http://hl7.org/fhir/R4/codesystem-organization-type.html)#govt)

**聯絡方式**：URL（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#url）
**網站連結**： [https://www.mohw.gov.tw/mp-1.html](https://www.mohw.gov.tw/mp-1.html)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "org-govt-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/v2-0203",
            "code" : "GOI"
          }
        ]
      },
      "system" : "https://oid.nat.gov.tw/",
      "value" : "A21000000I"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "govt"
        }
      ]
    }
  ],
  "name" : "衛生福利部",
  "telecom" : [
    {
      "system" : "url",
      "value" : "https://www.mohw.gov.tw/mp-1.html"
    }
  ]
}

```
