# 生命體徵資料-身體質量指數 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 生命體徵資料-身體質量指數

### 檢驗檢查資料

**狀態**：final

**分類**：Vital Signs ([Observation Category Codes](http://hl7.org/fhir/R4/codesystem-observation-category.html)#vital-signs)

**檢驗項目**：Body mass index (BMI) [Ratio] ([LOINC](http://loinc.org)#39156-5 "Body mass index (BMI) [Ratio]")

**病人**： [Patient/pat-example](Patient-pat-example.md) "陳加玲"

**檢查者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**執行日期**：2022-07-31

**檢驗值**：18.3 kg/m2



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-vital",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "39156-5",
        "display" : "Body mass index (BMI) [Ratio]"
      }
    ],
    "text" : "Body mass index (BMI) [Ratio]"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2022-07-31",
  "performer" : [
    {
      "reference" : "Practitioner/pra-dr-example"
    }
  ],
  "valueQuantity" : {
    "value" : 18.3,
    "unit" : "kg/m2",
    "system" : "http://unitsofmeasure.org",
    "code" : "kg/m2"
  }
}

```
