# 生命體徵資料-脈搏血氧飽和度 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 生命體徵資料-脈搏血氧飽和度

Profile: [TW Core Observation Pulse Oximetry](StructureDefinition-Observation-pulse-oximetry-twcore.md)

**status**: Final

**category**: 生命體徵

**code**: 脈搏血氧飽和度

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**effective**: 2022-07-31

**performer**: [Organization 衛生福利部臺北醫院](Organization-org-hosp-example.md)

**value**: 99 %(Details: UCUM code% = '%')

> **component****code**:吸入氧氣流速**value**: 6 liters/min(Details: UCUM codeL/min = 'L/min')

> **component****code**:吸入氧氣濃度**value**: 21 %(Details: UCUM code% = '%')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-pulse-oximetry-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pulse-oximetry-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "生命體徵"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "59408-5",
        "display" : "Oxygen saturation in Arterial blood by Pulse oximetry"
      },
      {
        "system" : "http://loinc.org",
        "code" : "2708-6",
        "display" : "Oxygen saturation in Arterial blood"
      }
    ],
    "text" : "脈搏血氧飽和度"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2022-07-31",
  "performer" : [
    {
      "reference" : "Organization/org-hosp-example"
    }
  ],
  "valueQuantity" : {
    "value" : 99,
    "unit" : "%",
    "system" : "http://unitsofmeasure.org",
    "code" : "%"
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "3151-8",
            "display" : "Inhaled oxygen flow rate"
          }
        ],
        "text" : "吸入氧氣流速"
      },
      "valueQuantity" : {
        "value" : 6,
        "unit" : "liters/min",
        "system" : "http://unitsofmeasure.org",
        "code" : "L/min"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "3150-0",
            "display" : "Inhaled oxygen concentration"
          }
        ],
        "text" : "吸入氧氣濃度"
      },
      "valueQuantity" : {
        "value" : 21,
        "unit" : "%",
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      }
    }
  ]
}

```
