# 心電圖檢查 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 心電圖檢查

### 心電圖檢查

**狀態**：final

**分類**：Diagnostic Procedure ([observation-category](http://terminology.hl7.org/CodeSystem/observation-category)#procedure)

**檢驗檢查項目**：心電圖檢查 ([LOINC](http://loinc.org)#11524-6 "EKG Study")

**病人**：[Patient/pat-example](Patient-pat-example.md)

**檢查日期**：2024-08-23

**ECG 導程資料**：

* **Lead I**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead II**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead III**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead aVR**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead aVL**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead aVF**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead V1**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead V2**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead V3**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead V4**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead V5**：SampledData（origin: 0, period: 2ms, dimensions: 12）
* **Lead V6**：SampledData（origin: 0, period: 2ms, dimensions: 12）



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-ecg-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-ecg-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "procedure",
          "display" : "Procedure"
        }
      ],
      "text" : "Diagnostic Procedure"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11524-6",
        "display" : "EKG Study"
      }
    ],
    "text" : "心電圖檢查"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2024-08-23",
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131329",
            "display" : "Lead I"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "-54 -53 -53 -55 -55 -53 -54 -54 -53 -54 -56 -56 -54 -53 -53 -53 -54 -54 -54 -54 -53 -51 -49 -50 -52 -54 -55 -52 -50 -49 -50 -52 -53 -54 -53 -53 -52 -50 -51 -52 -54 -53 -53 -51 -51 -51 -51 -52 -54 -54 -52 -50 -50 -52 -54 -54 -55 -54 -53 -52 -51 -51 -54 -56 -55 -53 -53 -53 -53 -55 -57 -59 -62 -61 -60 -61 -64 -67 -67 -65 -61 -57 -53 -49 -49 -49 -48 -48 -46 -44 -44 -46 -45 -44 -47 -47 -44 -43 -45 -45 -45 -47 -47 -47 -45 -43 -43 -47 -47 -49 -50 -48 -47 -48 -48 -49 -50 -50 -50 -51 -50 -48 -51 -52 -53 -53 -51 -51 -53 -52 -52 -53 -53 -54 -53 -52 -51 -52 -55 -55 -54 -53 -53 -53 -53 -54 -55 -55 -54 -53 -52 -50 -52 -55 -55 -55 -54 -52 -51 -53 -53 -55 -54 -53 -53 -52 -53 -52 -54 -55 -55 -54 -54 -52 -50 -52 -58 -57 -54 -53 -52 -51 -52 -54 -55 -56 -55 -53 -51 -53 -56 -57 -55 -55 -56 -55 -55 -53 -54 -56 -57 -56 -55 -54 -54 -56 -57 -57 -58 -56 -55 -55 -55 -56 -56 -57 -57 -56 -55 -55 -55 -57 -58 -57 -57 -56 -55 -55 -57 -58 -59 -59 -56 -53 -54 -56 -57 -59 -59 -58 -56 -56 -56 -57 -59 -59 -58 -57 -58 -59 -58 -58 -59 -60 -60 -59 -58 -58 -58 -59 -60 -58 -59 -60 -57 -58 -60 -60 -61 -60 -57 -57 -57 -57 -56 -56 -58 -58 -57 -55 -55 -57 -58 -57 -57 -57 -56 -56 -55 -55 -56 -58 -58 -55 -53 -55 -55 -57 -57 -56 -55 -56 -57 -56 -55 -56 -58 -58 -55 -54 -55 -56 -56 -56 -56 -56 -55 -53 -52 -54 -54 -55 -57 -56 -54 -53 -54 -55 -56 -56 -55 -54 -54 -54 -54 -55 -56 -55 -54 -52 -51 -53 -54 -54 -55 -57 -55 -53 -54 -55 -55 -54 -54 -55 -53 -51 -54 -56 -56 -56 -55 -53 -52 -52 -54 -57 -57 -56 -55 -55 -53 -52 -52 -55 -56 -55 -54 -52 -52 -53 -54 -55 -54 -53 -52 -50 -51 -55 -55 -54 -53 -53 -51 -50 -51 -53 -53 -53 -55 -53 -50 -51 -53 -53 -55 -54 -55 -56 -58 -58 -61 -64 -64 -62 -59 -57 -56 -58 -58 -59 -59 -58 -57 -56 -56 -55 -57 -59 -58 -56 -54 -54 -56 -57 -57 -57 -57 -56 -56 -55 -56 -56 -57 -58 -57 -55 -53 -54 -56 -56 -56 -56 -57 -55 -55 -55 -56 -58 -56 -54 -55 -55 -55 -56 -56 -57 -57 -56 -55 -55 -55 -57 -59 -58 -56 -55 -55 -55 -55 -58 -58 -57 -55 -55 -55 -55 -55 -57 -57 -58 -56 -55 -56 -55 -57 -59 -58 -55 -56 -55 -55 -57 -57 -57 -57 -56 -55 -55 -56 -57 -58 -57 -56 -57 -55 -53 -55 -56 -57 -58 -57 -58 -58 -56 -56 -58 -59 -57 -57 -56 -54 -56 -58 -60 -58 -55 -56 -56 -57 -57 -59 -59 -58 -58 -55 -54 -56 -58 -58 -58 -58 -57 -57 -58 -60 -61 -58 -60 -59 -57 -58 -58 -57 -57 -58 -58 -55 -55 -56 -56 -56 -58 -57 -57 -58 -54 -54 -58 -58 -57 -57 -56 -55 -55 -56 -57 -59 -58 -56 -56 -55 -55 -57 -58 -58 -59 -59 -56 -55 -56"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131330",
            "display" : "Lead II"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "-148 -147 -148 -149 -149 -148 -149 -149 -148 -150 -151 -150 -149 -150 -148 -148 -150 -151 -150 -149 -148 -147 -147 -148 -148 -149 -150 -149 -146 -145 -148 -149 -149 -150 -150 -149 -148 -146 -147 -148 -149 -148 -147 -146 -146 -145 -145 -147 -148 -147 -145 -144 -144 -145 -147 -147 -148 -148 -147 -145 -144 -145 -148 -149 -148 -147 -147 -146 -145 -145 -145 -145 -146 -144 -142 -143 -145 -147 -147 -144 -141 -139 -139 -139 -138 -138 -138 -138 -137 -136 -134 -135 -136 -136 -137 -137 -135 -135 -136 -136 -136 -137 -136 -136 -135 -133 -134 -136 -137 -140 -141 -141 -140 -140 -141 -142 -142 -143 -143 -143 -143 -142 -143 -146 -147 -146 -144 -142 -145 -146 -145 -146 -147 -146 -144 -144 -145 -145 -146 -146 -146 -145 -145 -144 -145 -147 -147 -147 -146 -146 -143 -142 -145 -148 -148 -147 -146 -144 -144 -145 -145 -147 -147 -145 -145 -145 -144 -145 -146 -147 -146 -146 -146 -145 -143 -144 -147 -147 -146 -144 -142 -143 -145 -145 -147 -147 -146 -145 -144 -144 -145 -148 -147 -146 -146 -144 -145 -145 -146 -148 -147 -146 -147 -146 -145 -146 -147 -147 -148 -147 -145 -144 -146 -147 -146 -147 -146 -144 -145 -145 -146 -147 -147 -147 -147 -147 -146 -145 -146 -147 -148 -147 -145 -143 -143 -145 -146 -148 -148 -146 -145 -144 -143 -145 -146 -146 -146 -145 -144 -144 -145 -146 -146 -147 -147 -145 -144 -143 -144 -145 -145 -144 -145 -145 -142 -143 -145 -145 -145 -144 -143 -143 -142 -144 -143 -142 -143 -143 -142 -141 -140 -141 -143 -143 -143 -142 -141 -142 -142 -142 -143 -144 -144 -142 -142 -143 -143 -144 -144 -144 -144 -144 -143 -143 -144 -145 -145 -146 -143 -141 -142 -144 -145 -146 -145 -145 -145 -142 -141 -144 -145 -145 -146 -144 -142 -143 -143 -143 -145 -146 -145 -144 -143 -144 -145 -145 -145 -145 -144 -142 -142 -143 -143 -143 -144 -146 -143 -143 -145 -145 -145 -146 -144 -143 -143 -142 -144 -146 -147 -147 -144 -143 -144 -143 -143 -145 -146 -146 -145 -145 -145 -143 -143 -145 -146 -145 -143 -143 -144 -144 -145 -145 -144 -144 -144 -142 -142 -145 -145 -144 -144 -144 -143 -142 -143 -144 -144 -145 -143 -142 -140 -142 -143 -144 -145 -144 -144 -144 -145 -146 -147 -148 -149 -148 -146 -144 -144 -144 -144 -146 -145 -146 -146 -144 -144 -143 -143 -145 -146 -145 -143 -142 -143 -143 -145 -146 -145 -143 -143 -143 -144 -143 -144 -144 -144 -144 -143 -142 -143 -144 -144 -144 -144 -143 -143 -144 -145 -146 -144 -142 -143 -142 -142 -144 -145 -146 -145 -143 -143 -143 -142 -143 -145 -145 -145 -143 -142 -143 -143 -143 -145 -144 -143 -141 -142 -143 -142 -144 -144 -145 -143 -143 -144 -142 -142 -145 -144 -141 -141 -142 -142 -144 -145 -144 -144 -143 -142 -141 -141 -143 -145 -143 -142 -143 -142 -140 -142 -144 -143 -144 -143 -142 -142 -142 -144 -145 -144 -142 -142 -141 -140 -141 -144 -146 -144 -142 -141 -140 -142 -143 -144 -144 -143 -142 -141 -140 -141 -143 -143 -143 -144 -142 -143 -144 -145 -145 -145 -145 -145 -144 -143 -143 -144 -145 -144 -143 -142 -142 -143 -143 -142 -143 -143 -141 -141 -139 -142 -144 -143 -141 -141 -141 -139 -139 -140 -141 -141 -140 -141 -140 -139 -139 -141 -141 -140 -141 -142 -140 -139 -140"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131389",
            "display" : "Lead III"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "-94 -95 -94 -94 -94 -95 -95 -94 -95 -96 -95 -94 -95 -96 -95 -95 -97 -97 -96 -95 -95 -96 -98 -97 -96 -95 -95 -96 -96 -96 -98 -98 -95 -96 -97 -96 -96 -96 -96 -96 -95 -95 -95 -95 -95 -95 -95 -95 -94 -93 -93 -95 -95 -93 -93 -93 -93 -94 -94 -93 -93 -94 -94 -94 -93 -94 -95 -94 -92 -90 -89 -86 -84 -83 -82 -82 -81 -79 -80 -80 -80 -82 -86 -90 -89 -89 -90 -90 -91 -92 -90 -89 -91 -91 -90 -90 -91 -92 -91 -91 -91 -90 -89 -89 -89 -90 -90 -89 -90 -91 -91 -93 -92 -92 -93 -93 -92 -92 -93 -92 -93 -93 -92 -94 -94 -93 -92 -92 -93 -94 -93 -93 -94 -93 -91 -92 -93 -94 -91 -91 -92 -93 -92 -92 -92 -92 -92 -91 -93 -93 -91 -92 -93 -93 -93 -92 -92 -92 -92 -92 -91 -92 -93 -92 -93 -92 -92 -92 -92 -92 -91 -91 -92 -92 -93 -92 -89 -90 -92 -91 -91 -93 -93 -91 -91 -91 -91 -93 -93 -91 -89 -90 -92 -91 -90 -90 -90 -91 -91 -92 -90 -90 -92 -92 -91 -90 -90 -91 -90 -90 -90 -90 -91 -91 -90 -89 -89 -89 -89 -90 -90 -90 -90 -90 -90 -90 -91 -90 -89 -89 -89 -88 -88 -89 -89 -88 -89 -89 -88 -88 -89 -88 -87 -87 -87 -87 -88 -88 -86 -86 -87 -88 -87 -87 -87 -86 -86 -85 -86 -86 -85 -86 -86 -85 -85 -85 -85 -85 -84 -84 -86 -86 -86 -87 -87 -86 -86 -85 -85 -86 -85 -84 -85 -86 -86 -85 -85 -86 -87 -87 -87 -86 -86 -87 -89 -88 -87 -87 -87 -88 -89 -88 -86 -87 -89 -88 -88 -88 -88 -88 -87 -88 -89 -89 -89 -90 -90 -90 -89 -90 -90 -90 -89 -88 -88 -89 -89 -88 -89 -90 -90 -90 -90 -89 -90 -90 -89 -90 -90 -90 -91 -90 -90 -89 -89 -89 -88 -90 -91 -90 -90 -92 -90 -88 -91 -91 -90 -90 -90 -90 -89 -90 -91 -91 -89 -88 -88 -91 -91 -90 -91 -91 -91 -90 -90 -90 -90 -92 -92 -91 -91 -90 -90 -91 -92 -91 -91 -90 -90 -90 -91 -92 -92 -92 -92 -91 -91 -92 -88 -89 -91 -90 -90 -90 -90 -90 -90 -88 -86 -88 -86 -84 -85 -86 -87 -87 -88 -86 -86 -87 -86 -87 -89 -88 -88 -88 -87 -87 -87 -89 -89 -89 -88 -87 -88 -89 -88 -87 -87 -88 -88 -88 -87 -86 -87 -89 -89 -88 -87 -89 -89 -88 -87 -89 -88 -89 -89 -89 -88 -88 -87 -86 -87 -88 -88 -89 -88 -86 -87 -88 -88 -86 -86 -87 -88 -88 -87 -88 -88 -85 -87 -88 -87 -87 -87 -89 -87 -87 -87 -87 -87 -88 -88 -87 -86 -86 -86 -86 -85 -87 -88 -87 -87 -87 -87 -87 -86 -86 -85 -87 -87 -87 -86 -86 -86 -87 -87 -87 -86 -86 -86 -85 -84 -86 -88 -87 -85 -85 -85 -85 -86 -85 -85 -86 -86 -87 -85 -84 -85 -87 -86 -85 -85 -85 -85 -86 -85 -85 -85 -86 -86 -86 -86 -86 -85 -84 -86 -86 -85 -87 -85 -85 -87 -87 -85 -86 -86 -86 -86 -87 -86 -86 -85 -84 -83 -85 -87 -85 -85 -85 -84 -85 -85 -85 -84 -84 -82 -83 -84 -84 -84 -84 -84 -83 -82 -83 -84 -85 -84 -84"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131390",
            "display" : "Lead aVR"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "100 100 101 102 102 100 101 101 101 102 104 103 102 101 101 100 102 103 102 101 101 99 98 99 100 102 102 101 98 97 99 101 101 102 101 101 100 98 99 100 101 101 100 99 98 98 98 99 101 100 99 97 97 98 100 100 101 101 100 99 98 98 101 102 101 100 100 100 99 100 101 102 104 102 101 102 104 107 107 104 101 98 96 94 94 93 93 93 91 90 89 91 90 90 92 92 90 89 90 90 91 92 91 91 90 88 89 91 92 94 95 94 93 94 95 96 96 97 96 97 96 95 97 99 100 100 98 96 99 99 98 100 100 100 99 98 98 98 100 101 100 99 99 99 99 100 101 101 100 99 98 96 98 102 102 101 100 98 97 99 99 101 101 99 99 99 99 98 100 101 101 100 99 99 97 98 102 102 100 98 97 97 98 100 101 102 101 99 98 98 101 103 101 101 101 100 100 99 100 102 102 101 101 100 99 101 102 102 103 101 100 100 101 102 101 102 101 100 100 100 101 102 102 102 102 102 101 100 102 103 104 103 101 98 98 100 102 103 103 102 100 100 100 101 103 103 102 101 101 101 102 102 102 103 104 102 101 101 101 102 102 101 102 102 100 100 102 102 103 102 100 100 99 100 100 99 100 101 99 98 98 99 100 100 100 100 98 99 99 98 99 101 101 99 98 99 99 101 101 100 100 100 100 99 99 101 102 102 99 97 99 100 101 101 101 100 100 98 97 99 99 100 101 100 98 98 98 99 101 101 100 99 99 99 99 100 100 100 99 97 97 98 99 99 99 101 99 98 99 100 100 100 99 99 98 97 99 101 101 101 100 98 98 98 99 101 101 101 100 100 99 97 98 100 101 100 98 98 98 98 99 100 99 98 98 96 97 100 100 99 99 99 97 96 97 98 98 99 99 97 95 97 98 99 100 99 99 100 101 102 104 106 107 105 102 100 100 101 101 102 102 102 101 100 100 99 100 102 102 101 99 98 99 100 101 101 101 100 99 99 100 100 100 101 100 99 98 98 100 100 100 100 100 99 99 99 100 102 100 98 99 99 98 100 100 101 101 100 99 99 99 100 102 101 100 99 98 99 99 101 102 100 99 98 99 99 99 100 101 101 100 99 100 99 100 102 101 98 98 99 99 100 101 100 101 100 98 98 98 100 102 100 99 100 98 96 99 100 100 101 100 100 100 99 100 101 101 100 99 98 97 98 101 103 101 99 99 98 99 100 101 101 101 100 98 97 99 100 101 100 101 99 100 101 102 103 101 102 102 100 100 100 100 101 101 100 98 98 99 99 99 100 100 99 99 97 98 101 101 99 99 99 97 97 98 99 100 99 99 98 97 97 99 99 99 100 101 98 97 98"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131391",
            "display" : "Lead aVL"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "20 21 20 19 19 21 21 20 21 21 19 19 20 21 21 21 22 22 21 21 21 23 24 24 22 20 20 22 23 23 24 23 21 21 22 21 22 23 23 22 20 21 21 22 22 22 22 21 20 20 20 22 23 20 19 20 19 20 21 20 21 22 20 19 19 20 21 20 20 18 16 13 11 11 11 11 9 6 6 7 9 12 17 20 20 20 21 21 22 24 23 22 23 23 21 22 23 24 23 23 23 21 21 21 22 24 23 21 22 21 21 22 22 22 23 22 21 21 22 21 21 22 21 21 21 20 20 21 20 21 21 20 20 20 19 20 21 21 18 18 19 20 20 19 19 19 18 18 19 20 19 21 20 19 19 18 19 20 21 19 19 19 19 20 20 20 20 20 19 18 18 18 19 20 22 20 16 16 19 19 19 21 20 18 18 18 18 20 21 19 16 16 19 18 17 17 17 19 18 18 16 17 18 19 19 17 16 17 16 17 17 17 18 17 17 16 16 16 17 18 17 16 16 17 16 17 18 17 16 15 15 15 16 18 18 16 16 15 14 15 16 16 16 15 14 14 15 15 14 13 14 15 14 13 13 13 14 14 14 13 13 14 13 13 14 14 13 12 12 12 15 15 14 15 15 15 14 13 14 15 15 14 14 14 14 14 15 15 16 16 15 14 14 16 18 16 16 15 15 16 17 16 15 16 17 16 15 15 16 17 16 16 16 16 16 17 17 18 19 18 18 17 16 16 17 18 18 17 17 17 18 18 18 18 18 18 17 18 18 19 20 18 18 18 17 16 16 19 19 17 18 19 18 17 19 20 18 17 17 17 17 19 19 19 18 15 15 18 18 17 19 20 19 17 17 17 18 20 20 19 18 17 18 19 20 20 20 18 18 18 19 19 20 21 20 19 19 19 17 18 21 19 18 19 18 18 18 16 14 15 13 10 10 12 14 15 16 14 14 14 13 15 16 16 16 16 15 14 15 16 17 17 16 15 15 16 16 16 16 16 16 16 15 14 15 17 18 17 16 16 16 16 15 17 16 17 17 15 16 17 16 15 16 16 16 16 15 15 16 17 16 15 14 14 16 16 16 17 16 14 14 15 16 16 16 17 16 15 15 14 16 16 16 16 14 13 14 15 15 16 16 15 15 15 15 15 16 15 15 15 14 15 15 14 16 17 16 16 14 14 15 14 13 15 16 14 13 14 14 14 16 15 13 13 14 16 15 14 14 15 14 13 14 13 15 16 15 14 14 14 14 15 14 14 13 12 14 13 13 15 14 14 15 15 13 14 15 15 15 16 15 14 14 13 13 15 16 14 13 14 14 14 15 15 14 14 12 12 14 14 15 14 13 13 12 12 13 14 14 14"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131392",
            "display" : "Lead aVF"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "-121 -121 -121 -122 -122 -121 -122 -122 -122 -123 -123 -122 -122 -123 -122 -122 -123 -124 -123 -122 -121 -121 -122 -123 -122 -122 -123 -123 -121 -121 -123 -124 -122 -123 -123 -122 -122 -121 -121 -122 -122 -121 -121 -120 -120 -120 -120 -121 -121 -120 -119 -120 -120 -119 -120 -120 -121 -121 -121 -119 -119 -120 -121 -121 -120 -120 -121 -120 -119 -118 -117 -116 -115 -114 -112 -113 -113 -113 -113 -112 -110 -111 -113 -114 -114 -114 -114 -114 -114 -114 -112 -112 -113 -113 -114 -113 -113 -113 -113 -113 -113 -113 -113 -112 -112 -112 -112 -113 -113 -115 -116 -117 -116 -116 -117 -117 -117 -118 -118 -118 -118 -117 -118 -120 -120 -120 -118 -117 -119 -120 -119 -120 -121 -120 -118 -118 -119 -120 -118 -118 -119 -119 -119 -118 -119 -119 -119 -119 -119 -119 -117 -117 -119 -120 -120 -119 -119 -118 -118 -118 -118 -120 -120 -119 -119 -119 -118 -118 -119 -119 -119 -118 -119 -119 -118 -118 -118 -119 -119 -117 -116 -118 -119 -118 -119 -119 -119 -119 -119 -118 -117 -119 -120 -119 -118 -117 -117 -118 -119 -120 -118 -118 -120 -119 -118 -118 -118 -119 -119 -119 -117 -117 -119 -119 -118 -118 -117 -117 -117 -117 -118 -118 -119 -119 -118 -119 -118 -118 -118 -118 -119 -118 -116 -116 -116 -116 -117 -118 -118 -117 -117 -116 -115 -116 -117 -117 -117 -117 -115 -115 -116 -117 -116 -117 -117 -116 -115 -114 -115 -115 -115 -115 -115 -115 -114 -114 -115 -115 -115 -114 -115 -115 -114 -115 -115 -114 -115 -114 -114 -113 -112 -112 -114 -115 -114 -114 -113 -114 -115 -114 -115 -115 -115 -114 -115 -115 -115 -116 -116 -116 -117 -116 -115 -115 -116 -117 -117 -117 -116 -114 -115 -116 -117 -117 -117 -117 -118 -116 -115 -117 -118 -117 -117 -116 -115 -116 -116 -116 -117 -118 -117 -117 -117 -117 -117 -117 -117 -118 -117 -116 -117 -117 -117 -116 -117 -117 -115 -116 -118 -117 -118 -119 -117 -116 -117 -117 -117 -118 -118 -118 -116 -117 -118 -117 -116 -116 -117 -119 -118 -117 -118 -117 -117 -117 -118 -117 -116 -118 -118 -118 -118 -117 -117 -117 -118 -117 -117 -118 -118 -117 -118 -118 -117 -117 -117 -117 -118 -118 -116 -115 -116 -116 -116 -117 -118 -117 -117 -116 -116 -117 -116 -116 -117 -117 -116 -115 -116 -115 -115 -116 -115 -117 -117 -116 -116 -115 -115 -116 -117 -117 -116 -116 -115 -115 -116 -117 -116 -115 -115 -116 -116 -116 -115 -115 -115 -116 -116 -115 -115 -116 -116 -116 -116 -116 -116 -116 -117 -118 -116 -115 -115 -114 -114 -116 -117 -117 -116 -115 -115 -116 -115 -115 -115 -116 -116 -115 -114 -116 -115 -114 -116 -116 -115 -114 -115 -116 -115 -115 -116 -116 -115 -115 -116 -115 -114 -115 -115 -114 -113 -115 -115 -116 -116 -115 -115 -115 -114 -113 -113 -115 -116 -115 -114 -115 -114 -113 -115 -116 -115 -115 -115 -114 -113 -114 -116 -116 -115 -114 -113 -113 -113 -113 -114 -116 -115 -115 -113 -112 -113 -115 -115 -115 -114 -114 -113 -113 -113 -114 -114 -115 -115 -114 -114 -115 -115 -115 -116 -116 -115 -115 -114 -114 -116 -116 -115 -114 -114 -114 -114 -115 -114 -114 -114 -113 -112 -112 -115 -115 -114 -113 -113 -113 -112 -112 -112 -112 -112 -112 -113 -112 -111 -112 -112 -112 -111 -112 -113 -112 -112 -112"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131331",
            "display" : "Lead V1"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "36 36 36 35 35 36 37 37 36 36 36 36 36 36 36 36 37 37 37 37 37 38 38 37 37 37 37 38 38 38 38 38 37 37 37 37 37 38 37 37 37 37 37 37 38 38 38 38 37 36 37 38 38 37 37 36 37 37 38 38 38 38 38 38 38 38 38 39 39 37 35 34 33 32 31 30 29 28 27 26 26 27 30 33 35 35 35 36 37 38 40 40 39 39 39 39 40 40 40 40 40 39 38 37 36 36 35 34 35 35 35 35 36 36 36 36 36 36 36 37 38 37 37 37 38 38 38 39 38 38 37 37 37 38 38 39 38 38 38 38 38 38 38 39 38 38 37 38 38 38 39 39 39 38 37 37 37 39 39 38 38 38 38 37 38 39 39 38 38 38 38 38 38 38 38 38 38 37 38 38 39 39 39 39 38 38 38 38 38 38 39 38 38 38 38 38 38 38 38 38 37 37 38 38 38 38 38 37 37 37 38 39 38 37 37 37 37 38 38 38 37 37 37 37 37 38 38 38 37 36 36 36 37 38 38 37 37 36 36 36 36 37 37 36 36 36 36 36 37 37 36 35 36 35 35 35 35 35 35 35 35 36 36 35 36 36 35 35 35 35 35 36 36 36 35 35 35 36 37 37 37 37 36 36 37 37 37 36 37 36 36 36 36 37 37 37 37 36 36 37 37 38 38 38 38 37 37 37 38 38 38 38 37 38 38 38 39 39 39 39 38 38 38 38 39 40 39 38 38 39 39 39 39 39 39 38 38 38 39 40 39 40 39 39 39 38 39 39 40 39 39 38 39 40 40 40 40 39 38 38 39 40 39 39 39 39 39 38 39 40 40 39 39 39 38 38 38 39 39 38 37 38 38 38 38 38 38 37 37 37 37 38 38 38 38 38 37 37 38 39 39 39 38 38 38 38 38 38 39 38 37 36 36 36 36 37 37 38 37 36 37 37 37 37 37 37 37 36 36 36 37 38 37 37 36 36 36 37 37 37 37 37 36 37 37 37 37 37 37 36 36 36 37 37 37 36 36 35 36 37 37 36 36 36 36 35 36 36 36 36 36 36 36 36 36 36 36 36 36 36 35 36 37 36 36 36 36 35 35 36 36 36 36 36 36 36 35 36 36 37 36 36 35 35 35 36 36 36 36 35 36 36 36 36 36 36 35 34 35 35 35 36 36 36 36 35 35 35 36 36 36 35 34 34 35 35 36 36 36 35 34 34 35 35 35 35 35 34 34 35 35 35 35 34 34 34 33 33 34 35 35 35 35 34 34 34 35 35 35 35 35 34 34 35 35 35 35 35 34 34 35 35 36 36 35 34 34 34 34 34 35 34 34 33 33 34 34 35 35 34"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131332",
            "display" : "Lead V2"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "32 32 32 32 32 33 33 33 33 33 32 32 33 33 32 33 33 33 33 33 34 34 34 33 32 32 32 33 34 34 34 33 33 33 33 33 33 33 33 33 32 32 32 32 33 33 33 33 32 32 32 34 34 33 32 32 32 32 33 34 34 34 34 34 33 34 34 35 35 34 32 31 30 30 29 29 28 27 25 21 19 19 21 22 24 24 25 26 26 27 29 28 28 27 27 27 27 27 28 27 27 26 26 26 26 26 25 25 26 26 27 28 29 29 29 29 29 30 30 31 32 32 31 32 32 33 33 34 33 33 32 32 32 33 34 34 34 33 33 33 33 33 34 34 33 33 32 33 33 33 34 34 34 33 33 32 33 34 34 34 33 33 33 33 34 35 34 34 33 33 33 33 33 34 34 34 33 32 33 34 34 34 34 34 33 33 33 34 33 34 34 34 33 33 34 34 34 34 33 33 32 33 33 34 33 33 33 33 33 33 34 35 33 33 33 33 33 34 34 33 33 33 33 33 33 34 34 34 33 33 32 33 34 35 35 34 33 33 33 33 34 34 34 33 33 33 33 34 34 34 33 33 33 33 32 32 33 33 32 32 33 33 33 33 33 33 32 32 32 32 32 32 33 32 31 31 31 32 32 33 33 32 32 32 32 32 32 32 32 32 32 31 32 32 32 33 33 32 32 33 33 34 34 33 33 33 33 33 33 34 34 33 33 33 33 33 34 34 34 33 33 33 33 33 34 35 34 33 33 34 34 34 34 34 34 33 33 34 35 35 35 35 34 35 34 34 35 35 35 35 34 34 34 35 36 36 36 35 34 33 34 35 35 35 35 35 35 34 35 36 36 35 35 35 34 34 35 35 36 35 34 35 35 35 35 35 35 35 34 34 34 35 35 35 35 34 34 34 35 36 36 35 34 34 34 34 34 34 35 34 33 32 32 32 32 33 34 34 34 33 33 34 33 33 34 33 33 33 33 33 34 35 34 33 33 33 33 33 34 34 34 33 33 34 34 34 34 34 33 33 33 33 33 34 34 33 33 32 32 34 34 33 33 33 33 32 33 33 33 33 33 33 32 33 33 33 33 33 33 33 32 33 34 33 33 33 32 32 32 33 33 33 33 33 33 32 32 33 34 34 33 33 33 32 32 33 33 33 33 32 33 32 33 33 33 33 32 31 31 32 32 33 33 32 32 32 32 32 32 33 33 32 31 31 32 32 32 33 33 32 31 31 32 32 32 32 32 31 31 31 31 32 32 32 31 31 30 30 31 32 32 32 32 31 31 32 32 32 33 33 32 32 32 33 32 32 32 32 32 32 32 32 33 33 33 32 31 32 31 32 33 32 31 31 31 31 32 33 33 32"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131333",
            "display" : "Lead V3"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "35 35 35 35 34 35 35 35 35 34 34 34 34 34 34 34 35 35 34 34 34 35 34 34 34 33 33 34 34 35 34 34 34 33 33 33 33 34 34 33 33 33 33 33 33 34 33 33 33 32 33 34 34 33 32 32 32 33 33 33 34 34 34 34 34 36 37 39 41 44 45 48 51 54 57 57 57 55 50 46 41 37 32 28 27 28 28 28 29 30 32 31 29 29 29 28 28 29 29 29 29 29 29 29 29 29 28 28 28 28 28 29 29 30 31 30 30 30 31 32 32 32 32 32 32 32 33 34 33 33 32 32 32 33 33 34 33 33 33 33 32 33 33 34 33 33 32 33 33 33 34 34 34 33 33 32 33 34 34 34 33 33 33 33 34 35 34 34 34 34 34 34 33 34 34 34 33 33 33 34 35 35 35 35 34 34 34 35 35 35 35 35 34 34 35 35 35 35 35 35 34 35 35 36 36 36 36 36 36 36 37 38 37 37 37 37 38 38 39 39 39 39 39 39 40 41 42 42 41 41 41 42 43 45 45 45 45 45 46 46 46 47 48 48 48 48 48 49 50 50 50 50 50 50 49 49 50 50 49 49 49 49 49 48 48 48 47 46 46 46 45 45 45 44 43 43 42 42 42 42 41 41 40 39 39 39 39 38 38 38 38 37 37 37 37 37 37 36 35 36 35 36 36 36 36 35 35 35 35 36 36 35 35 34 34 34 35 36 35 34 34 34 34 34 35 35 34 34 33 34 34 34 34 34 34 33 33 33 34 34 34 34 34 34 33 33 34 34 34 34 33 32 33 34 34 34 34 33 33 32 33 34 33 33 34 34 33 32 33 34 34 34 33 33 32 32 32 33 33 33 32 32 33 32 32 33 33 32 32 31 32 32 32 32 33 32 31 31 33 33 33 33 32 32 32 32 32 32 33 32 31 29 29 30 30 31 32 32 31 30 31 31 31 31 32 32 31 31 31 31 31 32 32 31 30 30 31 31 31 32 31 31 31 31 31 31 31 31 31 30 30 30 31 31 31 31 30 29 30 31 31 31 30 31 30 30 30 30 30 30 31 30 30 30 30 30 31 30 30 30 29 30 31 31 30 31 30 29 30 30 30 31 31 30 30 30 30 30 31 31 31 30 30 30 30 30 31 30 30 30 30 30 30 31 31 31 30 29 29 30 30 31 31 30 30 29 29 30 30 30 30 30 29 29 30 30 31 31 31 30 29 29 30 30 30 30 30 30 30 30 30 30 30 30 29 29 29 28 30 30 31 31 30 30 30 30 31 31 31 31 31 31 31 32 31 31 32 32 31 31 31 32 32 32 32 32 31 31 31 32 32 32 31 30 30 30 30 31 31 30"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131334",
            "display" : "Lead V4"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "44 44 44 44 44 44 44 44 44 44 43 43 44 44 43 44 45 44 44 43 44 45 44 44 43 43 43 43 43 44 43 43 42 42 42 42 42 42 42 41 41 41 41 41 41 42 41 41 41 40 41 42 42 41 41 40 40 41 41 42 42 41 41 41 41 42 43 44 46 47 47 49 51 53 55 55 54 53 52 51 50 48 45 43 43 44 43 43 44 45 47 45 44 43 43 42 42 42 41 41 41 41 41 41 41 41 40 39 39 38 38 38 39 39 39 39 38 38 38 39 39 38 38 38 38 38 38 39 38 38 37 36 37 37 38 38 38 37 37 37 37 38 38 38 38 38 38 38 38 38 39 40 39 39 38 38 38 40 40 39 39 39 39 39 40 41 40 40 40 40 40 40 40 40 41 41 40 39 40 41 41 41 41 41 40 40 40 41 41 41 41 41 40 40 41 41 41 41 41 41 40 41 41 42 42 41 42 41 41 42 43 43 42 42 42 42 42 43 43 43 43 43 43 42 43 44 45 45 44 43 43 44 45 46 46 46 46 46 46 46 46 47 47 47 47 47 47 48 49 49 49 49 49 49 49 49 49 49 49 49 49 49 50 49 49 49 48 48 48 48 48 48 49 48 47 47 47 47 48 48 47 47 46 46 46 47 46 46 46 46 45 45 45 45 45 45 44 43 43 43 43 43 43 43 43 42 42 42 42 43 42 42 41 40 40 40 41 41 41 40 39 39 38 39 39 40 39 38 38 38 38 38 38 38 37 36 36 36 37 37 37 37 36 36 35 35 36 36 35 35 34 34 34 35 35 35 34 34 33 32 33 34 34 34 34 34 33 32 33 34 34 33 33 33 32 32 33 33 33 33 32 32 33 33 33 34 34 33 33 32 33 33 33 34 34 34 33 33 34 35 35 34 34 34 33 33 33 33 34 33 31 30 30 30 31 31 32 32 31 30 31 31 31 31 31 31 30 29 30 29 30 31 30 30 29 29 29 30 30 30 30 30 30 30 30 30 31 31 30 30 30 29 30 30 31 30 29 29 29 30 30 30 30 30 30 29 29 30 30 30 30 30 30 30 30 30 30 30 30 30 29 30 31 31 31 31 30 30 30 31 31 31 31 31 31 31 30 31 32 32 31 31 31 30 30 31 31 31 31 31 31 31 31 31 31 31 31 29 30 31 31 32 32 31 31 30 31 31 31 32 32 32 31 31 32 32 33 33 33 32 32 32 33 33 33 34 33 33 33 33 33 34 34 34 33 33 33 33 34 35 35 35 34 34 34 34 35 35 35 35 35 34 34 35 34 34 34 34 33 33 32 33 33 33 32 32 31 31 30 30 31 29 29 28 27 27 27 27 27 26"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131335",
            "display" : "Lead V5"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "40 40 40 39 40 40 40 40 39 39 39 39 39 39 39 39 39 39 39 39 39 40 39 39 38 38 38 39 39 39 39 39 38 38 38 38 38 39 38 38 38 38 38 38 39 39 38 38 38 37 38 39 39 38 37 37 37 38 38 38 38 38 38 38 38 40 41 42 44 46 48 50 54 57 60 61 62 60 57 54 51 47 41 36 35 35 35 35 35 37 38 37 36 35 35 35 34 34 34 34 34 35 35 35 36 36 35 34 34 34 34 35 35 35 36 36 35 36 36 37 37 36 36 37 37 37 38 38 38 37 36 36 36 37 38 38 38 37 37 37 37 37 38 38 38 37 37 37 37 38 38 39 38 38 37 37 37 39 39 38 38 38 38 38 39 39 39 38 38 38 39 38 38 39 39 39 38 37 38 39 39 39 39 39 39 38 39 39 39 39 39 39 39 39 39 40 40 39 39 39 38 39 39 40 40 40 40 39 39 39 41 41 40 40 40 40 40 41 41 41 41 41 41 41 42 42 43 43 42 42 42 43 44 45 46 45 45 46 46 46 46 47 47 47 48 47 47 49 49 49 49 49 49 49 49 49 49 49 49 49 49 50 50 49 49 49 48 48 47 48 47 47 48 47 46 46 45 45 46 46 45 45 44 44 44 44 43 43 43 43 42 42 42 42 42 42 41 41 40 41 41 41 41 41 41 40 40 40 40 41 41 40 40 39 39 39 40 41 40 39 38 38 38 39 40 40 39 38 38 38 38 38 38 38 38 37 37 37 38 38 38 38 37 37 37 37 38 38 38 38 37 37 37 38 38 38 38 37 37 36 37 38 38 38 38 38 37 36 37 38 38 38 37 37 37 37 37 38 38 37 37 37 37 37 37 38 37 37 36 36 36 37 37 37 37 37 36 35 37 38 38 37 37 37 36 36 37 37 38 37 36 35 35 36 36 36 37 37 37 36 36 36 36 36 36 36 36 35 35 35 36 37 36 35 35 35 35 36 36 36 35 35 35 36 35 36 36 36 35 35 35 35 35 36 36 35 35 34 34 36 36 35 35 35 35 34 34 35 35 35 36 35 35 35 35 35 36 36 35 35 34 35 36 36 36 36 35 34 35 36 36 36 36 36 35 35 35 35 36 37 36 35 35 35 35 36 36 36 35 35 35 35 35 36 36 36 35 34 34 35 35 36 36 35 35 34 34 35 35 35 35 35 34 34 35 35 36 36 36 35 34 34 35 35 36 36 35 35 35 35 35 36 36 36 35 35 35 34 36 36 36 36 36 35 35 36 36 36 37 37 36 36 36 37 37 37 37 37 36 36 37 37 37 38 37 37 37 37 37 38 38 37 36 36 36 36 36 37 36 36"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.24",
            "code" : "131336",
            "display" : "Lead V6"
          }
        ]
      },
      "valueSampledData" : {
        "origin" : {
          "value" : 0
        },
        "period" : 2,
        "factor" : 50,
        "lowerLimit" : -32768,
        "upperLimit" : 32767,
        "dimensions" : 12,
        "data" : "44 44 45 44 44 44 45 45 44 44 43 43 44 44 43 44 44 44 44 43 44 44 44 43 43 43 43 43 44 44 44 43 43 43 43 43 43 43 43 43 42 42 42 42 43 43 43 43 42 41 42 44 43 42 42 42 41 42 42 42 42 41 41 41 41 42 43 44 46 48 49 51 54 58 61 63 63 63 61 60 58 54 48 42 40 40 39 38 39 40 41 40 39 39 38 38 38 38 38 38 38 38 39 39 39 40 39 38 39 38 38 39 39 39 40 39 39 39 39 40 41 40 40 40 40 40 41 41 41 40 40 39 39 40 41 41 41 40 40 40 40 40 41 41 40 40 40 40 40 40 41 41 41 40 40 40 40 41 41 41 40 40 40 40 41 42 41 41 41 41 41 41 41 41 41 41 40 40 40 41 42 42 42 41 41 41 41 41 41 41 42 41 41 40 41 41 41 41 41 40 40 40 41 41 41 41 41 41 41 41 42 42 41 41 41 41 41 42 42 42 42 42 41 41 42 42 43 43 42 42 42 42 44 45 45 44 44 44 44 44 45 45 45 45 46 45 45 46 47 47 47 46 47 47 47 47 47 47 47 47 47 48 48 47 47 47 46 46 46 46 46 46 47 46 45 45 45 45 46 46 45 45 44 44 44 44 44 44 44 43 43 42 43 43 43 43 43 42 42 42 42 42 42 42 42 41 41 41 42 43 42 41 41 40 40 40 41 41 41 40 39 39 39 40 40 41 40 39 39 39 40 39 39 40 39 39 39 39 39 40 40 39 39 39 38 38 39 39 39 39 39 38 39 39 40 40 40 39 38 38 39 40 39 39 40 40 39 38 39 40 40 39 39 39 38 38 39 39 39 39 38 38 39 39 39 40 39 39 38 38 38 39 39 39 40 39 38 38 40 40 40 39 39 39 39 39 39 40 40 39 38 37 37 37 38 38 39 40 39 38 39 39 39 39 39 39 39 38 38 38 39 40 39 39 38 38 38 39 39 39 39 38 38 39 39 39 39 39 39 38 38 38 39 39 39 39 38 38 38 39 39 39 39 39 39 38 38 39 39 39 40 39 39 39 39 39 40 39 39 39 38 39 40 40 40 40 39 38 39 40 40 40 40 40 40 40 39 40 40 41 40 40 40 39 39 40 40 40 40 40 40 40 40 40 40 40 40 38 39 40 40 40 41 40 40 39 39 40 40 40 40 40 39 39 40 39 40 41 40 40 39 39 39 40 40 40 39 39 39 39 39 39 40 39 39 39 38 38 39 40 40 40 40 39 39 40 40 41 41 41 41 41 41 41 41 41 42 42 41 41 41 41 42 42 42 42 42 42 42 43 43 42 42 42 42 42 42 43 42 42"
      }
    }
  ]
}

```
