# 臨床檢驗檢查 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Observation: 臨床檢驗檢查

Profile: [TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md)

**status**: Final

**category**: Exam

**code**: Capillary refill Time Nail Bed

**subject**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**encounter**: [Encounter: identifier = http://healthcare.example.org/identifiers/enocunter#E22081702; status = finished; class = pre-admission (ActCode#PRENC); type = Annual diabetes mellitus screening; serviceType = Nephrology (qualifier value); period = 2022-08-01 17:00:14+0800 --> 2022-08-01 18:00:14+0800; reasonCode = FH: Diabetes mellitus](Encounter-enc-example.md)

**effective**: 2021-11-10 16:48:57-0800

**value**: 1 s(Details: UCUM codes = 's')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "obs-clinical-result-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam",
          "display" : "Exam"
        }
      ],
      "text" : "Exam"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "44963-7"
      }
    ],
    "text" : "Capillary refill Time Nail Bed"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "encounter" : {
    "reference" : "Encounter/enc-example"
  },
  "effectiveDateTime" : "2021-11-10T16:48:57.246958-08:00",
  "valueQuantity" : {
    "value" : 1,
    "unit" : "s",
    "system" : "http://unitsofmeasure.org",
    "code" : "s"
  }
}

```
