# 近視的用藥聲明資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example MedicationStatement: 近視的用藥聲明資料

### 近視的用藥聲明資料

**用藥聲明的狀態**：Active ([Medication Status Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)#active)

**用藥聲明的分類**： Outpatient ([MedicationDispense Category Codes](http://hl7.org/fhir/R4/codesystem-medication-statement-category.html)#outpatient)

**藥品**：每瞳令-普益點眼液 ([臺灣食藥署藥品許可證](CodeSystem-medication-fda-tw.md)#衛署藥輸字第005728號)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**用藥的日期與時間**：2023-11-05T08:00:00

**提出聲明日期與時間**：2023-11-05T10:00:00

**聲明原因**：近視(Simple myopia) ([SNOMED CT](http://snomed.info/sct)#232133000)

> **藥品使用方式：****使用時間**：每日使用2次
**方式**：眼用(Ophthalmic use)([SNOMED CT](http://snomed.info/sct)#54485002)
**備註**：每日2次，每次1滴或1-2滴。



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "med-sta-drop-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore"
    ]
  },
  "status" : "active",
  "category" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medication-statement-category",
        "code" : "outpatient",
        "display" : "outpatient"
      }
    ],
    "text" : "門診"
  },
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw",
        "code" : "衛署藥輸字第005728號",
        "display" : "每瞳令-普益點眼液"
      }
    ],
    "text" : "每瞳令-普益點眼液"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "effectiveDateTime" : "2023-11-05T08:00:00+08:00",
  "dateAsserted" : "2023-11-05T10:00:00+08:00",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "232133000",
          "display" : "Simple myopia"
        }
      ],
      "text" : "近視"
    }
  ],
  "note" : [
    {
      "text" : "每日2次，每次1滴或1-2滴"
    }
  ],
  "dosage" : [
    {
      "text" : "每日2次，每次1滴或1-2滴",
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "54485002",
            "display" : "Ophthalmic use"
          }
        ],
        "text" : "眼用"
      }
    }
  ]
}

```
