# 爽胰達注射劑100單位+50微克藥品配藥資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example MedicationDispense: 爽胰達注射劑100單位+50微克藥品配藥資料

### 爽胰達注射劑100單位50微克藥品配藥資料

**配藥的狀態**：Completed ([MedicationDispense Status Codes](http://hl7.org/fhir/R4/codesystem-medicationdispense-status.html)#completed)

**配藥的分類**： Inpatient ([MedicationDispense Category Codes](http://hl7.org/fhir/R4/codesystem-medicationdispense-category.html)#inpatient)

**配藥的類型**：Daily Fill ([V3 Value SetActPharmacySupplyType](http://hl7.org/implement/standards/fhir/R4/v3/ActPharmacySupplyType/vs.html)#DF)

**藥品**：爽胰達注射劑100單位50微克 ([臺灣藥品許可證](CodeSystem-medication-fda-tw.md)#衛部菌疫輸字第001080號)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**就醫資料**：[Encounter/enc-example](Encounter-enc-example.md)

**配藥者**：[Practitioner/pra-phc-example](Practitioner-pra-phc-example.md) "陳耀詩"

> **配藥資料**：**藥品總劑量**：1 Intravenous Solution([OrderableDrugForm](http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm)#IVSOL)
**藥品天數**：3 days
**藥品使用方法**：每日注射一次，於餐前一小時內注射，建議固定在同一餐的餐前注射
**藥品包裝和審核時間**：2022-08-01T11:45:00
**藥品發放的時間**：2022-08-01T12:00:00

> **藥品替代資料**：**配藥是否與處方要求不同**：none([SubstanceAdminSubstitution](http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution)#N)
**替代原因**：formulary policy([ActReason](http://terminology.hl7.org/CodeSystem/v3-ActReason)#FP)



## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "med-dis-injection-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore"
    ]
  },
  "status" : "completed",
  "category" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/fhir/CodeSystem/medicationdispense-category",
        "code" : "inpatient"
      }
    ]
  },
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw",
        "code" : "衛部菌疫輸字第001080號",
        "display" : "爽胰達注射劑100單位+50微克"
      }
    ],
    "text" : "爽胰達注射劑100單位+50微克"
  },
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "context" : {
    "reference" : "Encounter/enc-example"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/pra-phc-example"
      }
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "code" : "DF",
        "display" : "Daily Fill"
      }
    ]
  },
  "quantity" : {
    "value" : 1,
    "unit" : "Intravenous Solution",
    "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
    "code" : "IVSOL"
  },
  "daysSupply" : {
    "value" : 3,
    "unit" : "days"
  },
  "whenPrepared" : "2022-08-01T11:45:00+08:00",
  "whenHandedOver" : "2022-08-01T12:00:00+08:00",
  "dosageInstruction" : [
    {
      "text" : "每日注射一次，於餐前一小時內注射，建議固定在同一餐的餐前注射",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d"
        }
      }
    }
  ],
  "substitution" : {
    "wasSubstituted" : false,
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution",
          "code" : "N",
          "display" : "none"
        }
      ]
    },
    "reason" : [
      {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
            "code" : "FP",
            "display" : "formulary policy"
          }
        ]
      }
    ]
  }
}

```
