# 明捷眼科診所地點資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Location: 明捷眼科診所地點資料

### 明捷眼科診所位置

**地點狀態**: Active ([LocationStatus](http://hl7.org/fhir/R4/codesystem-location-status.html)#active)

**地點類別**: Kind ([LocationMode](http://hl7.org/fhir/location-mode)#kind)

**地點類型**: Opthalmology clinic ([RoleCode](https://terminology.hl7.org/CodeSystem-v3-RoleCode.html)#OPH)

**地點資訊**: 專精於無痛白內障吸出術，及近視控制角膜塑型術。

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）

**聯絡電話（work）**：02-2276-7788

**地點開放時間**：週一 ～ 週五



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "loc-oph-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
    ]
  },
  "status" : "active",
  "name" : "明捷眼科診所",
  "description" : "專精於無痛白內障吸出術，及近視控制角膜塑型術",
  "mode" : "kind",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "OPH",
          "display" : "Opthalmology clinic"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "02-2276-7788",
      "use" : "work"
    }
  ],
  "hoursOfOperation" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
      "allDay" : false
    }
  ]
}

```
