# 衛生福利部臺北醫院急診室地點資料 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Location: 衛生福利部臺北醫院急診室地點資料

### 衛生福利部臺北醫院急診室位置

**地點狀態**: Active ([LocationStatus](http://hl7.org/fhir/R4/codesystem-location-status.html)#active)

**地點類別**: Kind ([LocationMode](http://hl7.org/fhir/location-mode)#kind)

**地點類型**: Emergency room ([RoleCode](https://terminology.hl7.org/CodeSystem-v3-RoleCode.html)#ER)

**地點資訊**: 24小時全年無休提供緊急醫療服務，醫護人員給予整體性、個別性之醫療照護服務。

**負責維護地點的機構**: [Organization/org-hosp-example](Organization-org-hosp-example.md) "衛生福利部臺北醫院"

**聯絡方式**：Phone（[ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html)#phone）

**聯絡電話（work）**：02-2276-5566

**聯絡地址（work）**：242新北市新莊區思源路127號

**地點開放時間**：週一 ～ 週五 ， 全天



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "loc-er-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
    ]
  },
  "status" : "active",
  "name" : "衛生福利部臺北醫院急診室",
  "description" : "24小時全年無休提供緊急醫療服務，醫護人員給予整體性、個別性之醫療照護服務。",
  "mode" : "kind",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "ER",
          "display" : "Emergency room"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "02-2276-5566",
      "use" : "work"
    }
  ],
  "address" : {
    "use" : "work",
    "type" : "both",
    "text" : "242新北市新莊區思源路127號",
    "line" : ["思源路127號"],
    "city" : "新莊區",
    "district" : "新北市",
    "postalCode" : "242"
  },
  "position" : {
    "longitude" : 25.043085494729105,
    "latitude" : 121.45941895179722
  },
  "managingOrganization" : {
    "reference" : "Organization/org-hosp-example"
  },
  "hoursOfOperation" : [
    {
      "daysOfWeek" : [
        "mon",
        "tue",
        "wed",
        "thu",
        "fri",
        "sat",
        "sun"
      ],
      "allDay" : true
    }
  ]
}

```
