# 疫苗接種 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Immunization: 疫苗接種

Profile: [TW Core Immunization](StructureDefinition-Immunization-twcore.md)

**status**: Completed

**vaccineCode**: Influenza, high-dose, quadrivalent, PF

**patient**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**encounter**: [Encounter: identifier = http://healthcare.example.org/identifiers/enocunter#E22081702; status = finished; class = pre-admission (ActCode#PRENC); type = Annual diabetes mellitus screening; serviceType = Nephrology (qualifier value); period = 2022-08-01 17:00:14+0800 --> 2022-08-01 18:00:14+0800; reasonCode = FH: Diabetes mellitus](Encounter-enc-example.md)

**occurrence**: 2020-11-19 12:46:57-0800

**primarySource**: false

**location**: [Location 衛生福利部臺北醫院耳鼻喉科](Location-loc-ent-example.md)



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "imm-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore"
    ]
  },
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/cvx",
        "code" : "197",
        "display" : "Influenza, high-dose, quadrivalent, PF"
      },
      {
        "system" : "http://hl7.org/fhir/sid/ndc",
        "code" : "49281012165",
        "display" : "FLUZONE High-Dose Quadrivalent Northern Hemisphere, 10 SYRINGE, GLASS in 1 PACKAGE (49281-121-65) > .7 mL in 1 SYRINGE, GLASS (49281-121-88) (package)"
      }
    ],
    "text" : "Influenza, high-dose, quadrivalent, PF"
  },
  "patient" : {
    "reference" : "Patient/pat-example"
  },
  "encounter" : {
    "reference" : "Encounter/enc-example"
  },
  "occurrenceDateTime" : "2020-11-19T12:46:57-08:00",
  "primarySource" : false,
  "location" : {
    "reference" : "Location/loc-ent-example"
  }
}

```
