# Positron emission tomography - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example ImagingStudy: Positron emission tomography

### Positron emission tomography

**識別碼(official)**：urn:oid:2.16.886.103.102695.312603252934799756197864329946
**識別碼(usual)**：a142485449496602a142485449496602

**狀態**：Available([ImagingStudyStatus](http://hl7.org/fhir/R4/valueset-imagingstudy-status.html)#available)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**檢查開始日期與時間**：1996-05-14T12:56:26+08:00

**影像描述**：PET WB & reg Restag Hd & Nck Ca

> **系列(series)實例**：**DICOM系列實例UID**：2.16.886.103.102695.308323898107272214360495873340
**數字識別碼**： 607
**所使用的成像儀器**： Positron emission tomography([CID 29 Acquisition Modality](http://dicom.nema.org/resources/ontology/DCM)#PT)
**摘要**：CORONALS [MPR Range]
**身體部位**：HEADNECK
> **SOP實例(1)**：**UID**：2.16.886.103.102695.204472109808701101171643476459
**DICOM class 類型**： urn:oid:1.2.840.10008.5.1.4.1.1.128
**序號**： 1
**實例的描述**： DERIVED&SECONDARY&OTHER&CSA MPR&CSAMANIPULATED

> **SOP實例(2)**：**UID**：2.16.886.103.102695.211371491775300429718822081671
**DICOM class 類型**： urn:oid:1.2.840.10008.5.1.4.1.1.2
**序號**： 2
**實例的描述**： DERIVED&SECONDARY&LOCALIZER&CT_SOM5 TOP&CSA RESAMPLED

> **SOP實例(3)**：**UID**：2.16.886.103.102695.157108816098836770904535991652
**DICOM class 類型**： urn:oid:1.2.840.10008.5.1.4.1.1.2
**序號**： 3
**實例的描述**：ORIGINAL&PRIMARY&AXIAL&CT_SOM5 SPI




## Resource Content

```json
{
  "resourceType" : "ImagingStudy",
  "id" : "img-pet-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "system" : "urn:dicom:uid",
      "value" : "urn:oid:2.16.886.103.102695.312603252934799756197864329946"
    },
    {
      "use" : "usual",
      "value" : "a142485449496602"
    }
  ],
  "status" : "available",
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "started" : "1996-05-14T12:56:26+08:00",
  "description" : "PET WB/reg Restag Hd/Nck Ca",
  "series" : [
    {
      "uid" : "2.16.886.103.102695.308323898107272214360495873340",
      "number" : 607,
      "modality" : {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "code" : "PT"
      },
      "description" : "CORONALS [MPR Range]",
      "bodySite" : {
        "display" : "HEADNECK"
      },
      "instance" : [
        {
          "uid" : "2.16.886.103.102695.204472109808701101171643476459",
          "sopClass" : {
            "system" : "urn:ietf:rfc:3986",
            "code" : "urn:oid:1.2.840.10008.5.1.4.1.1.128"
          },
          "number" : 1,
          "title" : "DERIVED\\SECONDARY\\OTHER\\CSA MPR\\CSAMANIPULATED"
        }
      ]
    }
  ]
}

```
