# 植入式裝置 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Device: 植入式裝置

Profile: [TW Core Implantable Device](StructureDefinition-Device-twcore.md)

### UdiCarriers

| | | |
| :--- | :--- | :--- |
| - | **DeviceIdentifier** | **CarrierHRF** |
| * | 09504000059118 | (01)09504000059118(17)141120(10)7654321D(21)10987654d321 |

**status**: Active

**expirationDate**: 2014-11-20

**lotNumber**: 7654321D

**serialNumber**: 10987654d321

**type**: Coated femoral stem prosthesis, modular

**patient**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "dev-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore"
    ]
  },
  "udiCarrier" : [
    {
      "deviceIdentifier" : "09504000059118",
      "carrierHRF" : "(01)09504000059118(17)141120(10)7654321D(21)10987654d321"
    }
  ],
  "status" : "active",
  "expirationDate" : "2014-11-20",
  "lotNumber" : "7654321D",
  "serialNumber" : "10987654d321",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "468063009",
        "display" : "Coated femoral stem prosthesis, modular"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/pat-example"
  }
}

```
