# 給付範圍 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Coverage: 給付範圍

Profile: [TW Core Coverage](StructureDefinition-Coverage-twcore.md)

**identifier**: Member Number/88800933501

**status**: Active

**type**: PPO

**subscriberId**: 888009335

**beneficiary**: [陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))](Patient-pat-example.md)

**relationship**: Self

**period**: 2020-01-01 --> (ongoing)

**payor**: [Organization 莉梓股份有限公司](Organization-org-co-example.md)

> **class****type**:An employee group**value**: xyz**name**: XYZ employee Group Plan

> **class****type**:A specific suite of benefits.**value**: gold**name**: Acme Gold Plan



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "coverage-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coverage-twcore"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MB",
            "display" : "Member Number"
          }
        ]
      },
      "system" : "http://example.org/fhir/memberidentifier",
      "value" : "88800933501"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "https://nahdo.org/sopt",
        "code" : "3712",
        "display" : "PPO"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "code" : "PPO",
        "display" : "preferred provider organization policy"
      }
    ],
    "text" : "PPO"
  },
  "subscriberId" : "888009335",
  "beneficiary" : {
    "reference" : "Patient/pat-example"
  },
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self"
      }
    ],
    "text" : "Self"
  },
  "period" : {
    "start" : "2020-01-01"
  },
  "payor" : [
    {
      "reference" : "Organization/org-co-example"
    }
  ],
  "class" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "group",
            "display" : "Group"
          }
        ],
        "text" : "An employee group"
      },
      "value" : "xyz",
      "name" : "XYZ employee Group Plan"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "plan",
            "display" : "Plan"
          }
        ],
        "text" : "A specific suite of benefits."
      },
      "value" : "gold",
      "name" : "Acme Gold Plan"
    }
  ]
}

```
