# 臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ConceptMap: 臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ConceptMap/medication-frequency-tw | *Version*:0.3.0 |
| Active as of 2024-01-16 | *Computable Name*:TWHealthProfessional |

 
此對應表為臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation，供實作者於撰寫程式以自動化對應或轉代碼時使用。 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "medication-frequency-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ConceptMap/medication-frequency-tw",
  "version" : "0.3.0",
  "name" : "TWHealthProfessional",
  "title" : "臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-16",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此對應表為臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation，供實作者於撰寫程式以自動化對應或轉代碼時使用。",
  "sourceUri" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-frequency-nhi-tw",
  "targetUri" : "http://hl7.org/fhir/ValueSet/timing-abbreviation",
  "group" : [
    {
      "source" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-frequency-nhi-tw",
      "target" : "http://terminology.hl7.org/CodeSystem/v3-GTSAbbreviation",
      "element" : [
        {
          "code" : "QOD",
          "display" : "隔日使用一次",
          "target" : [
            {
              "code" : "QOD",
              "display" : "QOD",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "QW",
          "display" : "每週一次",
          "target" : [
            {
              "code" : "WK",
              "display" : "weekly",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "QD",
          "display" : "每日一次",
          "target" : [
            {
              "code" : "QD",
              "display" : "QD",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "QDAM",
          "display" : "每日一次上午使用",
          "target" : [
            {
              "code" : "AM",
              "display" : "AM",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "QDPM",
          "display" : "每日一次下午使用",
          "target" : [
            {
              "code" : "PM",
              "display" : "PM",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "QDHS",
          "display" : "每日一次睡前使用",
          "target" : [
            {
              "code" : "BED",
              "display" : "at bedtime",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "BID",
          "display" : "每日二次",
          "target" : [
            {
              "code" : "BID",
              "display" : "BID",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "QID",
          "display" : "每日四次",
          "target" : [
            {
              "code" : "QID",
              "display" : "QID",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HS",
          "display" : "睡前一次",
          "target" : [
            {
              "code" : "BED",
              "display" : "at bedtime",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    }
  ]
}

```
