# 臺灣戶政司婚姻狀態代碼對應HL7 MaritalStatus - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ConceptMap: 臺灣戶政司婚姻狀態代碼對應HL7 MaritalStatus 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ConceptMap/marital-status-tw | *Version*:0.3.0 |
| Active as of 2023-08-25 | *Computable Name*:TWMaritalStatus |

 
此對應表為臺灣戶政司婚姻狀態代碼對應至國際標準碼HL7 MaritalStatus，供實作者於撰寫程式以自動化對應或轉代碼時使用。 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "marital-status-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ConceptMap/marital-status-tw",
  "version" : "0.3.0",
  "name" : "TWMaritalStatus",
  "title" : "臺灣戶政司婚姻狀態代碼對應HL7 MaritalStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-08-25",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此對應表為臺灣戶政司婚姻狀態代碼對應至國際標準碼HL7 MaritalStatus，供實作者於撰寫程式以自動化對應或轉代碼時使用。",
  "sourceUri" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/marital-status-tw",
  "targetUri" : "http://hl7.org/fhir/ValueSet/marital-status",
  "group" : [
    {
      "source" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/marital-status-tw",
      "target" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
      "element" : [
        {
          "code" : "1",
          "display" : "未婚",
          "target" : [
            {
              "code" : "U",
              "display" : "unmarried",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2",
          "display" : "有偶",
          "target" : [
            {
              "code" : "M",
              "display" : "Married",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "3",
          "display" : "離婚",
          "target" : [
            {
              "code" : "D",
              "display" : "Divorced",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "4",
          "display" : "喪偶",
          "target" : [
            {
              "code" : "W",
              "display" : "Widowed",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "5",
          "display" : "婚姻關係消滅",
          "target" : [
            {
              "code" : "A",
              "display" : "Annulled",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "6",
          "display" : "有偶（施行法）",
          "target" : [
            {
              "code" : "M",
              "display" : "Married",
              "equivalence" : "subsumes"
            }
          ]
        },
        {
          "code" : "7",
          "display" : "終止結婚（施行法）",
          "target" : [
            {
              "code" : "D",
              "display" : "Divorced",
              "equivalence" : "subsumes"
            }
          ]
        },
        {
          "code" : "8",
          "display" : "喪偶（施行法）",
          "target" : [
            {
              "code" : "W",
              "display" : "Widowed",
              "equivalence" : "subsumes"
            }
          ]
        },
        {
          "code" : "9",
          "display" : "婚姻關係消滅（施行法）",
          "target" : [
            {
              "code" : "A",
              "display" : "Annulled",
              "equivalence" : "subsumes"
            }
          ]
        }
      ]
    }
  ]
}

```
