# 手術摘要報告 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Composition: 手術摘要報告

### 手術摘要報告

**臨床狀態**：Final ([CompositionStatus](http://hl7.org/fhir/composition-status)#final)

**種類**：Medical records ([LOINC](http://loinc.org)#11503-0)

**分類**：Surgical operation note ([LOINC](http://loinc.org)#11504-8)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**編輯時間**：2023-11-05T14:45:00

**報告創建者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**根據特定技術領域的定義**：normal ([v3 Code System Confidentiality](http://terminology.hl7.org/CodeSystem/v3-Confidentiality/)#N)

**證明準確性**：

> **認證者提供的認證類型**：Personal([CompositionAttestationMode](http://hl7.org/fhir/composition-attestation-mode/)#personal)**被證明的時間**：2023-11-05T15:30:00**負責證明的人員**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md)"王依昇"**負責維護機構**：[Organization/org-hosp-example](Organization-org-hosp-example.md)"衛生福利部臺北醫院"

**正在記錄的臨床服務**：

> **被記錄的主要臨床行為代碼**：Surgical([ActCode](http://terminology.hl7.org/CodeSystem/v3-ActCode/)#SURG)**文件所涵蓋的時間區間**：2023-11-05T12:00:00 ～ 2023-11-05T16:00:00

**報告小節內容：** [Procedure/pro-appendectomy-example](Procedure-pro-appendectomy-example.md)



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "com-surgery-example",
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11503-0",
        "display" : "Medical records"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "11504-8"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "date" : "2023-11-05T14:45:00Z",
  "author" : [
    {
      "reference" : "Practitioner/pra-dr-example",
      "display" : "王依昇"
    }
  ],
  "title" : "手術摘要報告",
  "confidentiality" : "N",
  "attester" : [
    {
      "mode" : "personal",
      "time" : "2023-11-05T15:30:00Z",
      "party" : {
        "reference" : "Practitioner/pra-dr-example",
        "display" : "王依昇"
      }
    }
  ],
  "custodian" : {
    "reference" : "Organization/org-hosp-example",
    "display" : "衛生福利部臺北醫院"
  },
  "event" : [
    {
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
              "code" : "SURG",
              "display" : "Surgical"
            }
          ]
        }
      ],
      "period" : {
        "start" : "2023-11-05T12:00:00Z",
        "end" : "2023-11-05T16:00:00Z"
      }
    }
  ],
  "section" : [
    {
      "entry" : [
        {
          "reference" : "Procedure/pro-appendectomy-example"
        }
      ]
    }
  ]
}

```
