# 陳加玲的病摘 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Composition: 陳加玲的病摘

### 陳加玲的病摘

**臨床狀態**：Final ([CompositionStatus](http://hl7.org/fhir/composition-status)#final)

**種類**：Medical records ([LOINC](http://loinc.org)#11503-0)

**分類**： Hospital Admission history and physical note ([LOINC](http://loinc.org)#47039-3)

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**編輯時間**：2023-09-10T10:30:00

**病摘創建者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**根據特定技術領域的定義**：restricted ([v3 Code System Confidentiality](http://terminology.hl7.org/CodeSystem/v3-Confidentiality/)#R)

**證明準確性**：

> **認證者提供的認證類型**：Personal([CompositionAttestationMode](http://hl7.org/fhir/composition-attestation-mode/)#personal)**被證明的時間**：2023-09-10T11:00:00**負責證明的人員**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md)"王依昇"**負責維護機構**：[Organization/org-hosp-example](Organization-org-hosp-example.md)"衛生福利部臺北醫院"

**正在記錄的臨床服務**：

> **被記錄的主要臨床行為代碼**：medication list([ActCode](http://terminology.hl7.org/CodeSystem/v3-ActCode/)#MEDLIST)**文件所涵蓋的時間區間**：2023-09-10T08:00:00 ～ 2023-09-15T09:30:00

**病摘小節內容：**

> **section.entry[Observation]**：[Observation/obs-bloodPressure-example](Observation-obs-bloodPressure-example.md)**section.entry[Practitioner]**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md)**section.entry[MedicationRequest]**：[MedicationRequest/med-req-cod-example](MedicationRequest-med-req-cod-example.md)



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "com-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore"
    ]
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11503-0",
        "display" : "Medical records"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "47039-3"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/pat-example"
  },
  "date" : "2023-09-10T10:30:00Z",
  "author" : [
    {
      "reference" : "Practitioner/pra-dr-example"
    }
  ],
  "title" : "陳加玲的病摘",
  "confidentiality" : "R",
  "attester" : [
    {
      "mode" : "personal",
      "time" : "2023-09-10T11:00:00Z",
      "party" : {
        "reference" : "Practitioner/pra-dr-example"
      }
    }
  ],
  "custodian" : {
    "reference" : "Organization/org-hosp-example"
  },
  "event" : [
    {
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
              "code" : "MEDLIST",
              "display" : "medication list"
            }
          ]
        }
      ],
      "period" : {
        "start" : "2023-09-10T08:00:00Z",
        "end" : "2023-09-15T09:30:00Z"
      }
    }
  ],
  "section" : [
    {
      "entry" : [
        {
          "reference" : "Practitioner/pra-dr-example"
        },
        {
          "reference" : "Observation/obs-bloodPressure-example"
        },
        {
          "reference" : "MedicationRequest/med-req-cod-example"
        }
      ]
    }
  ]
}

```
