# 臺灣中華郵政5碼郵遞區號 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣中華郵政5碼郵遞區號 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code5-tw | *Version*:2022-06-21 |
| Active as of 2022-06-21 | *Computable Name*:TWPostalCode5 |
| **Copyright/Legal**: 中華郵政 | |

 
臺灣中華郵政5碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。
代碼出版日期：2022-06-21；資料所屬單位：中華郵政。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWPostalCode5](ValueSet-postal-code5-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "postal-code5-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code5-tw",
  "version" : "2022-06-21",
  "name" : "TWPostalCode5",
  "title" : "臺灣中華郵政5碼郵遞區號",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-06-21",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣中華郵政5碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。  \n代碼出版日期：2022-06-21；資料所屬單位：中華郵政。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱\n\n",
  "copyright" : "中華郵政",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "property" : [
    {
      "code" : "city",
      "description" : "鄉鎮市區",
      "type" : "string"
    },
    {
      "code" : "district",
      "description" : "縣市名稱",
      "type" : "string"
    },
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "10001",
      "display" : "臺北市中正區中山南路",
      "definition" : "臺北市中正區中山南路20號",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-06-21"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10002",
      "display" : "臺北市中正區中山南路",
      "definition" : "臺北市中正區中山南路7號",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-06-21"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10005",
      "display" : "臺北市中正區重慶南路1段",
      "definition" : "臺北市中正區重慶南路1段30號",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-06-21"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10006",
      "display" : "臺北市中正區重慶南路1段",
      "definition" : "臺北市中正區重慶南路1段38號",
      "property" : [
        {
          "code" : "district",
          "valueString" : "臺北市"
        },
        {
          "code" : "city",
          "valueString" : "中正區"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-06-21"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
