# 臺灣醫事司醫事機構代碼 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣醫事司醫事機構代碼 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw | *Version*:2024-08-19 |
| Active as of 2024-08-19 | *Computable Name*:TWOrganizationIdentifier |
| **Copyright/Legal**: 衛生福利部醫事司 | |

 
臺灣醫事司醫事機構代碼，參照至[衛生福利部醫事司](https://dep.mohw.gov.tw/DOMA/cp-4926-54415-106.html)的[醫療機構與人員基本資料20231231.csv](https://www.mohw.gov.tw/dl-87760-1a0f2eab-c96a-4839-950d-beb93d903b6f.html)
[醫事機構代碼查詢系統](https://rao.mohw.gov.tw/AgencyCode.aspx?FD1=txtAgency_qry&FD2=txtAgencyName_qry)代碼出版日期：2020-06-11；資料所屬單位：衛生福利部醫事司。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWOrganizationIdentifier](ValueSet-organization-identifier-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "organization-identifier-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw",
  "version" : "2024-08-19",
  "name" : "TWOrganizationIdentifier",
  "title" : "臺灣醫事司醫事機構代碼",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-08-19",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣醫事司醫事機構代碼，參照至[衛生福利部醫事司](https://dep.mohw.gov.tw/DOMA/cp-4926-54415-106.html)的[醫療機構與人員基本資料20231231.csv](https://www.mohw.gov.tw/dl-87760-1a0f2eab-c96a-4839-950d-beb93d903b6f.html)  \n[醫事機構代碼查詢系統](https://rao.mohw.gov.tw/AgencyCode.aspx?FD1=txtAgency_qry&FD2=txtAgencyName_qry)\n代碼出版日期：2020-06-11；資料所屬單位：衛生福利部醫事司。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱\n",
  "copyright" : "衛生福利部醫事司",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 50,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    },
    {
      "code" : "address",
      "description" : "地址",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "3701014247",
      "display" : "大衛牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區富錦街527號1樓"
        }
      ]
    },
    {
      "code" : "2701010024",
      "display" : "交通部民用航空局航空醫務中心",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區敦化北路405巷123弄10號"
        }
      ]
    },
    {
      "code" : "3801012567",
      "display" : "漢浤堂健康中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民生東路四段128號"
        }
      ]
    },
    {
      "code" : "3701010061",
      "display" : "政雄牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民生東路五段２４３號"
        }
      ]
    },
    {
      "code" : "3801012692",
      "display" : "春日和中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區復興北路81巷35號1樓"
        }
      ]
    },
    {
      "code" : "3701014238",
      "display" : "嘉一牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區新東街11巷3號1樓"
        }
      ]
    },
    {
      "code" : "3701014327",
      "display" : "松新牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路4段687號2樓及689號2樓"
        }
      ]
    },
    {
      "code" : "3701014309",
      "display" : "鉑金牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路3段164號1樓、164之1號(1樓)"
        }
      ]
    },
    {
      "code" : "3501015357",
      "display" : "髮立現診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民生東路3段113巷6弄3號1樓"
        }
      ]
    },
    {
      "code" : "3501015348",
      "display" : "恆美學診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路4段56號2樓"
        }
      ]
    },
    {
      "code" : "3801012709",
      "display" : "爾雅中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區慶城街24號5樓"
        }
      ]
    },
    {
      "code" : "3501015302",
      "display" : "瑞麗嘉健康美學慶中診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路3段259號5樓"
        }
      ]
    },
    {
      "code" : "3501015491",
      "display" : "蘭瑞診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區敦化南路1段25號3樓"
        }
      ]
    },
    {
      "code" : "3501015339",
      "display" : "麥茵茲美形診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路5段71號2樓之3、2樓之4及3樓之5"
        }
      ]
    },
    {
      "code" : "3801012727",
      "display" : "欣百漢中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路5段80號1、2、3樓"
        }
      ]
    },
    {
      "code" : "3501015384",
      "display" : "南京小岩井診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路3段303巷8弄6號1樓"
        }
      ]
    },
    {
      "code" : "3701014283",
      "display" : "大友牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區撫遠街350之1號(1樓)"
        }
      ]
    },
    {
      "code" : "3701014256",
      "display" : "佳斯緹牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民生東路3段113巷6弄5號1樓"
        }
      ]
    },
    {
      "code" : "3501015428",
      "display" : "佳利安診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路3段305號8樓"
        }
      ]
    },
    {
      "code" : "3501015473",
      "display" : "守葳診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路3段256巷46號1、2樓"
        }
      ]
    },
    {
      "code" : "3501015419",
      "display" : "嬌妮美診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路5段3號9樓"
        }
      ]
    },
    {
      "code" : "3501015133",
      "display" : "弘宇診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民權東路3段160巷2之6號(1樓)"
        }
      ]
    },
    {
      "code" : "3501015508",
      "display" : "君綺國際診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區敦化南路1段25號2樓"
        }
      ]
    },
    {
      "code" : "3501015375",
      "display" : "佳思優醫美整形診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區敦化北路8號1樓(1、2層)"
        }
      ]
    },
    {
      "code" : "3701014292",
      "display" : "勤美民生牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民生東路5段58號1樓"
        }
      ]
    },
    {
      "code" : "3701014210",
      "display" : "怡德牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路4段226號(1樓)"
        }
      ]
    },
    {
      "code" : "3501015535",
      "display" : "韓后國際健康醫美診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區復興北路69號10樓"
        }
      ]
    },
    {
      "code" : "3701014185",
      "display" : "誠楷牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區敦化南路1段7號3樓"
        }
      ]
    },
    {
      "code" : "3501015240",
      "display" : "宥全診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民生東路5段216號1樓"
        }
      ]
    },
    {
      "code" : "3501010870",
      "display" : "余內科診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路四段６４６號"
        }
      ]
    },
    {
      "code" : "3501010852",
      "display" : "周玄文診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民權東路三段１６０巷１９弄６號"
        }
      ]
    },
    {
      "code" : "3801012674",
      "display" : "渼生堂中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路3段138號(1、2樓)"
        }
      ]
    },
    {
      "code" : "3701013544",
      "display" : "微風牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區復興南路1段51號2樓"
        }
      ]
    },
    {
      "code" : "3701014265",
      "display" : "博飛迅牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路4段666號7樓之2"
        }
      ]
    },
    {
      "code" : "3701011817",
      "display" : "饒河牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區塔悠路１３號"
        }
      ]
    },
    {
      "code" : "3501015393",
      "display" : "微醫未來美學診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路5段166、168號11樓"
        }
      ]
    },
    {
      "code" : "3501015455",
      "display" : "宸曜診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區敦化北路155巷8號1、2樓"
        }
      ]
    },
    {
      "code" : "3501015142",
      "display" : "佑達骨科診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路4段95號1樓"
        }
      ]
    },
    {
      "code" : "3501013040",
      "display" : "安禾聯合診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區民權東路三段一七八號三樓"
        }
      ]
    },
    {
      "code" : "3801012496",
      "display" : "皇脈中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路四段245巷29號"
        }
      ]
    },
    {
      "code" : "3501015035",
      "display" : "安兒康小兒專科診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區敦化北路116號、118號、118號2樓"
        }
      ]
    },
    {
      "code" : "3701010829",
      "display" : "生春牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區南京東路五段139號"
        }
      ]
    },
    {
      "code" : "3701010776",
      "display" : "固榮牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區延吉街１６號"
        }
      ]
    },
    {
      "code" : "3801010287",
      "display" : "國晉中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區光復南路６巷４６號"
        }
      ]
    },
    {
      "code" : "3701011997",
      "display" : "群益牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區光復北路１２３號１樓"
        }
      ]
    },
    {
      "code" : "3701011086",
      "display" : "慶華牙醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區延吉街１０巷８號"
        }
      ]
    },
    {
      "code" : "3801012049",
      "display" : "仲佑中醫診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路三段２12號１樓"
        }
      ]
    },
    {
      "code" : "3501014270",
      "display" : "生昇復健專科診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區三民路39號"
        }
      ]
    },
    {
      "code" : "3501010058",
      "display" : "林聰賢婦產科診所",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "臺北市松山區八德路四段３４５號２Ｆ"
        }
      ]
    },
    {
      "code" : "0131060029",
      "display" : "衛生福利部臺北醫院",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-08-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "address",
          "valueString" : "新北市新莊區思源路127號、長青街6號2樓、3樓"
        }
      ]
    }
  ]
}

```
