# 臺灣健保署給藥途徑 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署給藥途徑 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw | *Version*:2024-06-04 |
| Active as of 2022-08-02 | *Computable Name*:TWMedicationPath |
| **Copyright/Legal**: 衛生福利部中央健康保險署 | |

 
臺灣健保署給藥途徑，[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「給藥途徑/作用部位（2022/8/2版本）」。 
代碼出版日期：2024-06-04；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWMedicationPathSCT](ValueSet-medication-path-sct-tw.md)
* [TWMedicationPath](ValueSet-medication-path-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medication-path-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw",
  "version" : "2024-06-04",
  "name" : "TWMedicationPath",
  "title" : "臺灣健保署給藥途徑",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-08-02",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署給藥途徑，[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「給藥途徑/作用部位（2022/8/2版本）」。  \n\n代碼出版日期：2024-06-04；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
  "copyright" : "衛生福利部中央健康保險署",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 42,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AD",
      "display" : "右耳",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AS",
      "display" : "左耳",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AU",
      "display" : "每耳",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "ET",
      "display" : "氣內切",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "GAR",
      "display" : "潄口用",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "HD",
      "display" : "皮下灌注",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IA",
      "display" : "動脈注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "ICV",
      "display" : "腦室注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "ID",
      "display" : "皮內注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IE",
      "display" : "脊髓硬膜內治射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "肌肉注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IMP",
      "display" : "植入",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "INHL",
      "display" : "吸入",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IP",
      "display" : "腹腔注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IPLE",
      "display" : "胸膜內注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IS",
      "display" : "滑膜內注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IT",
      "display" : "椎骨內注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IV",
      "display" : "靜脈注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IVA",
      "display" : "靜脈添加",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IVD",
      "display" : "靜脈點滴滴入",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IVI",
      "display" : "玻璃体內注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IVP",
      "display" : "靜脈注入",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "LA",
      "display" : "局部麻醉",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "局部注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "NA",
      "display" : "鼻用",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "OD",
      "display" : "右眼",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "ORO",
      "display" : "口咽直接用藥(如噴劑、塗抹)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "OS",
      "display" : "左眼",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "OU",
      "display" : "每眼",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "PO",
      "display" : "口服",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "皮下注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "SCI",
      "display" : "結膜下注射",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "SKIN",
      "display" : "皮膚用",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "SL",
      "display" : "舌下",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "SPI",
      "display" : "脊髓",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "RECT",
      "display" : "肛門用",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "TOPI",
      "display" : "局部塗擦(與LA易混淆)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "TPN",
      "display" : "全靜脈營養劑",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "VAG",
      "display" : "陰道用",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "IRRIG",
      "display" : "沖洗(irrigation)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "EXT",
      "display" : "外用",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        }
      ]
    },
    {
      "code" : "XX",
      "display" : "其他",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-02"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
