# 臺灣健保署用藥品項 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署用藥品項 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-nhi-tw | *Version*:2025-04-30 |
| Active as of 2025-04-30 | *Computable Name*:TWMedicationNHI |
| **Copyright/Legal**: 衛生福利部中央健康保險署 | |

 
臺灣健保署用藥品項代碼，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年5月查詢檔(帶走所有壓縮檔114.4.30更新)」。 
代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWMedicationNHI](ValueSet-medication-nhi-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medication-nhi-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-nhi-tw",
  "version" : "2025-04-30",
  "name" : "TWMedicationNHI",
  "title" : "臺灣健保署用藥品項",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-04-30",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署用藥品項代碼，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年5月查詢檔(帶走所有壓縮檔114.4.30更新)」。  \n\n代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*  \n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱",
  "copyright" : "衛生福利部中央健康保險署",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 35,
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    },
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A000015421",
      "display" : "YEN KUANG EYE DROPS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000015435",
      "display" : "YEN KUANG EYE DROPS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000023100",
      "display" : "NYDRAZID TABLETS 100MG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000026157",
      "display" : "VI-GRANS LIQUID",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000058172",
      "display" : "MEWEILY GRANULES \"TOLIN\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000058199",
      "display" : "MEWEILY GRANULES \"TOLIN\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000059100",
      "display" : "Diapin Tablets 2mg (Diazepam) \"Pine Lawer\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A0000591G0",
      "display" : "Diapin Tablets 2mg (Diazepam) \"Pine Lawer\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000060100",
      "display" : "DIAPIN TABLETS 5MG (DIAZEPAM) \"PINE LAWER\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A0000601G0",
      "display" : "Diapin Tablets 5mg (Diazepam) \"Pine Lawer\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000072100",
      "display" : "EPHEDRINE HCL TABLETS 25MG \"H.S.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000076100",
      "display" : "ACETAMINOPHEN TABLETS 0.3 GM \"F.Y.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000080277",
      "display" : "KEFLODIN INJECTION 0.5GM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000081100",
      "display" : "TETRACIN CAPSULES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000085100",
      "display" : "KESONTON CAPSULES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000086100",
      "display" : "SINOMIN TABLETS 500 MG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000090100",
      "display" : "FISHERMAN STRONG LIVER OIL CAPSULES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000096100",
      "display" : "MENNA CAPSULES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000098100",
      "display" : "EACO-15MG S.C. TABLETS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000106100",
      "display" : "ERYTHROMYCIN CAPSULES 250MG \"SYNMOSA\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000111100",
      "display" : "ESTRIOL TABLETS \"HONTEN\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000118100",
      "display" : "EPHEDRINE HCL TABLETS 25 MG \"F.Y.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A0001181G0",
      "display" : "EPHEDRINE HCL TABLETS 25 MG \"F.Y.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000119100",
      "display" : "DL-METHYLEPHEDRINE HCL TABLETS 25.MG \"F.Y.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A0001191G0",
      "display" : "DL-METHYLEPHEDRINE HCL TABLETS 25.MG \"F.Y.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000133209",
      "display" : "PROLUTON DEPOT INJECTION 250 MG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000134209",
      "display" : "TESTOVIRON DEPOT INJECTION 100 MG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000135321",
      "display" : "ULTRALANUM OINTMENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000135329",
      "display" : "ULTRALANUM OINTMENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000137151",
      "display" : "BROWN MIXTURE LIQUID (WITHOUT OPIUM)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000138209",
      "display" : "TESTOVIRON DEPOT INJECTION 250 MG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000152100",
      "display" : "PUCOPIN TABLETS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000164100",
      "display" : "NITROGLYCERIN TABLETS \"NYSCO\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A000173100",
      "display" : "FUDECOUGH TABLETS 15MG \"F.Y.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        }
      ]
    },
    {
      "code" : "A003092100",
      "display" : "ASPIRIN TABLETS 500MG",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2018-06-24"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
