# 臺灣食藥署藥品許可證 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣食藥署藥品許可證 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw | *Version*:2024-06-20 |
| Active as of 2024-06-20 | *Computable Name*:TWMedicationFDA |
| **Copyright/Legal**: 衛生福利部食品藥物管理署 | |

 
臺灣食藥署藥品許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36)
代碼出版日期：2022-08-03-03；資料所屬單位：衛生福利部食品藥物管理署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWMedicationFDA](ValueSet-medication-fda-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medication-fda-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw",
  "version" : "2024-06-20",
  "name" : "TWMedicationFDA",
  "title" : "臺灣食藥署藥品許可證",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-06-20",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣食藥署藥品許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36)  \n代碼出版日期：2022-08-03-03；資料所屬單位：衛生福利部食品藥物管理署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱",
  "copyright" : "衛生福利部食品藥物管理署",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 34,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "內衛成製字第000012號",
      "display" : "皮癢濕軟膏",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000029號",
      "display" : "均隆號百中驅風油",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000030號",
      "display" : "司寧軟膏",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000038號",
      "display" : "紫藥水1%",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000039號",
      "display" : "黃藥水0.2%",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000040號",
      "display" : "雙氧水3%",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000041號",
      "display" : "美麗沙而",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000042號",
      "display" : "紅藥水2%",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000043號",
      "display" : "稀碘酒",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000044號",
      "display" : "複方煤溜油酚溶液\"洸洋\"",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000049號",
      "display" : "美克沙而",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000050號",
      "display" : "帆船牌消毒水",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-06"
        },
        {
          "code" : "status",
          "valueCode" : "停用"
        }
      ]
    },
    {
      "code" : "內衛成製字第000053號",
      "display" : "新阿斯美膠囊",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000061號",
      "display" : "撒隆巴斯",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000062號",
      "display" : "煤溜油酚肥皂液",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000075號",
      "display" : "\"福元\"蘇打錠500毫克",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-06"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000076號",
      "display" : "佳朗敏擦劑",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000077號",
      "display" : "魚石脂軟膏",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000078號",
      "display" : "\"洸洋\"氧化鋅軟膏",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000080號",
      "display" : "硫軟膏",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000083號",
      "display" : "阿克里諾兒錠(外用)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000093號",
      "display" : "\"美\"利風油",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000103號",
      "display" : "癬克伏外用液",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000104號",
      "display" : "康得能口服液",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000107號",
      "display" : "雙氧水",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000112號",
      "display" : "\"黃氏\"皇船牌胃散",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000114號",
      "display" : "皮樂軟膏",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000115號",
      "display" : "癬能藥水",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000122號",
      "display" : "驅蟲錠",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛成製字第000133號",
      "display" : "消健糖衣錠",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛署藥輸字第025485號",
      "display" : "阿立批挫",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛署藥輸字第005728號",
      "display" : "每瞳令-普益點眼液",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "內衛藥製字第006008號",
      "display" : "鹽酸四環素眼藥膏",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "衛部菌疫輸字第001080號",
      "display" : "爽胰達注射劑100單位+50微克",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-08-03"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
