# 臺灣健保署醫療服務給付項目 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署醫療服務給付項目 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw | *Version*:2024-11-29 |
| Active as of 2024-11-29 | *Computable Name*:TWMedicalServicePayment |
| **Copyright/Legal**: 衛生福利部中央健康保險署 | |

 
臺灣健保署醫療服務給付項目，參照至[全民健康保險醫療服務給付項目及支付標準](https://www.nhi.gov.tw/ch/cp-5943-f1cce-2821-1.html)中的「醫療服務給付項目(113.05.01生效) (113.04.23更新)」。 
代碼出版日期：2022-07-01；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「生效日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWLaboratoryCategory](ValueSet-laboratory-category-tw.md)
* [TWMedicalServicePayment](ValueSet-procedure-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medical-service-payment-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
  "version" : "2024-11-29",
  "name" : "TWMedicalServicePayment",
  "title" : "臺灣健保署醫療服務給付項目",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-11-29",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署醫療服務給付項目，參照至[全民健康保險醫療服務給付項目及支付標準](https://www.nhi.gov.tw/ch/cp-5943-f1cce-2821-1.html)中的「醫療服務給付項目(113.05.01生效) (113.04.23更新)」。  \n\n代碼出版日期：2022-07-01；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「生效日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱\n\n",
  "copyright" : "衛生福利部中央健康保險署",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 5899,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "00101B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)2.地區醫院(1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00102B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)2.地區醫院(3)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00105B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)3.金門馬祖以外之山地離島地區(1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00106B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)3.金門馬祖以外之山地離島地區(3)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00107B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)4.金門馬祖地區(1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00108B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)4.金門馬祖地區(3)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00109C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(1-1)處方交付特約藥局調劑(1-30人次)",
      "definition" : "通則12：未滿四歲兒童不限科別各項門診診察費得依表定點數加計百分之二十。婦產科、外科及內科之專科醫師：加計百分之十三；整形外科、骨科、泌尿科及神經外科之專科醫師：診治未滿四歲兒童加計百分之十三，診治四歲以上者加計百分之十；其餘專科醫師：診治未滿四歲兒童加計百分之十三，診治四歲以上者加計百分之九。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00110C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(3-1)未開處方或處方由本院所自行調劑(1-30人次)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00111C",
      "display" : "一般門診診察費－基層院所門診診察費2.每位醫師每日門診量超過四十人次，但在六十人次以下部分(41-60)(1)處方交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00112C",
      "display" : "一般門診診察費–基層院所門診診察費2.每位醫師每日門診量超過四十人次，但在六十人次以下部分(41-60)(3)未開處方或處方由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00113C",
      "display" : "一般門診診察費－基層院所門診診察費3.每位醫師每日門診量超過六十人次，但在八十人次以下部分(61-80)(1)處方交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00114C",
      "display" : "一般門診診察費－基層院所門診診察費3.每位醫師每日門診量超過六十人次但在八十人次以下部分(61-80)(3)未開處方或處方由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00115C",
      "display" : "一般門診診察費－基層院所門診診察費4.每位醫師每日門診量超過八十人次，但在一五0人次以下部分(81-150)(1)處方交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00116C",
      "display" : "一般門診診察費－基層院所門診診察費4.每位醫師每日門診量超過八十人次，但在一五0人次以下部分(81-150)(3)未開處方或處方由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00117C",
      "display" : "一般門診診察費－基層院所門診診察費5.每位醫師每日門診量超過一五0人次部分(>150)(1)處方交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00118C",
      "display" : "一般門診診察費－基層院所門診診察費5.每位醫師每日門診量超過一五0人次部分(>150)(3)未開處方或處方由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00121C",
      "display" : "牙科門診診察費1.每位醫師每日門診量在二十人次以下部分(≦20)1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.本項支付點數含護理費29-39點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00122C",
      "display" : "牙科門診診察費1.每位醫師每日門診量在二十人次以下部分(≦20)2)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.本項支付點數含護理費29-39點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00123C",
      "display" : "牙科門診診察費2.每位醫師每日門診量超過二十人次部分(>20)1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.本項支付點數含護理費29-39點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00124C",
      "display" : "牙科門診診察費2.每位醫師每日門診量超過二十人次部分(>20)2)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.本項支付點數含護理費29-39點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00125C",
      "display" : "牙科門診診察費3.山地離島地區1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.本項支付點數含護理費29-39點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00126C",
      "display" : "牙科門診診察費3.山地離島地區2)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.本項支付點數含護理費29-39點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00128C",
      "display" : "自閉症、失智症及重度以上特定身心障礙(非精神疾病)者診察費",
      "definition" : "限全民健康保險牙醫門診總額特殊醫療服務計畫適用對象之牙醫醫療服務申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00131B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)2.地區醫院(2)開具慢性病連續處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00132B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)2.地區醫院(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00135B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)3.金門馬祖以外之山地離島地區(2)開具慢性病連續處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00136B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)3.金門馬祖以外之山地離島地區(4)開具慢性病連續處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00137B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)4.金門馬祖地區(2)開具慢性病連續處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00138B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)4.金門馬祖地區(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00141C",
      "display" : "一般門診診察費－基層院所門診診察費2.每位醫師每日門診量超過四十人次，但在六十人次以下(41-60)(2)開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00142C",
      "display" : "一般門診診查費–基層院所門診診查費2.每位醫師每日門診量超過四十人次，但在六十人次以下(41-60)(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00143C",
      "display" : "一般門診診察費－基層院所門診診察費3.每位醫師每日門診量超過六十人次，但在八十人次以下部分(61-80)(2)開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00144C",
      "display" : "一般門診診察費－基層院所門診診察費3.每位醫師每日門診量超過六十人次，但在八十人次以下部分(61-80)(4)開具慢性病連續處方由本院所自行調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00145C",
      "display" : "一般門診診察費–基層院所門診診察費4.每位醫師每日門診量超過八十人次，但在一五0人次以下(81-150)(2)開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00146C",
      "display" : "一般門診診察費–基層院所門診診察費4.每位醫師每日門診量超過八十人次，但在一五0人次以下(81-150)(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00147C",
      "display" : "一般門診診察費－基層院所門診診察費5.每位醫師每日門診量超過一五0人次部分(>150)(2)開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00148C",
      "display" : "一般門診診察費－基層院所門診診察費5.每位醫師每日門診量超過一五0人次部分(>150)(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00154A",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)1.醫學中心及區域醫院(1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00155A",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)1.醫學中心及區域醫院(2)開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00156A",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)1.醫學中心及區域醫院(3)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00157A",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)1.醫學中心及區域醫院(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00158C",
      "display" : "一般門診診察費－基層院所門診診察費:1.每位醫師每日門診量四十人次以下部分(≦40)(５)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00159C",
      "display" : "一般門診診察費－基層院所門診診察費:1.每位醫師每日門診量四十人次以下部分(≦40)(６)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00160C",
      "display" : "一般門診診察費－基層院所門診診察費2.每位醫師每日門診量超過四十人次，但在六十人次以下部分(41-60)(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00161C",
      "display" : "一般門診診察費—基層院所門診診察費2.每位醫師每日門診量超過四十人次，但在六十人次以下部分(41-60)(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00162C",
      "display" : "一般門診診察費—基層院所門診診察費3.每位醫師每日門診量超過六十人次，但在八十人次以下部分(61-80)(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00163C",
      "display" : "一般門診診察費—基層院所門診診察費3.每位醫師每日門診量超過六十人次，但在八十人次以下部分(61-80)(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00164C",
      "display" : "一般門診診察費–基層院所門診診察費4.每位醫師每日門診量超過八十人次，但在一五0人次以下(81-150)(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00165C",
      "display" : "一般門診診察費–基層院所門診診察費4.每位醫師每日門診量超過八十人次，但在一五0人次以下(81-150)(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調行調劑。",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00166C",
      "display" : "一般門診診察費－基層院所門診診察費5.每位醫師每日門診量超過一五0人次部分(>150)(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00167C",
      "display" : "一般門診診察費－基層院所門診診察費5.每位醫師每日門診量超過一五0人次部分(>150)(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00168C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑(≦50)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00169C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑(≦50)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00170A",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)1.醫學中心及區域醫院(５)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00171A",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)1.醫學中心及區域醫院(６)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00172B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)2.地區醫院(５)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00173B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)2.地區醫院(６)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00174B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)3.金門馬祖以外之山地離島地區(５)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00175B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)3.金門馬祖以外之山地離島地區(６)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00176B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)4.金門馬祖地區(５)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00177B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)4.金門馬祖地區(６)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.通則11:4歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00178B",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)1.醫院(2)開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00179B",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)1.醫院(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00180B",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)1.醫院(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00181B",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)1.醫院(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00184C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00185C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00186C",
      "display" : "精神科門診診察費－每位醫師每日門診量在超過四十五人次部分(>45)(1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00187C",
      "display" : "精神科門診診察費－每位醫師每日門診量在超過四十五人次部分(>45)(2)開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00188C",
      "display" : "精神科門診診察費－每位醫師每日門診量在超過四十五人次部分(>45)(3)未開處方或處方由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00189C",
      "display" : "精神科門診診察費－每位醫師每日門診量在超過四十五人次部分(>45)(4)開具慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00190C",
      "display" : "精神科門診診察費－每位醫師每日門診量在超過四十五人次部分(>45)(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00191C",
      "display" : "精神科門診診察費－每位醫師每日門診量在超過四十五人次部分(>45)(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00197C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(≦40)2-1)開具慢性病連續處方並交付特約藥局調劑(1-30人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00198C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(≦40)2-2)開具慢性病連續處方並交付特約藥局調劑(31-40人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00199C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(≦40)4-1)開具慢性病連續處方並由本院所自行調劑(1-30人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00200C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(≦40)4-2)開具慢性病連續處方並由本院所自行調劑(31-40人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00201B",
      "display" : "急診診察費(按檢傷分類)檢傷分類第一級",
      "definition" : "1.檢傷分類依衛生福利部規定。2.地區醫院得就本項費用與01015C急診診察費擇一申報，惟採行後一年始得變更。3.夜間(晚上十時至隔日早上六時)加計百分之五十、例假日(週六零時起至週日二十四時止、國定假日零時至二十四時)加計百分之二十，同時符合夜間及例假日者，則僅加計百分之五十。4.山地離島及符合衛生福利部公告之緊急醫療資源不足地區急救責任醫院加計百分之三十，若同時符合夜間、例假日者，依表定點數加計百分之八十。5.地區醫院申報檢傷分類第四、五級之急診診察費得依表定點數加計百分之十九。6.內含護理費比率為百分之三十二點零四。7.本項年齡未滿六個月者，依表定點數加計百分之一百，其餘年齡為兒童加成項目，依本節通則十規定辦理。8.兒科專科醫師申報得加計百分之五十，其餘專科醫師申報未滿七歲兒童者，得加計百分之五十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00202B",
      "display" : "急診診察費(按檢傷分類)檢傷分類第二級",
      "definition" : "1.檢傷分類依衛生福利部規定。2.地區醫院得就本項費用與01015C急診診察費擇一申報，惟採行後一年始得變更。3.夜間(晚上十時至隔日早上六時)加計百分之五十、例假日(週六零時起至週日二十四時止、國定假日零時至二十四時)加計百分之二十，同時符合夜間及例假日者，則僅加計百分之五十。4.山地離島及符合衛生福利部公告之緊急醫療資源不足地區急救責任醫院加計百分之三十，若同時符合夜間、例假日者，依表定點數加計百分之八十。5.地區醫院申報檢傷分類第四、五級之急診診察費得依表定點數加計百分之十九。6.內含護理費比率為百分之三十二點零四。7.本項年齡未滿六個月者，依表定點數加計百分之一百，其餘年齡為兒童加成項目，依本節通則十規定辦理。8.兒科專科醫師申報得加計百分之五十，其餘專科醫師申報未滿七歲兒童者，得加計百分之五十。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00203B",
      "display" : "急診診察費(按檢傷分類)檢傷分類第三級",
      "definition" : "1.檢傷分類依衛生福利部規定。2.地區醫院得就本項費用與01015C急診診察費擇一申報，惟採行後一年始得變更。3.夜間(晚上十時至隔日早上六時)加計百分之五十、例假日(週六零時起至週日二十四時止、國定假日零時至二十四時)加計百分之二十，同時符合夜間及例假日者，則僅加計百分之五十。4.山地離島及符合衛生福利部公告之緊急醫療資源不足地區急救責任醫院加計百分之三十，若同時符合夜間、例假日者，依表定點數加計百分之八十。5.地區醫院申報檢傷分類第四、五級之急診診察費得依表定點數加計百分之十九。6.內含護理費比率為百分之三十二點零四。7.本項年齡未滿六個月者，依表定點數加計百分之一百，其餘年齡為兒童加成項目，依本節通則十規定辦理。8.兒科專科醫師申報得加計百分之五十，其餘專科醫師申報未滿七歲兒童者，得加計百分之五十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00204B",
      "display" : "急診診察費(按檢傷分類)檢傷分類第四級",
      "definition" : "1.檢傷分類依衛生福利部規定。2.地區醫院得就本項費用與01015C急診診察費擇一申報，惟採行後一年始得變更。3.夜間(晚上十時至隔日早上六時)加計百分之五十、例假日(週六零時起至週日二十四時止、國定假日零時至二十四時)加計百分之二十，同時符合夜間及例假日者，則僅加計百分之五十。4.山地離島及符合衛生福利部公告之緊急醫療資源不足地區急救責任醫院加計百分之三十，若同時符合夜間、例假日者，依表定點數加計百分之八十。5.地區醫院申報檢傷分類第四、五級之急診診察費得依表定點數加計百分之十九。6.內含護理費比率為百分之三十二點零四。7.本項年齡未滿六個月者，依表定點數加計百分之一百，其餘年齡為兒童加成項目，依本節通則十規定辦理。8.兒科專科醫師申報得加計百分之五十，其餘專科醫師申報未滿七歲兒童者，得加計百分之五十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00205C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)處方交付特約藥局調劑(51-70)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00206C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(2)開具慢性病連續處方並交付特約藥局調劑(51-70)",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00207C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(3)未開處方或處方由本院所自行調劑(51-70)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00208C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(4)開具慢性病連續處方並由本院所自行調劑(51-70)",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00209C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑(51-70)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00210C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑(51-70)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00211C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)處方交付特約藥局調劑(71-150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00212C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(2)開具慢性病連續處方並交付特約藥局調劑(71-150)",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00213C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(3)未開處方或處方由本院所自行調劑(71-150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00214C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(4)開具慢性病連續處方並由本院所自行調劑(71-150)",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00215C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑(71-150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00216C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑(71-150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00217C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)處方交付特約藥局調劑(>150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00218C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(2)開具慢性病連續處方並交付特約藥局調劑(>150)",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00219C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(3)未開處方或處方由本院所自行調劑(>150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00220C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(4)開具慢性病連續處方並由本院所自行調劑(>150)",
      "definition" : "通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。因註內容過多無法容納，請詳醫療費用支付標準。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00221C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(5)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並交付特約藥局調劑(>150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00222C",
      "display" : "一般門診診察費—基層院所門診診察費6.山地離島地區(6)開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方並由本院所自行調劑(>150)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00223C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(1-2)處方交付特約藥局調劑(31-40人次)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。※加成方式詳見通則十二",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00224C",
      "display" : "一般門診診察費－基層院所門診診察費1.每位醫師每日門診量在四十人次以下部分(3-2)未開處方或處方由本院所自行調劑(31-40人次)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00225B",
      "display" : "急診診察費(按檢傷分類)檢傷分類第五級",
      "definition" : "1.檢傷分類依衛生福利部規定。2.地區醫院得就本項費用與01015C急診診察費擇一申報，惟採行後一年始得變更。3.夜間(晚上十時至隔日早上六時)加計百分之五十、例假日(週六零時起至週日二十四時止、國定假日零時至二十四時)加計百分之二十，同時符合夜間及例假日者，則僅加計百分之五十。4.山地離島及符合衛生福利部公告之緊急醫療資源不足地區急救責任醫院加計百分之三十，若同時符合夜間、例假日者，依表定點數加計百分之八十。5.地區醫院申報檢傷分類第四、五級之急診診察費得依表定點數加計百分之十九。6.內含護理費比率為百分之三十二點零四。7.本項年齡未滿六個月者，依表定點數加計百分之一百，其餘年齡為兒童加成項目，依本節通則十規定辦理。8.兒科專科醫師申報得加計百分之五十，其餘專科醫師申報未滿七歲兒童者，得加計百分之五十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00226B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)５.地區醫院假日加計－地區醫院週六門診診察費加計",
      "definition" : "1.00226B及00227B限地區醫院申報。2.開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方之案件不得申報上述加計點數。3.應於開診前至保險人健保資訊網服務系統VPN登錄開診資訊。4.住院值班醫師不得為假日之門診看診醫師。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00227B",
      "display" : "一般門診診察費－醫院門診診察費(不含牙科門診)５.地區醫院假日加計－地區醫院週日及國定假日門診診察費加計",
      "definition" : "1.00226B及00227B限地區醫院申報。2.開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方之案件不得申報上述加計點數。3.應於開診前至保險人健保資訊網服務系統VPN登錄開診資訊。4.住院值班醫師不得為假日之門診看診醫師。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00228B",
      "display" : "精神科門診診察費－地區醫院假日加計－地區醫院週六精神科門診診察費加計",
      "definition" : "1.00228B及00229B限地區醫院申報。2.開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方之案件不得申報上述加計點數。3.應於開診前至保險人健保資訊網服務系統VPN登錄開診資訊。4.住院值班醫師不得為假日之門診看診醫師。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00229B",
      "display" : "精神科門診診察費－地區醫院假日加計－地區醫院週日及國定假日精神科門診診察費加計",
      "definition" : "1.00228B及00229B限地區醫院申報。2.開具連續二次以上調劑，而且每次給藥二十八天以上之慢性病連續處方之案件不得申報上述加計點數。3.應於開診前至保險人健保資訊網服務系統VPN登錄開診資訊。4.住院值班醫師不得為假日之門診看診醫師。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00230C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)1-1)處方交付特約藥局調劑(1-30人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00231C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)1-2)處方交付特約藥局調劑(31-50人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00232C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)2-1)開具慢性病連續處方並交付特約藥局調劑(1-30人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00233C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)2-2)開具慢性病連續處方並交付特約藥局調劑(31-50人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00234C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)3-1)未開處方或處方由本院所自行調劑(1-30人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00235C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)3-2)未開處方或處方由本院所自行調劑(31-50人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00236C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)4-1)開具慢性病連續處方並由本院所自行調劑(1-30人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00237C",
      "display" : "一般門診診察費－基層院所門診診察費6.山地離島地區(1)每位醫師每日門診量在五十人次以下部分(≦50)4-2)開具慢性病連續處方並由本院所自行調劑(31-50人)",
      "definition" : "註:1.以上第1至5點每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，以二十五日計算合理量。2.第6點山地離島地區每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以實際看診日數計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。3.以上第1至6點限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。4.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。5.處方由本院所自行調劑者，得另申報門診藥事服務費。6.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。7.本項支付點數含護理費29-39點。8.山地離島地區經總額受託單位與保險人共同協議認定之特殊地區院所得除外，以山地離島地區三十人次以下部分之支付點數申報。9.基層診所醫師診治病人後，應交付處方箋給病人，由病人自行選擇調劑之場所。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00238C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所1-1)處方交付特約藥局調劑(1-30人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00239C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所1-2)處方交付特約藥局調劑(31-45人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00240C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所2-1)開具慢性病連續處方並交付特約藥局調劑(1-30人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00241C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所2-2)開具慢性病連續處方並交付特約藥局調劑(31-45人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00242C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所3-1)未開處方或處方由本院所自行調劑(1-30人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00243C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所3-2)未開處方或處方由本院所自行調劑(31-45人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00244C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所4-1)開具慢性病連續處方並由本院所自行調劑(1-30人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00245C",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)2.基層診所4-2)開具慢性病連續處方並由本院所自行調劑(31-45人)",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00301C",
      "display" : "中度特定身心障礙(非精神疾病)者診察費",
      "definition" : "註:限全民健康保險牙醫門診總額特殊醫療服務計畫適用對象之牙醫醫療服務申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00302C",
      "display" : "中度以上精神疾病病人診察費",
      "definition" : "1.限「全民健康保險牙醫門診總額特殊醫療服務計畫」適用對象之牙醫醫療服務申報。2.限精神病及精神分裂之病人。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00303C",
      "display" : "輕度特定身心障礙者(非精神疾病)及失能老人診察費",
      "definition" : "註:限全民健康保險牙醫門診總額特殊醫療服務計畫適用對象之牙醫醫療服務申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00304C",
      "display" : "身心障礙者轉出醫療院所至特殊醫療服務計畫院所之轉診費用",
      "definition" : "註:1.交付病人牙醫醫療院所轉診單，且病歷應記載。2.提供病人或家屬相關諮詢及轉出病歷摘要(不包含X光片)。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00305C",
      "display" : "符合牙醫門診加強感染管制實施方案之牙科門診診察費1.每位醫師每日門診量在二十人次以下部份(≦20)－處方交付特約藥局調劑",
      "definition" : "註:1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑。4.本項支付點數含護理費32點至43點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00306C",
      "display" : "符合牙醫門診加強感染管制實施方案之牙科門診診察費1.每位醫師每日門診量在二十人次以下部份(≦20)－未開處方或處方由本院所自行調劑",
      "definition" : "註:1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑。4.本項支付點數含護理費32點至43點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00307C",
      "display" : "符合牙醫門診加強感染管制實施方案之牙科門診診察費2.每位醫師每日門診量超過二十人次部分(>20)－處方交付特約藥局調劑",
      "definition" : "註:1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑。4.本項支付點數含護理費32點至43點。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "00308C",
      "display" : "符合牙醫門診加強感染管制實施方案之牙科門診診察費2.每位醫師每日門診量超過二十人次部分(>20)－未開處方或處方由本院所自行調劑",
      "definition" : "註:1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑。4.本項支付點數含護理費32點至43點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00309C",
      "display" : "符合牙醫門診加強感染管制實施方案之牙科門診診察費3.山地離島地區(包含「全民健康保險牙醫門診總額醫療資源不足地區改善方案」山地離島地區之門診及巡迴案件)－處方交付特約藥局調劑",
      "definition" : "註:1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑。4.本項支付點數含護理費32點至43點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00310C",
      "display" : "符合牙醫門診加強感染管制實施方案之牙科門診診察費3.山地離島地區(包含「全民健康保險牙醫門診總額醫療資源不足地區改善方案」山地離島地區之門診及巡迴案件)－未開處方或處方由本院所自行調劑",
      "definition" : "註:1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑。4.本項支付點數含護理費32點至43點。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00311C",
      "display" : "符合牙醫門診加強感染管制實施方案之重度特定身心障礙(非精神疾病)者診察費",
      "definition" : "限「全民健康保險牙醫門診總額特殊醫療服務計畫」適用對象之牙醫醫療服務申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00312C",
      "display" : "符合牙醫門診加強感染管制實施方案之中度特定身心障礙(非精神疾病)者診察費",
      "definition" : "註:限「全民健康保險牙醫門診總額特殊醫療服務計畫」適用對象之牙醫醫療服務申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00313C",
      "display" : "符合牙醫門診加強感染管制實施方案之中度以上精神疾病病人診察費",
      "definition" : "1.限「全民健康保險牙醫門診總額特殊醫療服務計畫」適用對象之牙醫醫療服務申報。2.限精神疾病及思覺失調症之病人。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00314C",
      "display" : "符合牙醫門診加強感染管制實施方案之輕度特定身心障礙者(非精神疾病)及失能老人診察費",
      "definition" : "限「全民健康保險牙醫門診總額特殊醫療服務計畫」適用對象之牙醫醫療服務申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00315C",
      "display" : "符合牙醫門診加強感染管制實施方案之環口全景X光片診察",
      "definition" : "1.係指病人在該院所從未執行本項診察或01271C，或三年以上未就診，且該病人基於醫師之專業判斷，有施行環口全景X光片診察之需要，醫師得於主訴處理完畢後擇適當時機執行。2.申報時應檢附Panoramicradiography環口全景X光片攝影。3.同次診察內含34001C至34004C之X光費用，不得另行申報。4.病歷中除應記載缺牙部位、牙冠牙橋與阻生齒外，應記載X光片呈現之診斷與發現。5.本項與01271C三年內限擇一申報一次，申報本項一年內不得申報01272C、01273C、00316C、00317C。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00316C",
      "display" : "符合牙醫門診加強感染管制實施方案之年度X光片診察",
      "definition" : "1.係指病人間隔一年以上未就診或二年以上未執行本項，且經醫師專業判斷疑有鄰接面齲齒或疑似牙周炎者，醫師得於主訴處理完畢後擇適當時機執行。2.申報時應檢附雙側咬翼片Bite-Wing(後牙)及至少二張根尖周X光攝影(前牙)或至少四張根尖周X光片(不同部位，後牙優先)。3.同次診察內含34001C至34004C之X光費用，不得另行申報。4.病歷中除應記載缺牙部位、牙冠牙橋與阻生齒以及鄰接面齲齒齒位及部位外，應記載X光片呈現之診斷與發現。5.申報本項一年內不得申報01271C、01272C、01273C、00315C、00317C。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00317C",
      "display" : "符合牙醫門診加強感染管制實施方案之高齲齒罹患率族群年度X光片診察",
      "definition" : "1.適應症係指一年以上未執行本項，且符合高齲齒罹患率的族群者，經醫師專業判斷有執行X光片診察需要者，醫師可於病人之主訴處理完畢後擇適當時機執行。2.申報時應檢附雙側咬翼片Bite-Wing(後牙)及至少二張根尖周X光攝影(前牙)。3.高齲齒罹患率的族群為：(1)化療、放射線治療病人。(2)中風病人。(3)自體免疫疾病病人。(4)糖尿病病人。(5)心血管疾病病人。(6)巴金氏症Parkinson'sdisease。(7)透析治療(洗腎)病人。(8)經醫師專業判斷為高齲齒罹患率族群者。(須詳細註明原因)4.同次診察內含34001C至34004C之X光費用，不得另行申報。5.病歷中除應記載缺牙部位、牙冠牙橋與阻生齒以及鄰接面齲齒齒位及部位外，應記載X光片呈現之診斷與發現。6.申報本項一年內不得申報01271C、01272C、01273C、00315C、00316C。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "00318C",
      "display" : "符合牙醫門診加強感染管制實施方案之自閉症、失智症及極重度特定身心障礙(非精神疾病)者診察費",
      "definition" : "限「全民健康保險牙醫門診總額特殊醫療服務計畫」適用對象之牙醫醫療服務申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01015C",
      "display" : "急診診察費",
      "definition" : "1.急診定義及適用範圍如附表2.1.1。2.內含護理費比率為百分之八點八至百分之十四。3.夜間(晚上十時至隔日早上六時)加計百分之五十、例假日(週六之零時起至週日二十四時止、國定假日零時至二十四時)加計百分之二十，同時符合夜間及例假日者，則僅加計百分之五十；屬西醫基層總額部門院所，例假日加成維持原週六之中午十二時起至週日二十四時止、國定假日零時至二十四時加計百分之二十規定。4.山地離島及符合衛生福利部公告之緊急醫療資源不足地區急救責任醫院加計百分之三十，若同時符合夜間、例假日者，依表定點數加計百分之八十。5.地區醫院得依表定點數加計百分之十九。6.本項年齡未滿六個月者，依表定點數加計百分之一百，其餘年齡為兒童加成項目，依本節通則十規定辦理。7.地區醫院之兒科專科醫師申報得加計百分之五十，其餘專科醫師申報未滿七歲兒童者，得加計百分之五十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01018B",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)1.醫院(1)處方交付特約藥局調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01019B",
      "display" : "精神科門診診察費－每位醫師每日門診量在四十五人次以下部分(≦45)1.醫院(1)未開處方或處方由本院自行調劑",
      "definition" : "1.處方交付特約藥局調劑或未開處方者，不得申報藥事服務費。2.處方由本院所自行調劑者，得另申報門診藥事服務費。3.偏遠地區因所在地無特約藥局，交付慢性病連續處方箋至其他特約醫院或衛生所調劑，得比照處方箋交付特約藥局調劑申報。4.內含護理費比率為百分之八點七至百分之十一點五。5.基層院所精神科門診診察費限向衛生局登記為診所(不含中醫診所及牙醫診所)之特約醫事服務機構申報。6.基層院所精神科每月看診日數計算方式:每月實際看診日數不足二十五日(不含二十五日)，應以日計；每月實際看診日數二十五日以上者(含二十五日)，得以當月全月日數計。通則12:3歲(含)以下兒童之門診診察費得依表定點數加計百分之二十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01021C",
      "display" : "精神科急診診察費",
      "definition" : "1.精神科急診定義及範圍如附表2.1.1。2.本項支付點數含護理費48-67點。3.夜間(晚上十時至隔日早上六時)加成百分之五十、例假日(週六零時起至週日二十四時止、國定假日零時至二十四時)加成百分之二十，同時符合夜間及例假日者，則僅加成百分之五十。4.山地離島及符合衛生福利部公告之緊急醫療資源不足地區急救責任醫院加成百分之三十，若同時符合夜間、例假日者，依表定點數加成百分之八十。5.兒童加成項目。6.屬西醫基層總額部門院所，例假日加成維持原週六之中午十二時起至週日二十四時止、國定假日零時至二十四時加成百分之二十規定。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01023C",
      "display" : "高危險早產兒特別門診診察費",
      "definition" : "1.限出生時二千公克以下的早產兒於未滿三歲前之特別門診追蹤治療，並限由小兒科專科醫師親自執行。2.內含護理費比率為百分之十一點五至百分之十五點三。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01024C",
      "display" : "山地離島地區醫療報酬–山地離島地區醫師巡迴醫療費(半天)",
      "definition" : "1.山地離島地區巡迴醫療每位醫師、藥事人員及護理人員每月以八次為限，每次以半天為單位。2.申報01024C及01028C者，得另依規定申報醫療費。3.相關規定請依「全民健康保險申請山地離島地區醫療報酬作業須知」辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01027C",
      "display" : "山地離島地區醫療報酬–山地離島地區護理人員巡迴醫療費(半天)",
      "definition" : "1.山地離島地區巡迴醫療每位醫師、藥事人員及護理人員每月以八次為限，每次以半天為單位。2.申報01024C及01028C者，得另依規定申報醫療費。3.相關規定請依「全民健康保險申請山地離島地區醫療報酬作業須知」辦理。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "01028C",
      "display" : "山地離島地區醫療報酬–支援二、三、四級離島無醫師地區醫療費(一天)",
      "definition" : "1.山地離島地區巡迴醫療每位醫師、藥事人員及護理人員每月以八次為限，每次以半天為單位。2.申報01024C及01028C者，得另依規定申報醫療費。3.相關規定請依「全民健康保險申請山地離島地區醫療報酬作業須知」辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01030D",
      "display" : "助產所產後檢查",
      "definition" : "註:1.內容包括:產後恢復檢查、避孕指導、德國麻疹預防注射之諮商及指導。2.原助產所接生之個案，每人每次產後一個月內得申報四次到宅產後檢查服務，各次產後檢查服務內容如下:(1)第一次檢查a.身體評估(囟門、頸部、肩膀、心跳、髖關節)、測量新生兒:體溫、呼吸、頭圍、身長、教導新生兒沐浴、臍帶護理。b.教導母乳哺餵方式、餵食注意事項(唇色變化、溢吐奶)、排氣技巧、測量產婦:體溫、呼吸、血壓、子宮收縮、子宮底高度、傷口評估、惡露評估、產後飲食衛教、家庭衛生環境評估。(2)第二次檢查第一次服務項目+黃疸評估、發奶及脹奶處理。(3)第三次檢查第一、二次服務項目+奶量評估、生理性脫水評估、新生兒體重測量、紅臀處理、分辨腹瀉及便秘差異及處理方式、回覆示教新生兒沐浴、臍帶護理。(4)第四次檢查第一、二、三次服務項目+新生兒預防注射注意事項、避孕措施、產後運動、回覆示教新生兒沐浴、臍帶護理、母乳哺餵技巧、溢吐奶處理、排氣技巧。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01033C",
      "display" : "山地離島地區醫療報酬–山地離島地區藥事人員巡迴醫療費(半天)",
      "definition" : "1.山地離島地區巡迴醫療每位醫師、藥事人員及護理人員每月以八次為限，每次以半天為單位。2.申報01024C及01028C者，得另依規定申報醫療費。3.相關規定請依「全民健康保險申請山地離島地區醫療報酬作業須知」辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01034B",
      "display" : "辦理轉診費_回轉及下轉-使用保險人電子轉診平台",
      "definition" : "1.適用對象:(1)回轉:醫院對收治之上轉病患，其病情穩定後，已無需於該院繼續接受治療，但仍需接受門診或住院相關醫療服務，經病患同意，轉回原診療或其他適當之特約院所。(2)下轉:醫院對收治之病患，其病情穩定後，已無需於該院繼續接受治療，但仍需接受門診或住院相關醫療服務，經病患同意，轉診至特約類別較低層級之適當院所。2.執行規範:(1)院所宜協助病患轉診就醫安排事宜，並應交付病患轉診單，提供接受轉診之院所必要之診療資訊，包含:保險對象基本資料、病歷摘要或處置情形、轉診目的、轉診單開立日期及有效期限、建議轉診之診療科別等，後續應確認該院所接受轉診。(2)院所針對同一病患之轉診，應同院整合後辦理，不應分科分次轉出。(3)執行前述及其餘轉診相關事宜，應依全民健康保險轉診實施辦法各項規定辦理。3.支付規範:(1)院所除當次就醫之診察費外，可同時申報本項費用。(2)下列情形不得申報本項費用:a.同體系醫療院所間(含委託經營)之轉診案件。b.已申報「全民健康保險急診品質提升方案」轉診品質獎勵費用者。c.已申報「全民健康保險急性後期整合照護計畫」轉出醫院轉銜作業獎勵費者。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01035B",
      "display" : "辦理轉診費_回轉及下轉-未使用保險人電子轉診平台",
      "definition" : "1.適用對象:(1)回轉:醫院對收治之上轉病患，其病情穩定後，已無需於該院繼續接受治療，但仍需接受門診或住院相關醫療服務，經病患同意，轉回原診療或其他適當之特約院所。(2)下轉:醫院對收治之病患，其病情穩定後，已無需於該院繼續接受治療，但仍需接受門診或住院相關醫療服務，經病患同意，轉診至特約類別較低層級之適當院所。2.執行規範:(1)院所宜協助病患轉診就醫安排事宜，並應交付病患轉診單，提供接受轉診之院所必要之診療資訊，包含:保險對象基本資料、病歷摘要或處置情形、轉診目的、轉診單開立日期及有效期限、建議轉診之診療科別等，後續應確認該院所接受轉診。(2)院所針對同一病患之轉診，應同院整合後辦理，不應分科分次轉出。(3)執行前述及其餘轉診相關事宜，應依全民健康保險轉診實施辦法各項規定辦理。3.支付規範:(1)院所除當次就醫之診察費外，可同時申報本項費用。(2)下列情形不得申報本項費用:a.同體系醫療院所間(含委託經營)之轉診案件。b.已申報「全民健康保險急診品質提升方案」轉診品質獎勵費用者。c.已申報「全民健康保險急性後期整合照護計畫」轉出醫院轉銜作業獎勵費者。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01036C",
      "display" : "辦理轉診費_上轉-使用保險人電子轉診平台",
      "definition" : "註:1.適用對象:院所對無法處理病情之病患，因醫療需要，經病患同意後，轉診至特約類別較高層級之適當醫院。2.執行規範:(1)院所宜協助病患轉診就醫安排事宜，並應交付病患轉診單，提供接受轉診之院所必要之診療資訊，包含:保險對象基本資料、病歷摘要或處置情形、轉診目的、轉診單開立日期及有效期限、建議轉診之診療科別等，後續應確認該院所接受轉診。(2)院所針對同一病患之轉診，應同院整合後辦理，不應分科分次轉出。(3)執行前述及其餘轉診相關事宜，應依全民健康保險轉診實施辦法各項規定辦理。3.支付規範:(1)院所除當次就醫之診察費外，可同時申報本項費用。(2)下列情形不得申報本項費用:a.同體系醫療院所間(含委託經營)之轉診案件。b.已申報「全民健康保險急診品質提升方案」轉診品質獎勵費用者。c.已申報「全民健康保險急性後期整合照護計畫」轉出醫院轉銜作業獎勵費者。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01037C",
      "display" : "辦理轉診費_上轉-未使用保險人電子轉診平台",
      "definition" : "註:1.適用對象:院所對無法處理病情之病患，因醫療需要，經病患同意後，轉診至特約類別較高層級之適當醫院。2.執行規範:(1)院所宜協助病患轉診就醫安排事宜，並應交付病患轉診單，提供接受轉診之院所必要之診療資訊，包含:保險對象基本資料、病歷摘要或處置情形、轉診目的、轉診單開立日期及有效期限、建議轉診之診療科別等，後續應確認該院所接受轉診。(2)院所針對同一病患之轉診，應同院整合後辦理，不應分科分次轉出。(3)執行前述及其餘轉診相關事宜，應依全民健康保險轉診實施辦法各項規定辦理。3.支付規範:(1)院所除當次就醫之診察費外，可同時申報本項費用。(2)下列情形不得申報本項費用:a.同體系醫療院所間(含委託經營)之轉診案件。b.已申報「全民健康保險急診品質提升方案」轉診品質獎勵費用者。c.已申報「全民健康保險急性後期整合照護計畫」轉出醫院轉銜作業獎勵費者。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01038C",
      "display" : "接受轉診門診診察費加算",
      "definition" : "註:1.適用對象:接受申報01034B-01037C之轉診案件。2.執行規範:(1)院所應設置適當之設施及人員，為需要轉診之保險對象，提供適當就醫安排，並保留一定優先名額予轉診之病人。(2)接受轉診後，應依醫療法施行細則有關轉診之規定，將保險對象之初步診療處置情形，及後續診療疾病之相關檢查及處置結果，回復原轉診院所。(3)執行前述及其餘轉診相關事宜，應依全民健康保險轉診實施辦法各項規定辦理。3.支付規範:(1)申報本項費用者，當次就醫可同時申報門診診察費，且此次門診不列入院所原門診合理量計算。(2)下列情形不得申報本項費用:a.同體系醫療院所間(含委託經營)之轉診案件。b.屬全民健康保險轉診實施辦法第十一條所列之「視同轉診」情形者。c.已申報「全民健康保險急診品質提升方案」轉診品質獎勵費用者。d.已申報「全民健康保險急性後期整合照護計畫」承作醫院初評評估費者。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01039C",
      "display" : "腎臟移植諮詢費",
      "definition" : "1.適應症:年齡未滿六十五歲符合下列任一條件者適用:(1)透析前，eGFR<10ml/min/1.73㎡連續二次，間隔三個月以上，且逐漸衰退者。(2)領有「慢性腎衰竭(尿毒症)，必須接受定期透析治療者」重大傷病證明(三個月以上)，並於開始接受透析一年內。2.支付規範:(1)諮詢參與人員:包括移植醫療團隊之外科、泌尿科、小兒外科或曾接受過台灣腎臟醫學會與台灣移植醫學會共同舉辦之腎臟移植諮詢訓練課程之腎臟科專科醫師，以及病人或病人家屬。(2)諮詢時間:每一個案諮詢時間至少十五分鐘。(3)諮詢紀錄:應有參與諮詢醫療團隊及病人或其家屬簽名之「腎臟移植諮詢檢核表(含醫病共享決策評估表)」，並應併入病人之病歷紀錄留存。(4)申報規定:A.門診、住診均可申報。B.每人終生限給付一次。C.不得與「全民健康保險鼓勵院所加強推動腹膜透析與提升照護品質計畫」之醫病共享決策診療項目、「全民健康保險末期腎臟病前期(Pre-ESRD)之病人照護與衛教計畫」P3405C「結案資料處理費」併同申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01040C",
      "display" : "職業病初診、第一、二、三次複診診察費-處方交付特約藥局調劑",
      "definition" : "1.按全民健康保險給付基層院所門診合理量內診察費(代碼為00109C，00139C，00110C，00140C，00158C，00159C)之二倍2.限勞工保險職業病初診及三次以內(含)之複診申報3.本項診察費應由職業醫學科專科醫師執行",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01050C",
      "display" : "職業病初診、第一、二、三次複診診療費-開具慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.按全民健康保險給付基層院所門診合理量內診察費(代碼為00109C，00139C，00110C，00140C，00158C，00159C)之二倍2.限勞工保險職業病初診及三次以內(含)之複診申報3.本項診察費應由職業醫學科專科醫師執行",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01060C",
      "display" : "職業病初診、第一、二、三次複診診察費-未開處方或處方由本院所自行調劑",
      "definition" : "1.按全民健康保險給付基層院所門診合理量內診察費(代碼為00109C，00139C，00110C，00140C，00158C，00159C)之二倍2.限勞工保險職業病初診及三次以內(含)之複診申報3.本項診察費應由職業醫學科專科醫師執行",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01070C",
      "display" : "職業病初診、第一、二、三次複診診察費-開具慢性病連續處方並由本院所自行調劑",
      "definition" : "1.按全民健康保險給付基層院所門診合理量內診察費(代碼為00109C，00139C，00110C，00140C，00158C，00159C)之二倍2.限勞工保險職業病初診及三次以內(含)之複診申報3.本項診察費應由職業醫學科專科醫師執行",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01075C",
      "display" : "職業性醫學科診斷性會談費",
      "definition" : "一、限由職業醫學科專科醫師執行。二、經確診為職業病之勞工保險被保險人案件。三、須填寫勞工保險職業病評估報告書，並由職業醫學科專科醫師簽名，留存病歷備查。四、勞工保險職業病門診初診及三次以內複診之診察費，調整為全民健康保險給付特約基層院所門診合理量內診察費之二倍，惟於申報本項會談費當次，不再加倍。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01076B",
      "display" : "尿中無機砷檢查",
      "definition" : "「尿中無機砷檢查」值需呈現「尿中無機砷總量」檢驗值(即三價砷、五價砷、MMA、DMA、肌酸酐之檢驗值合計數)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01077B",
      "display" : "試壓耐氧檢查",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01078B",
      "display" : "血清銦檢查",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01080C",
      "display" : "職業病初診、第一、二、三次複診診察費-開具連續二次以上調劑，而且每次調劑二十八天以上之慢性病連續處方並交付特約藥局調劑",
      "definition" : "1.按全民健康保險給付基層院所門診合理量內診察費(代碼為00109C，00139C，00110C，00140C，00158C，00159C)之二倍2.限勞工保險職業病初診及三次以內(含)之複診申報3.本項診察費應由職業醫學科專科醫師執行",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01090C",
      "display" : "職業病初診、第一、二、三次複診診察費-開具連續二次以上調劑，而且每次調劑二十八天以上之慢性病連續處方並由本院所自行調劑",
      "definition" : "1.按全民健康保險給付基層院所門診合理量內診察費(代碼為00109C，00139C，00110C，00140C，00158C，00159C)之二倍2.限勞工保險職業病初診及三次以內(含)之複診申報3.本項診察費應由職業醫學科專科醫師執行",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01188C",
      "display" : "勞工保險職業傷害門診初診加給診察費",
      "definition" : "配合支付標準2-1-1門診診察費調整，修訂勞工保險職業傷害門診診察費支付代碼表，刪除牙醫兩字。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01271C",
      "display" : "環口全景X光片診察",
      "definition" : "1.係指病人在該院所從未執行本項診察或00315C，或三年以上未就診，且該病人基於醫師之專業判斷，有施行環口全景X光片診察之需要，醫師得於主訴處理完畢後擇適當時機執行。2.申報時應檢附Panoramicradiography環口全景X光片攝影。3.同次診察內含34001C至34004C之X光費用，不得另行申報。4.病歷中除應記載缺牙部位、牙冠牙橋與阻生齒外，應記載X光片呈現之診斷與發現。5.本項與00315C三年內限擇一申報一次，申報本項一年內不得申報01272C、01273C、00316C、00317C。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01272C",
      "display" : "年度X光片診察",
      "definition" : "1.係指病人間隔一年以上未就診或二年以上未執行本項，且經醫師專業判斷疑有鄰接面齲齒或疑似牙周炎者，醫師得於主訴處理完畢後擇適當時機執行。2.申報時應檢附雙側咬翼片Bite-Wing(後牙)及至少二張根尖周X光攝影(前牙)或至少四張根尖周X光片(不同部位，後牙優先)。3.同次診察內含34001C至34004C之X光費用，不得另行申報。4.病歷中除應記載缺牙部位、牙冠牙橋與阻生齒以及鄰接面齲齒齒位及部位外，應記載X光片呈現之診斷與發現。5.申報本項一年內不得申報01271C、01273C、00315C、00316C、00317C。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01273C",
      "display" : "高齲齒罹患率族群年度X光片診察",
      "definition" : "1.適應症係指一年以上未執行本項，且符合高齲齒罹患率的族群者，經醫師專業判斷有執行X光片診察需要者，醫師可於病人之主訴處理完畢後擇適當時機執行。2.申報時應檢附雙側咬翼片Bite-Wing(後牙)及至少二張根尖周X光攝影(前牙)。3.高齲齒罹患率的族群為：(1)化療、放射線治療病人。(2)中風病人。(3)自體免疫疾病病人。(4)糖尿病病人。(5)心血管疾病病人。(6)巴金氏症Parkinson'sdisease。(7)透析治療(洗腎)病人。(8)經醫師專業判斷為高齲齒罹患率族群者。(須詳細註明原因)4.同次診察內含34001C至34004C之X光費用，不得另行申報。5.病歷中除應記載缺牙部位、牙冠牙橋與阻生齒以及鄰接面齲齒齒位及部位外，應記載X光片呈現之診斷與發現。6.申報本項一年內不得申報01271C、01272C、00315C、00316C、00317C。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "02005B",
      "display" : "住院會診費",
      "definition" : "1.本項會診費，除急診期間外，每一保險對象每次住院最多限申報五次。2.急診處暫留床病人，以申報一次為限。3.不得同時申報高風險妊娠生產新生兒緊急處置費(編號57124C、57125B及57126B)。4.兒童專科醫師得加計百分之一百二十，若同時符合兒童加成者，依加成率合計後一併加成，最高加成上限為百分之一百二十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02006K",
      "display" : "一般病床住院診察費(天)",
      "definition" : "1.經濟病床及急性精神病床比照申報。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.兒童專科醫師得加計百分之一百五十，若同時符合兒童加成者，依加成率合計後一併加成，最高加成上限為百分之一百五十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02007A",
      "display" : "一般病床住院診察費(天)",
      "definition" : "1.經濟病床及急性精神病床比照申報。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.兒童專科醫師得加計百分之一百五十，若同時符合兒童加成者，依加成率合計後一併加成，最高加成上限為百分之一百五十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02008B",
      "display" : "一般病床住院診察費(天)",
      "definition" : "1.經濟病床及急性精神病床比照申報。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.兒童專科醫師得加計百分之一百五十，若同時符合兒童加成者，依加成率合計後一併加成，最高加成上限為百分之一百五十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02010B",
      "display" : "燒傷病床住院診察費(天)",
      "definition" : "本項兒童加成方式:病人年齡未滿六個月者，依表定點數加計百分之一百二十；年齡在六個月以上至未滿二歲者，依表定點數加計百分之九十；年齡在二歲以上至未滿七歲者，依表定點數加計百分之八十。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02011K",
      "display" : "加護病床住院診察費(天)",
      "definition" : "1.精神科加護病床、燒傷中心及骨髓移植隔離病床比照申報。2.兒科專科醫師得加計百分之一百二十，若同時符合兒童加成或兒科及新生兒科加護病房加成者，依加成率合計後一併加成，最高加成上限為百分之一百四十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02012A",
      "display" : "加護病床住院診察費(天)",
      "definition" : "1.精神科加護病床、燒傷中心及骨髓移植隔離病床比照申報。2.兒科專科醫師得加計百分之一百二十，若同時符合兒童加成或兒科及新生兒科加護病房加成者，依加成率合計後一併加成，最高加成上限為百分之一百四十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02013B",
      "display" : "加護病床住院診察費(天)",
      "definition" : "1.精神科加護病床、燒傷中心及骨髓移植隔離病床比照申報。2.兒科專科醫師得加計百分之一百二十，若同時符合兒童加成或兒科及新生兒科加護病房加成者，依加成率合計後一併加成，最高加成上限為百分之一百四十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02014K",
      "display" : "隔離病床住院診察費(天)",
      "definition" : "1.核醫病床得比照申報。2.兒童專科醫師得加計百分之一百五十，若同時符合兒童加成者，依加成率合計後一併加成，最高加成上限為百分之一百五十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02015A",
      "display" : "隔離病床住院診察費(天)",
      "definition" : "1.核醫病床得比照申報。2.兒童專科醫師得加計百分之一百五十，若同時符合兒童加成者，依加成率合計後一併加成，最高加成上限為百分之一百五十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02016B",
      "display" : "隔離病床住院診察費(天)",
      "definition" : "1.核醫病床得比照申報。2.兒童專科醫師得加計百分之一百五十，若同時符合兒童加成者，依加成率合計後一併加成，最高加成上限為百分之一百五十。小兒外科專科醫師診治未滿十九歲病人之案件，得依前述規範加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02017K",
      "display" : "新生兒中重度住院診察費(天)",
      "definition" : "本項非兒童加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02018A",
      "display" : "新生兒中重度住院診察費(天)",
      "definition" : "本項非兒童加成項目",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02019B",
      "display" : "新生兒中重度住院診察費(天)",
      "definition" : "本項非兒童加成項目",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02020B",
      "display" : "緩和醫療家庭諮詢費",
      "definition" : "1.適應症:以現行住院或急診重症病患，且己進入末期狀態者為主。2.相關規範:(1)諮詢參與人員:包括主治醫療團隊、病患或病患家屬。(2)諮詢時間:每一個案諮詢時間至少1小時。(3)諮詢記錄:應有完整的諮詢溝通內容記錄，並應併入病患之病歷記錄留存，紀錄並有參與諮詢醫療團隊及病患或家屬簽名。(4)申報規定:a.另已參與全民健康保險安寧共同照護試辦方案、住院安寧療護及居家安寧照護後，不得再申報。b.每人每院限申報二次。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02021K",
      "display" : "慢性病床住院診察費(天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02022A",
      "display" : "慢性病床住院診察費(天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02023B",
      "display" : "慢性病床住院診察費(天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02024B",
      "display" : "高危險妊娠住院診察費",
      "definition" : "適應症:1.妊娠二十二週以上至未滿三十三週早產病患。2.四十歲以上初產婦。3.BMI≧35之初產婦。4.嚴重妊娠高血壓。5.前置胎盤患者。6.多胞胎。7.胎兒生長遲緩或胎兒發育異常者(IUGR)或胎盤功能異常者。8.妊娠合併內科疾病:心臟病、糖尿病、甲狀腺疾病、腎臟疾病(NS,IgA,ESRD)、免疫性疾病(SLE)、血小板低下症。9.白血病。10.血友病(Coagulopathy)。11.愛滋病。12.產後大出血者。13.胎盤早期剝離。14.合併接受外科手術者。15.雙胞胎輸血症候群。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02025B",
      "display" : "出院準備及追蹤管理費",
      "definition" : "1.醫事機構條件:須設有出院準備服務小組，定期召開會議，檢討、修訂出院照護計畫架構、流程等，並能具體解決問題，且記錄完整。2.服務項目:(1)出院準備服務計畫:提供營養、復健、用藥、後續門診追蹤、緊急就醫之醫療資源與途徑等資訊，提升病人及家屬居家自我照顧能力、提供生活適應訓練、社會經濟及心理層面諮詢等疾病相關之計畫及指導。(2)每位個案應進行一次以上之跨團隊溝通協調。(3)評估個案需求，協助轉介全民健康保險家庭醫師整合性照護計畫社區醫療群、各類居家照護、全民健康保險居家醫療照護整合計畫、長照機構等後續照護資源。(4)提供電話專線諮詢服務。(5)出院後電訪追蹤至少一次。3.支付規範:(1)醫事服務機構應檢附計畫書(敘明收案對象及執行方式)及專業團隊名單向保險人分區業務組申請核備後執行。(2)每人每次住院得申請一次。(3)排除出院後轉往同體系院所住院之案件。4.品質監控指標:同一疾病三日再急診比率(含跨院)、同一疾病十四日內非計畫性再住院率(含跨院)。5.施行本項須依保險人公布之「02025B出院準備及追蹤管理費作業規範」辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02027B",
      "display" : "器官移植協調管理費",
      "definition" : "註:本項須併同下列器官摘取或移植手術之診療項目申報，不得單獨申報。1.器官摘取:68034B、68038B、75021B、75022B、75419B、76018B、76019B、73050B、75034B、76036B。2.器官移植:68035B、68037B、68047B、75020B、75418B、76020B、73049B。3.異體骨髓/周邊造血細胞移植:94201B、94206B。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02028B",
      "display" : "預立醫療照護諮商費-同次住院未曾申報或僅申報一次02020B「緩和醫療家庭諮詢費」者",
      "definition" : "執行02028B及02029B1.符合下列任一適應症，且具完全行為能力之住院病人：(1)六十五歲以上重大傷病，且罹患安寧療護收案條件所列之疾病別。(2)臨床失智評估量表(ClinicalDementiaRating,CDR)0.5至1分。(3)病人自主權利法第十四條第一項第五款所公告之病名。(4)「全民健康保險居家醫療照護整合計畫」收案對象。2.相關規範：(1)諮商參與人員：依病人自主權利法之規定辦理。(2)諮商紀錄：應有每次會議完整之諮商溝通內容紀錄，並應將影本併入病人之病歷紀錄留存，紀錄有參與諮商醫療團隊及病人或家屬簽名，並簽署預立醫療決定。(3)申報規定：A.當次就醫前已於全民健康保險憑證註記預立醫療決定者，不得申報本項費用。B.每人終生以申報一次為限。C.應依病人自主權利法，於申報前完成預立醫療決定上傳至中央主管機關之資料庫，未完成者，本項費用不予支付。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        }
      ]
    },
    {
      "code" : "02029B",
      "display" : "預立醫療照護諮商費-同次住院申報二次02020B「緩和醫療家庭諮詢費」者",
      "definition" : "執行02028B及02029B1.符合下列任一適應症，且具完全行為能力之住院病人：(1)六十五歲以上重大傷病，且罹患安寧療護收案條件所列之疾病別。(2)臨床失智評估量表(ClinicalDementiaRating,CDR)0.5至1分。(3)病人自主權利法第十四條第一項第五款所公告之病名。(4)「全民健康保險居家醫療照護整合計畫」收案對象。2.相關規範：(1)諮商參與人員：依病人自主權利法之規定辦理。(2)諮商紀錄：應有每次會議完整之諮商溝通內容紀錄，並應將影本併入病人之病歷紀錄留存，紀錄有參與諮商醫療團隊及病人或家屬簽名，並簽署預立醫療決定。(3)申報規定：A.當次就醫前已於全民健康保險憑證註記預立醫療決定者，不得申報本項費用。B.每人終生以申報一次為限。C.應依病人自主權利法，於申報前完成預立醫療決定上傳至中央主管機關之資料庫，未完成者，本項費用不予支付。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03001K",
      "display" : "急性一般病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03002A",
      "display" : "急性一般病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03003BA",
      "display" : "慢性呼吸照護病房病床費/天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03004B",
      "display" : "急性一般病床(床/天)–病床費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03005K",
      "display" : "經濟病床(床/天)-病房費",
      "definition" : "指每一病室設超過四床之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03006A",
      "display" : "經濟病床(床/天)–病房費",
      "definition" : "指每一病室設超過四床之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03008B",
      "display" : "經濟病床(床/天)–病房費",
      "definition" : "指每一病室設超過四床之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03009K",
      "display" : "嬰兒病床(床/天)--病房費",
      "definition" : "註:1.指足月出生四個月內或早於35週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者.3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03010E",
      "display" : "加護病床(床/天)-病房費",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03011F",
      "display" : "加護病床(床/天)–病房費",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03012G",
      "display" : "加護病床(床/天)–病房費",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03012GA",
      "display" : "醫學中心亞急性呼吸照護病房病床費/天",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03013HA",
      "display" : "區域醫院亞急性呼吸照護病房病床費/天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03014A",
      "display" : "精神科加護病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03016B",
      "display" : "燒傷病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03017A",
      "display" : "燒傷加護病床(床/天)–病房費",
      "definition" : "1.C.V.P.處理費、矽砂床、監視器等費用已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣及C.V.P.置入等另按實際使用申報。3.適應症:二度燒傷，燒傷面積成人大於全身百分之二十，兒童大於百分之十；或三度燒傷，燒傷面積成人大於全身百分之十，兒童大於百分之五。4.申報費用時應檢附病歷摘要，並保存病人入出院時皮表處理之彩色照片，以備審核。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03018A",
      "display" : "急診觀察床(床/天)–病房費(第二天起)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03019B",
      "display" : "急診觀察床(床/天)–病房費(第二天起)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03019BA",
      "display" : "觀察病床(６小時)",
      "definition" : "限門診或急診施行下列診療項目時申報:1.癌症化學治療2.紫斑症或先天性免疫不全之免疫球蛋白注射3.地中海型貧血輸血",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03020B",
      "display" : "隔離病床(床/天)1.普通隔離病床–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03021B",
      "display" : "隔離病床(床/天)2.正壓隔離病床–病房費",
      "definition" : "指對免疫缺乏之重症患者，具有保護免於受外界感染源侵犯之特殊設計之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03022K",
      "display" : "骨髓移植隔離病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03023A",
      "display" : "嬰兒病床(床/天)--病房費",
      "definition" : "註:1.指足月出生四個月內或早於35週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者.3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03024B",
      "display" : "嬰兒病床(床/天)--病房費",
      "definition" : "註:1.指足月出生四個月內或早於35週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者.3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03025B",
      "display" : "精神科加護病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03026K",
      "display" : "急性一般病床(床/天)–護理費(第二天起)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03027A",
      "display" : "急性一般病床(床/天)–護理費(第二天起)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03028BA",
      "display" : "慢性呼吸照護病房護理費/天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03029B",
      "display" : "急性一般病床(床/天)–護理費(第二天起)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03030K",
      "display" : "經濟病床(床/天)–護理費(第二天起)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03031A",
      "display" : "經濟病床(床/天)–護理費(第二天起)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03033B",
      "display" : "經濟病床(床/天)–護理費(第二天起)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03034K",
      "display" : "嬰兒病床(床/天)--護理費(第二天起)",
      "definition" : "1.指足月出生四個月內或早於三十五週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者。3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03035A",
      "display" : "嬰兒病床(床/天)--護理費(第二天起)",
      "definition" : "1.指足月出生四個月內或早於三十五週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者。3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03036B",
      "display" : "嬰兒病床(床/天)--護理費(第二天起)",
      "definition" : "1.指足月出生四個月內或早於三十五週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者。3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03037A",
      "display" : "精神科加護病床(床/天)--護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03039B",
      "display" : "精神科加護病床(床/天)--護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03040B",
      "display" : "燒傷病房(床/天)--護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03041A",
      "display" : "燒傷加護病床(床/天)–護理費(第二天起)",
      "definition" : "1.C.V.P.處理費、矽砂床、監視器等費用已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣及C.V.P.置入等另按實際使用申報。3.適應症:二度燒傷，燒傷面積成人大於全身百分之二十，兒童大於百分之十；或三度燒傷，燒傷面積成人大於全身百分之十，兒童大於百分之五。4.申報費用時應檢附病歷摘要，並保存病人入出院時皮表處理之彩色照片，以備審核。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03042A",
      "display" : "急診觀察床(床/天)–護理費(第二天起)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03043B",
      "display" : "急診觀察床(床/天)–護理費(第二天起)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03044B",
      "display" : "隔離病床(床/天)1.普通隔離病床–護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03045B",
      "display" : "隔離病床(床/天)2.正壓隔離病床–護理費(第二天起)",
      "definition" : "指對免疫缺乏之重症患者，具有保護免於受外界感染源侵犯之特殊設計之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03046K",
      "display" : "骨髓移植隔離病床(床/天)–護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03047E",
      "display" : "加護病床(床/天)–護理費(第二天起)",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03048F",
      "display" : "加護病床(床/天)–護理費(第二天起)",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03049G",
      "display" : "加護病床(床/天)–護理費(第二天起)",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03049GA",
      "display" : "醫學中心亞急性呼吸照護病房護理費/天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03050HA",
      "display" : "區域醫院亞急性呼吸照護病房護理費/天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03051B",
      "display" : "隔離病床(床/天)3.負壓隔離病床–病房費",
      "definition" : "指對患有具傳染性疾病之病人，能夠不讓其病源體散布於社區或醫院內之特殊設計之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03052B",
      "display" : "隔離病床(床/天)3.負壓隔離病床–護理費(第二天起)",
      "definition" : "指對患有具傳染性疾病之病人，能夠不讓其病源體散布於社區或醫院內之特殊設計之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03053B",
      "display" : "核醫病床-病房費",
      "definition" : "註:限行政院原子能委員會安全檢查及游離輻射量合格之核醫病床申報",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03054B",
      "display" : "核醫病床–護理費(第二天起)",
      "definition" : "限行政院原子能委員會安全檢查及游離輻射量合格之核醫病床申報",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03055K",
      "display" : "精神急性一般病床(床/天)-病房費",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03056A",
      "display" : "精神急性一般病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03057B",
      "display" : "精神急性一般病床(床/天)–病床費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03058K",
      "display" : "精神急性一般病床(床/天)--護理費(第二天起)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03059A",
      "display" : "精神急性一般病床(床/天)--護理費(第二天起)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03060B",
      "display" : "精神急性一般病床(床/天)--護理費(第二天起)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03061K",
      "display" : "精神急性經濟病床(床/天)--病房費",
      "definition" : "指每一病室設超過四床之病床。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03062A",
      "display" : "精神急性經濟病床(床/天)--病房費",
      "definition" : "指每一病室設超過四床之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03063B",
      "display" : "精神急性經濟病床(床/天)--病房費",
      "definition" : "指每一病室設超過四床之病床。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03064K",
      "display" : "精神急性經濟病床(床/天)--護理費(第二天起)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03065A",
      "display" : "精神急性經濟病床(床/天)--護理費(第二天起)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03066B",
      "display" : "精神急性經濟病床(床/天)--護理費(第二天起)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03067K",
      "display" : "慢性病床(床/天)-病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03068A",
      "display" : "慢性病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03069B",
      "display" : "慢性病床(床/天)–病房費",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03070K",
      "display" : "慢性病床(床/天)--護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03071A",
      "display" : "慢性病床(床/天)--護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03072B",
      "display" : "慢性病床(床/天)--護理費(第二天起)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03073A",
      "display" : "急診觀察床(床/天)--病房費(第一天)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03074B",
      "display" : "急診觀察床(床/天)--病房費(第一天)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03075A",
      "display" : "急診觀察床(床/天)--護理費(第一天)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03076B",
      "display" : "急診觀察床(床/天)--護理費(第一天)",
      "definition" : "1.急診留觀或待床病人，入住滿六小時始得申報。2.留置超過一日(二十四小時)者，比照住院病房費申報方式，依算進不算出原則計算。3.僅作注射點滴、輸血或休息者，不予支付。4.山地離島地區病人因故無法後送而須於衛生所(室)留觀者，依03019B及03074B「病床費」、03043B及03076B「護理費」申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03077K",
      "display" : "急性一般病床(床/天)--護理費(第一天)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03078A",
      "display" : "急性一般病床(床/天)--護理費(第一天)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03079B",
      "display" : "急性一般病床(床/天)--護理費(第一天)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03080K",
      "display" : "經濟病床(床/天)--護理費(第一天)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03081A",
      "display" : "經濟病床(床/天)--護理費(第一天)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03082B",
      "display" : "經濟病床(床/天)--護理費(第一天)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03083K",
      "display" : "嬰兒病床(床/天)--護理費(第一天)",
      "definition" : "1.指足月出生四個月內或早於三十五週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者。3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03084A",
      "display" : "嬰兒病床(床/天)--護理費(第一天)",
      "definition" : "1.指足月出生四個月內或早於三十五週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者。3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03085B",
      "display" : "嬰兒病床(床/天)--護理費(第一天)",
      "definition" : "1.指足月出生四個月內或早於三十五週出生之早產兒出生後矯正年齡五個月內之嬰兒(正常新生兒除外)因疾病而需特別觀察治療者，或因早產需要特別養育者，以入住時之年齡判定。2.限無家屬照顧，二十四小時由醫護人員照顧者。3.本項非兒童加成項目。4.非註1之嬰兒住院者，以急性一般病床申報費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03086K",
      "display" : "精神急性一般病床(床/天)--護理費(第一天)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03087A",
      "display" : "精神急性一般病床(床/天)--護理費(第一天)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03088B",
      "display" : "精神急性一般病床(床/天)--護理費(第一天)",
      "definition" : "護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03089K",
      "display" : "精神急性經濟病床(床/天)--護理費(第一天)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03090A",
      "display" : "精神急性經濟病床(床/天)--護理費(第一天)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03091B",
      "display" : "精神急性經濟病床(床/天)--護理費(第一天)",
      "definition" : "1.指每一病室設超過四床之病床。2.護理費為偏鄉醫院及符合全日平均護病比之加成項目。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "03092K",
      "display" : "慢性病床(床/天)--護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03093A",
      "display" : "慢性病床(床/天)--護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03094B",
      "display" : "慢性病床(床/天)--護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03095A",
      "display" : "精神科加護病床(床/天)--護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03096B",
      "display" : "精神科加護病床(床/天)--護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03097B",
      "display" : "燒傷病房(床/天)--護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03098A",
      "display" : "燒傷加護病床(床/天)--護理費(第一天)",
      "definition" : "1.C.V.P.處理費、矽砂床、監視器等費用已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣及C.V.P.置入等另按實際使用申報。3.適應症:二度燒傷，燒傷面積成人大於全身百分之二十，兒童大於百分之十；或三度燒傷，燒傷面積成人大於全身百分之十，兒童大於百分之五。4.申報費用時應檢附病歷摘要，並保存病人入出院時皮表處理之彩色照片，以備審核。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03099B",
      "display" : "核醫病床–護理費(第一天)",
      "definition" : "限行政院原子能委員會安全檢查及游離幅射測量合格之核醫病床申報",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03100K",
      "display" : "骨髓移植隔離病床(床/天)–護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03101B",
      "display" : "隔離病床(床/天)1.普通隔離病床–護理費(第一天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03102B",
      "display" : "隔離病床(床/天)2.正壓隔離病床–護理費(第一天)",
      "definition" : "指對免疫缺乏之重症患者，具有保護免於受外界感染源侵犯之特殊設計之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03103B",
      "display" : "隔離病床(床/天)3.負壓隔離病床–護理費(第一天)",
      "definition" : "指對患有具傳染性疾病之病人，能夠不讓其病源體散布於社區或醫院內之特殊設計之病床。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03104E",
      "display" : "加護病床(床/天)–護理費(第一天)",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03105F",
      "display" : "加護病床(床/天)–護理費(第一天)",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03106G",
      "display" : "加護病床(床/天)–護理費(第一天)",
      "definition" : "註：1.監視器、C.V.P.處理費等已包括在所訂點數內，不得另計。2.呼吸器、電擊、氧氣、C.V.P.置入及顱內壓監視置入等另按實際使用申報。3.使用加護病床病人以下列為限：1)急性心肌梗塞病人，不穩定型心絞痛或狹心症病人。2)急性心臟衰竭、急性腎臟衰竭、急性肝臟衰竭病人。3)急性呼吸衰竭、呼吸窘迫、間歇性呼吸暫停或重度窒息需積極呼吸治療病人。4)手術後仍需輔助性治療或生命徵象不穩定者。5)危命性不整脈(含心搏暫停後)病人。6)休克病人。7)嚴重新陳代謝及電解質、水分不平衡病人或內分泌異常需加強監視病人。8)急性中毒性昏迷病人。9)肝硬化性肝昏迷病人。10)胸腔外科、心臟外科及神經外科術後病人需加強醫療者。11)腦中風、腦膜炎、腦炎等腦病變急性期，合併意識障礙或昏迷者。12)癲癇重積症病人。13)急性顱內壓增高危及生命者。14)急性腦幹病變者。15)敗血症或疑敗血症且生命徵象不穩定者。16)新生兒黃膽過高需換血者。17)出生體重低於一千五百公克之極度早產兒。18)兒童進行高風險侵入性處置或手術，需加強監測或醫療者。19)其他危篤重症危及生命者。4.入住加護病房之病人如符合下列條件，應予轉出：1)血液動力學值穩定者(生命徵象、中心靜脈壓、肺動脈楔壓、心輸出量)。2)脫離呼吸器。3)病情穩定已不需使用特殊生理監測器者。4)合併症已穩定控制者。5)已脫離急性期不需加護醫療照護者。6)家屬要求自動出院者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICU"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04001A",
      "display" : "一般慢性精神病床住院照護費(床/天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04002B",
      "display" : "一般慢性精神病床住院照護費(床/天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04004C",
      "display" : "精神科日間住院治療費(日間全天)-成人",
      "definition" : "限經中央衛生主管機關精神醫療院所(科)評鑑合格且辦理日間住院業務者申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04007C",
      "display" : "精神科日間住院治療費(日間半天)-成人",
      "definition" : "限經中央衛生主管機關精神醫療院所(科)評鑑合格且辦理日間住院業務者申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04010A",
      "display" : "院外適應治療(天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04011B",
      "display" : "院外適應治療(天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04012C",
      "display" : "精神科日間住院治療費(日間全天)-六歲以上至未滿十六歲",
      "definition" : "限經中央衛生主管機關精神醫療院所(科)評鑑合格且辦理日間住院業務者申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04013C",
      "display" : "精神科日間住院治療費(日間全天)-未滿六歲",
      "definition" : "限經中央衛生主管機關精神醫療院所(科)評鑑合格且辦理日間住院業務者申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04014C",
      "display" : "精神科日間住院治療費(日間半天)-六歲以上至未滿十六歲",
      "definition" : "限經中央衛生主管機關精神醫療院所(科)評鑑合格且辦理日間住院業務者申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04015C",
      "display" : "精神科日間住院治療費(日間半天)-未滿六歲",
      "definition" : "限經中央衛生主管機關精神醫療院所(科)評鑑合格且辦理日間住院業務者申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05101B",
      "display" : "一般灌食(天)2500卡以下≦2500卡",
      "definition" : "註:一般管灌食之適用症1.因口腔、頭頸部外傷或疾病而吞食困難者，但無代謝改變，可以一般成份比例供應者。例如:口腔癌、下顎骨折、消化道灼傷、食道狹窄、食道切除、食道癌者。2.輕至中度灼傷、外傷以致無法經口進食或經口進食不足者3.因意識不清或昏迷無法控制進食，而無代謝改變，可以一般成份比例供應者。4.神經性厭食、習慣性嘔吐，輕至中度者。5.癌症病人進食不足或無法進食，但無代謝改變，可以一般成份比例供應者。6.免疫功能過低，需以無菌飲食供應者。7.胃造口或空腸造口等手術病患。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05102B",
      "display" : "一般灌食(天)超過2500卡>2500卡",
      "definition" : "一般管灌食之適用症1.因口腔、頭頸部外傷或疾病而吞食困難者，但無代謝改變，可以一般成份比例供應者。例如:口腔癌、下顎骨折、消化道灼傷、食道狹窄、食道切除、食道癌者。2.輕至中度灼傷、外傷以致無法經口進食或經口進食不足者3.因意識不清或昏迷無法控制進食，而無代謝改變，可以一般成份比例供應者。4.神經性厭食、習慣性嘔吐，輕至中度者。5.癌症病人進食不足或無法進食，但無代謝改變，可以一般成份比例供應者。6.免疫功能過低，需以無菌飲食供應者。7.胃造口或空腸造口等手術病患。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05103B",
      "display" : "營養成份調整配方灌食(天)2500卡以下≦2500卡",
      "definition" : "管灌進食病人需調整營養成份配方之適用症:1.便秘或長期臥床腸道功能不足者。2.腹瀉或敏感性腸症。3.純素食而需管灌飲食者。4.對牛奶蛋白過敏者。5.嚴重營養不良。6.神經性厭食症。7.中至重度灼傷或外傷。8.新陳代謝亢進或異化代謝期。(例如敗血症、癌症)9.外科手術後嚴重營養流失者。10.急、慢性腎衰竭。11.肝性腦病變。12.慢性阻塞性肺部疾病。13.呼吸衰竭。14.用呼吸器者。15.因壓力造成高血糖症或糖尿病者。16.胰臟炎、膽囊炎、膽道阻塞。17.慢性或中至重度脂肪痢。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05104B",
      "display" : "營養成份調整配方灌食(天)超過2500卡>2500卡",
      "definition" : "管灌進食病人需調整營養成份配方之適用症:1.便秘或長期臥床腸道功能不足者。2.腹瀉或敏感性腸症。3.純素食而需管灌飲食者。4.對牛奶蛋白過敏者。5.嚴重營養不良。6.神經性厭食症。7.中至重度灼傷或外傷。8.新陳代謝亢進或異化代謝期。(例如敗血症、癌症)9.外科手術後嚴重營養流失者。10.急、慢性腎衰竭。11.肝性腦病變。12.慢性阻塞性肺部疾病。13.呼吸衰竭。14.用呼吸器者。15.因壓力造成高血糖症或糖尿病者。16.胰臟炎、膽囊炎、膽道阻塞。17.慢性或中至重度脂肪痢。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05105B",
      "display" : "預解及元素食灌食(天)1000卡以下≦1000卡",
      "definition" : "管灌進食病人需部分水解配方之適用症:1.短腸症、小腸截腸、慢性發炎性腸疾病、腸道管。2.胰臟功能不全、廔管及膽汁缺乏等造成之嚴重脂肪痢頑固性腹瀉。3.其他經專案報准之個案。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05106B",
      "display" : "預解及元素食灌食(天)1001卡-2000卡",
      "definition" : "管灌進食病人需部分水解配方之適用症:1.短腸症、小腸截腸、慢性發炎性腸疾病、腸道管。2.胰臟功能不全、廔管及膽汁缺乏等造成之嚴重脂肪痢頑固性腹瀉。3.其他經專案報准之個案。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05107B",
      "display" : "預解及元素食灌食(天)>2000卡",
      "definition" : "管灌進食病人需部分水解配方之適用症:1.短腸症、小腸截腸、慢性發炎性腸疾病、腸道管。2.胰臟功能不全、廔管及膽汁缺乏等造成之嚴重脂肪痢頑固性腹瀉。3.其他經專案報准之個案。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05108B",
      "display" : "免疫調節管灌食(天)-1000卡以下≦1000卡",
      "definition" : "註:1.本項適用症如下，且使用至全身發炎徵候群消失，即行停止。(1)嚴重敗血症:臨床上懷疑或證實有感染，加上符合至少二項SIRS(全身性發炎反應徵候群)條件，及臨床上併有至少一個器官衰竭。(2)急性肺損傷:PaO2/FiO2<300mmHg(3)急性呼吸窘迫症:PaO2/FiO2<200mmHg2.實證醫學被証實的免疫配方內含EPA/GLA(含魚油、琉璃苣油和抗氧化劑等)等成分為主者。3.施行本項不得同時申報05101B、05102B、05103B、05104B、05105B、05106B、05107B。4.SIRS(全身性發炎反應症候群):四項條件如下。(1)體溫大於38℃或低於36℃。(2)心跳大於90次/每分鐘。(3)呼吸大於20/每分鐘或血中二氧化碳分壓小於32mmHg。(4)白血球總數高於12000/μL或低於4000/μL或不成熟的白血球比例高於10%。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05109B",
      "display" : "免疫調節管灌食(天)-1001卡-2000卡",
      "definition" : "註:1.本項適用症如下，且使用至全身發炎徵候群消失，即行停止。(1)嚴重敗血症:臨床上懷疑或證實有感染，加上符合至少二項SIRS(全身性發炎反應徵候群)條件，及臨床上併有至少一個器官衰竭。(2)急性肺損傷:PaO2/FiO2<300mmHg(3)急性呼吸窘迫症:PaO2/FiO2<200mmHg2.實證醫學被証實的免疫配方內含EPA/GLA(含魚油、琉璃苣油和抗氧化劑等)等成分為主者。3.施行本項不得同時申報05101B、05102B、05103B、05104B、05105B、05106B、05107B。4.SIRS(全身性發炎反應症候群):四項條件如下。(1)體溫大於38℃或低於36℃。(2)心跳大於90次/每分鐘。(3)呼吸大於20/每分鐘或血中二氧化碳分壓小於32mmHg。(4)白血球總數高於12000/μL或低於4000/μL或不成熟的白血球比例高於10%。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05110B",
      "display" : "免疫調節管灌食(天)->2000卡",
      "definition" : "註:1.本項適用症如下，且使用至全身發炎徵候群消失，即行停止。(1)嚴重敗血症:臨床上懷疑或證實有感染，加上符合至少二項SIRS(全身性發炎反應徵候群)條件，及臨床上併有至少一個器官衰竭。(2)急性肺損傷:PaO2/FiO2<300mmHg(3)急性呼吸窘迫症:PaO2/FiO2<200mmHg2.實證醫學被証實的免疫配方內含EPA/GLA(含魚油、琉璃苣油和抗氧化劑等)等成分為主者。3.施行本項不得同時申報05101B、05102B、05103B、05104B、05105B、05106B、05107B。4.SIRS(全身性發炎反應症候群):四項條件如下。(1)體溫大於38℃或低於36℃。(2)心跳大於90次/每分鐘。(3)呼吸大於20/每分鐘或血中二氧化碳分壓小於32mmHg。(4)白血球總數高於12000/μL或低於4000/μL或不成熟的白血球比例高於10%。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05151B",
      "display" : "加護病房營養照護費－初次照護費",
      "definition" : "1.適應症:(1)一歲以上且入住ICU超過二天之個案。(2)未滿一歲且入住ICU超過二天之個案，須由醫師會診。2.申報次數:每案入住ICU最多申報六次，同日內限申報一次。(1)七天內:限申報05151B一次、05152B最多二次。(2)超過七天部分:限申報05152B最多三次。(3)不得同時申報編號05151B、05152B。(4)同院不同ICU病房之入住天數須合併計算。3.執行人員資格:經中華民國營養師公會全國聯合會認證之營養師，並應報經保險人核定，如有異動，仍應重行報請核定。4.申報時應有營養照護紀錄於病歷備查，內容須涵蓋:(1)營養評估。(2)營養診斷及處置。(3)營養評值及追蹤。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05152B",
      "display" : "加護病房營養照護費－追蹤照護費",
      "definition" : "1.適應症:(1)一歲以上且入住ICU超過二天之個案。(2)未滿一歲且入住ICU超過二天之個案，須由醫師會診。2.申報次數:每案入住ICU最多申報六次，同日內限申報一次。(1)七天內:限申報05151B一次、05152B最多二次。(2)超過七天部分:限申報05152B最多三次。(3)不得同時申報編號05151B、05152B。(4)同院不同ICU病房之入住天數須合併計算。3.執行人員資格:經中華民國營養師公會全國聯合會認證之營養師，並應報經保險人核定，如有異動，仍應重行報請核定。4.申報時應有營養照護紀錄於病歷備查，內容須涵蓋:(1)營養評估。(2)營養診斷及處置。(3)營養評值及追蹤。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05201A",
      "display" : "門診藥事服務費－一般處方給藥(七天以內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05202B",
      "display" : "門診藥事服務費－每人每日八十件內-一般處方給藥(七天以內)-特約藥局(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05203C",
      "display" : "門診藥事服務費－每人每日八十件內一般處方給藥(七天以內)-基層院所藥事人員調劑(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05204D",
      "display" : "門診藥事服務費－一般處方給藥(七天以內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05205A",
      "display" : "門診藥事服務費－慢性病處方給藥十四至二十七天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05206B",
      "display" : "門診藥事服務費－每人每日八十件內-慢性病處方給藥十四至二十七天-特約藥局(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05207C",
      "display" : "門診藥事服務費－慢性病處方給藥十四至二十七天(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05208D",
      "display" : "門診藥事服務費－慢性病處方給藥十四至二十七天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05209A",
      "display" : "門診藥事服務費－慢性病處方給藥二十八天以上",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05210B",
      "display" : "門診藥事服務費－每人每日八十件內-慢性病處方給藥二十八天以上-特約藥局(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05211C",
      "display" : "門診藥事服務費－慢性病處方給藥二十八天以上(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05212D",
      "display" : "門診藥事服務費－慢性病處方給藥二十八天以上",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05213K",
      "display" : "住院藥事服務費(天)－非單一劑量處方",
      "definition" : "1.精神科日間住院病患申報藥事服務費，應以該病患實際日間住院治療之日數為限；至院外適應治療期間，不得再申報本項費用。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.精神科日間住院病患及留置急診處暫留床病患不得申報單一劑量藥事服務費。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05214A",
      "display" : "住院藥事服務費(天)—非單一劑量處方",
      "definition" : "1.精神科日間住院病患申報藥事服務費，應以該病患實際日間住院治療之日數為限；至院外適應治療期間，不得再申報本項費用。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.精神科日間住院病患及留置急診處暫留床病患不得申報單一劑量藥事服務費。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05215B",
      "display" : "住院藥事服務費(天)—非單一劑量處方",
      "definition" : "1.精神科日間住院病患申報藥事服務費，應以該病患實際日間住院治療之日數為限；至院外適應治療期間，不得再申報本項費用。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.精神科日間住院病患及留置急診處暫留床病患不得申報單一劑量藥事服務費。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05216K",
      "display" : "住院藥事服務費(天)－單一劑量處方",
      "definition" : "1.精神科日間住院病患申報藥事服務費，應以該病患實際日間住院治療之日數為限；至院外適應治療期間，不得再申報本項費用。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.精神科日間住院病患及留置急診處暫留床病患不得申報單一劑量藥事服務費。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05217A",
      "display" : "住院藥事服務費(天)—單一劑量處方",
      "definition" : "1.精神科日間住院病患申報藥事服務費，應以該病患實際日間住院治療之日數為限；至院外適應治療期間，不得再申報本項費用。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.精神科日間住院病患及留置急診處暫留床病患不得申報單一劑量藥事服務費。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05218B",
      "display" : "住院藥事服務費(天)—單一劑量處方",
      "definition" : "1.精神科日間住院病患申報藥事服務費，應以該病患實際日間住院治療之日數為限；至院外適應治療期間，不得再申報本項費用。2.留置急診處暫留床二日以上者，自第二天起比照申報。3.精神科日間住院病患及留置急診處暫留床病患不得申報單一劑量藥事服務費。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05219B",
      "display" : "放射性藥品處方之藥事服務費(天)",
      "definition" : "凡設置核子醫學部或核醫科，使用放射性同位素(如口服I-131以及其他身體各部位之檢查所需之放射線製劑均屬之)，且調劑藥師具有放射性物質操作執照，於核醫科特殊配製環境內調配，及申報本標準第二部第二章第一節第二十項核子醫學檢查一、「造影」所列項目(排除「26009B甲狀腺刺激素試驗」、「26049B核子斷層檢查術」、「26074C碘-131癌症追蹤檢查-施打Thyrogen」及「26078A鐳223治療處置費」四項)時，得申報本項。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05220A",
      "display" : "全靜脈營養注射劑處方之藥事服務費(天)",
      "definition" : "1.限設有經「台灣靜脈暨腸道營養學會」認定合格之「營養醫療小組」之特約醫院申報。2.需為TPN處方，指含有胺基酸、碳水化合物、維生素及微量元素之重新混合注射劑，並於無菌環境中依無菌調配操作標準調配。3.屬三合一營養注射劑之處方組合品項不得申報本項。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TPN"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05221A",
      "display" : "化學腫瘤藥品處方之藥事服務費(天)",
      "definition" : "註:在層流工作檯內操作或調配之化學腫瘤藥品〈係指所有細胞毒(cytoxic)藥品針劑、非單一劑量包裝之口服細胞毒藥品及生物毒藥品類等〉者得申報本項，惟不包括藥廠製造之一般口服或外用化學腫瘤等，無需在層流工作檯調配之成品製劑者。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05222A",
      "display" : "門診藥事服務費-慢性病處方給藥十三天以內",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05223B",
      "display" : "門診藥事服務費-每人每日八十件內-慢性病處方給藥十三天以內-特約藥局(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05224C",
      "display" : "門診藥事服務費-每人每日八十件內-慢性病處方給藥十三天以內-基層院所藥事人員調劑(山地離島地區每人每日一百件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05225D",
      "display" : "門診藥事服務費-慢性病處方給藥十三天以內",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05226B",
      "display" : "門診藥事服務費-一般處方給藥(七天以內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05227B",
      "display" : "門診藥事服務費—慢性病處方給藥十三天以內",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05228B",
      "display" : "門診藥事服務費－慢性病處方給藥十四至二十七天",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05229B",
      "display" : "門診藥事服務費－慢性病處方給藥二十八天以上",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05234D",
      "display" : "門診藥事服務費(診所自聘藥事人員及藥局部分)每人每日八十一至一百件內(山地離島地區每人每日一百零一至一百二十件內)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05235B",
      "display" : "特殊輸注液處方藥事服務費(天)",
      "definition" : "1.非重新組合之TPN混合注射劑僅添加少量微量元素或維生素者得申報本項。2.須於無菌環境中調配。3.本項適應症如下:限水病患、透析病患、新生兒及小兒血液腫瘤科病患或其他經專業認定須自行調配特殊輸注液之個案，且無市售品項可供使用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05301C",
      "display" : "護理訪視費(次)-資源耗用群為第一類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05302C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群第一類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05303C",
      "display" : "護理訪視費(次)-資源耗用群為第二類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05303CA",
      "display" : "呼吸治療人員訪視費",
      "definition" : "行政院衛生福利部以89年5月2日衛署89021187號函核定本署所送「全民健康保險呼吸器依賴患者整合性照護前膽性支付方式」試辦計畫。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05304C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第二類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05305C",
      "display" : "護理訪視費(次)-資源耗用群第三類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05306C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第三類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05307C",
      "display" : "醫師訪視費(次)1.在宅",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05308C",
      "display" : "山地離島地區醫師訪視費(次)1.在宅",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05309C",
      "display" : "醫師訪視費(次)1.在宅－同一醫師，應同一承辦居家照護業務機構之請，當日訪視個案在五個以上者，自第五個個案起，其訪視費依本項申報",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05310C",
      "display" : "山地離島地區醫師訪視費(次)1.在宅－山地離島地區同一醫師，應同一承辦居家照護業務機構之請，當日訪視個案在五個以上者，自第五個個案起，其訪視費依本項申報",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05312C",
      "display" : "甲類醫師訪視費用(次)-在宅",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05313C",
      "display" : "甲類護理訪視費(次)-在宅:訪視時間1小時以內(≦1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05314C",
      "display" : "甲類護理訪視費(次)-在宅:訪視時間1小時以上(>1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05315C",
      "display" : "其他專業人員處置費(次)-在宅:目前僅限於社會工作人員或心理師",
      "definition" : "1.現暫定為社會工作人員或心理師。訪視次數每一個案每週以乙次為原則，若病人病情有顯著變化，需要多於每週乙次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位專業人員每月訪視次數以45次為限。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05316C",
      "display" : "病患自控式止痛處置及材料費(Patient-ControlledAnagesia,PCA)",
      "definition" : "1.所訂點數含PCA幫浦注射費、PCA裝置(set)、PCA袋(bag)等。2.每一個案每月限申報2次。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05321C",
      "display" : "護理訪視費(次)-資源耗用群為第四類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05322C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第四類(在合理量內)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05323C",
      "display" : "甲類醫師訪視費用–山地離島地區(次)-在宅",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05324C",
      "display" : "甲類護理訪視費(次)-在宅:訪視時間1小時以內(≦1小時)-山地離島地區",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05325C",
      "display" : "甲類護理訪視費(次)-在宅:訪視時間1小時以上(>1小時)–山地離島地區",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05326C",
      "display" : "臨終病患訪視費",
      "definition" : "註:1.限訪視臨終病人，且ECOG三級以上之病人，實際訪視時間在二小時以上，始得申報此項費用，每位病人申報訪視次數僅限一次。2.甲乙兩類醫事人員皆可申報。3.服務內容需包含臨終訪視、善終準備及家屬哀傷輔導等。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05327C",
      "display" : "臨終病患訪視費山地離島地區",
      "definition" : "註:1.限訪視臨終病人，且ECOG三級以上之病人，實際訪視時間在二小時以上，始得申報此項費用，每位病人申報訪視次數僅限一次。2.甲乙兩類醫事人員皆可申報。3.服務內容需包含臨終訪視、善終準備及家屬哀傷輔導等。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05328C",
      "display" : "護理訪視費(次)-資源耗用群為第一類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05329C",
      "display" : "山地離島地區護理訪視費(次)–資源耗用群第一類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05330C",
      "display" : "護理訪視費(次)-資源耗用群為第二類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05331C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第二類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05332C",
      "display" : "護理訪視費(次)-資源耗用群第三類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05333C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第三類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05334C",
      "display" : "護理訪視費(次)-資源耗用群為第四類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "05335C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第四類(超出合理量)1.在宅",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05336C",
      "display" : "乙類醫師訪視費用(次)-在宅",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05337C",
      "display" : "乙類醫師訪視費用山地離島地區(次)-在宅",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05338C",
      "display" : "乙類護理訪視費(次)-在宅:訪視時間1小時以內(≦1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05339C",
      "display" : "乙類護理訪視費山地離島地區(次)-在宅:訪視時間1小時以內(≦1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05340C",
      "display" : "乙類護理訪視費(次)-在宅:訪視時間1小時以上(>1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05341C",
      "display" : "乙類護理訪視費山地離島地區(次)-在宅:訪視時間1小時以上(>1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。※屬居整計畫案件者，其訪視次數依居整計畫規定辦理。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05342C",
      "display" : "護理訪視費(次)-資源耗用群為第一類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05343C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群第一類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05344C",
      "display" : "護理訪視費(次)-資源耗用群為第一類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05345C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群第一類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05346C",
      "display" : "護理訪視費(次)-資源耗用群為第二類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05347C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第二類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05348C",
      "display" : "護理訪視費(次)-資源耗用群為第二類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05349C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第二類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05350C",
      "display" : "護理訪視費(次)-資源耗用群第三類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05351C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第三類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05352C",
      "display" : "護理訪視費(次)-資源耗用群第三類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05353C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第三類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05354C",
      "display" : "護理訪視費(次)-資源耗用群為第四類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05355C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第四類(在合理量內)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05356C",
      "display" : "護理訪視費(次)-資源耗用群為第四類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05357C",
      "display" : "山地離島地區護理訪視費(次)-資源耗用群為第四類(超出合理量)2.機構",
      "definition" : "1.資源耗用群分類:第一類:需居家護理一般照護項目之病人。第二類:需居家護理特殊照護群組任一組之病人。第三類:需居家護理特殊照護群組任二組之病人。第四類:需居家護理特殊照護群組任三組及以上之病人。2.所訂點數含訪視、護理服務、治療處置、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。3.上項代採之檢體，委託代檢機構應以保險醫事服務機構或保險人指定之醫事檢驗機構為限。4.視訪時間應記錄於訪視紀錄內，並請患者或其家屬簽章。5.訪視次數每一個案每月以二次為限，出院後新收個案當次之訪視，不計算於當月訪視次數內；依病情需要多於二次者，申報費用時應檢附護理計畫，並詳述理由。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05358C",
      "display" : "醫師訪視費(次)2.機構",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05359C",
      "display" : "山地離島地區醫師訪視費(次)2.機構",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "05360C",
      "display" : "醫師訪視費(次)2.機構－同一醫師，應同一承辦居家照護業務機構之請，當日訪視個案在五個以上者，自第五個個案起，其訪視費依本項申報",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05361C",
      "display" : "山地離島地區醫師訪視費(次)2.機構－山地離島地區同一醫師，應同一承辦居家照護業務機構之請，當日訪視個案在五個以上者，自第五個個案起，其訪視費依本項申報",
      "definition" : "1.訪視次數每一個案至少每三個月訪視一次，每二個月申報一次為限，若病人病情有顯著變化，需要多於一次者，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師訪視個案數，每日以八人次為原則；每月以一百八十人次為限。3.訪視醫師，以與保險人特約之保險醫事服務機構之醫師為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05362C",
      "display" : "甲類醫師訪視費用(次)-機構",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05363C",
      "display" : "甲類醫師訪視費用–山地離島地區(次)-機構",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05364C",
      "display" : "乙類醫師訪視費用(次)-機構",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05365C",
      "display" : "乙類醫師訪視費用山地離島地區(次)-機構",
      "definition" : "1.訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位醫師每月訪視次數以四十五次為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05366C",
      "display" : "甲類護理訪視費(次)-機構:訪視時間1小時以內(≦1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05367C",
      "display" : "甲類護理訪視費(次)-機構:訪視時間1小時以內(≦1小時)-山地離島地區",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05368C",
      "display" : "乙類護理訪視費(次)-機構:訪視時間1小時以內(≦1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05369C",
      "display" : "乙類護理訪視費山地離島地區(次)-機構:訪視時間1小時以內(≦1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05370C",
      "display" : "甲類護理訪視費(次)-機構:訪視時間1小時以上(>1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05371C",
      "display" : "甲類護理訪視費(次)-機構:訪視時間1小時以上(>1小時)–山地離島地區",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05372C",
      "display" : "乙類護理訪視費(次)-機構:訪視時間1小時以上(>1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05373C",
      "display" : "乙類護理訪視費山地離島地區(次)-機構:訪視時間1小時以上(>1小時)",
      "definition" : "1.護理人員訪視次數每一個案每週以二次為原則，若病人病情有顯著變化，需要多於每週二次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位護理人員每月訪視次數以四十五次為限。3.護理訪視費所訂點數含訪視、護理服務、治療處置、代取藥、代採檢體及送檢之檢查費、治療材料及電子資料處理等費用在內。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05374C",
      "display" : "其他專業人員處置費(次)-機構:目前僅限於社會工作人員或心理師",
      "definition" : "1.現暫定為社會工作人員或心理師。訪視次數每一個案每週以乙次為原則，若病人病情有顯著變化，需要多於每週乙次者，申報費用時應檢附訪視記錄，並詳述理由。2.每位專業人員每月訪視次數以45次為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05401C",
      "display" : "精神復健機構(日間型機構)之復健治療(天)",
      "definition" : "100年1月27日第1次「全民健康保險醫療給付協議會議」討論第1案同意調整支付標準代碼05401C「精神復健機構(日間型機構)之復健治療」支付點數由450點調整為480點並溯自100年1月1日起施行",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05402C",
      "display" : "精神復健機構(住宿型機構)全日之復健治療(天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05403C",
      "display" : "精神復健機構(住宿型機構)夜間之復健治療(天)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05404C",
      "display" : "居家治療醫師診治費(次)",
      "definition" : "1.診治費每一個案每人每月以二次為原則，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師診治個案數，每日以八個為限；每月以二百四十個為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05405C",
      "display" : "居家治療醫師診治費-同一醫師，應同一承辦居家治療業務之醫療機構之請，當日診治個案數在五個以上者，自第五個個案起其診治費依本項申報。",
      "definition" : "1.診治費每一個案每人每月以二次為原則，申報費用時應檢附訪視紀錄，並詳述理由。2.每位醫師診治個案數，每日以八個為限；每月以二百四十個為限。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05406C",
      "display" : "居家治療其他專業人員處置費(次)",
      "definition" : "註:處置費每一個案每月以二次為限,申報費用時應檢附訪視紀錄。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05601K",
      "display" : "安寧住院照護費(每日)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05602A",
      "display" : "安寧住院照護費(每日)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05603B",
      "display" : "安寧住院照護費(每日)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06001C",
      "display" : "酸鹼度反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "pH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06002C",
      "display" : "比重檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sp.gr (specific gravity)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06003C",
      "display" : "尿蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine protein"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06004C",
      "display" : "尿糖",
      "definition" : "尿糖試紙檢查比照申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine sugar"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06005C",
      "display" : "尿膽素原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine urobilinogen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06006C",
      "display" : "尿膽紅素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine bilirubin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06007C",
      "display" : "尿酮體",
      "definition" : "血中丙酮檢查比照申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ketone body"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06008C",
      "display" : "班尼迪克特反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "Benedict reaction"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06009C",
      "display" : "尿沉渣",
      "definition" : "包括紅血球、白血球、圓柱體、上皮細胞、粘液、淋巴球、寄生虫等無染色標本檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine Sediments"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06010C",
      "display" : "本周氏蛋白試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bence Jones protein"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06011B",
      "display" : "乳糜尿之確定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chyuria"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06012C",
      "display" : "尿一般檢查(包括蛋白、糖、尿膽元、膽紅素、尿沈渣、比重、顏色、混濁度、白血球酯脢、潛血、酸鹼度及酮體)",
      "designation" : [
        {
          "language" : "en",
          "value" : "General urine examination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06013C",
      "display" : "尿生化檢查(包括蛋白、糖、尿膽元、膽紅素、比重、顏色、混濁度、酸鹼度、白血球酯脢及酮體)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine biochemistry examination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06014B",
      "display" : "酸鹼度(酸鹼儀)",
      "designation" : [
        {
          "language" : "en",
          "value" : "pH by pH meter"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06015C",
      "display" : "亞硝酸鹽檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nitrite"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06016B",
      "display" : "脂肪染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fat stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06017B",
      "display" : "白血球酯脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Leukocyte rsterase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06503B",
      "display" : "尿滲透壓檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine-osmolarity test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06504C",
      "display" : "懷孕試驗－乳膠凝集法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pregnancy test -Latex agglutination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06505C",
      "display" : "懷孕試驗－酵素免疫法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pregnancy test -EIA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06508B",
      "display" : "紫質類檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Porphyrin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06509B",
      "display" : "Porphobilinogen檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Porphobilinogen test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06510C",
      "display" : "巴拉刈定性檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Paraquet (qualitative) test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06511C",
      "display" : "四次尿糖",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine Sugar (4 timed specimens)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06512B",
      "display" : "尿液糞紫質檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coproporphyrin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06513B",
      "display" : "尿液新陳代謝障礙檢測",
      "designation" : [
        {
          "language" : "en",
          "value" : "CNP, DNPH, AAT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07001C",
      "display" : "糞便潛血化學法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occult blood(chemical method)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07002C",
      "display" : "糞便中膽紅素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stool bilirubin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07003C",
      "display" : "阿米巴檢驗(直接法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amoeba (direct smear)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07004C",
      "display" : "澱粉質染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "Starch stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07005C",
      "display" : "中性脂肪染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "Neutral fat stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07006C",
      "display" : "脂肪酸染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fatty acid stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07007C",
      "display" : "酸鹼值",
      "designation" : [
        {
          "language" : "en",
          "value" : "PH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07008C",
      "display" : "糞便中尿膽素原",
      "definition" : "93.6.14健保醫字第0930060063號公告中文名稱修正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stool urobilinogen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07009C",
      "display" : "糞便一般檢查(包括外觀、蟲卵、潛血反應、硬度、顏色、消化能力、紅、白血球、粘液等)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stool routine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07010B",
      "display" : "胰蛋白酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Trypsin test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07011C",
      "display" : "寄生蟲卵－直接抹片檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parasite ova- direct smear"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07012C",
      "display" : "寄生蟲卵－濃縮法",
      "definition" : "93.6.14健保醫字第0930060063號公告英文名稱修正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parasite ova-conc. method of ova"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07013C",
      "display" : "寄生蟲卵－計數法",
      "definition" : "含培養費用",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parasite ova-count/gram"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07015C",
      "display" : "還原物質測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Reducing substances"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "07016C",
      "display" : "蟯蟲膠片",
      "designation" : [
        {
          "language" : "en",
          "value" : "Perianal swab for pinwarm"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07017B",
      "display" : "APT檢測試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "APT test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07018C",
      "display" : "糞便白血球檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stool WBC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08001C",
      "display" : "紅血球計數",
      "designation" : [
        {
          "language" : "en",
          "value" : "R.B.C"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08002C",
      "display" : "白血球計數",
      "designation" : [
        {
          "language" : "en",
          "value" : "W.B.C"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08003C",
      "display" : "血色素檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hemoglobin (Hb)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08004C",
      "display" : "血球比容值測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hematocrite (Hct)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08005C",
      "display" : "紅血球沈降速度測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "E.S.R.(Erythrocyte sedimentation rate)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08006C",
      "display" : "血小板計數",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelet count"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08007C",
      "display" : "血中寄生蟲檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parasite (malaria or filaria)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08008C",
      "display" : "網狀紅血球計數",
      "designation" : [
        {
          "language" : "en",
          "value" : "Reticulocyte count"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08009C",
      "display" : "紅血球形態",
      "designation" : [
        {
          "language" : "en",
          "value" : "RBC morphology"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08010C",
      "display" : "嗜酸性白血球計算",
      "designation" : [
        {
          "language" : "en",
          "value" : "Eosinophil count"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08011C",
      "display" : "全套血液檢查Ｉ(八項)",
      "designation" : [
        {
          "language" : "en",
          "value" : "CBC-I(WBC,RBC,HB,HCT,PLATELET COUNT,MCV,MCH,MCHC)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08012C",
      "display" : "全套血液檢查Ⅱ(七項)",
      "designation" : [
        {
          "language" : "en",
          "value" : "CBC-Ⅱ(WBC、RBC、Hb、Hct、MCV、MCH、MCHC)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08013C",
      "display" : "白血球分類計數",
      "designation" : [
        {
          "language" : "en",
          "value" : "WBC differential count"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08014C",
      "display" : "血液一般檢查(白血球，紅血球及血色素)",
      "definition" : "同時實施此三項檢查，須以此項申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blood routine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08015C",
      "display" : "紅斑性狼瘡細胞",
      "designation" : [
        {
          "language" : "en",
          "value" : "LE cell preparation (Lupus-Erythromatosus)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08016C",
      "display" : "紅斑性狼瘡因子",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "LE factor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08017B",
      "display" : "血清黏度",
      "designation" : [
        {
          "language" : "en",
          "value" : "Serum viscosity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08018C",
      "display" : "出血時間",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bleeding time (Duke method)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08019C",
      "display" : "出血時間",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bleeding time (Ivy method)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08020C",
      "display" : "凝血時間",
      "designation" : [
        {
          "language" : "en",
          "value" : "Clotting time, coagulation time(Lee-White method)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08021C",
      "display" : "血塊收縮試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Clot retraction test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08022B",
      "display" : "纖維蛋白原測定(定性)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fibrinogen (qualitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08023B",
      "display" : "纖維蛋白原測定(定量)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fibrinogen (quantitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08024B",
      "display" : "纖維蛋白原測定(免疫比濁法)",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fibrinogen (Nephelometry)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08025B",
      "display" : "凝血脢時間",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thrombin time"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08026C",
      "display" : "凝血酶原時間(一段式)",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prothrombin time"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08027B",
      "display" : "骨髓細胞形態判讀",
      "definition" : "1.Hematopathology2.淋巴檢查比照申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bone marrow cells morphology interpretation"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08028B",
      "display" : "胚胎血色素量值",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hb F quantitation (fetal Hb)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08029B",
      "display" : "Ｈ血紅素檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告中文名稱修正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hb H preparation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08030C",
      "display" : "血紅素電泳",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hb electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08031B",
      "display" : "紅血球脆性試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "RBC fragility"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08032B",
      "display" : "漢姆斯酸性血清試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acid Ham test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08033B",
      "display" : "自動溶血試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Autohemolysis test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08034B",
      "display" : "毛細管抵抗測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Capillary fragility test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08035C",
      "display" : "血漿凝固時間",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasma clotting time"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08036C",
      "display" : "部分凝血活酶時間",
      "definition" : "註：屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "APTT (activated partial thromboplastin time)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08037B",
      "display" : "纖維蛋白降解產物－定性",
      "designation" : [
        {
          "language" : "en",
          "value" : "FDP (fibrin degradation product) -qualitative"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08038B",
      "display" : "纖維蛋白降解產物－定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "FDP (fibrin degradation product) -quantitative"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08039B",
      "display" : "半定量血塊收縮試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Semiquantitative clot retraction"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08040B",
      "display" : "變性血色素檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Methemoglobin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08041B",
      "display" : "糖水試驗",
      "definition" : "含半定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sugar water test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08042C",
      "display" : "骨髓鐵染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "B.M. iron stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08043C",
      "display" : "蘇丹Ｂ染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "B.M. Sudan black B stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08044B",
      "display" : "白血球鹼性磷酸解酶染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "LAP stain (leukocyte-alkaline phosphatase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08045B",
      "display" : "凝塊溶解試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Clot lysis test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08046B",
      "display" : "硫酸魚精蛋白副凝固試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "3P test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08047B",
      "display" : "過氧化酶染色",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "B.M. peroxidase stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08048B",
      "display" : "特異性酯酶染色",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Specific esterase stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08049B",
      "display" : "非特異性酯酶染色",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nonspecific esterase stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08050B",
      "display" : "酸性磷酸酶染色",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acid phosphatase stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08051B",
      "display" : "肝糖染色試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PAS (periodic acid schiff) stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08052B",
      "display" : "胚胎血色素染色",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Betke stain (fetal Hb)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08053B",
      "display" : "漢斯氏體染色",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Heinz body stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08054B",
      "display" : "血色素A2測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hemoglobin A2 (Hb-A2)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08055B",
      "display" : "凝血酶原消耗試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prothrombin consumption test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08056B",
      "display" : "部份凝血激素取代試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PTT substitution test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08057B",
      "display" : "第二因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor Ⅱ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08058B",
      "display" : "第五因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor Ⅴ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08059B",
      "display" : "第七因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor Ⅶ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08060B",
      "display" : "第八因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor Ⅷ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08061B",
      "display" : "第九因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor Ⅸ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08062B",
      "display" : "第十因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor Ⅹ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08063B",
      "display" : "尿素溶解試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urea solubility test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08064B",
      "display" : "凝血酶原轉化試驗(包括測Ⅲ、Ⅶ、Ⅹ)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prothrombin-proconvertin test (P&P)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08065B",
      "display" : "終端去氧轉化酶染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "TdT(terminal deoxy-transferase stain)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08066B",
      "display" : "優球蛋白溶解時間",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Euglobulin clot lysis test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08067B",
      "display" : "第八因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor Ⅷ inhibitor test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08068B",
      "display" : "凝血酶時間矯正試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別，中文名稱修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thrombin time correction test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08069B",
      "display" : "血小板凝集試驗",
      "definition" : "包括ADP，collagen(膠原)及epinephrin(腎上腺素)等三項以上。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelet aggregation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08070B",
      "display" : "血小板留滯試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelet retention test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08071B",
      "display" : "細胞化學染色",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cytochemical stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08072B",
      "display" : "抗凝血Ⅲ",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "AT Ⅲ (antithrombin)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08073B",
      "display" : "IsopropanolHRstabilitytest",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Isopropanol HR stability test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08074B",
      "display" : "活化再鈣化凝血時間",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ART"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08075C",
      "display" : "血液滲透壓",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blood osmolality"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08076B",
      "display" : "鋅化原紫質檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "ZPP (zincprotoporphrin)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08077B",
      "display" : "蛋白C",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Protein C"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08078B",
      "display" : "α2抗胞漿素",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "α-2-Antiplasmin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08079B",
      "display" : "D雙合體試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "D dimer test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08080B",
      "display" : "第十一因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "FactorＸⅠ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08081B",
      "display" : "第十二因子測定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "FactorＸⅡ assay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08082C",
      "display" : "全套血液檢查III(五項)",
      "designation" : [
        {
          "language" : "en",
          "value" : "CBC-Ⅲ(WBC、RBC、HB、HCT、MCV)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08083C",
      "display" : "平均紅血球血紅素量",
      "definition" : "不得與08011C、08012C重複申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "MCH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08084C",
      "display" : "平均紅血球血紅素濃度",
      "definition" : "不得與08011C、08012C重複申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "MCHC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08085B",
      "display" : "血漿黏度",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasma viscosity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08086B",
      "display" : "全血黏度",
      "designation" : [
        {
          "language" : "en",
          "value" : "Whole blood viscosity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08087B",
      "display" : "尿液纖維蛋白原分解物含量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine fibrinogen degeneration product (Urine FDP)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08088B",
      "display" : "混合性凝血酶原時間",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mixing PT"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "08089B",
      "display" : "活化凝血時間",
      "definition" : "不得合併施行08026C及08036C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ACT test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08090B",
      "display" : "血漿血色素電泳",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasma hemoglobin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08091B",
      "display" : "等電點血色素電泳分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Isoelectric hemoglobin electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08092B",
      "display" : "混合性部份凝血活酶時間",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mixed APTT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08093B",
      "display" : "不穩定性血紅素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Unstable hemoglobin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08094B",
      "display" : "尿甘酸化物酶染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "Beta-glucuronidase stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08095B",
      "display" : "第二因子抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 2 antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08096B",
      "display" : "第五因子抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 5 antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08097B",
      "display" : "第七因子抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 7 antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08098B",
      "display" : "第十二因子抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 12 antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08099B",
      "display" : "第十三因子抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 13 antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08100B",
      "display" : "第二因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 2 inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08101B",
      "display" : "第五因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 5 inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08102B",
      "display" : "第七因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 7 inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08103B",
      "display" : "第九因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 9 inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08104B",
      "display" : "第十因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 10 inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08105B",
      "display" : "第十一因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 11 inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08106B",
      "display" : "第十二因子之抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Factor 12 inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08107B",
      "display" : "G型免疫球蛋白次群定量",
      "definition" : "含IgG1、IgG2、IgG3、IgG4",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgG subclass"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08109B",
      "display" : "蛇毒素試驗時間",
      "designation" : [
        {
          "language" : "en",
          "value" : "Reptilase time"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08111B",
      "display" : "輔因子活力",
      "definition" : "適應症為凝血異常，疑有Von-willebrandsdisease者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ristocetin cofactor activity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08112B",
      "display" : "血小板第三因子呈現試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelat factor-3 availbility test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08113B",
      "display" : "血小板第四因子呈現試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelat factor 4 test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08114B",
      "display" : "β-血凝球蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "β-tromboglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08115B",
      "display" : "血栓質生成試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Throm. gener. Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08116B",
      "display" : "組織胞漿素元活化因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "TPA (Tissue-type plaseminogen activator)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08117B",
      "display" : "胞質素元活化因子抑制劑",
      "designation" : [
        {
          "language" : "en",
          "value" : "PAI-1"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08118B",
      "display" : "Vonwillebrandfactor",
      "designation" : [
        {
          "language" : "en",
          "value" : "Von willebrand factor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08119B",
      "display" : "黏著試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Adhesion test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08120B",
      "display" : "凝血酵素碎片1+2",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prothrombin fragment 1+2"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08122B",
      "display" : "蛋白S",
      "designation" : [
        {
          "language" : "en",
          "value" : "Protein S"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08123B",
      "display" : "蛋白C抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Protein C Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08124B",
      "display" : "蛋白S抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Protein S Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08125B",
      "display" : "血中肝素濃度測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Heparin level"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08126B",
      "display" : "狼瘡抗凝血因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lupus anticoagulant test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08127C",
      "display" : "平均紅血球容積",
      "definition" : "不得與08011C、08012C、08082C重複申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "MCV"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08128B",
      "display" : "骨髓細胞形態判讀合併細胞分類計數",
      "definition" : "1.Hematopathology2.淋巴檢查比照申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bone marrow cells morphology interpretation and differential counting"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08129C",
      "display" : "胰島素血清檢驗",
      "definition" : "93.6.14健保醫字第0930060063號公告增列本項。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08130C",
      "display" : "骨質特異性鹼性磷酸酶",
      "definition" : "適應症同33064B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bone-alkaline phosphatase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08131C",
      "display" : "血小板功能閉鎖時間-膠原蛋白/腎上腺素",
      "definition" : "註：不得與08018C、08019C、08069B同時申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelet function closure time-Col/Epi"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08132C",
      "display" : "血小板功能閉鎖時間-膠原蛋白/二磷酸腺苷酸",
      "definition" : "註：不得與08018C、08019C、08069B同時申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelet function closure time-Col/ADP"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08133B",
      "display" : "胱蛋白C",
      "definition" : "適應症：1.第一型及第二型糖尿病患者腎臟功能監測2.腎臟移植病患腎功能監測3.具急性腎衰竭風險者之早期腎功能監測。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cystatin C"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08134B",
      "display" : "連續血糖監測",
      "definition" : "1.適應症：(1)第一型糖尿病(領有重大傷病證明)、新生兒糖尿病，或因Near-totalpancreatectomy所致糖尿病等個案，且須符合下列任一條件：A.血糖過度起伏且最近六個月二次醣化血紅素(HbA1c)值都大於(含)8%。B.低血糖無感症。C.常有嚴重低血糖，須他人協助治療，最近三個月有因低血糖曾至急診診治或住院。D.懷孕。(2)懷孕之第二型糖尿病或妊娠糖尿病，且接受胰島素注射者。(3)肝醣儲積症第零型、第一型、第三型、第六型、第九型，有嚴重低血糖病史或仍持續使用玉米粉治療者。2.支付規範：(1)門診使用，一年至多執行二次，且間隔一個月以上。如一年執行超過二次者，應事前審查。(2)住院使用應事前審查。一年至多執行二次，且間隔一個月以上。(3)限糖尿病共同照護網醫療機構申報，執行檢查人員和判讀醫師、營養師、衛教師必須參加過有關連續血糖監測之訓練課程。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Continuous glucose monitoring"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09001C",
      "display" : "總膽固醇",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cholestero1, total"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09002C",
      "display" : "血中尿素氮",
      "designation" : [
        {
          "language" : "en",
          "value" : "BUN, blood urea nitrogen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09003C",
      "display" : "尿素氮、尿",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urea-N (urine)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09004C",
      "display" : "三酸甘油脂",
      "definition" : "93.6.14健保醫字第0930060063號公告中文名稱修正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Triglyceride (TG)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09005C",
      "display" : "血液及體液葡萄糖-空腹",
      "definition" : "1.空腹血糖係指飯前空腹八小時；餐後血糖係指飯後二小時或喝完糖水二小時(依進食時開始計時)。2.尿液除外。3.同次門診以申報一次為限。4.下列情形須於病歷註明理由備查：(1)急診病人未符合上述時間條件，惟因病情需要執行者，得以09140C申報。(2)空腹與餐後二項同時申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Glucose-Ante Cibum, AC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09006C",
      "display" : "醣化血紅素",
      "designation" : [
        {
          "language" : "en",
          "value" : "HbA1c (Hemoglobin A1c)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09008B",
      "display" : "酚磺鈦",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.S.P.(Phenol-sulfon-phthalein)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09009C",
      "display" : "三碘甲狀腺原氨酸攝取率",
      "designation" : [
        {
          "language" : "en",
          "value" : "T3 Uptake Ratio"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09010C",
      "display" : "四碘甲狀腺素生化法",
      "designation" : [
        {
          "language" : "en",
          "value" : "T4"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09011C",
      "display" : "鈣",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ca (Calcium)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09012C",
      "display" : "磷",
      "designation" : [
        {
          "language" : "en",
          "value" : "P (Phosphoras)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09013C",
      "display" : "尿酸",
      "designation" : [
        {
          "language" : "en",
          "value" : "Uric acid"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09014C",
      "display" : "肌氨酸",
      "designation" : [
        {
          "language" : "en",
          "value" : "Creatin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09015C",
      "display" : "肌酸酐、血",
      "designation" : [
        {
          "language" : "en",
          "value" : "Creatinine (B) CRTN"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09016C",
      "display" : "肌酐、尿",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Creatinine (U) CRTN"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09017C",
      "display" : "澱粉脢、血",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amylase (B)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09018B",
      "display" : "粘性蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mucoprotein"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09019B",
      "display" : "ｒ-球蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "r-globulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09020C",
      "display" : "鐵",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fe (Iron-bound)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09021C",
      "display" : "鈉",
      "designation" : [
        {
          "language" : "en",
          "value" : "Na (Sodium)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09022C",
      "display" : "鉀",
      "designation" : [
        {
          "language" : "en",
          "value" : "K(Potassium)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09023C",
      "display" : "氯",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cl (Chloride)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09024C",
      "display" : "二氧化碳",
      "designation" : [
        {
          "language" : "en",
          "value" : "Carbon dioxide"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09025C",
      "display" : "血清麩胺酸苯醋酸轉氨基脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "S-GOT/AST"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09026C",
      "display" : "血清麩胺酸丙酮酸轉氨基脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "S-GPT/ALT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09027C",
      "display" : "鹼性磷酯酶",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂中英文名稱，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Alkaline phosphatase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09028C",
      "display" : "酸性磷酯酶",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acid phosphatase"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09029C",
      "display" : "膽紅素總量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bilirubin total"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09030C",
      "display" : "直接膽紅素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bilirubin direct"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09031C",
      "display" : "麩胺轉酸脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "r-GT(r-glutamyl transferase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09032C",
      "display" : "肌酸磷化脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "CPK(Creatine-phospho-kinase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09033C",
      "display" : "乳酸脫氫脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "LDH(Lactic dehydrogenase)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09034B",
      "display" : "酚四溴鈉試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "BSP45' (Sulfobromophthalein)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09035C",
      "display" : "總鐵結合能力",
      "designation" : [
        {
          "language" : "en",
          "value" : "TIBC(Total Iron Binding Capacity)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09036B",
      "display" : "腦燐脂膽固醇結合試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "C.C.F. (Cephalin cholestered flocculation)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09037C",
      "display" : "血氨",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blood ammonia"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09038C",
      "display" : "白蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Albumin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09039C",
      "display" : "球蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Globubin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09040C",
      "display" : "全蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Total protein"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09041B",
      "display" : "血液氣體分析",
      "definition" : "1.包括PH.PCO2.PO2及HCO3等測定在內2.本項不得加計急診加成",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blood gas analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09042C",
      "display" : "攝護腺酸性磷酸酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.A.P. (Prostatic acid phoshpatase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09043C",
      "display" : "高密度脂蛋白－膽固醇",
      "designation" : [
        {
          "language" : "en",
          "value" : "HDL-C (highdensity lipoprotein cholesterol)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09044C",
      "display" : "低密度脂蛋白－膽固醇",
      "designation" : [
        {
          "language" : "en",
          "value" : "LDL-C (Lowdensity lipoprotein cholesterol)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09046B",
      "display" : "鎂",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mg (Magnesium)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09047B",
      "display" : "銅",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cu (Copper)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09048B",
      "display" : "鋅",
      "designation" : [
        {
          "language" : "en",
          "value" : "Zn (Zinc)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09049B",
      "display" : "鉛",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pb (Lead)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09050B",
      "display" : "乳糖",
      "designation" : [
        {
          "language" : "en",
          "value" : "Galactose"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09051C",
      "display" : "葡萄糖六磷酸脫氫酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "G-6-P-D (Glucose-6-phosphate-dehydrogenase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09052B",
      "display" : "香莢杏仁酸定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "VMA (Vanillyle-mandelic-acid) (quantative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09053B",
      "display" : "17酮類固醇類",
      "designation" : [
        {
          "language" : "en",
          "value" : "17-KS (17-ketosteroids)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09054B",
      "display" : "17氫氧根腎上腺酮",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "17-OHCS(17-hydroxycorticosteroids)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09055B",
      "display" : "尿動情激素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urinary estriol E3"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09056B",
      "display" : "5-氫氧靛基醋酸",
      "designation" : [
        {
          "language" : "en",
          "value" : "5-HIAA (5-Hydroxyindoleacetic-acid)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09057B",
      "display" : "胺基左旋醣酸",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "S-ALA (S-Aminolevulinic acid)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09058B",
      "display" : "胺基左旋醣酸脫氫酵素",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "S-ALA dehydrase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09059B",
      "display" : "乳酸",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lactic Acid (lactate)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09060B",
      "display" : "丙銅酸",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pyruvate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09061B",
      "display" : "肌酸磷化同功酶",
      "definition" : "93.6.14健保醫字第0930060063號公告中文名稱修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CPK isoenzyme"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09062B",
      "display" : "乳酸脫氫同功酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別，中文名稱修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "LDH isoenzyme"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09063B",
      "display" : "Ｄ型木糖吸收試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "D-xylose test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09064C",
      "display" : "解脂酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lipase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09065B",
      "display" : "蛋白電泳分析",
      "definition" : "包括血清及體液",
      "designation" : [
        {
          "language" : "en",
          "value" : "protein electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09066B",
      "display" : "脂蛋白電泳分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lipoprotein electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09067B",
      "display" : "鹼性磷酸酯電泳分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Alkaline phosphatase isoenzyme electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09068B",
      "display" : "澱粉脢電泳分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amylase isoenzyme electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09069B",
      "display" : "血清醛縮酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aldolase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09070B",
      "display" : "羥基丁酸鹽脫氫酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBDH (Hydroxbutyric-dehydrogenase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09071C",
      "display" : "肌酸磷酸酶(MB同功酶)",
      "designation" : [
        {
          "language" : "en",
          "value" : "CK-MB (Creatine phosphokinase-MB)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09072B",
      "display" : "異枸櫞酸去氫酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICDH (Isocitric dehydrogenase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09073B",
      "display" : "維生素Ａ定量",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vitamin A"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09074B",
      "display" : "維生素Ｃ定量",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vitamin C"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09075B",
      "display" : "後腎上腺髓素",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Metanephrine"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09076B",
      "display" : "5-核酸解酶",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "5-Nucleotidase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09077B",
      "display" : "兒茶酚胺測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Catecholamine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09078B",
      "display" : "結石分析",
      "definition" : "註：1.限泌尿道結石申報。2.同一患者，間隔時間應為兩年(含)以上。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stone analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09079C",
      "display" : "麝香混濁反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "T.T.T."
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09080C",
      "display" : "硫酸鋅混濁反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "Z.T.T."
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09081C",
      "display" : "殘餘氯定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "N.P.N."
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09082B",
      "display" : "蔗糖溶血分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sucrose hemolysis test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09083B",
      "display" : "膽素脂脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cholinesterase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09084B",
      "display" : "β脂蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "β-lipoprotein"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09085C",
      "display" : "白胺酸胺脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Leucine aminopeptidase(LAP)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09086C",
      "display" : "Ｎ－乙醯胺基葡萄糖甘脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "NAG (N-acetyl-β-D-glucosaminidase)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09087B",
      "display" : "甲狀腺素結合容量",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TBK"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09088B",
      "display" : "先天代謝異常有關之酵素定量檢查",
      "definition" : "1.限衛生福利部委託具優生保健諮詢中心之醫院申請實施。2.限由小兒科遺傳專科醫師主持。3.本項目如已申請衛生福利部補助者，本保險不另支付該次檢查費用。4.如做為一般性篩檢者，非屬本保險給付範圍。5.每單項酵素檢查400點，酵素定量檢查總點數以3500點為上限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Enzyme test for inborn errors of metabolism"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09089B",
      "display" : "有機酸定量檢查",
      "definition" : "1.限衛生福利部委託具優生保健諮詢中心之醫院申請實施。2.限由小兒科遺傳專科醫師主持。3.本項目如已申請衛生福利部補助者，本保險不另支付該次檢查費用。4.如做為一般性篩檢者，非屬本保險給付範圍。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Organic acdis analysis quantitative"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09090B",
      "display" : "有機酸定性檢查",
      "definition" : "1.限衛生福利部委託具優生保健諮詢中心之醫院申請實施。2.限由小兒科遺傳專科醫師主持。3.本項目如已申請衛生福利部補助者，本保險不另支付該次檢查費用。4.如做為一般性篩檢者，非屬本保險給付範圍。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Organic acids analysis qualitative"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09091B",
      "display" : "經皮測黃疸值",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcutaneous biliubin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09092B",
      "display" : "游離膽固醇",
      "designation" : [
        {
          "language" : "en",
          "value" : "Free cholesterol"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09093B",
      "display" : "肝臟機能ICG色素檢查",
      "definition" : "限肝臟手術前之評估使用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ICG (Indocyanine green)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09094B",
      "display" : "尿液鐵",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine hemosiderin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09095B",
      "display" : "總脂肪",
      "designation" : [
        {
          "language" : "en",
          "value" : "Total lipid"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09096B",
      "display" : "胺基酸定性檢查",
      "definition" : "1.限衛生福利部委託具優生保健諮詢中心之醫院申請實施。2.限由小兒科遺傳專科醫師主持。3.本項目如已申請衛生福利部補助者，本保險不另支付該次檢查費用。4.如做為一般性篩檢者，非屬本保險給付範圍。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amino acids analysis qualitative"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09097B",
      "display" : "G6PD定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "G6PD quantitative"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09098B",
      "display" : "心肌旋轉蛋白T",
      "definition" : "本項與心肌旋轉蛋白I檢驗，限擇一施行申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Troponin T"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09099C",
      "display" : "心肌旋轉蛋白Ｉ",
      "definition" : "1.本項與心肌旋轉蛋白T檢驗，限擇一施行申報。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Troponin I"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09100B",
      "display" : "尿液蛋白電泳",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine protein electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09101B",
      "display" : "蔗糖確認試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sucrose confirmation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09102B",
      "display" : "腺甘脫胺脢",
      "designation" : [
        {
          "language" : "en",
          "value" : "ADA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09103C",
      "display" : "胰島素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Insulin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09104C",
      "display" : "胎盤生乳激素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "HPL (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09105C",
      "display" : "黃體脂酮免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Progesteron (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09106C",
      "display" : "游離甲狀腺素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Free T4 (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09107C",
      "display" : "游離三碘甲狀腺素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Free T3 (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09108C",
      "display" : "生長激素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "GH (Growth hormon), EIA/LIA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09109C",
      "display" : "17-氫氧基黃體脂酮免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "17-OHP (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09110B",
      "display" : "骨原蛋白免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Osteocalcin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09111C",
      "display" : "甲狀腺球蛋白",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thyroglobulin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09112C",
      "display" : "甲狀腺刺激素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "TSH(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09113C",
      "display" : "皮質素免疫分析",
      "definition" : "1.游離皮質素(Freecortisol)比照申報。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cortisol (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09114B",
      "display" : "醛類脂醇酵素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aldosterone (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09115B",
      "display" : "降血鈣素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Calcitonin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09116B",
      "display" : "抗利尿激素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "ADH (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09117C",
      "display" : "甲狀腺原氨酸免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "T3 (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09118B",
      "display" : "碳-副甲狀腺素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "C-terminal PTH (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09119B",
      "display" : "促腎上腺皮質素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "ACTH (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09120C",
      "display" : "催乳激素免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prolactin (PRL), EIA/LIA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09121C",
      "display" : "睪丸酯醇免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Testosterone (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "09122C",
      "display" : "Intact副甲狀腺素免疫分析",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intact parathyrin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09123B",
      "display" : "MM-副甲狀腺素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "MM-parathyrin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09124B",
      "display" : "血漿腎素活性免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "PRA (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09125C",
      "display" : "濾泡刺激素免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "FSH (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09126C",
      "display" : "黃體化激素免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "LH (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09127C",
      "display" : "二氫基春情素免疫分析",
      "definition" : "健保醫字第0960053235號",
      "designation" : [
        {
          "language" : "en",
          "value" : "Estradiol (E2), EIA/LIA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09128C",
      "display" : "C-胜鏈胰島素免疫分析",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "C-peptide (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09129C",
      "display" : "維生素B12免疫分析",
      "definition" : "屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "VIT-B12 (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09130C",
      "display" : "葉酸免疫分析",
      "definition" : "註：1.屬西醫基層總額部門院所，限貧血病人病因檢查申報，一年不得超過一次。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Folic acid (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09131C",
      "display" : "春情素醇酵素免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Estriol (E3), EIA/LIA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09132B",
      "display" : "胃泌激素免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gastrin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09133B",
      "display" : "環磷酸腺酐酸免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "C-AMP (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09134C",
      "display" : "糞便潛血免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stool occult blood (iFOB)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09135B",
      "display" : "乳酸－丙酮酸檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lactic acid, pyruvic acid"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09136B",
      "display" : "缺糖型式運鐵蛋白之分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Carbohydrate-deficient transferrin, CDT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09137B",
      "display" : "血清酮體定量分析",
      "definition" : "1.適應症：糖尿病酮酸中毒。2.不得同時申報06007C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Serum ketone body (quantitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09138C",
      "display" : "直接及總膽紅素比值",
      "definition" : "不得同時申報編號09029C及09030C",
      "designation" : [
        {
          "language" : "en",
          "value" : "Direct Bilirubin/Total Bilirubin Ratio"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09139C",
      "display" : "醣化白蛋白(GA)",
      "definition" : "1.適應症:(1)糖尿病合併慢性腎病變。(2)因血液疾病導致HbA1c無法反映血糖控制者。(3)懷孕糖尿病人及妊娠糖尿病人。(4)血糖數值顯示控制不良，但HbA1c數值仍於良好範圍者。(5)禁忌症:血中白蛋白濃度<3g/dL。2.支付規範:(1)不得同時申報編號09006C。(2)一年限申報四次，若為懷孕糖尿病人、妊娠糖尿病人或當年度為糖尿病及初期慢性腎臟病照護整合方案新收案個案，一年限申報六次。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09140C",
      "display" : "血液及體液葡萄糖-餐後",
      "definition" : "1.空腹血糖係指飯前空腹八小時；餐後血糖係指飯後二小時或喝完糖水二小時(依進食時開始計時)。2.尿液除外。3.同次門診以申報一次為限。4.下列情形須於病歷註明理由備查：(1)急診病人未符合上述時間條件，惟因病情需要執行者，得以09140C申報。(2)空腹與餐後二項同時申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Glucose-Post Cibum, PC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01",
      "display" : "第一次兒童衛教指導費(可搭配第一次兒童預防保健申報)",
      "definition" : "於出生至二個月；提供嬰兒哺餵、嬰幼兒猝死症候群預防、事故傷害預防等衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10001B",
      "display" : "銀",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Silver (Ag)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10002B",
      "display" : "鋁",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aluminum (Al)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10003B",
      "display" : "砷",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Arsenic (As)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10004B",
      "display" : "金",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gold (Au)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10005B",
      "display" : "鎘",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cadmium (Cd)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "10006B",
      "display" : "鈷",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cobalt (Co)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10007B",
      "display" : "鉻",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chromium (Cr)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10008B",
      "display" : "汞",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mercury (Hg)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "10009B",
      "display" : "錳",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Manganese (Mn)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10010B",
      "display" : "鎳",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nickel (Ni)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10011B",
      "display" : "鉬",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Molybdenium (Mo)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10012B",
      "display" : "鋅(原子吸收光譜法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Zinc(Zn)(AA method)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10501C",
      "display" : "卡巴馬平",
      "designation" : [
        {
          "language" : "en",
          "value" : "Carbamazepine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10502B",
      "display" : "二苯妥因",
      "designation" : [
        {
          "language" : "en",
          "value" : "Diphenylhydantoin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10503B",
      "display" : "甲乙琥珀亞胺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ethosuximide"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10504B",
      "display" : "滅殺除癌",
      "designation" : [
        {
          "language" : "en",
          "value" : "Methotrexate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10505B",
      "display" : "普卡因胺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Procainamide & NAPA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10506B",
      "display" : "立克菌星",
      "designation" : [
        {
          "language" : "en",
          "value" : "Netilmicin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10507B",
      "display" : "乙苯嘧啶二酮",
      "designation" : [
        {
          "language" : "en",
          "value" : "Primidone"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10508B",
      "display" : "水楊酸",
      "designation" : [
        {
          "language" : "en",
          "value" : "Salicylate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10509B",
      "display" : "茶鹼",
      "designation" : [
        {
          "language" : "en",
          "value" : "Theophylline"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10510C",
      "display" : "發爾波克",
      "designation" : [
        {
          "language" : "en",
          "value" : "Valproic acid"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10511C",
      "display" : "長葉毛地黃",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Digoxin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10512B",
      "display" : "Amikacin",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amikacin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10515B",
      "display" : "力多卡因",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lidocaine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10516B",
      "display" : "奎尼丁",
      "designation" : [
        {
          "language" : "en",
          "value" : "Quinidine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10517B",
      "display" : "Disopyramide",
      "designation" : [
        {
          "language" : "en",
          "value" : "Disopyramide"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10518B",
      "display" : "健大黴素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gentamicin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10519B",
      "display" : "托不拉黴素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tobramycin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "10520C",
      "display" : "鋰鹽",
      "designation" : [
        {
          "language" : "en",
          "value" : "Li(Lithium)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10521B",
      "display" : "Imipramine",
      "designation" : [
        {
          "language" : "en",
          "value" : "Imipramine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10522B",
      "display" : "血中藥物濃度測定－Cyclosporine-A",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - cyclosporine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10523B",
      "display" : "血中藥物濃度測定-二苯環丙氨",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - amitriptyline"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10524B",
      "display" : "血中藥物濃度測定－Desipramine",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - desipramine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10525B",
      "display" : "血中藥物濃度測定－Phenobarbital(luminal)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - phenobarbital (luminal)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10526B",
      "display" : "血中藥物濃度測定－Diazepam(valium)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - diazepam (valium)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10527B",
      "display" : "苯重氮基鹽類濃度(定量)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Benzodiazepine(quantitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10529B",
      "display" : "血中藥物濃度測定-普潘奈",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - propanolol"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10530B",
      "display" : "血中藥物濃度測定－Dibekacin",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - dibekacin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10531B",
      "display" : "血中藥物濃度測定－Vancomycin",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - vancomycin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10532B",
      "display" : "血中藥物濃度測定-氯黴素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - chloramphenicol"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10533B",
      "display" : "血中藥物濃度測定-康絲菌素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - kanamycin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10534B",
      "display" : "血中藥物濃度測定－Nortriptyline",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - nortriptyline"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10535B",
      "display" : "血中藥物濃度測定-三環抗鬱劑",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring - TCA (tricyclic antidepressant)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10536B",
      "display" : "血中藥物濃度測定-FK-506",
      "designation" : [
        {
          "language" : "en",
          "value" : "Therapeutic drug monitoring-FK-506"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10537C",
      "display" : "Sirolimus全血濃度測定",
      "definition" : "93.6.14健保醫字第0930060063號公告增列本項。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sirolimus"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10801B",
      "display" : "毒物試驗(定性)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Drug test (qualitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10802B",
      "display" : "巴比妥酸鹽",
      "designation" : [
        {
          "language" : "en",
          "value" : "Barbiturate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10803B",
      "display" : "乙醯對氨基酚",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acetaminophen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10804B",
      "display" : "一氧化碳血紅素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Carboxylhemoglobin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10805B",
      "display" : "氰化物",
      "definition" : "93.6.14健保醫字第0930060063號公告英文名稱修正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cyanide"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10806B",
      "display" : "甲醇",
      "designation" : [
        {
          "language" : "en",
          "value" : "Methyl alcohol"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10807B",
      "display" : "乙醇",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ethyl alcohol"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "10808B",
      "display" : "高鐵血紅素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Methemoglobin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10809B",
      "display" : "血中農藥中毒濃度測定",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10810B",
      "display" : "安非他命檢測(免疫分析)",
      "definition" : "限鑑別診斷用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amphetamine (EIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10811B",
      "display" : "嗎啡檢測(免疫分析)",
      "definition" : "限鑑別診斷用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Morphine (EIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10812B",
      "display" : "古柯鹼檢測(免疫分析)",
      "definition" : "限鑑別診斷用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cocaine (EIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10813B",
      "display" : "大麻檢測(免疫分析)",
      "definition" : "限鑑別診斷用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cannabinoids (EIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10814B",
      "display" : "天使塵檢測(免疫分析)",
      "definition" : "限鑑別診斷用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Phonclidine (EIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10815B",
      "display" : "有機磷濃度確認分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Organophosphate confirmation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10816B",
      "display" : "乙醯膽鹼脢紅血球(定量)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cholinesterase-RBC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10817B",
      "display" : "乙醇-酒後非駕駛",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ethanol-drunk not driving"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "10818B",
      "display" : "乙醇-酒後駕駛",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ethanol-DUI (Driving under the influence)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10819C",
      "display" : "殺鼠藥分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rodenticide test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11001C",
      "display" : "ABO血型測定檢驗",
      "definition" : "1.同一醫療院所門、住診限申報一次2.接受不同血型之骨髓或周邊血液幹細胞移植術後之病人不限申報一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "A.B.AB.O blood grouping"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11002C",
      "display" : "交叉配合試驗",
      "definition" : "1.冷凍沈澱品(cryoprecipitate)、凝血脢(thrombin)、血漿(plasma)不得申報交叉試驗。2.每一血袋限申報一次",
      "designation" : [
        {
          "language" : "en",
          "value" : "Crossmatching test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11003C",
      "display" : "RH(D)型檢驗",
      "definition" : "1.同一醫療院所門、住診限申報一次。2.接受不同血型之骨髓或周邊血液幹細胞移植術後之病人不限申報一次。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11004C",
      "display" : "不規則抗體篩檢",
      "definition" : "每次輸血前限申報一次",
      "designation" : [
        {
          "language" : "en",
          "value" : "Antibody screening"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11005B",
      "display" : "不規則抗體鑑定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Antibody identification"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11006B",
      "display" : "不規則抗體之沖出及鑑定",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Elution & antibody identification"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11007B",
      "display" : "血小板抗體",
      "definition" : "註：適應症1.兩次以上輸血仍無法提升血小板數目(輸血小板無療效)，懷疑免疫因素引起。2.血小板低下症鑑別診斷，如NAITP、AITP、TTP、DITP、PTP、ITP等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Platelet antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11008B",
      "display" : "特殊血型-Lewisantigen",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Special blood group studies- Lewis antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11009B",
      "display" : "特殊血型-D、E、C、e、c",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Special blood group studies-D、E、C、e、c"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11010B",
      "display" : "特殊血型－特殊血型三大群以上",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Special blood group studies"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11011B",
      "display" : "輸血反應探測",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Investigation transfusion reaction"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11012B",
      "display" : "HLA符合試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA compatible donor searching"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12001C",
      "display" : "梅毒試驗",
      "definition" : "S.T.S檢查比照申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "RPR/VDRL test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12002B",
      "display" : "傷寒凝集試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Widal & Weil-Felix test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12003C",
      "display" : "抗鏈球菌溶血素Ｏ效價測定—溶血抑制法",
      "designation" : [
        {
          "language" : "en",
          "value" : "ASLO, anti-streptolysin-O test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12004C",
      "display" : "抗鏈球菌溶血素O效價測定－免疫比濁法",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ASLO, anti-streptolysin-O test -Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12005B",
      "display" : "鏈球菌激脢試驗",
      "definition" : "Streptokinase檢查比照申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Streptokinase test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12006B",
      "display" : "布魯氏菌凝集素試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Brucella agglutinin test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12007C",
      "display" : "α－胎兒蛋白檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "AFP α-fetoprotein(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12008B",
      "display" : "冷凝集反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cold hemoagglutinin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12009C",
      "display" : "類風濕性關節炎因子試驗-乳膠凝集法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rheumatoid factor test - Latex agglutination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12010C",
      "display" : "類風濕性關節炎因子試驗—被動血球凝集法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rheumatoid factor test - PHA(passive hemagglutination)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12011C",
      "display" : "類風濕性關節炎因子試驗－免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rheumatoid factor test - Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12012B",
      "display" : "冷凝球蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cryoglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12013C",
      "display" : "Ｃ反應性蛋白試驗—乳膠凝集法",
      "designation" : [
        {
          "language" : "en",
          "value" : "C.R.P (C-reactive protein) - Latex agglutination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12014C",
      "display" : "Ｃ反應性蛋白試驗－免疫擴散法",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "C.R.P (C-reactive protein) - Macinni immunodifusion"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12015C",
      "display" : "Ｃ反應性蛋白試驗－免疫比濁法",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "C.R.P (C-reactive protein) - Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12016C",
      "display" : "砂眼披衣菌抗原－酵素免疫法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chlamydia trachomatis Ag -EIA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12017B",
      "display" : "砂眼披衣菌抗原－螢光法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chlamydia trachomatis Ag - FA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12018C",
      "display" : "梅毒螺旋體抗體試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "TPPA/TPHA test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12019B",
      "display" : "螢光梅毒螺旋體抗體吸附試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "FTA - ABS"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12020C",
      "display" : "肺炎黴漿菌抗體試驗",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mycoplasma pneumonia Ab test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12021C",
      "display" : "癌胚胎抗原檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "CEA(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12022C",
      "display" : "乙型人類絨毛膜促性腺激素",
      "designation" : [
        {
          "language" : "en",
          "value" : "β-HCG(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12023B",
      "display" : "人體阿米巴體抗體檢驗",
      "definition" : "93.6.14健保醫字第0930060063號公告中文名稱修正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amebiasis Ab test(IHA法)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12024B",
      "display" : "免疫球蛋白Ｇ—單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgG - Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12025B",
      "display" : "免疫球蛋白Ｇ—免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgG - Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12026B",
      "display" : "免疫球蛋白Ａ—單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgA - Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12027B",
      "display" : "免疫球蛋白Ａ—免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgA - Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12028B",
      "display" : "免疫球蛋白Ｍ—單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgM - Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12029B",
      "display" : "免疫球蛋白Ｍ—免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgM - Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12030B",
      "display" : "免疫球蛋白Ｄ",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgD"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12031C",
      "display" : "免疫球蛋白Ｅ",
      "definition" : "詳見91.04.23健保醫字第0910007178號公告.91.05.01起修訂適用表別為基層適用.",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12032B",
      "display" : "補體1定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "C1 quantitation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12033B",
      "display" : "補體3－單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "C3 - Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12034B",
      "display" : "補體3－免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "C3 - Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12035B",
      "display" : "補體3(活化測定)－單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "C3 Activator(properdin factor B) - Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12036B",
      "display" : "補體3(活化測定)－免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "C3 Activator(properdin factor B) -Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12037B",
      "display" : "補體4－單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "C4 - Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12038B",
      "display" : "補體4－免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "C4 -Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12039B",
      "display" : "補體-5定量",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "C' - 5"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12040B",
      "display" : "α1-抗胰蛋白脢－單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "α1 - antitrypsin - Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12041B",
      "display" : "α1-抗胰蛋白脢－免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "α1-antitrypsin-Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12042B",
      "display" : "α1–粘液蛋白(免疫比濁法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "α1-acid glycoprotein ( Nephelometry)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12043B",
      "display" : "α2-巨球蛋白－單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "α2-macroglobulin-Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12044B",
      "display" : "α2-巨球蛋白－免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "α2-macroglobulin-Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12045B",
      "display" : "結合蛋白－單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Haptoglobin-Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12046B",
      "display" : "結合蛋白－免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Haptoglobin-Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12047B",
      "display" : "運鐵蛋白－單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transferrin-Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12048C",
      "display" : "運鐵蛋白—免疫比濁法",
      "definition" : "12048C除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transferrin-Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12049B",
      "display" : "轉銅素—單向免疫擴散法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ceruloplasmin-Single radial immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12050B",
      "display" : "轉銅素免疫比濁法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ceruloplasmin-Nephelometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12051B",
      "display" : "胞漿蛋白原",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasminogen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12052B",
      "display" : "β2-微球蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "β2-microglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12053C",
      "display" : "抗核抗體(間接免疫螢光法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "ANA (antinuclear antibody) IFA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12054B",
      "display" : "微粒體抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "AMIA,anti-microsomal antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12055B",
      "display" : "骨骼肌抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "ASkMA,anti-skeletal muscle antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12056B",
      "display" : "粒腺體抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "AMA, anti-mitochondrial antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12057B",
      "display" : "平滑肌抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "ASMA,anti-smooth muscle antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12058B",
      "display" : "壁細胞抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "APCA,anti-parietal cell antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12059B",
      "display" : "嗜異性抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Heterophile Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12060C",
      "display" : "DNA抗體",
      "definition" : "註：屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-DNA、Anti-dsDNA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12061B",
      "display" : "肌球蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Myoglobin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12062B",
      "display" : "冷凝球蛋白",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cryoglobubin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12063B",
      "display" : "可抽出的核抗體檢查(定性)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-ENA test (qualitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12064B",
      "display" : "可抽出的核抗體測定—Ro/La抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-ENA-Ro/La Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12065B",
      "display" : "EBCapsidAb",
      "designation" : [
        {
          "language" : "en",
          "value" : "(Epstein-Barr virus C.A)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12066B",
      "display" : "基底膜帶抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Basement membrane zone Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12067B",
      "display" : "細胞間質抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intercellular substance antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12068C",
      "display" : "甲狀腺球蛋白抗體",
      "definition" : "註：1.屬西醫基層總額部門院所，適應症：用於甲狀腺低下(自體免疫型)及甲狀腺癌病人。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thyroglobulin antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12069B",
      "display" : "隱球菌抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cryptococcus antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12070B",
      "display" : "冷凝纖維蛋白原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cryofibrinogen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12071B",
      "display" : "淋巴球表面標記－Ｔ細胞及Ｂ細胞定量",
      "definition" : "單源抗體定量Ｔ及Ｂ細胞或Ｅ及ＥＡＣ-rosette。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocyte surface marker-Total T & B lymphocytes"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12072B",
      "display" : "淋巴球表面標記－癌症腫瘤檢驗",
      "definition" : "包含成熟Ｔ及Ｂ細胞檢查，輔助性及抑制性Ｔ細胞，殺手細胞及活化細胞之檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocyte surface marker-Tumor/cancer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12073C",
      "display" : "淋巴球表面標記－感染性疾病檢驗",
      "definition" : "1.包含成熟T及Ｂ細胞檢查，輔助性及抑制性T細胞檢查。2.屬西醫基層總額部門院所限由感染科專科醫師開立處方始可申報。3.12073C屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocyte surface marker-Infectious disease"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12074B",
      "display" : "淋巴球表面標記－免疫性疾病檢驗",
      "definition" : "包含成熟Ｔ及Ｂ細胞檢查，輔助性及抑制性Ｔ細胞，活化Ｔ細胞及其他ＨＬＡ之單源抗體檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocyte surface marker-Immunological disease"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12075B",
      "display" : "白血球表面標記",
      "definition" : "成熟與不成熟Ｔ及Ｂ或顆粒球與單核球等單源抗體之使用量≦10種",
      "designation" : [
        {
          "language" : "en",
          "value" : "Leukocyte surface marker"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12076B",
      "display" : "淋巴球表面標記－其他疾病",
      "definition" : "至少包含五種有關T及B細胞檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocyte surface marker-Others"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12077C",
      "display" : "ＣＡ–125腫瘤標記(EIA/LIA法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "CA-125 (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12078C",
      "display" : "ＣＡ–153腫瘤標記(EIA/LIA法)",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CA-153 (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12079C",
      "display" : "ＣＡ–199腫瘤標記(EIA/LIA法)",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CA-199 (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12080B",
      "display" : "SCC腫瘤標記(EIA/LIA法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "SCC (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12081C",
      "display" : "攝護腺特異抗原(EIA/LIA法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "PSA(prostate specific antigen) (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12082B",
      "display" : "多核形白血球吞噬功能",
      "designation" : [
        {
          "language" : "en",
          "value" : "PMN phagocytosis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12083B",
      "display" : "多核形白血球殺菌功能",
      "designation" : [
        {
          "language" : "en",
          "value" : "PMN bacterial capacity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12084B",
      "display" : "總Ｂ－細胞檢查(包括Ｇ.Ａ.Ｍ.Ｃ四項)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Total B-cell count"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12085B",
      "display" : "淋巴球變形反應—分裂原刺激",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocyte transformation-Mitogen stimulation"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12086C",
      "display" : "人類白血球抗原－HLA-B27",
      "definition" : "1.保險對象接受器官移植申報12087B及12176B時，除父母、兄弟姐妹等各給付一次外，另確定為捐贈者最高可給付共三次。2.12088B及12177B需俟12087B及12176B檢查後配合相合者，如有需要另行檢查。3.12086C屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA-B27"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12087B",
      "display" : "人類白血球抗原－HLA-ABC(多種抗原)",
      "definition" : "註：1.保險對象接受器官移植申報12087B及12176B時，除父母、兄弟姐妹等各給付一次外，另確定為捐贈者最高可給付共三次。2.12088B及12177B需俟12087B及12176B檢查後配合相合者，如有需要另行檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA-ABC multiple antige"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12088B",
      "display" : "人類白血球抗原－HLA-DR(多種抗原)",
      "definition" : "註：1.保險對象接受器官移植申報12087B及12176B時，除父母、兄弟姐妹等各給付一次外，另確定為捐贈者最高可給付共三次。2.12088B及12177B需俟12087B及12176B檢查後配合相合者，如有需要另行檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA-DR multiple antige"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12089B",
      "display" : "單向混合淋巴球反應",
      "definition" : "1.雙向混合淋巴球反應two-wayMLR比照申報。2.受者對捐者或捐者對受者皆以本項核實申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "One-way MLR"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12090B",
      "display" : "淋巴球毒殺試驗—單獨檢驗B細胞或T細胞",
      "definition" : "1.同時檢測B細胞及T細胞時，不得申報二次12090B。2.活體器官移植及骨髓移植前配對，若同時由多名捐贈者進行本項檢驗，申報上限二次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocytotoxic test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12091B",
      "display" : "免疫病理檢查--腎組織",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunopathology - Kidney"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12092B",
      "display" : "免疫病理檢查--皮膚組織",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunopathology - Skin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12093B",
      "display" : "免疫病理檢查--肝組織",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunopathology - Liver"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12094B",
      "display" : "免疫病理檢查--肺組織",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunopathology - Lung"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12095B",
      "display" : "免疫病理檢查--胃組織",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunopathology - Stomach"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12096B",
      "display" : "免疫病理檢查--其他",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunopathology - Others"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12097B",
      "display" : "庫姆氏血中多項抗體檢驗(直接法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Direct Coombs' polyspecific test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12098B",
      "display" : "庫姆氏血中多項抗體檢驗(間接法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Indirect Coombs' polyspecific test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12099B",
      "display" : "庫姆氏血中單項IgG抗體檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coombs' IgG monospecific test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12100B",
      "display" : "庫姆氏血中單項C3抗體檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coombs' C3 monospecific test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12101B",
      "display" : "趨化性試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chemotaxis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12102B",
      "display" : "免疫擴滲分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunodiffusion"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12103B",
      "display" : "免疫電泳分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunoelectrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12104B",
      "display" : "CH50免疫檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "CH50"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12105B",
      "display" : "單核球移動抑制因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Migration inhibition factor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12106C",
      "display" : "結核菌素測驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tuberculin test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12107C",
      "display" : "披衣菌抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chlamydia Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12108B",
      "display" : "體液免疫複合體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immune complex"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12109B",
      "display" : "成人T淋巴白血病病毒抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HTLV-Ⅰ/ Anti-ATLA Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12110B",
      "display" : "血清前白蛋白定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prealbumin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12111C",
      "display" : "微白蛋白(免疫比濁法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Microalbumin (Nephelometry)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12112B",
      "display" : "白蛋白(免疫比濁法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Albumin (Nephelometry)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12113B",
      "display" : "脂蛋白脢元B(免疫比濁法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Apolipoprotein B (Nephelometry)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12114B",
      "display" : "脂蛋白脢元Ａ1(免疫比濁法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Apolipoprotein A1 (Nephelometry)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12115B",
      "display" : "抗凝血原(免疫比濁法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-thrombin (Nephelometry)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12116C",
      "display" : "鐵蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ferritin (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12117B",
      "display" : "T淋巴球交叉配合試驗",
      "definition" : "1.B淋巴球交叉配合試驗Blymphocytecross-match比照申報。2.此項檢查必須配合骨髓移植才能實施申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T lymphocyte crossmatch test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12118B",
      "display" : "退伍軍人菌抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Legionella pneumophila Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12120B",
      "display" : "腫瘤多胜脢抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "TPA(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12121C",
      "display" : "甲促素結合體抗體",
      "definition" : "屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TSH recepter Ab(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12122B",
      "display" : "免疫球蛋白E補體結合反應免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Reaginic IgE (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12123C",
      "display" : "C-反應蛋白(毛細管沉澱法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "C-Reactive protein (Capillary ppt)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12124B",
      "display" : "甲狀腺結合球蛋白",
      "designation" : [
        {
          "language" : "en",
          "value" : "TBG (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12125C",
      "display" : "B型鏈球菌抗原(乳膠凝集法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Streptococcus group B Ag-latex agglutination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12126B",
      "display" : "肺炎雙球菌抗原(乳膠凝集法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Streptococcus pneumonia Ag-latex agglutination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12127B",
      "display" : "B型嗜血桿菌抗原(乳膠凝集法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hameophilus influenzae type B Ag-latex agglutination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12128B",
      "display" : "腦膜炎雙球菌抗原(乳膠凝集法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Neisseria meningitides Ag-latex agglutination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12129C",
      "display" : "腦脊髓液快速測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "CSF quick test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12130B",
      "display" : "沙門氏菌抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Salmonella AG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12131B",
      "display" : "志賀氏菌抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Shigella AG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12132B",
      "display" : "肺炎披衣菌(TWAR)抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chlamydia pneumoniae Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12133B",
      "display" : "抗β2醣蛋白I抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-β2-glycoprotein-I Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12134C",
      "display" : "甲狀腺過氧化酶抗體",
      "definition" : "註：1.本項檢查與12054B僅可擇一申報。2.屬西醫基層總額部門院所，適應症：用於甲狀腺低下(自體免疫型)及孕婦甲狀腺功能異常。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-TPO Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12135B",
      "display" : "抗角質抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-keratin antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12136B",
      "display" : "DNA分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "DNA analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12137B",
      "display" : "肌肉炎自體抗體組合",
      "definition" : "包括抗t-合成酵素抗體(T-synthetaseAb)、抗訊號測定微抗體(Anti-SRPAntibody)、Mi-2抗體(Mi-2Ab)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Myositis auto-antibodies"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12138B",
      "display" : "腎絲球基底膜抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-glomerular basement menbrane antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12139B",
      "display" : "腦脊髓液新隱形球菌藥物濃度試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cryptococcus neoformans stain (CSF)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12140B",
      "display" : "T3+DR+,T3+DR-",
      "designation" : [
        {
          "language" : "en",
          "value" : "T3+DR+, T3+DR-"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12141B",
      "display" : "劉氏3+8+抗原,劉氏3+8-細胞",
      "designation" : [
        {
          "language" : "en",
          "value" : "LEU3+8+, LEU3+8- CELL"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12142B",
      "display" : "劉氏2+15+抗原,劉氏2+15-細胞",
      "designation" : [
        {
          "language" : "en",
          "value" : "LEU2+15+, LEU2+15- CELL"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12143B",
      "display" : "抗原依靠性補體細胞毒殺試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "ADCC cytotoxicity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12144B",
      "display" : "自然毒殺細胞活力試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "NK activity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12145B",
      "display" : "直接細胞毒殺試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Direct cytotoxicity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12146B",
      "display" : "免疫球蛋白G1量",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgG1"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12147B",
      "display" : "免疫球蛋白G2量",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgG2"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12148B",
      "display" : "免疫球蛋白G3量",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgG3"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12149B",
      "display" : "免疫球蛋白G4量",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgG4"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12150B",
      "display" : "胺基酸定量檢查",
      "definition" : "1.限衛生福利部委託具優生保健諮詢中心之醫院申請實施。2.限由小兒科遺傳專科醫師主持。3.本項目如已申請衛生福利部補助者，本保險不另支付該次檢查費用。4.如做為一般性篩檢者，非屬本保險給付範圍。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amino acids analysis (quantitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12151C",
      "display" : "同半胱胺酸",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Homocysteine"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12152B",
      "display" : "InvitroIgG,A,Msynthesis",
      "designation" : [
        {
          "language" : "en",
          "value" : "In vitro IgG, A, M synthesis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12153B",
      "display" : "混合淋巴球雙向培養",
      "designation" : [
        {
          "language" : "en",
          "value" : "MLC (Mixed lymphocyte culture)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12154B",
      "display" : "可抽出之核抗體Jo-1",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti Jo-1 antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12155B",
      "display" : "可抽出之核抗體KI,KU(免疫擴滲分析法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "KI, KJ (ID)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12156B",
      "display" : "Ribosomal-P抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ribosomal-P Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12157B",
      "display" : "腦脊髓液免疫球蛋白免疫電泳",
      "designation" : [
        {
          "language" : "en",
          "value" : "IEP for CSF Immunoglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12158B",
      "display" : "尿液免疫球蛋白免疫電泳",
      "designation" : [
        {
          "language" : "en",
          "value" : "IEP for Urine Immunoglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12159B",
      "display" : "尿液免疫固定電泳分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urine immunofixation electrophoresis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12160B",
      "display" : "免疫球蛋白κ/λ",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunoglobulin κ/λ"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12161B",
      "display" : "白血球介質-2",
      "designation" : [
        {
          "language" : "en",
          "value" : "IL-2"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12162B",
      "display" : "組織壞死因子",
      "definition" : "註：適應症1.類風濕性關節炎、僵直性關節炎、乾癬、乾癬性關節炎、發炎性腸炎、血管炎之特定表現鑑別診斷。2.使用抗腫瘤壞死因子生物製劑藥物者，依臨床狀況監控其疾病狀態及藥物反應。3.特定感染症如結核感染之特定表現及免疫缺損之監控。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TNF"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12163B",
      "display" : "第一型人類嗜T細胞抗體(定性)",
      "designation" : [
        {
          "language" : "en",
          "value" : "HTLV-1 antibody (qualitative)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12164B",
      "display" : "脂蛋白a",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lipoprotein a"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12165C",
      "display" : "A群鏈球菌抗原",
      "definition" : "屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Streptococcus group A antigen (EIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12166B",
      "display" : "腦膜炎雙球菌抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Meningococcal Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12167B",
      "display" : "組織胞漿菌抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Histoplasma capsutatum Ab test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12168B",
      "display" : "芽生菌抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blastomycosis Ab test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12169B",
      "display" : "球孢子菌抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "C. immitis Ab test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12170B",
      "display" : "麴菌抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aspergillus Ab test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12171B",
      "display" : "抗嗜中性球細胞質抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "ANCA (Anti-nutrophil cytoplasmic Ab)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12172C",
      "display" : "尿液肺炎球菌抗原",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pneumococcus Ag (urine)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12173B",
      "display" : "可抽出的核抗體測定—Sm/RNP抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-ENA,Sm/RNP Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12174B",
      "display" : "可抽出的核抗體測定—Scl-70抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-ENA,Scl-70 Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12175B",
      "display" : "淋巴球變形反應—抗原刺激",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocyte transformation-Antigen stimulation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12176B",
      "display" : "人類白血球抗原－HLA-ABC(單一抗原)",
      "definition" : "註：1.保險對象接受器官移植申報12087B及12176B時，除父母、兄弟姐妹等各給付一次外，另確定為捐贈者最高可給付共三次。2.12088B及12177B需俟12087B及12176B檢查後配合相合者，如有需要另行檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA-ABC single antigen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12177B",
      "display" : "人類白血球抗原－HLA-DR(單一抗原)",
      "definition" : "註：1.保險對象接受器官移植申報12087B及12176B時，除父母、兄弟姐妹等各給付一次外，另確定為捐贈者最高可給付共三次。2.12088B及12177B需俟12087B及12176B檢查後配合相合者，如有需要另行檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA-DR single antigen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12178C",
      "display" : "腎上腺抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Adrenal antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12179C",
      "display" : "Aspergillus抗原測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aspergillus Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12180C",
      "display" : "穀醯酸脫梭脢抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Glutamic acid decarboxylase autoantibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12181C",
      "display" : "乙醯膽鹼抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acetylcholine receptor antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12182C",
      "display" : "去氧核糖核酸類定性擴增試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "DNA qualitative amplification test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12183C",
      "display" : "核糖核酸類定性擴增試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "RNA qualitative amplification test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12184C",
      "display" : "去氧核糖核酸類定量擴增試驗",
      "definition" : "不得同時申報14085C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "DNA quantitative amplification test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12185C",
      "display" : "核糖核酸類定量擴增試驗",
      "definition" : "註：若執行人類免疫缺乏病毒核酸檢測以14074C申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "RNA quantitative amplification test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12186C",
      "display" : "染色體轉位基因重組之南方墨點法分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chromosomal translocation gene recombination analysis by southern blot"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12187C",
      "display" : "短片段重覆序列多型性分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "STR polymorphism analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12188C",
      "display" : "染色體轉位融合基因之反轉錄聚合脢連鎖反應分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chromosomal translocation fusion gene analysis by RT-PCR"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12189C",
      "display" : "肺炎披衣菌IgM",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chlamydia pneumoniae Ab IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12190C",
      "display" : "肺炎披衣菌IgG",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chlamydia pneumoniae Ab IgG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12191C",
      "display" : "尿液退伍軍人菌抗原",
      "definition" : "適應症：1.非典型肺炎。2.一般治療肺炎之抗生素使用後，病情持續惡化者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Legionella pneumophila Ag (urine)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "12192C",
      "display" : "前降鈣素原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Procalcitonin (PCT)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12193C",
      "display" : "B型利納肽(B型利納利尿胜肽)",
      "definition" : "註：屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pro-BNP/(BNP)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12194B",
      "display" : "代謝產物串聯質譜儀分析",
      "definition" : "1.限衛生福利部委託具優生保健諮詢中心之醫院申請實施。2.限由遺傳專科醫師主持。3.本項目如已申請衛生福利部補助者，本保險不另支付該次檢查費用。4.如做為一般性篩檢者，非屬本保險給付範圍。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tandem Mass Analysis of Metabolites"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12195B",
      "display" : "第二型人類表皮生長因子受體(Her-2/neu)原位雜合檢驗",
      "definition" : "適應症：1.乳癌之invasivecarcinoma(侵襲性癌)、轉移性胃腺癌(或胃食道接合處腺癌)。2.本法為IHC染色結果之輔助檢查方法，不可單獨使用。3.此法僅適用於Her-2/neuIHCscore為2+之乳癌或胃腺癌(或胃食道接合處腺癌)患者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Her-2/neu in situ hybridization(ISH)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12196B",
      "display" : "HLA-B1502基因檢測",
      "definition" : "1.適應症：癲癇症、三叉神經痛、腎原性尿崩症及雙極性之精神疾患初次需使用含卡馬西平Carbamazepine成份藥物病患申報。2.每人限申報一次，需於健保卡藥物過敏欄註記藥物過敏基因型。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA-B 1502 gene typing"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12197B",
      "display" : "血中藥物濃度測定-Everolimus",
      "definition" : "註：1.測定移植病人器官移植後抗排斥用藥Certican濃度。2.罕見疾病結節性硬化症患者經本保險核准使用Everolimus者亦適用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TDM - Everolimus"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12198C",
      "display" : "游離攝護腺特異抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Free PSA (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12199B",
      "display" : "人類組織相容複合物Ι類鏈相關基因A抗體篩檢",
      "definition" : "1.臟器移植接受者術前評估，且PRA60%以上，限申報1次為原則。2.限臟器移植接受者術後產生排斥現象，且PRA上升，當次排斥限申報1次為原則。",
      "designation" : [
        {
          "language" : "en",
          "value" : "MICA Antibody Screening"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12200B",
      "display" : "人類白血球群體反應性抗體百分比篩檢試驗",
      "definition" : "1.臟器移植接受者術前評估，每6個月內限申報1次為原則。2.限臟器移植接受者術後產生排斥反應時檢測。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Human Leukocyte Panel Reactive Antibodies Percentage screening test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12201B",
      "display" : "抗環瓜氨酸月太抗體",
      "definition" : "1.原因不明之關節炎且RF為陰性。2.RF陽性，但仍未符合類風濕診斷，需區分／鑑別是否為其他原因。3.每位患者僅給付一次，疑似RA者，每年最多檢查1次。4.限風濕病專科醫師。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-cyclic citrullinated peptide"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12202C",
      "display" : "C型肝炎病毒核酸基因檢測－即時聚合酶連鎖反應法",
      "definition" : "適應症：1.疑似感染C型肝炎(包含急性、慢性，及未知原因感染者)且C型肝炎核酸病毒量檢測結果為陽性患者。2.未做過基因型檢測的C型肝炎陽性確定患者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HCV Genotyping Test(RealTime PCR)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12203B",
      "display" : "C型肝炎病毒核酸基因檢測－一般聚合酶連鎖反應法",
      "definition" : "適應症：1.疑似感染C型肝炎(包含急性、慢性，及未知原因感染者)且C型肝炎核酸病毒量檢測結果為陽性患者。2.未做過基因型檢測的C型肝炎陽性確定患者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HCV Genotyping Test(PCR)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12204B",
      "display" : "白血球表面標記",
      "definition" : "成熟與不成熟Ｔ及Ｂ或顆粒球與單核球等單源抗體之使用量-11-20種",
      "designation" : [
        {
          "language" : "en",
          "value" : "Leukocyte surface marker"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12205B",
      "display" : "白血球表面標記",
      "definition" : "成熟與不成熟Ｔ及Ｂ或顆粒球與單核球等單源抗體之使用量-21-30種",
      "designation" : [
        {
          "language" : "en",
          "value" : "Leukocyte surface marker"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12206B",
      "display" : "白血球表面標記",
      "definition" : "成熟與不成熟Ｔ及Ｂ或顆粒球與單核球等單源抗體之使用量-31種以上",
      "designation" : [
        {
          "language" : "en",
          "value" : "Leukocyte surface marker"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12207B",
      "display" : "白血病即時定量聚合酶連鎖反應法實驗室開發檢測(LDTs)",
      "definition" : "註：1.適應症：(1)含有BCR-ABL1之慢性骨髓性白血病(chronicmyelogenousleukemia，CML)與急性白血病。(2)含有PML-RARA、RUNX1-ETO與CBFB-MYH11之急性骨髓性白血病(acutemyeloidleukemia，AML)。2.支付規範：限衛生福利部核准之實驗室開發檢測施行計畫表列醫療機構申報。3.執行本項之醫事服務機構應報經保險人核定，如有異動，應重行報請核定。4.不得同時申報編號12217B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "RQ-PCR(Real Time Quantitative PCR) for leukemia(LDTs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12208B",
      "display" : "生長刺激表達基因2蛋白(ST2)",
      "definition" : "1.適應症:慢性心臟衰竭NYHAClassIII或ACC/AHAStageD以上且病情急性惡化。2.支付規範:不得同時申報編號12193C。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12209B",
      "display" : "類胰蛋白酶",
      "definition" : "1.適應症：疑過敏性休克，臨床上出現以下任一狀況：(1)急性出現病徵累及皮膚/黏膜組織(如：全身性蕁麻疹、發癢或潮紅、嘴唇-舌-懸雍垂水腫)，且合併血壓下降或終器官失能(如：暈倒、昏厥、大小便失禁)。(2)於接觸可能過敏原後，快速(幾秒至幾小時內)出現血壓下降或終器官失能(如：暈倒、昏厥、大小便失禁)，且出現A至C一項以上病徵：A.累及皮膚/黏膜組織(如：全身性蕁麻疹、發癢或潮紅、嘴唇-舌-懸雍垂水腫)。B.危及呼吸(如：喘、哮鳴-支氣管攣縮)、喘鳴、尖峰流速下降、低血氧)。C.持續腸胃道症狀(如：腹部絞痛、嘔吐)。(3)接觸可能過敏原後血壓快速下降(數分鐘至數小時內)：A.成人血壓下降之定義：收縮壓小於90mmHg或下降大於其人血壓基礎值30%以上。B.嬰幼兒或兒童血壓下降之定義a.一個月以上至未滿一歲：低於70mmHg。b.一歲以上至未滿十一歲：低於[70mmHg+(2×age)]。c.十一歲以上至未滿十八歲：低於90mmHg或收縮壓下降大於其人血壓基礎值30%以上。2.支付規範：執行時點為症狀發生後六小時內及二十四至四十八小時。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tryptase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12210B",
      "display" : "水通道蛋白4抗體",
      "definition" : "註：1.適應症：(1)泛視神經脊髓炎症候群(NeuromyelitisOpticaSpectrumDisorders,NMOSD)之診斷。(2)多發性硬化症(MultipleSclerosis,MS)、視神經炎(OpticalNeuritis,ON)、橫截性脊髓炎(TransverseMyelitis,TM)、自體免疫性腦炎(AutoimmuneEncephalitis,AE)之鑑別診斷。2.專科別：過敏免疫風濕科(含兒科)、眼科(含兒科)、神經科(含兒科)。3.檢查次數：除下列情形，每人每年限執行一次。(1)檢測結果為陽性者，不得再檢驗。(2)檢測結果為陰性者，疑似泛視神經脊髓炎症候群且疾病明顯惡化時，得再次檢驗(需於病歷記載)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aquaporin-4 antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12211B",
      "display" : "異常凝血酶原檢驗",
      "definition" : "註：1.適應症：(1)肝硬化之慢性肝炎(含酒精性肝硬化)，並符合下列條件之一：A.肝組織切片MetavirF4或IshakF5以上，另血友病病人及類血友病病人經照會消化系專科醫師同意後，得不作切片。B.超音波診斷為肝硬化併食道或胃靜脈曲張，或肝硬化併脾腫大。C.電腦斷層或磁振造影檢查診斷為肝硬化。(2)肝癌接受根除治療之病人。2.執行頻率：每年兩次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PIVKA-II (Des-r-Carboxy Prothrombin)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12212B",
      "display" : "腦膜炎/腦炎病原體多標的核酸檢測",
      "definition" : "1.適應症：疑似有腦膜炎或腦炎徵兆或症狀之病人，且有實驗室檢查相關證據(含腦脊髓液)支持者。2.限急診科、感染科、兒科及神經科專科醫師執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Meningitis Encephalitis multiplex PCR"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12213B",
      "display" : "HLA-B*5801基因檢測",
      "definition" : "1.適應症：新使用Allopurinol前且符合下列任一條件者：(1)尿酸製造過多之痛風。(2)經促尿酸排泄藥物使用最大耐受劑量後仍無法控制血液尿酸值6mg/dl以下，需使用Allopurinol者。(3)具促尿酸排泄藥物使用禁忌症，如過敏、腎功能不全、肝功能不全等。(4)具尿酸成分之尿路結石病史。(5)接受化學治療之癌症病人用以預防急性尿酸引起腎病變。2.已連續使用Allopurinol一個月以上或曾使用Allopurinol累計滿三個月以上者，不予給付。3.為確保檢測品質，以LDT執行本項檢測，須具衛生福利部核准之實驗室開發檢測施行計畫。4.每人終生限給付一次，若檢測結果為陰性，且一個月內未開立Allopurinol者，不予給付；另檢測後一個月內未上傳檢測結果者，不予支付。5.內含一般材料費及檢測套組比率為百分之七十五。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HLA-B* 5801 gene typing"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12214B",
      "display" : "淋巴球毒殺試驗—同時檢測B細胞及T細胞",
      "definition" : "1.同時檢測B細胞及T細胞時，不得申報二次12090B。2.活體器官移植及骨髓移植前配對，若同時由多名捐贈者進行本項檢驗，申報上限二次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphocytotoxic test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12215C",
      "display" : "新型冠狀病毒核糖核酸定性擴增試驗",
      "definition" : "1.適應症：符合抗病毒藥物使用條件者或臨床醫師懷疑為COVID-19中重症者，且抗原快篩陰性或無法取得抗原快篩適用的檢體化驗時。2.支付規範：本項須按「全民健康保險鼓勵醫事服務機構即時查詢病患就醫資訊方案」格式，於檢驗(查)申報前上傳檢驗(查)結果報告，未上傳者本項不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "SARS-CoV-2 RNA qualitative amplification test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12216C",
      "display" : "C型肝炎病毒核心抗原",
      "definition" : "適應症：下列高風險族群再感染之追蹤檢驗C型肝炎病毒得執行本項或HCVRNA檢驗項目，執行頻率如下：1.C型肝炎抗體陽性之HIV感染者、靜脈注射藥癮者，每一年限申報一次。2.C型肝炎抗體陽性之慢性血液透析病人，每四年限申報一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hepatitis C core Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12217B",
      "display" : "白血病即時定量聚合酶連鎖反應法體外診斷醫療器材檢測(IVD)",
      "definition" : "1.適應症：(1)含有BCR-ABL1之慢性骨髓性白血病(chronicmyelogenousleukemia，CML)與急性白血病。(2)含有PML-RARA、RUNX1-ETO與CBFB-MYH11之急性骨髓性白血病(acutemyeloidleukemia，AML)。2.支付規範：限具BCR-ABL1或具PML-RARA及RUNX1-ETO及CBFB-MYH11檢測項目有通過美國病理學會(TheCollegeofAmericanPathologists,CAP)、財團法人全國認證基金會(TaiwanAccreditationFoundation,TAF)認證、台灣病理學會之分子實驗室認證或經衛生福利部食品藥物管理署精準醫療分子檢測實驗室認證(列冊登錄)之分子實驗室檢測，並須檢附IVD檢測試劑進貨證明，由特約醫事服務機構申報。3.執行本項之醫事服務機構應報經保險人核定，如有異動，應重行報請核定。4.不得同時申報編號12207B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "RQ-PCR(Real Time Quantitative PCR) for leukemia(IVD)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13001C",
      "display" : "痰液一般檢查(含括結晶，寄生蟲)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sputum Routine (Include Crystal, Parasite)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "13002B",
      "display" : "阿米巴抗體凝集試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amoebic Ab (IHA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13003B",
      "display" : "新型隱球菌抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cryptococcus neoformans antigen test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13004B",
      "display" : "白喉毒力試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Virulence test for c. diphtherise"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13005B",
      "display" : "披衣菌檢查(定性)",
      "designation" : [
        {
          "language" : "en",
          "value" : "DNA test for chlamydia (qualitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13006C",
      "display" : "排泄物，滲出物及分泌物之細菌顯微鏡檢查",
      "definition" : "1.此項檢查係指對糞便，喀痰，穿刺液，胃液,十二指腸液，膽汁，膿，眼分泌液，鼻腔液,咽喉液，唾液，及其他滲出物中細菌，原蟲等的檢查。2.同一檢體之檢查不論有無染色及方法如何，均限申報一次。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13007C",
      "display" : "細菌培養鑑定檢查(包括一般細菌、真菌、原蟲等為對象的培養鑑定，抗酸菌除外)",
      "definition" : "1.一般厭氧性的培養比照申報。2.對同一檢體合併實施一般培養及厭氧性培養時加算二分之一，以13008C申報。此項加計除山地離島地區外，基層院所限由專任醫師開立處方始可申報。3.不得同時申報13030B。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "13008C",
      "display" : "細菌培養鑑定檢查(包括一般細菌、真菌、原蟲等為對象的培養鑑定，抗酸菌除外)，對同一檢體合併實施一般培養及厭氧性培養時加算二分之一",
      "definition" : "1.一般厭氧性的培養比照申報。2.對同一檢體合併實施一般培養及厭氧性培養時加算二分之一，以13008C申報。此項加計除山地離島地區外，基層院所限由專任醫師開立處方始可申報。3.不得同時申報13030B。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13009C",
      "display" : "細菌藥物敏感性試驗－1菌種",
      "definition" : "1.細菌藥物感受性檢查結果，若無法檢測出細菌時，不可申報此項。2.此項之申報是以細菌培養鑑定所鑑定的菌種中實際實施細菌藥物感受性試驗的菌種數來申報。3.試驗的藥物須至少有三分之一以上是第一代之抗生素。4.除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13010C",
      "display" : "細菌藥物敏感性試驗－2菌種",
      "definition" : "1.細菌藥物感受性檢查結果，若無法檢測出細菌時，不可申報此項。2.此項之申報是以細菌培養鑑定所鑑定的菌種中實際實施細菌藥物感受性試驗的菌種數來申報。3.試驗的藥物須至少有三分之一以上是第一代之抗生素。4.除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13011C",
      "display" : "細菌藥物敏感性試驗－3菌種以上",
      "definition" : "1.細菌藥物感受性檢查結果，若無法檢測出細菌時，不可申報此項。2.此項之申報是以細菌培養鑑定所鑑定的菌種中實際實施細菌藥物感受性試驗的菌種數來申報。3.試驗的藥物須至少有三分之一以上是第一代之抗生素。4.除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13012C",
      "display" : "抗酸菌培養",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acid-fast culture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13013C",
      "display" : "抗酸菌鑑定檢查",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13014B",
      "display" : "抗酸菌藥物敏感性試驗—三種藥物以下",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sensitivity test of acid-fast"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13015C",
      "display" : "抗酸菌藥物敏感性試驗—四種藥物以上",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sensitivity test of acid-fast"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13016B",
      "display" : "血液培養",
      "definition" : "1.限對同一血液檢體合併實施厭氧及需氧檢查且使用血液培養瓶者申報。2.申報本項者，不得另行申報13007C、13008C。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13017C",
      "display" : "KOH顯微鏡檢查",
      "definition" : "除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "KOH preparation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13018C",
      "display" : "幽門桿菌檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Helicobacter pyroli test (Clo test)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13019B",
      "display" : "試管抗藥性試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sensitivity test (tube method)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13020C",
      "display" : "抗生素敏感性試驗(MIC法)一菌種【抗微生物藥劑最低抑菌濃度MIC】",
      "definition" : "不得同時申報13009C-13011C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bacteria MIC test (1 species) [(minimum inhibitory concentration MIC)]"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13021B",
      "display" : "抗生素敏感性試驗(MIC法)二菌種【抗微生物藥劑最低抑菌濃度MIC】",
      "definition" : "不得同時申報13009C-13011C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bacteria MIC test (2 species) [(minimum inhibitory concentration MIC)]"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13022B",
      "display" : "抗生素敏感性試驗(MIC法)三菌種以上【抗微生物藥劑最低抑菌濃度MIC)】",
      "definition" : "不得同時申報13009C-13011C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bacteria MIC test (3 species) [(minimum inhibitory concentration MIC)]"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13023C",
      "display" : "細菌最低抑制濃度快速試驗",
      "definition" : "註：不得同時申報13031B、13032B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bacterial minimal inhibition concentration rapid detection"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "13024C",
      "display" : "結核菌檢驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tuberculosis(T.B)test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13025C",
      "display" : "抗酸性濃縮抹片染色檢查",
      "definition" : "1.適應症:(1)懷疑分枝桿菌感染。(2)分枝桿菌治療監控。2.相關規範:(1)需在負壓實驗室操作。(2)需附抗酸菌濃縮抹片染色檢查報告。(3)不得與13006C同時申報。(4)限疾病管制署認可之結核病檢驗機構執行。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13026C",
      "display" : "抗酸菌培養(限同時使用固態培養基及具自動化偵測功能之液態培養系統)",
      "definition" : "1.適應症:(1)懷疑分枝桿菌感染。(2)分枝桿菌治療監控。2.相關規範:(1)需在負壓實驗室操作，且具自動化偵測之液態培養基系統。(2)需附抗酸菌培養報告。(3)不得與13012C同時申報。(4)限疾病管制署認可之結核病檢驗機構執行。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13028B",
      "display" : "困難梭狀桿菌抗原快速檢驗(GDH)",
      "definition" : "1.結腸炎、偽膜性結腸炎、中毒性巨結腸及結腸穿孔。2.抗生素治療後發生腹瀉症狀。3.懷疑C.difficile群聚感染。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Clostridium Difficile GDH Ag rapid test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13029B",
      "display" : "困難梭狀桿菌毒素A、B快速檢驗(ToxinA/B)",
      "definition" : "1.結腸炎、偽膜性結腸炎、中毒性巨結腸及結腸穿孔。2.抗生素治療後發生腹瀉症狀。3.懷疑C.difficile群聚感染。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Clostridium Difficile Toxin A/B rapid test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13030B",
      "display" : "胃幽門螺旋桿菌特殊培養法",
      "definition" : "1.適應症：(1)消化性潰瘍(不含食道)。(2)胃淋巴瘤。(3)萎縮性胃炎。(4)結節性胃炎。(5)胃黏膜腸上皮化生。(6)胃癌。2.每人以申報一次為原則，惟第一線除菌治療失敗，需進行第二、三線治療時，得再次檢測，並應於病歷詳述理由。3.限內科、兒科、家醫科專科醫師開立處方。4.須於生物安全第二等級(BSL-2)實驗室操作。5.不得同時申報13007C、13008C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Special Cultivation method for Helicobacter pylori"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13031B",
      "display" : "胃幽門螺旋桿菌藥物敏感度檢測—三種抗生素藥物敏感度檢測",
      "definition" : "1.適應症：(1)消化性潰瘍(不含食道)。(2)胃淋巴瘤。(3)萎縮性胃炎。(4)結節性胃炎。(5)胃黏膜腸上皮化生。(6)胃癌。2.支付規範：(1)三種抗生素之藥物敏感度檢測包含：Metronidazole、Levofloxacin及Clarithromycin(2)須於生物安全第二等級(BSL-2)實驗室操作。(3)限內科、兒科、家醫科專科醫師開立處方。(4)執行頻率：每人以申報一次為原則。(5)不得同時申報13023C、13032B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Susceptibility testing containing three antibiotics for Helicobacter pylori"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13032B",
      "display" : "難治型胃幽門螺旋桿菌藥物敏感度檢測—五種抗生素藥物敏感度檢測",
      "definition" : "1.適應症：(1)消化性潰瘍(不含食道)。(2)胃淋巴瘤。(3)萎縮性胃炎。(4)結節性胃炎。(5)胃黏膜腸上皮化生。(6)胃癌。2.支付規範：(1)僅用於第一線治療失敗，需進行第二線治療時，並應於病歷詳述理由。(2)五種抗生素之藥物敏感度檢測包含：Metronidazole、Levofloxacin、Clarithromycin、Tetracycline及Amoxicillin。(3)須於生物安全第二等級(BSL-2)實驗室操作。(4)限內科、兒科、家醫科專科醫師開立處方。(5)執行頻率：每人以申報一次為原則。(6)不得同時申報13023C、13031B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Susceptibility testing containing five antibiotics for refractory Helicobacter pylori"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14001B",
      "display" : "病毒分離及鑑定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Isolation and identification of virus"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14002B",
      "display" : "腺病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Adenovirus CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14003B",
      "display" : "巨大細胞病毒抗體補體結合法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cytomegalovirus CMV CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14004B",
      "display" : "巨大細胞病毒抗體酵素免疫法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cytomegalovirus CMV EIA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14005C",
      "display" : "單純疱疹病毒III補體結合抗體(各項)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Herpes simpliex virus CF HSV Ab (each)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14006B",
      "display" : "麻疹病毒抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Measles virus Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14007B",
      "display" : "麻疹病毒IgM抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Measles virus IgM Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14008B",
      "display" : "麻疹病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Measles CF virus Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14009C",
      "display" : "腮腺炎病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mumps CF virus Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14010B",
      "display" : "呼吸道融合病毒抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Respiratory syncytial virus Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14011B",
      "display" : "呼吸道融合病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Respiratory syncytial virus (RSV) CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14012B",
      "display" : "水痘帶狀疱疹病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Varicella-zoster virus CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14013B",
      "display" : "水痘帶狀疱疹病毒IgM抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Varicella-zoster virus IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14014B",
      "display" : "肺炎漿胞菌補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mycoplasma pneumoniae CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14015B",
      "display" : "副流行性感冒病毒1型抗原",
      "definition" : "執行二項(含二項)以上副流行性感冒病毒抗原檢測者，第二項(含二項)以後一律八折支付",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parainfluenza virus type 1 Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14016B",
      "display" : "副流行性感冒病毒2型抗原",
      "definition" : "執行二項(含二項)以上副流行性感冒病毒抗原檢測者，第二項(含二項)以後一律八折支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parainfluenza virus type 2 Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14017B",
      "display" : "副流行性感冒病毒1型補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parainfluenza type 1 CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14018B",
      "display" : "副流行性感冒病毒2型補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parainfluenza type 2 CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14019B",
      "display" : "副流行性感冒病毒3型補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parainfluenza type 3 CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14020B",
      "display" : "流行性感冒Ａ型病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Influenza A CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14021B",
      "display" : "流行性感冒Ｂ型病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Influenza B CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14022B",
      "display" : "日本腦炎病毒補體結合抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Japanese encephalitis CF Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14023B",
      "display" : "柯沙奇Ｂ型病毒抗體(每項)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coxsackie B virus Ab (each)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14024B",
      "display" : "柯沙奇Ｂ型病毒補體結合抗體(B1-B6)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coxsackie virus CF Ab (type B1-B6)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14025C",
      "display" : "腸內病毒70抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Entero virus type 70 Ab"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14026C",
      "display" : "輪狀病毒抗原",
      "definition" : "註：屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rota virus Ag"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14027C",
      "display" : "輪狀病毒抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rota virus Ab"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14028B",
      "display" : "呼腸弧病毒抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Reo virus Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14029B",
      "display" : "小兒麻痺病毒第1.2.3型抗體各項",
      "designation" : [
        {
          "language" : "en",
          "value" : "Polio virus type Ⅰ.Ⅱ.Ⅲ Ab each"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14030C",
      "display" : "Ｂ型肝炎表面抗原(定性)",
      "definition" : "14030C至14032C不得同時申報14085C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBsAg-Latex"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14031C",
      "display" : "Ｂ型肝炎表面抗原(定性)",
      "definition" : "14030C至14032C不得同時申報14085C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBsAg-RPHA"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14032C",
      "display" : "Ｂ型肝炎表面抗原(定性)",
      "definition" : "14030C至14032C不得同時申報14085C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBsAg (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14033C",
      "display" : "Ｂ型肝炎表面抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti HBs"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14034C",
      "display" : "B型肝炎e抗原檢查HBeAg－RPHA法",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBeAg--RPHA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14035C",
      "display" : "B型肝炎e抗原檢查HBeAg",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBeAg (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14036C",
      "display" : "Ｂ型肝炎Ｅ抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBe(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14037C",
      "display" : "Ｂ型肝炎核心抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBc(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14038C",
      "display" : "Ｂ型肝炎核心抗體免疫球蛋白Ｍ檢查(EIA/LIA法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBc IgM (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14039C",
      "display" : "Ａ型肝炎抗體免疫球蛋白Ｍ檢查(EIA/LIA法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HAV IgM(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14040C",
      "display" : "Ａ型肝炎抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti HAV"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14041B",
      "display" : "Ｄ型肝炎抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-delta"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14042B",
      "display" : "弓漿蟲IgG抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Toxoplasma IgG AB"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14043B",
      "display" : "德國麻疹血球凝集抗體效價(ＨＩ法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rubella AB titer(ＨＩ法)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14044B",
      "display" : "德國麻疹免疫球蛋白Ｇ檢查(EIA/LIA法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-rubella IgG(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14045B",
      "display" : "德國麻疹免疫球蛋白Ｍ檢查(EIA/LIA法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-rubella IgM(EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14046B",
      "display" : "ＥＢ病毒囊鞘免疫球蛋白Ｇ.Ｍ.Ａ.(ＩＦＡ法)",
      "designation" : [
        {
          "language" : "en",
          "value" : "EB VCA IgG, IgM, IgA, IFA METHOD, EACH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14047B",
      "display" : "EB病毒核抗原抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "EBNA Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14048B",
      "display" : "巨細胞病毒核抗原抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cytomegalo virus IgM Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14049C",
      "display" : "後天免疫不全症候群檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "ANTI-HIV TEST (EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14050B",
      "display" : "後天免疫不全症候群檢查-顆粒凝集法",
      "designation" : [
        {
          "language" : "en",
          "value" : "ANTI-HIV TEST PA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14051C",
      "display" : "Ｃ型肝炎病毒抗體檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "HCV Ab( EIA/LIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14052B",
      "display" : "單純疱疹病毒IgM抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Herpes simplex virus IgM Ab"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14053B",
      "display" : "單純疱疹病毒-1或-2抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Herpes Simplex Virus-1 Ag or-2 Ag。"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14054B",
      "display" : "腮腺炎病毒IgM抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mumps virus IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14055B",
      "display" : "B型肝炎表面抗體效價檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBS titer"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14056B",
      "display" : "腸病毒71型-IgM抗體快速檢驗試驗",
      "definition" : "適應症1.臨床上出現手足口症或疱疹性咽喉炎症狀之患者。2.臨床上出現病毒性腦膜炎、心肌炎、急性心肺衰竭等疑似腸病毒感染之患者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Enterovirus 71 IgM antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14057B",
      "display" : "流行性感冒嗜血桿菌抗原B檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Haemophilus influenzae type B test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "14058C",
      "display" : "呼吸融合細胞病毒試驗",
      "definition" : "註：屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "RSV screening test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14059B",
      "display" : "巨細胞病毒抗原檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "CMV Ag test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14060B",
      "display" : "第六型人類庖疹病毒抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Human herpesvirus-6 antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14061B",
      "display" : "水痘-帶狀庖疹抗原檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "VZV Ag test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14062B",
      "display" : "登革熱病毒抗體IgM檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dengue virus 1gM test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14063B",
      "display" : "登革熱病毒抗體IgG檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dengue virus 1gG test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14064C",
      "display" : "腺病毒抗原檢查",
      "definition" : "註：1.不論何種檢測方式。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Adenovirus Ag test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14065C",
      "display" : "流行性感冒A型病毒抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Influenza A Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14066C",
      "display" : "流行性感冒B型病毒抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Influenza B Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14067B",
      "display" : "弓漿蟲病毒IgM間接免疫螢光試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Toxoplasma-1gM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14068B",
      "display" : "帶狀疱疹病毒IgG連酶抗體試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Varicella/zoster-1gG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14069B",
      "display" : "單純性疱疹病毒IgG連酶抗體試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "HSV-IgG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14070B",
      "display" : "麻疹病毒抗體IgG",
      "designation" : [
        {
          "language" : "en",
          "value" : "Measles Ab (IgG)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14071B",
      "display" : "弓漿蟲抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "T. GONDII Ab (IgM)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14072B",
      "display" : "C型肝炎確認檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "RIBA test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14073B",
      "display" : "巨細胞病毒傳訊者核糖核酸pp67",
      "definition" : "註：1.本項檢查不得做為例行篩檢檢測用。2.適應症限定為器官移植、骨髓移植患者懷疑巨細胞病毒感染後可能發展為疾病之患者。3.檢查次數：器官移植或骨髓移植後每週或每二週作一次，最多連續作三個月。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CMV m-RNA pp67"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14074C",
      "display" : "HIV病毒負荷量檢查",
      "definition" : "1.限下列任一情境使用(1)人類免疫缺乏病毒感染診斷A.使用時機：抗體初篩檢測(14049C或14050B或14082B)陽性後執行。B.執行頻率：每人每年限一次。C.執行院所：限衛生福利部人類免疫缺乏病毒指定醫事機構或疾病管制署病原體分生檢測認可之健保特約醫事服務機構申報。(2)人類免疫缺乏病毒感染治療監測A.執行院所：限衛生福利部人類免疫缺乏病毒指定醫事機構申報。B.執行頻率：每人每年限四次。2.屬西醫基層總額部門院所限由感染科專科醫師開立處方始可申報。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HIV viral load test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14075C",
      "display" : "HIV-I抗體檢查(西方墨點法)",
      "definition" : "1.限衛生福利部人類免疫缺乏病毒指定醫事機構或疾病管制署西方墨點法認可之健保特約醫事服務機構執行。2.限於14049C、14050B或14082B陽性時，確定診斷用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HIV-I Ab (Western blot)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14076C",
      "display" : "HIV-II抗體檢查(西方墨點法)",
      "definition" : "1.限衛生福利部人類免疫缺乏病毒指定醫事機構或疾病管制署西方墨點法認可之健保特約醫事服務機構執行。2.限於14049C、14050B或14082B陽性時，確定診斷用。3.HIV-II限於HIV-I檢查時未出現gp120band。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HIV-II Ab (Western blot)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14077C",
      "display" : "血中白血球巨細胞病毒抗原pp65",
      "designation" : [
        {
          "language" : "en",
          "value" : "CMV Ag pp65"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14078C",
      "display" : "急性E型肝炎抗體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HEV IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14079C",
      "display" : "PavovirusB19免疫球蛋白G檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pavovirus B19 IgG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14080C",
      "display" : "PavovirusB19免疫球蛋白M檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pavovirus B19 IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14081B",
      "display" : "副流行性感冒病毒3型抗原",
      "definition" : "執行二項(含二項)以上副流行性感冒病毒抗原檢測者，第二項(含二項)以後一律八折支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parainfluenza virus type 3 Ag"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14082C",
      "display" : "人類免疫缺乏病毒抗原及抗體複合型試驗",
      "definition" : "1.不得同時申報14049C。2.除山地離島地區外，基層院所限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HIV Ag/Ab Combo Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14083C",
      "display" : "HIV1/2抗體確認檢驗(抗體免疫層析檢驗法)",
      "definition" : "1.使用時機：限於14049C、14050B或14082B陽性時，確定診斷用。2.限衛生福利部人類免疫缺乏病毒指定醫事機構或疾病管制署抗體免疫層析法認可之健保特約醫事服務機構執行。3.不得同時申報14075C、14076C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HIV 1/2 Confirmatory Test(Immunochromatographic Test)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14084C",
      "display" : "新型冠狀病毒抗原檢測",
      "definition" : "1.適應症：符合抗病毒藥物使用條件者。2.支付規範：(1)本項須按「全民健康保險鼓勵醫事服務機構即時查詢病患就醫資訊方案」格式，於檢驗(查)申報前上傳檢驗(查)結果報告，未上傳者本項不予支付。(2)限由醫事人員執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "SARS-CoV-2 Ag test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14085C",
      "display" : "B型肝炎病毒核心關連抗原(HBcrAg)合併表面抗原(HBsAg)定量檢驗",
      "definition" : "1.適應症：慢性B型肝炎病人，因B型肝炎發作接受口服抗病毒藥物治療，得於停藥前執行本項檢測，而延長用藥期間之檢驗，每次檢驗須間隔二十四週以上。2.不得同時申報12184C、14030C、14031C、14032C。3.須符合全民健康保險藥物給付項目及支付標準附件六藥品給付規定第十節抗微生物劑10.7.3.暨10.7.4.之醫師資格。4.本項須按「全民健康保險鼓勵醫事服務機構即時查詢病患就醫資訊方案」格式，於檢驗(查)申報前上傳檢驗(查)結果報告，未上傳者本項不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Quantification of Hepatitis B virus core-related antigen (HBcrAg) combined with Hepatitis B surface antigen(HBsAg)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15001C",
      "display" : "體液細胞檢查",
      "definition" : "註:含痰(Sputum)，尿(Urine)，腹水(Ascites)，脊髓液(C.S.F.)，胸水(PleuralEffusion)，心包膜積水(Pericardialeffusion)，氣管刷取(bronchialbrushing)及氣管沖洗(bronchialwashing)等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Body fluid cytology"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15007C",
      "display" : "穿刺細胞檢查",
      "definition" : "註：1.含甲狀腺(Thyroid)，淋巴腺(Lymphnode)，乳房(Breast)，肺臟(Lung)，縱膈腔(Mediastinum)，肝臟(Liver)，胰臟(Pancreas)，腫瘤(Mass)穿刺及鼻(Nasal)細胞檢查等。2.屬西醫基層總額部門院所，適應症如下：(1)甲狀腺結節或囊腫之鑑別良/惡性。(2)甲狀腺癌超音波陰影經治療後不消失。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Needle aspiration cytology"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15017C",
      "display" : "婦科細胞檢查",
      "definition" : "1.子宮頸或陰道抹片同一病人3~6個月內限做1次。2.6個月內需重新施做之適應症：(1)曾罹患過子宮頸癌或癌前病變之婦女(2)最近一次子宮頸抹片檢查結果為異常之婦女(3)免疫功能受抑制的高危險群婦。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pap's smear (Cytology部分)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "15018B",
      "display" : "體液細胞檢查加細胞切片",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fluid cytology plus cell block"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15020B",
      "display" : "支氣管切片奈印",
      "designation" : [
        {
          "language" : "en",
          "value" : "Impint bronchial biopsy-CM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15021C",
      "display" : "薄片細胞學檢查",
      "definition" : "子宮頸癌篩檢及診斷不得申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thin layer cytology"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15022C",
      "display" : "血液抹片檢查",
      "definition" : "註：不得與08009C、08013C同時申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blood smear interpretation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16001C",
      "display" : "精液分析",
      "definition" : "包括motility,count,morphology,amount,appearance,PH測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Semen analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16002C",
      "display" : "腹水分析",
      "definition" : "包括蛋白定性、血球計數、白血球分類。Includeprotein-qualitative、cellcount&DC",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ascitic fluid analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16003C",
      "display" : "胸水分析",
      "definition" : "包括蛋白定性、血球計數、白血球分類。Includeprotein-qualitative、cellcount&DC",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pleural fluid analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16004C",
      "display" : "胃液分析",
      "definition" : "包括數量、顏色、混濁度、粘液、臭氣、PH、Pepsin及乳酸定量、潛血、蟲卵在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gastric juice analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16005B",
      "display" : "十二指腸液分析",
      "definition" : "包括數量、顏色、混濁度、粘液、臭氣、PH、Pepsin及乳酸定量、潛血、蟲卵在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "Duodenal juice analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16006C",
      "display" : "腦脊髓液分析",
      "definition" : "包括WBC,RBC,Pandy's,neutrophil,lymphocyte,eosinophil在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "CSF"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16007C",
      "display" : "膿或分泌物分析",
      "definition" : "如同時實施其他生化、血液檢查,比照本標準表已有項目申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pus or discharge analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16008C",
      "display" : "關節囊液分析--常規檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Synovial fluid analysis-Routine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16009C",
      "display" : "心胞膜液常規檢查(含蛋白定性、血球計數、白血球分類)",
      "definition" : "其他心胞膜液各項檢查,請就實際檢查內容依支付標準生化學、細胞學、細菌學..等各章節所訂項目及點數申報費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pericardial fluid routine test (Pandytest, cell count, differential count )"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16010C",
      "display" : "分析肺泡灌洗液之細胞總數及分類",
      "designation" : [
        {
          "language" : "en",
          "value" : "Analysis of total cell count and differntiation in BAL fluid"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16011C",
      "display" : "搖晃試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Shake test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16012C",
      "display" : "關節囊液分析--茜素紅S染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "Synovial fluid analysis-Alizarin Red S stain"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "16013C",
      "display" : "關節囊液分析--偏光鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Synovial fluid analysis-Crystal exam"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17001C",
      "display" : "萊特氏最高流量計—移動型",
      "definition" : "註:內含一般材料費及單一使用拋棄式之過濾器",
      "designation" : [
        {
          "language" : "en",
          "value" : "Wrights peak flow meter-portable"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17002B",
      "display" : "最大吸氣壓及最大吐氣壓",
      "definition" : "1.限呼吸器weaning時申報。2.內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pi max and Pe max"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17003C",
      "display" : "流量容積圖形檢查",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Flow-volume curve"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17004C",
      "display" : "標準肺量測定(包括FRC測定)",
      "definition" : "1.包含流速－容積測定(flow-volumetest)、肺通氣試驗(Ventilationtest)、肺餘量試驗(residualvolumetest)2.內含一般材料費及單一使用拋棄式之過濾器。3.除山地離島地區外，基層院所限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lung volume with functional residual capacity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17005B",
      "display" : "單次呼吸肺氮廓清試驗",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Single breath nitrogen washout test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17006C",
      "display" : "支氣管擴張劑試驗",
      "definition" : "1.內含一般材料費及單一使用拋棄式之過濾器。2.除山地離島地區外，基層院所限由專任醫師開立處方始可申報。3.不得同時申報：17019C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchodilator test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17007B",
      "display" : "標準支氣管擴張劑試驗",
      "definition" : "1.內含一般材料費及單一使用拋棄式之過濾器。2.不得同時申報17020B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Standard bronchodilator test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17008B",
      "display" : "睡眠多項生理檢查",
      "definition" : "註:1.含EEG、EMG、ECG、EOG、respiratoryairflow、thoracicrespiratoryeffort、abdominalrespiratoryeffort。2.適應症如下:(1)睡眠呼吸障礙、猝睡症、睡眠行為異常、parasomnia癲癇引起的睡眠中斷、神經肌肉疾病侷限性胸廓異常合併睡眠問題。(2)不得做慢性肺部疾病例行診斷。(3)「困難處理失眠症」之鑑別診斷。3.內含一般材料費及單一使用拋棄式之過濾器。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17009B",
      "display" : "一氧化碳肺瀰散量測定",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CO diffusing capacity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17010B",
      "display" : "壓力容積圖形試驗",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pressure volume curve"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17011B",
      "display" : "壓力流量圖形試驗",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pressure flow curve"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17012B",
      "display" : "壓力容積圖形及壓力流量圖形試驗",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pressure volume curve and pressure flow curve"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17013B",
      "display" : "二氧化碳刺激試驗及閉口壓",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CO2 stimulation test and mouth occlusion pressure"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17014B",
      "display" : "閉鎖容積試驗",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Closing volume"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17015B",
      "display" : "缺氧刺激試驗",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hypoxic stimulation test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "17016B",
      "display" : "運動肺功能試驗",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Exercise pulmonary function test (stress test)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17017B",
      "display" : "全階呼吸量測定",
      "definition" : "1.限呼吸器weaning時申報。2.內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Haloscale respiration"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17018B",
      "display" : "基礎代謝率",
      "definition" : "註：內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Basal metabolic rate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17019C",
      "display" : "支氣管激發試驗",
      "definition" : "1.內含一般材料費及單一使用拋棄式之過濾器。2.不得同時申報：17006C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchial provocation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17020B",
      "display" : "多次呼吸肺氮廓清試驗",
      "definition" : "1.內含一般材料費及單一使用拋棄式之過濾器。2.不得同時申報17007B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mutiple breath nitrogen washout test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17021B",
      "display" : "肺成熟度檢查–微小氣泡檢測法",
      "definition" : "1.適應症:妊娠週數小於38週，出生後發生呼吸窘迫之新生兒。2.內含一般材料費及單一使用拋棄式之過濾器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Microbobble test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17022B",
      "display" : "呼氣一氧化氮監測(FeNO)",
      "definition" : "1.適應症:六歲以上至未滿十三歲確診氣喘患者追蹤使用。2.支付規範:(1)申報次數:一年最多申報三次。(2)申報專科別:兒科。(3)執行限制:限受過操作訓練之醫療人員。(4)費用申報時必要之附件:檢測報告。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17023B",
      "display" : "六分鐘步行測試",
      "definition" : "註：1.適應症：(1)原發性肺性高血壓(Primarypulmonaryhypertension)。(2)先天性心臟病合併肺高壓。(3)其他申請肺動脈高血壓用藥申請事前審查者。2.適用層級：申請肺高壓用藥之醫院門、住診均可使用。3.支付規範：(1)執行頻率：每年二次。(2)不得同時申報57017C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Six-minute Walk Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "17024B",
      "display" : "胸部電阻斷面造影",
      "definition" : "1.適應症：入住加護病房，且為柏林定義中重度急性呼吸窘迫症候群病人(ICD-10-CM：J80)。2.限內科、外科、麻醉科、兒科、急診醫學科、神經科及神經外科專科醫師執行。3.須醫師及呼吸治療師在場共同操作，隨時提供必要之緊急措施。4.執行本項至少需有十六個以上胸帶電極數，且執行本項時間至少六十分鐘，並應於申報時填寫執行起迄時間。5.需檢附「胸部電阻斷面造影報告」備查。6.每次住院以申報一次為原則，至多申報二次，並應於病歷敘明重複執行之原因。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chest electrical impedance tomography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18001C",
      "display" : "心電圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "E.K.G. (Electrocardiography)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "18002B",
      "display" : "向量心電圖",
      "definition" : "限由心臟專科醫師施行後申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "V.C.G. (Vectorcardiography)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18003C",
      "display" : "馬斯特運動心電圖",
      "definition" : "限由心臟專科醫師施行後申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Masters two-step test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18004C",
      "display" : "馬斯特運動心電圖",
      "definition" : "1.withcontrast2.限由心臟專科醫師施行後申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Masters two-step test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18005C",
      "display" : "超音波心臟圖(包括單面、雙面)",
      "definition" : "1.限由心臟專科醫師施行後申報。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Echocardiography (-M-mode and -sector- scan)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18006C",
      "display" : "杜卜勒氏超音波心臟圖",
      "definition" : "1.限由心臟專科醫師施行後申報。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Doppler echocardiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18007C",
      "display" : "杜卜勒氏彩色心臟血流圖",
      "definition" : "1.已含18006C杜卜勒氏超音波心臟圖，不得同時申報18006C。2.限由心臟專科醫師施行後申報。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。4.適應症：(1)心臟手術或介入性治療前後之評估。(2)瓣膜性心臟疾病。(3)先天性心臟病。(4)心肌病變或缺血性心臟病。(5)主動脈病變。(6)心臟衰竭。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Doppler color flow mapping"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18008C",
      "display" : "杜卜勒氏血流測定(周邊血管)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Doppler flowmetry (perivasculary)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18009B",
      "display" : "動脈分段血流及壓力之測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "PVR (pulse volume recording)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18010C",
      "display" : "頸動脈聲圖檢查",
      "definition" : "註：屬西醫基層總額部門院所支付規範如下：1.符合下列任一條件，且頸動脈超音波檢查(20013C)發現內膜增厚1.0mm以上：(1)急性腦中風或腦中風病史。(2)六十五歲以上具高風險心血管危險因子之一(高血壓、高血糖、高血脂、吸菸史或有腦中風家族病史)。(3)疑暫時性腦中風(TIA)，且有突發性腦中風相關症狀(臉及肢體出現麻或無力、意識混亂、表達或理解力異常、視力障礙、中樞性頭暈、行走、平衡障礙或不明原因頭痛)。(4)曾經接受頭頸部放射治療超過十年以上。(5)脈動性耳鳴。2.除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CPA (carotid phonoangiography)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18011B",
      "display" : "四肢血流探測,壓力測量並記錄",
      "designation" : [
        {
          "language" : "en",
          "value" : "Doppler extremity and pressure recording"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18012B",
      "display" : "深部靜脈血流檢查圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "PRG (phleborheograph)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18013C",
      "display" : "胎心音監視(三小時以內)",
      "definition" : "不得同時申報18035B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fetal monitor ≦ 3hrs"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18014C",
      "display" : "胎心音監視(三小時後每小時)",
      "definition" : "一日內累積監視超過六小時者仍以六小時計，且不得同時申報18035B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fetal monitor,per hour after the first 3 hours"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18015B",
      "display" : "極度踏車運動試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Treadmill exercise test or graded exercise test, GXT"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "18016B",
      "display" : "頸靜脈波圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "J.P. (Jugular pulse)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18017B",
      "display" : "頸動脈波圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "C.P. (Carotid pulse)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18018B",
      "display" : "心音圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.C.G. (Phonocardiography)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18019C",
      "display" : "攜帶式心電圖記錄檢查",
      "definition" : "1.包括材料費(patientkit)在內。2.限心臟專科醫師實施，申報費用應附檢查報告。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "24hrs. Holter's scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18020B",
      "display" : "心導管－一側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cardiac cath- one side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18021B",
      "display" : "心導管－二側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cardiac cath- both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18022B",
      "display" : "冠狀動脈攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coronary angiography"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "18023B",
      "display" : "希氏束檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBE (His Bundle electrogram)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18024B",
      "display" : "電氣生理檢查－一般性",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electrophysiology- general"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18025B",
      "display" : "電氣生理檢查－複雜性",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electrophysiology-complex"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18026B",
      "display" : "心室造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cardioangiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18027B",
      "display" : "主動脈造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aortography(cineangiography)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18028B",
      "display" : "心律調復術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cardioversion (one course)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18029B",
      "display" : "心輸出量測定",
      "definition" : "註：1.第二次以後，每次測定支付100點。2.每日最多以申報二次為限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cardiac output"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18030B",
      "display" : "心輸出量測定第二次以後",
      "definition" : "註：1.第二次以後，每次測定支付100點。2.每日最多以申報二次為限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Second time cardiac output"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18031B",
      "display" : "立致停測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Regitine test (phentolamine test)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "18032B",
      "display" : "組織胺測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Histamine test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18033B",
      "display" : "經食道超音波心圖",
      "definition" : "註：不得同時申報18047B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T.E.E"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18034B",
      "display" : "手腕式心律紀錄檢查，三十日內每人次",
      "definition" : "含一般及特殊材料費。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Wrist ECG Recorder"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18035B",
      "display" : "胎心音監視(每日)",
      "definition" : "1.限住院病人申報。2.不得同時申報：18013C、18014C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fetal monitor, per day"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18036B",
      "display" : "心跳間變異數",
      "designation" : [
        {
          "language" : "en",
          "value" : "R-R interval variation，RRIV"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18037C",
      "display" : "胎兒、臍帶、或孕期子宮動脈杜卜勒超音波",
      "definition" : "1.含胎兒超音波檢查。2.屬西醫基層總額部門院所，比照高危險妊娠適應症：(1)嚴重妊娠高血壓或子癲前症。(2)羊水過多或過少。(3)多胞胎併發症(如雙胞胎輸血症候群、羊水或胎兒生長異常)。(4)胎兒生長遲緩或胎兒發育異常者(IUGR)或胎盤功能異常者。(5)妊娠合併內科疾病：糖尿病、腎臟疾病(NS、IgA、ESRD)或免疫性疾病(如SLE)。(6)胎兒水腫或胎兒貧血。(7)杜卜勒檢查異常者之追蹤。(8)胎兒構造異常。(9)懷疑植入性胎盤。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fetal,umbilical cord,or gravid uterine artery Doppler ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18038B",
      "display" : "骨盆腔血流檢查",
      "definition" : "含骨盆腔超音波檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pelvic Doppler ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18039C",
      "display" : "無壓迫性試驗",
      "definition" : "註：屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Non-stress test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18040B",
      "display" : "催產素挑釁試驗(胎盤功能試驗)",
      "definition" : "使用之點滴及藥物另行申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Oxytocin challenge test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18041B",
      "display" : "周邊動靜脈血管超音波檢查",
      "definition" : "包括血管形態及血流之波相、流速、流量、阻力等測量。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sonography for peripheral vessel"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18042B",
      "display" : "靜脈曲張檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tourniquet test (including Perthes's test and Brodie-Trendelenburg test--etc.)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18043B",
      "display" : "冠狀動脈血管內超音波",
      "definition" : "1.包含心導管檢查費用2.適應症：(1)左主幹冠狀動脈；左前降枝、左迴旋枝及右冠狀動脈開口病灶；及慢性完全阻塞性之病灶(2)評估支架內再狹窄之原因及選擇最佳的治療方法(3)血管狹窄長度超過35毫米或短於5毫米且狹窄原因不明的治療方式(4)在完成介入性治療後(包括氣球擴張術或血管支架置放術)，血管攝影仍呈現內膜剝離或填充缺陷之影像時(5)冠狀動脈鈣化嚴重，欲以血管鑽頭研磨器作為治療工具之血管(6)作為冠狀動脈斑塊去除術(DCA)之準則及依據。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coronary Intravascular Ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18044B",
      "display" : "負荷式心臟超音波心臟圖",
      "definition" : "1.適應症如下：(1)胸痛或疑似心絞痛，但心電圖無法判讀或無法運動，用來診斷冠狀動脈心臟病。(2)急性胸痛症候群但無心電圖或心肌酵素上升之系列變化，用來診斷冠狀動脈心臟病。(3)新發生或新診斷之心臟衰竭或左心室收縮功能障礙，用來診斷冠狀動脈心臟病或評估狀動脈心臟病之可能性。(4)過去已經診斷冠狀動脈心臟病接受藥物治療，但症狀惡化時，做為危險度評估。(5)冠狀動脈心臟病已經經由心導管或電腦斷層診斷，但無法判斷狹窄程度是否有臨床顯著影響。(6)冠狀動脈心臟病已經經過經皮血管介入治療或燒道手術後再發胸痛，做為危險度評估。(7)中度以上危險群病人合併運動功能不良，非心臟手術前的術前危險度評估。(8)嚴重冠狀動脈疾病合併左心室功能低下，評估心肌存活度。(9)瓣膜性心臟病，疾病嚴重度之評估。2.相關規範：(1)限心臟專科醫師執行。(2)限一年申報一次。(3)不得同時申報之診療項目及編號：18003C、18004C，若適應症為1,2,7不應同時申報運動心電圖(18015B)。若適應症為8不應同時申報核子醫學攝影。(4)費用申報時必要之附件：休息時心臟超音波左心室局部活動與最高負荷時左心室局部活動的變化。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stress echocardiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18045B",
      "display" : "傾斜床檢查",
      "definition" : "1.適應症如下：(1)首次發生暈厥合併頭部或其他身體部位之外傷。(2)首次暈厥發生在工作中，並足以影響公共安全者，如：大眾運輸工具司機(3)暈厥反覆發生而無明顯心臟疾病之病患。(4)心臟疾病患者，反覆發生非心因性暈厥。(5)鑑別迷走神經反應或姿態性低血壓引起之暈厥。2.相關規範：(1)限心臟專科或神經科或耳鼻喉科專科醫師執行。(2)限一年申報一次。(3)不得同時申報之診療項目及編號：A.心電圖監控(編號：18001C、18002B及47032B)B.血壓監控(編號：47033B)C.靜脈輸液相關費用(編號：39016B)。(4)費用申報時必要之附件：完整之檢查報告(含血壓、心跳、藥物劑量、與病人症狀之紀錄)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Head-up Tilt table test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "18046B",
      "display" : "生物電抗非侵入式心輸出量及血流動力學監測",
      "definition" : "1.適應症：(1)心臟手術病人或未滿十九歲施行心導管介入性治療病人，手術中或手術後心臟功能衰竭，有立即生命危險者。(2)心臟病人，使用數種強心劑。(3)各種休克病人及心臟血管功能衰竭，經使用數種心臟藥物，亦無法有效改善者。2.支付規範：(1)限加護病房病人申報。(2)同次住院，未滿十九歲者每兩週得申報一次，其餘病人限申報一次。(3)執行本項時不得同時執行18029B「心輸出量測定」及18030B「第二次心輸出量測定」。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bioreactance non-invasive cardiac output and hemodynamic monitoring"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "18047B",
      "display" : "心內超音波",
      "definition" : "1.適應症：心房顫動，曾接受電氣燒灼手術(33139B、33140B，含冷凍消融手術)，須再次執行電氣燒灼手術(含冷凍消融手術)者。2.限中華民國心臟學會、中華民國心律醫學會核發「心臟電生理暨介入治療專科醫師認證」之心臟專科醫師執行。3.申報費用時應檢附影像報告於病歷備查。4.不得同時申報18033B及33049B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intracardiac echocardiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19001C",
      "display" : "腹部超音波(包括肝liver,膽囊gallbladder,胰pancreas,脾spleen,下腔靜脈inferiorvenacava,腹主動脈abdominalaorta,腎kidney及其他腹部超音波abdominalothers在內)",
      "definition" : "兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Abdominal ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19002B",
      "display" : "術中超音波",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intra-operative echo"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19003C",
      "display" : "婦科超音波",
      "definition" : "註：1.不含杜卜勒檢查及立體組像。2.不得同時申報19011C、19013C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gynecologic ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19004C",
      "display" : "鼻竇超音波檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Echo for sinus"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19005C",
      "display" : "其他超音波",
      "definition" : "1.本節未列之超音波檢查，得以本項申報。2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Echo for others"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19007C",
      "display" : "超音波導引(為組織切片，抽吸、注射等)",
      "definition" : "1.實施超音波導引下組織切片、抽吸、注射，除申報本項外，應再加報第二章第一節第二十二項診斷穿刺。2.兒童加成項目。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ultrasonic guidance for needle placement(eg, biopsy, aspiration, injection)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19008B",
      "display" : "超音波導引下肝內藥物注入治療",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sono guided intrahepatic drug injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19009C",
      "display" : "腹部超音波，追蹤性",
      "definition" : "兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Abdominal ultrasound, for follow-up"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19010C",
      "display" : "產科超音波",
      "definition" : "1.不含杜卜勒檢查及立體組像。2.不得同時申報19011C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Obstetric ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19011C",
      "display" : "高危險妊娠胎兒生理評估",
      "definition" : "1.不含杜卜勒檢查及立體組像。2.不得同時申報18013C、18014C、18035B、19003C、19010C、19013C。3.適應症：(1)各種高危險妊娠情況：子宮內胎兒生長遲滯(IUGR)、糖尿病(DM)、妊娠高血壓症(含慢性高血壓與子癲前症)、羊水異常、妊娠二十四週後之胎動減少、其他高危險妊娠狀況等。(2)胎兒篩檢結果不正常：非反應性NST、陽性OCT、產科超音波檢查發現先天胎兒異常、杜卜勒超音波檢查發現胎兒臍帶血流異常及胎兒血管血流異常等。4.胎兒生理評估為確認胎兒窘迫的檢查，在妊娠期間若超過兩次須於病歷記載檢查理由。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fetal biophysical profile"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19012C",
      "display" : "頭頸部軟組織超音波(如甲狀腺thyroid、副甲狀腺parathyroid、腮腺parotid)",
      "definition" : "兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Head and neck soft tissue echo(thyroid,parathyroid,parotid gland)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19013C",
      "display" : "陰道超音波",
      "definition" : "1.支付規範：(1)不含杜卜勒檢查及立體組像。(2)不得同時申報：19003C及19011C。2.禁忌症：無性行為者。3.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師或診所支援他診所之醫師(接受支援之婦產科診所限執業登記醫師五人以下者)開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vaginal ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19014C",
      "display" : "乳房超音波",
      "definition" : "兒童加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19015C",
      "display" : "男性外生殖器官超音波",
      "definition" : "兒童加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19016C",
      "display" : "四肢超音波",
      "definition" : "兒童加成項目。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19017C",
      "display" : "經尿道(直腸)超音波檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transurethral (transrectal) ultrasonography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "19018C",
      "display" : "嬰幼兒腦部超音波",
      "definition" : "1.腦部超音波為嬰兒前囪門尚未關閉時才能操作的檢查。2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Brain echo"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02",
      "display" : "第二次兒童衛教指導費(可搭配第二次兒童預防保健申報)",
      "definition" : "於二個月至四個月；提供嬰兒餵食與口腔清潔、嬰幼兒猝死症候群預防、事故傷害預防等衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20",
      "display" : "新生兒聽力篩檢服務",
      "definition" : "新生兒聽力篩檢補助服務方案，補助對象為出生三個月內新生兒",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20001C",
      "display" : "腦波檢查睡眠或清醒",
      "definition" : "申報應附檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "EEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20002C",
      "display" : "腦波檢查－睡眠及清醒",
      "definition" : "申報應附檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "EEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20003C",
      "display" : "面神經刺激檢查",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20004B",
      "display" : "腦波檢查(手提式)",
      "definition" : "申報應附檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "EEG (portable)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20005B",
      "display" : "蝶骨下電極腦波檢查",
      "definition" : "申報應附檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sphenoid EEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20006B",
      "display" : "鼻咽電極腦波檢查",
      "definition" : "申報應附檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nasopharyngeal lead EEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20007B",
      "display" : "腦幹聽覺誘發電位檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Brainstem auditory evoked potentials(A.E.P Bs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20008B",
      "display" : "中程聽覺誘發電位檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Middle-latency auditory evoked potentials(A.E.P. ML)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20009B",
      "display" : "長程聽覺誘發電位檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Long-latency auditory evoked potentials(A.E.P. L.L)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20010B",
      "display" : "體感誘發電位檢查－上肢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Somatosensory evoked potentials (S.E.P.)-upper limb"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20011B",
      "display" : "體感誘發電位檢查–下肢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Somatosensory evoked potentials (S.E.P.)-lower limb"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20012B",
      "display" : "視覺誘發電位檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Visual evoked potentials (V.E.P.)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20013C",
      "display" : "頸動脈超音波檢查",
      "definition" : "屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dopscan"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "20014B",
      "display" : "針極肌電圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Needle electromyogram"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20015B",
      "display" : "運動神經傳導測定－上肢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mortor nerve conduction velocity-upper"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20016B",
      "display" : "運動神經傳導測定－下肢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mortor nerve conduction velocity-lower"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20017B",
      "display" : "肌無力藥物測驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tensilon or vagostigmin test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20018B",
      "display" : "重覆刺激測驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Repetitive stimulation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20019B",
      "display" : "感覺神經傳導速度測定",
      "definition" : "同時檢查雙側或四肢時，仍以申報一次為限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sensory nerve conductive velocity, SNCV"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20020B",
      "display" : "單纖維肌電圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "Single fiber EMG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20021B",
      "display" : "眼動脈流速測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Oculoplethymography(O.P.G.)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "20022B",
      "display" : "瞬眼反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blink reflex"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20023B",
      "display" : "F波",
      "designation" : [
        {
          "language" : "en",
          "value" : "F wave"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20024B",
      "display" : "H反射",
      "designation" : [
        {
          "language" : "en",
          "value" : "H reflex"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "20025B",
      "display" : "周邊神經纖維撕裂檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Single nerve fiber tearing"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20026B",
      "display" : "穿顱都卜勒超音波檢查(顱內血管超音波檢查)",
      "designation" : [
        {
          "language" : "en",
          "value" : "(TRANSCRANIAL DOPPLER SONOGRAPHY)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20027B",
      "display" : "數位影像腦波監測",
      "definition" : "限設有癲癇治療小組之醫院申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Digital video EEG long term monitoring"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20028B",
      "display" : "大腦皮質腦電圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electrocorticography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20029B",
      "display" : "瓦達測驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Wada's test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "20030B",
      "display" : "肌肉組織化學檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Histocheical examination of muscle tissue"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20031B",
      "display" : "穩定狀態聽性誘發反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "Steady state evoked potential(SSEP)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20032B",
      "display" : "運動誘發電位(上肢)",
      "definition" : "申報費用須檢附報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Motor evoked potential upper"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20033B",
      "display" : "神經功能溫度閾值測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Quantitative thermal threshold"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20034B",
      "display" : "磁波刺激檢查(上肢)",
      "definition" : "1.適應症包括：多發性硬化症、運動神經元疾病、脊髓損傷或病變、周邊神經病變、手術時皮質脊髓徑路之功能、腦中風之偏癱。2.申報費用時須檢附詳細病歷紀錄，包括檢查目的及報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Magnetic stimulation (upper extremity)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "20035B",
      "display" : "運動誘發電位(下肢)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Motor evoked potential lower limb"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20036B",
      "display" : "磁波刺激檢查(下肢)",
      "definition" : "1.適應症包括：多發性硬化症、運動神經元疾病、脊髓損傷或病變、周邊神經病變、手術時皮質脊髓徑路之功能、腦中風之偏癱。2.申報費用時須檢附詳細病歷紀錄，包括檢查目的及報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Magnetic stimulation (lower extremity)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20037B",
      "display" : "交感神經皮膚反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sympathetic skin response"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20038B",
      "display" : "震顫圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tremography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20039B",
      "display" : "交感神經測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Austmomic function test(SSR+RRIV)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20040B",
      "display" : "表面肌電圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "Surface EMG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20041B",
      "display" : "感覺神經功能檢查",
      "definition" : "1.含挀動感覺、皮表感覺。2.不得重複申請本項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sensation testing"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20042B",
      "display" : "電腦化神經心理測驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Neurobehavior exaluation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20043B",
      "display" : "動作障礙相關量表之評估—執行一項量表",
      "definition" : "1.本項目量表包含：(1)巴金森氏症UPDRS量表。(2)肌張力不全症FMDRS量表。(3)異動症UDysRS量表。(4)斜頸症TWSTRS量表。2.同次就醫執行二項以上量表者，不得拆分申報。3.每位病人每項量表每年限執行一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Evaluation of Movement Disorder Rating Scale"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "20044B",
      "display" : "多次入睡睡眠檢查",
      "definition" : "註：1.適應症：(1)疑似猝睡症之診斷與追蹤。(2)疑似原發性嗜睡症之診斷。(3)以下二項情況不適用：A.不得作為阻塞性睡眠呼吸中止症起初評估或診斷的工具，或接受治療後的療效評估。B.不得作為例行性內科或神經系統疾病(除猝睡症)、失眠症、晝夜節律失調的嗜睡度評估。2.支付規範：(1)每人每年限執行一次。(2)限胸腔內科、神經內科、精神科、耳鼻喉科、兒童神經科及兒童胸腔科醫師執行。(3)申報時須檢附本項檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Multiple Sleep Latency Test(MSLT)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "20045B",
      "display" : "動作障礙相關量表之評估—執行二項以上量表",
      "definition" : "1.本項目量表包含：(1)巴金森氏症UPDRS量表。(2)肌張力不全症FMDRS量表。(3)異動症UDysRS量表。(4)斜頸症TWSTRS量表。2.同次就醫執行二項以上量表者，不得拆分申報。3.每位病人每項量表每年限執行一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Evaluation of Movement Disorder Rating Scale"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21",
      "display" : "成人預防保健:四十歲以上未滿六十五歲者，每三年補助一次(第一階段)",
      "definition" : "一、受檢者應先填寫「成人預防保健服務檢查紀錄結果表單」之基本資料、個人及家族疾病史、長期服藥、健康行為及憂鬱檢測。二、生化檢查:飯前血糖、總膽固醇、三酸甘油脂、高密度脂蛋白膽固醇、AST(GOT)、ALT(GPT)、肌酸酐。三、尿液檢查:蛋白質。四、腎絲球過濾率計算。五、低密度脂蛋白膽固醇計算。※國健局以公務預算支應，由本署代辦本項服務。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21003C",
      "display" : "外括約肌肌電圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "External sphincter electromyogram (EMG)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21004C",
      "display" : "尿流速圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "Uroflowmetry (UFR)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21005C",
      "display" : "尿道壓力測量檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urethral pressure profile studies (UPP)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21006B",
      "display" : "錄影尿流動力學檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Video-urodynamic study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21007C",
      "display" : "膀胱壓檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cystometry (CMG)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21008C",
      "display" : "膀胱掃描",
      "definition" : "限尿滯留及排尿困難者申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bladder sonography"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "21009B",
      "display" : "膀胱壓力檢查及Urecholine反應測驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cystometry and Urecholine test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21010C",
      "display" : "膀胱超音波尿量測量",
      "definition" : "同一病患視病情需要，每星期最多使用此法測量膀胱餘尿兩次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bladder sonography for measurement of urine amount"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21011C",
      "display" : "壓力尿流速圖",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pressure-flow study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "21012B",
      "display" : "應力尿道壓力測量檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stress urethral pressure profile (stress UPP)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22",
      "display" : "成人預防保健:六十五歲以上者，每年補助一次(第一階段)",
      "definition" : "一、受檢者應先填寫「成人預防保健服務檢查紀錄結果表單」之基本資料、個人及家族疾病史、長期服藥、健康行為及憂鬱檢測。二、生化檢查:飯前血糖、總膽固醇、三酸甘油脂、高密度脂蛋白膽固醇、AST(GOT)、ALT(GPT)、肌酸酐。三、尿液檢查:蛋白質。四、腎絲球過濾率計算。五、低密度脂蛋白膽固醇計算。※國健局以公務預算支應，由本署代辦本項服務",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22001C",
      "display" : "純音聽力檢查",
      "definition" : "1.包括骨導聽力及氣導聽力。2.不得同時申報22041C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pure tone audiometry ( PTA )"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "22002B",
      "display" : "響音重振檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Recruitment test ( SISI )"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "22003C",
      "display" : "聽音電阻檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Impedance audiometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22004C",
      "display" : "鼓室圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tympanometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22005C",
      "display" : "一般語言檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Medium speech evaluation"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "22006C",
      "display" : "複雜語言檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Complex speech evaluation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22007C",
      "display" : "語言錄音檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sound record testing"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "22008B",
      "display" : "聲場聽力檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sound field testing"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22009B",
      "display" : "音聲頻譜儀檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sound spectrography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22010C",
      "display" : "吞嚥檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Swallowing evaluation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22011B",
      "display" : "語言分辨聽力檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Speech discrimination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22012B",
      "display" : "響音衰退檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tone decay test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22013B",
      "display" : "語言聽力檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Speech audiometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22014B",
      "display" : "誘發反應聽力檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "E.R.A.( electrical responce audiometry )"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22015B",
      "display" : "詐聾聽力檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Functional hearing test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22016B",
      "display" : "眼振圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "ENG ( electronystagmography )"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22017C",
      "display" : "前庭平衡檢查",
      "definition" : "1.包括上肢、下肢偏倚檢查、起立檢查、眼球運動檢查、頭位變化檢查等項。2.屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "V.F.T. ( vestibular function test )"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22018B",
      "display" : "腦幹反應檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "B.S.R. ( brain stem response )"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22019B",
      "display" : "內耳溫差試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Caloric test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22020B",
      "display" : "甘油試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Glycerine test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22021B",
      "display" : "上頷竇機能檢查－單側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Maxillary sinus moljodol exam.-single side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22022B",
      "display" : "上頷竇機能檢查－雙側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Maxillary sinus moljodol exam.-both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22023B",
      "display" : "耳蝸誘發聽力檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Econg"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22024B",
      "display" : "喉部發聲機能檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Phonatory ability test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22025B",
      "display" : "自記聽力檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bekesy audiometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22026C",
      "display" : "聽反射測驗(ART)",
      "designation" : [
        {
          "language" : "en",
          "value" : "(ART) Acoustic emission test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22027C",
      "display" : "耳聲傳射檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "OTO acoustic emission test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22028C",
      "display" : "耳咽管功能檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "E-tube function test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22029C",
      "display" : "鐙骨肌反射衰退試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stapedial reflex decay"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22030C",
      "display" : "喉機能音響分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "Larynageal acoustic analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22031B",
      "display" : "聽反射衰退檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acoustic reflex decay test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22032B",
      "display" : "交替性兩側響度平衡測驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Alternate binaural loundness balance test(ABLB)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22033B",
      "display" : "幼兒聽力篩檢(腦幹聽反射)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Argo-1 infant hearing testargo-1 infant hearing test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22034B",
      "display" : "重心動搖儀檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Posturography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22035B",
      "display" : "喉部氣體動力學分析(音聲氣體流動分析)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Laryngeal aerodynamic analysis"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "22037B",
      "display" : "前庭誘發肌電位－頸性或眼性前庭誘發肌電位",
      "definition" : "註：1.適應症為末梢前庭病變之眩暈症之鑑別診斷，視患者狀況施作頸性前庭誘發肌電位(cVEMP)或眼性前庭誘發肌電位(oVEMP)時申報。2.不可重複申報本項。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vestibular evoked myogenic potential－cVEMP or oVEMP"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22038B",
      "display" : "喉肌電圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Laryngeal EMG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22039C",
      "display" : "聽覺穩定狀態電位反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "ASSR"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22040B",
      "display" : "前庭誘發肌電位－頸性及眼性前庭誘發肌電位",
      "definition" : "註：1.適應症為末梢前庭病變之眩暈症之鑑別診斷，視患者狀況同時施作頸性前庭誘發肌電位(cVEMP)及眼性前庭誘發肌電位(oVEMP)時申報。2.不可重複申報22037B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vestibular evoked myogenic potential－cVEMP and oVEMP"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22041C",
      "display" : "遊戲式聽力檢查",
      "definition" : "1.適應症：限聽力篩檢未通過，且符合下列任一適應症之二歲以上至未滿七歲兒童：(1)傳音性及感音性耳聾(H90)。(2)突發性自發性聽力喪失(H91.2)。(3)聽障(H91.9)。(4)耳鳴(H93.1)。(5)其他異常聽覺(H93.2)。2.基層診所之聽力檢查室須符合醫療機構設置標準附表(一)之聽力設施規範。3.每年以申報二次為原則，如需額外執行應於病歷敘明重複執行之原因。4.申報費用時須檢附遊戲式聽力檢查報告。5.不得同時申報22001C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Conditioning play audiometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23",
      "display" : "成人預防保健:四十歲以上未滿六十五歲者，每三年補助一次(第二階段)",
      "definition" : "一、第一階段之檢驗結果判讀與建議。二、身體檢查:身高、體重、血壓、脈搏、腰圍、身體質量指數、視力檢查、耳鼻喉及口腔檢查、頸部檢查、胸部檢查、心臟聽診、呼吸聽診、腹部檢查、四肢檢查。三、健康諮詢:戒菸、節酒、戒檳榔、規律運動、維持正常體重、健康飲食、事故傷害預防、口腔保健。※國健局以公務預算支應，由本署代辦本項服務。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23001C",
      "display" : "角膜曲度測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ophthalmometry exam (Keratometry)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23002C",
      "display" : "光覺測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Light perception"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23003B",
      "display" : "低視能檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Low vision test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23004B",
      "display" : "彩色角膜屈度攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Photokeratoscopy (color)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23101C",
      "display" : "色盲檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Color blindness test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23102C",
      "display" : "15色度檢查",
      "definition" : "限視網膜機能障礙患者申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Panel D-15 test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23103C",
      "display" : "100色度檢查",
      "definition" : "限視網膜機能障礙患者申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "100 hue test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23104B",
      "display" : "暗適應試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dark adaptation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23201C",
      "display" : "立體官能檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Synoptometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23202C",
      "display" : "四燈融像檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Worth-4-dots test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23203C",
      "display" : "三稜鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prism cover test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23204C",
      "display" : "立體感視覺檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Titmus test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23205C",
      "display" : "複相檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Maddox rod test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23206C",
      "display" : "眼肌協調檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Comitance test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23207C",
      "display" : "斜視鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cheiroscope"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23208C",
      "display" : "斜視檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Squint examination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23301C",
      "display" : "希厄滋氏眼壓測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Schiotz's tonometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23302C",
      "display" : "壓平式眼壓測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Goldman applantation tonometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23303C",
      "display" : "眼壓電圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tonography"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23304C",
      "display" : "青光眼點藥激發試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mydriatic test (provocative test)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23305C",
      "display" : "氣壓式眼壓測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Penumotonometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23306C",
      "display" : "暗房俯臥激發試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dark room + prone test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23307B",
      "display" : "飲水激發試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Water drinking test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23308B",
      "display" : "眼壓晝夜差別檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Diurnal variation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23401C",
      "display" : "細隙燈顯微鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Slit lamp exam"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23402C",
      "display" : "前房隅角鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gonioscope exam"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23403C",
      "display" : "角膜厚度檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pachymetry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23404C",
      "display" : "角膜內皮細胞顯微檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Corneal endothelial microscope"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23405C",
      "display" : "細隙燈眼接觸鏡眼底檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Slit lamp contact mirror funduscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23501C",
      "display" : "眼底檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Funduscopic exam"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23502C",
      "display" : "眼底彩色攝影每張",
      "definition" : "1.病歷應檢附特殊影像照片備查。2.如再次執行應間隔二個月以上，因病情變化需再次執行，應詳載原因。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fundus color photo picture/picture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23503C",
      "display" : "超音波檢查(A掃瞄)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Echo exam (A.scan)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23504C",
      "display" : "超音波檢查(B掃瞄)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Echo exam (B.scan)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23505C",
      "display" : "螢光眼底血管攝影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fluorescein angiography (FAG)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23506C",
      "display" : "微細超音波檢查",
      "definition" : "本項檢查有下列四種形式：1.UBM(Uetrobiomicrosonography)。2.OCT(OpticalCoherentTomography)。3.HRT(HeiderburgRetinaTomography)。4.眼部血管超音波檢查，包括centralretinalartery及ophthalamicartery。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Microsonography"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23601C",
      "display" : "周邊視野檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Visual field exam.(perimetry)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23602C",
      "display" : "中心視野檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Scotometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23605C",
      "display" : "眼球突出測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Exophthalmometry"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23606C",
      "display" : "複視檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Diplopia test ( Hess chart test,…etc)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23607C",
      "display" : "靜態視野檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Static visual field examination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23608C",
      "display" : "動態視野檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Kinetic visual field examination"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23609C",
      "display" : "電腦自動視野儀檢查—Threshold",
      "definition" : "屬西醫基層總額部門院所，除山地離島地區外，限由專任醫師開立處方及執行始可申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Automated perimetry — Threshold"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23610C",
      "display" : "電腦自動視野儀檢查—Screen",
      "designation" : [
        {
          "language" : "en",
          "value" : "Automated perimetry — Screen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23701C",
      "display" : "淚液分泌機能檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Schirmer test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23702C",
      "display" : "間接式眼底鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Indirect ophthalmoscopy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23703B",
      "display" : "網膜電圖檢查",
      "definition" : "限眼底檢查患者無法診斷確定者申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electro-retinography (ERG)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23704B",
      "display" : "眼電圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electro-oculogram (EOG)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23705B",
      "display" : "眼肌電圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electromyogram (EMG)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23706C",
      "display" : "角膜活體螢光細胞染色檢查",
      "definition" : "不得同時申報23401C",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fluorescein stain of cornea"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23707B",
      "display" : "眼激發電位圖檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Visual evoked potential"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23801C",
      "display" : "不等視檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anisometropia examination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23802B",
      "display" : "角膜活體細胞染色",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rose bengal stain of cornea"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23803C",
      "display" : "瞳孔散大",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pupil dilatation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23804C",
      "display" : "角膜真菌暗視野檢鏡",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fungus dark field examination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23805C",
      "display" : "結膜脫離細胞檢鏡",
      "designation" : [
        {
          "language" : "en",
          "value" : "Conjunctival scraping"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23806C",
      "display" : "眼瞼下垂試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tensilon or neostigmine test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23807C",
      "display" : "人工水晶體度數超音波生物計測儀測定",
      "definition" : "限人工晶體(IOL)裝置申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "DBR"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23809C",
      "display" : "視網膜裂孔位置測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Localization of retinal break"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23810B",
      "display" : "眼動脈壓測量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ophthalmodynamometer"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23811C",
      "display" : "外眼部攝影檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "External eye photography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23812C",
      "display" : "弱視檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amblyopia examination"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "23813B",
      "display" : "ICG眼底血管攝影",
      "definition" : "限螢光眼底血管攝影術(23505C)檢查法所無法表現之脈絡膜新生血管(CNB)患者申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Indocyanine green (ICG) angiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24",
      "display" : "成人預防保健:六十五歲以上者，每年補助一次(第二階段)",
      "definition" : "一、第一階段之檢驗結果判讀與建議。二、身體檢查:身高、體重、血壓、脈搏、腰圍、身體質量指數、視力檢查、耳鼻喉及口腔檢查、頸部檢查、胸部檢查、心臟聽診、呼吸聽診、腹部檢查、四肢檢查。三、健康諮詢:戒菸、節酒、戒檳榔、規律運動、維持正常體重、健康飲食、事故傷害預防、口腔保健。※國健局以公務預算支應，由本署代辦本項服務",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24003B",
      "display" : "血漿體抑制素",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasma somatostatin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24007B",
      "display" : "血漿游離鈣測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasma free Ca++"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24008B",
      "display" : "胰島素降血糖刺激試驗",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：09005C*5次，27008B*5次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Insulin hypoglycemic stimulation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24009C",
      "display" : "口服葡萄糖耐量試驗(五次血糖測定)",
      "definition" : "本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：09005C*5次",
      "designation" : [
        {
          "language" : "en",
          "value" : "Oral glucose tolerance test (5 blood glucose measurements)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "24010B",
      "display" : "靜脈注射葡萄糖耐量試驗",
      "definition" : "本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：09005C*5次及27015C*7次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intravenous glucose stimulation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24011B",
      "display" : "靜脈點滴鈣試驗",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：09005C*5次、09011C*5次及27015C*5次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Calcium infusion test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24012B",
      "display" : "水負荷試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Water loading test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24013B",
      "display" : "鹽水負荷試驗",
      "definition" : "本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27032B*2次，27031B*2次",
      "designation" : [
        {
          "language" : "en",
          "value" : "Saline loading test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24014B",
      "display" : "高張性鹽水負荷試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hypertonic saline loading test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24015B",
      "display" : "脫水試驗",
      "definition" : "本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：06503B*8次及08075C*8次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Water deprivation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24016B",
      "display" : "脫水與抗利尿激素試驗",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：06503B*8次及08075C*8次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Water deprivation + DDAVP test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24017B",
      "display" : "脫水與口服Tegretol試驗",
      "definition" : "本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：06503B*8次及08075C*8次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Water deprivation + tegretol test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24018B",
      "display" : "促腎上腺皮質素刺激試驗",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27006B*5次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ACTH stimulation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24019B",
      "display" : "運動試驗與生長激素測定",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27008B*2次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Exercise test for GH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24020B",
      "display" : "口服L-dopa與生長激素測定",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27008B*5次。2.針劑藥費另計",
      "designation" : [
        {
          "language" : "en",
          "value" : "L-dopa test for GH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24021B",
      "display" : "小腸內泌素試驗",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27016B*6次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Secretin test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24022B",
      "display" : "六胃泌激素試驗",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27068B*4次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pentagastrin test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24023B",
      "display" : "類胰島素成長因子",
      "designation" : [
        {
          "language" : "en",
          "value" : "Somatomedine C (insulin-like growth factor 1)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24024B",
      "display" : "Clonidine刺激試驗與生長激素測定",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27008B*5次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Clonidine stimulation test for HGH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24025B",
      "display" : "升糖素刺激試驗與生長激素測定",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27008B*8次及09005C*5次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Glucagon Test for HGH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24026B",
      "display" : "胰島素刺激生長激素測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Insulin stimulation test for G. H."
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24027B",
      "display" : "黃體激素釋放素刺激試驗",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：27014B*6次及27013B*6次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "LHRH Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24028B",
      "display" : "升糖素刺激試驗與胰臟β-細胞功能測定",
      "definition" : "1.本項試驗點數除包含通則所述之各項費用外，另包含下列檢驗費：09005C*6次及27022B*6次。2.針劑藥費另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Glucagon Test for β-cell function"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "24029B",
      "display" : "空腹及口服75公克葡萄糖兩小時後血漿葡萄糖測定",
      "definition" : "1.本項試驗點數除包括通則所述之各項費用外，另包括下列檢驗費：09005C*2次。2.不得與24009C同時併報。3.適應症：限於空腹或餐後血糖異常但未達診斷糖尿病標準者實施。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasma glucose(fasting and 2 hours post 75 gm oral glucose loading)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25",
      "display" : "成人預防保健:罹患小兒麻痺且年在三十五歲以上者，每年補助一次(第一階段)",
      "definition" : "一、受檢者應先填寫「成人預防保健服務檢查紀錄結果表單」之基本資料、個人及家族疾病史、長期服藥、健康行為及憂鬱檢測。二、生化檢查:飯前血糖、總膽固醇、三酸甘油脂、高密度脂蛋白膽固醇、AST(GOT)、ALT(GPT)、肌酸酐。三、尿液檢查:蛋白質。四、腎絲球過濾率計算。五、低密度脂蛋白膽固醇計算。※國健局以公務預算支應，由本署代辦本項服務",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25001C",
      "display" : "第一級外科病理，眼觀檢查",
      "definition" : "如異物(金屬、玻璃、結石、寄生蟲等)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Surgical pathology Level Ⅰ, Gross examination only"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25002C",
      "display" : "第二級外科病理，組織鏡檢確認",
      "definition" : "附帶切除之闌尾、包皮(包莖)、疝氣囊、陰囊水腫、胃迷走神經切除、皮膚(整形修復)、交感神經結、睪丸(閹割性睪丸切除)、創傷性之指頭截肢、結紮之輸卵管、附帶切除之陰道壁、輸精管結紮。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Surgical pathology Level Ⅱ"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "25003C",
      "display" : "第三級外科病理",
      "definition" : "人工流產、膿瘍、動脈瘤、肛門息肉、闌尾炎、粥狀動脈硬化、Bartholin氏囊腫、非病理性骨折之骨碎片、關節囊腫、腕部隧道症、軟骨刮削、膽脂瘤、結腸造口術、結膜切片/翼狀胔肉、雞眼、角膜、食道及小腸憩室病、Dupuytren'scontracture、股骨頭(非骨折性)、纖維脂肪瘤、廔管、包皮(包皮炎，尖狀濕疣)、膽囊、腱鞘囊腫、血腫、痔瘡、Morgagni囊、椎間盤突出、關節游離體、關節半月板、黏液囊腫、外傷性神經瘤、藏毛廔管、鼻腔及鼻竇發炎性息肉、皮膚囊腫/皮膚息肉/皮膚清創術、軟組織清創術、脂肪瘤、精液囊腫、肌腱、睪丸附屬器官、血栓、口腔及鼻咽扁桃腺或腺樣組織、精索靜脈曲張、靜脈曲張、輸精管(非結紮)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Surgical pathology Level III"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25004C",
      "display" : "第四級外科病理",
      "definition" : "自然流產、動脈切片、骨髓切片、外生骨疣、腦/腦膜(非腫瘤)、乳房切片(不需margin)如fibrocysticchange、乳房縮小整形術、支氣管切片、子宮頸切片、結腸切片、十二指腸切片、子宮頸/子宮內膜息肉、結腸直腸息肉切除、尖性濕疣、皮纖維瘤、子宮內頸刮除術/切片、子宮內膜刮除術/切片、食道切片、創傷性之肢體截肢、輸卵管切片、股骨頭骨折、非創傷性之指頭截肢、牙齦/口腔黏膜切片、心臟瓣膜、血管瘤、皮內痣、關節切除置換、瘢瘤、腎臟切片、喉部切片、子宮肌瘤切除術、唇切片、經支氣管肺切片、淋巴結切片、肌肉切片、鼻黏膜切片、鼻咽或口咽切片、神經切片、牙源性囊腫、網膜切片、卵巢切除(非腫瘤)、卵巢切片、鼻竇切片、副甲狀腺切除、腹膜切片、腦下垂體腫瘤、胎盤(非懷孕後三個月)、肋膜/心包膜切片、子宮脫垂(有或無輸卵管及卵巢)、前列腺細針切片、攝護腺刮除、唾液腺切片、皮脂漏性角化病、皮膚-(非囊腫/非息肉/非清創/非整形標本)、小腸切片、軟組織-(非腫瘤/非脂肪瘤/非清創標本)、脾臟、胃切片、胃/小腸息肉切除、滑液膜、睪丸-(非腫瘤/非切片/非閹割)、甲狀腺舌管鰓裂囊腫、舌切片、扁桃腺切片、氣管切片、毛髮上皮瘤、輸卵管異位懷孕、輸尿管切片、尿道切片、膀胱切片、陰道切片、尋常疣、會陰切片。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Surgical pathology Level IV"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25006B",
      "display" : "冰凍切片檢查",
      "definition" : "1.含該一冷凍切片製成之石蠟切片。2.同一病例限申報一次。3.同一病例冷凍切片後之剩餘標本(含後送標本)，得依上述外科病理第一級至第六級之標準另行申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Frozen section"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25007B",
      "display" : "細胞遺傳學檢查",
      "definition" : "1.含染色體檢查。2.主要適用於下列疾病之治療：(1)血液惡性腫瘤的診斷與治療(2)骨髓移植病人的治療及追蹤(3)泛骨髓移植低下症(pancytopenia)(4)骨髓增生病變的診斷及治療追蹤(5)骨髓造血機能異常病人診斷及治療追蹤。3.除通則一所列兩種專科醫師外，亦得檢附遺傳專科醫師簽名與加註專科醫師證書字號之細胞遺傳學檢查報告，另血液疾病患者之檢查亦得檢附血液病專科醫師簽名與加註專科醫師證書字號之細胞遺傳學檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cytogenetics"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25009B",
      "display" : "肌肉病理切片檢查(冷凍特殊染色)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Muscle biopsy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25010B",
      "display" : "組織化學染色第一類",
      "definition" : "除第二類以外之其他。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Histochemical stain group Ⅰ"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25011B",
      "display" : "組織化學染色第二類",
      "definition" : "結核桿菌鑑定及酵素化學染色。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Histochemical stain group Ⅱ"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25012B",
      "display" : "免疫組織化學染色(每一抗體)",
      "definition" : "註：1.每例(同次門診或同次住院)以申報五種抗體為限。2.若屬下列特殊診斷種類，則申報以十種抗體為限。(1)淋巴瘤(lymphoma)(2)雙側乳癌病理檢體(bilateralbreastcancerspecimens)(3)不明原發部位惡性腫瘤(cancerofunknownprimary)(4)惡性及來源行為不明性骨及軟組織腫瘤(malignanttumorsofsofttissue,bone,andtumorsofuncertaindifferentiation)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunohistochemical stains, each antibody"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "25013B",
      "display" : "螢光切片檢查第一類(每一抗體)",
      "definition" : "直接性螢光切片檢查(directimmunofluorescence)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunofluorescence group I, each antibody"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25014B",
      "display" : "電子顯微鏡切片檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electron microscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25021B",
      "display" : "染色體檢查(特殊)",
      "definition" : "1.限衛生福利部認證之遺傳諮詢中心申請實施。2.人員資格依遺傳諮詢中心相關規定辦理。3.本項目如已申請衛生福利部補助者，本保險不另支付該次檢查費用。4.如做為一般性篩檢者，非屬本保險給付範圍。5.每一個案限給付一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chromosomal analysis ， special"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25022B",
      "display" : "DOPA反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "DOPA reaction"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25023B",
      "display" : "非直接免疫螢光檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Indirect immunofluorescence"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25024C",
      "display" : "第五級外科病理",
      "definition" : "腎上腺切除、骨切片、病理性骨折之骨碎片、乳房腫瘤切除(需要檢查margin)、乳房切除(不含淋巴結)、腦切片、腦/腦膜(腫瘤)、子宮頸圓錐狀切除、膽囊癌膽囊切除、非腫瘤的結腸切除、非創傷性之肢體截肢、眼摘除、腎臟部份或全部切除、喉部分及全部切除(不含淋巴結)、肝臟切片、肝臟部分切除、肺臟楔形切片、淋巴腺摘除、縱隔腔腫瘤、心肌切片、牙源性腫瘤、器官移植(角膜除外)、卵巢腫瘤、胰臟切片、胎盤(懷孕後三個月)、前列腺非根除性切除、唾液腺切除、前哨淋巴結切除、非腫瘤的小腸切除、軟組織切片或簡單切除(非脂肪瘤)、非腫瘤的胃切除、睪丸切片、胸腺腫瘤、甲狀腺切除、輸尿管切除、經尿道膀胱腫瘤切除、子宮切除/子宮肌瘤及非脫垂(有或無輸卵管及卵巢)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Surgical pathology Level V"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25025C",
      "display" : "第六級外科病理",
      "definition" : "骨切除(腫瘤)、乳房切除(含淋巴結)、結腸切除(腫瘤)、食道部分及全部切除、截肢(關節截斷)、胎兒、喉部分及全部切除(含淋巴結)、肺葉切除、胰臟部份或全切除、前列腺根除性切除、小腸切除(腫瘤)、軟組織腫瘤廣泛性切除、胃部份或全部切除(腫瘤)、睪丸腫瘤、舌/扁桃腺腫瘤根除性切除、膀胱部分或全部切除、子宮切除/腫瘤性(有或無輸卵管及卵巢)、會陰全部或部分切除。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Surgical pathology Level VI"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "25026B",
      "display" : "螢光切片檢查第二類",
      "definition" : "間接性螢光切片檢查(indirectimmunofluorescence)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunofluorescence group II"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26",
      "display" : "成人預防保健:罹患小兒麻痺且年在三十五歲以上者，每年補助一次(第二階段)",
      "definition" : "一、第一階段之檢驗結果判讀與建議。二、身體檢查:身高、體重、血壓、脈搏、腰圍、身體質量指數、視力檢查、耳鼻喉及口腔檢查、頸部檢查、胸部檢查、心臟聽診、呼吸聽診、腹部檢查、四肢檢查。三、健康諮詢:戒菸、節酒、戒檳榔、規律運動、維持正常體重、健康飲食、事故傷害預防、口腔保健。※國健局以公務預算支應，由本署代辦本項服務",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26001B",
      "display" : "腦掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Brain scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26002B",
      "display" : "淚囊閃爍攝影檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dacryoscintigraphy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26003B",
      "display" : "腦脊髓液動態檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "CSF dynamic study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26004B",
      "display" : "鎝-99m甲狀腺掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tc99m thyroid scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26005B",
      "display" : "碘-131甲狀腺掃描及24小時攝取量測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "I-131 thyroid scan and 24 hrs uptake"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26006B",
      "display" : "碘-131單一攝取量測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "I-131-uptake (1,3,6 or 24hrs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26007B",
      "display" : "三碘甲狀腺素抑制試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "T3 suppression test with uptake"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26008B",
      "display" : "三碘甲狀腺素抑制試驗甲狀腺掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "T3 suppression with scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26009B",
      "display" : "甲狀腺刺激素試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "TSH stimulation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26010B",
      "display" : "甲狀腺刺激素試驗及甲狀腺掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "TSH stimulation test with scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26011B",
      "display" : "碘-131頸及胸部掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "I-131 neck & chest scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26012B",
      "display" : "碘-131癌症追蹤檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "I-131 cancer work-up"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26013B",
      "display" : "鉈-201癌症追蹤檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tl-201 cancer work-up"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26014B",
      "display" : "肺灌注檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lung perfusion scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26015B",
      "display" : "肺通氣檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lung ventilation study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26016B",
      "display" : "肝脾臟掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Liver and spleen scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26017B",
      "display" : "全身骨髓檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Whole body Bone marrow scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26018B",
      "display" : "異位胃黏膜掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ectopic gastric mucosa scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26019B",
      "display" : "陰囊攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Scrotal scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26020B",
      "display" : "腎臟掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Renal scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26021B",
      "display" : "腎上腺掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Adrenal scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26023B",
      "display" : "心肌梗塞攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Myocardial infarct study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26024B",
      "display" : "靜態心肌斷層灌注掃描",
      "definition" : "註:含SPECT(26049B)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Resting myocardial perfusion study with SPECT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26025B",
      "display" : "壓力與重分佈心肌斷層灌注掃描",
      "definition" : "1.壓力掃描包括使用藥物如Persantin等之刺激或是運動如跑步機、腳踏車等之刺激後再進行掃描。2.含26024B及26049B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stress & redistribution myocardial perfusion study with SPECT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26026B",
      "display" : "邁克氏憩室掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Meckle's diverticulum scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26027B",
      "display" : "靜脈檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Venography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26028B",
      "display" : "動脈檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Arteriography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26029B",
      "display" : "全身骨骼掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Whole body bone scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26030B",
      "display" : "全身腫瘤掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Whole body tumor scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26031B",
      "display" : "全身炎症掃描",
      "designation" : [
        {
          "language" : "en",
          "value" : "Whole body inflammation scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26032B",
      "display" : "血漿量測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plasma volume"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26033B",
      "display" : "紅血球量測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Red cell volume"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26034B",
      "display" : "紅血球壽命測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Red cell survival"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26035B",
      "display" : "脾臟分隔檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Spleen sequestration"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26036B",
      "display" : "鎝99m紅血球肝脾臟攝影(用紅血球)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tc-99m RBC liver/spleen scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26037B",
      "display" : "鐵59鐵動力學檢查",
      "definition" : "包括血清鐵測定。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fe-59 ferrokinetics study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26038B",
      "display" : "碘-131治療每1mci",
      "designation" : [
        {
          "language" : "en",
          "value" : "I-131I treatment per 1 mci"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26039B",
      "display" : "碘-125纖維蛋白原吸收試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "I-125 fibrinogen uptake test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26040B",
      "display" : "肝膽道閃爍攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cholescintigraphy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26041B",
      "display" : "施靈氏試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Schilling test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26042B",
      "display" : "磷-32真性位血球過多症治療",
      "designation" : [
        {
          "language" : "en",
          "value" : "32P treatment for polycythemia vera"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26043B",
      "display" : "核醫肺功能檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pulmonary function test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26044B",
      "display" : "心室搏出分率測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ventricular ejection fraction measurements"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26045B",
      "display" : "心室搏出分率及心室壁活動測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ventricular ejection fraction measurement & wall motion study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26046B",
      "display" : "甲狀腺素服用後碘-131之攝取測定",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂英文名稱，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "I-131 uptake after thyroxine intake"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26047B",
      "display" : "靜態核醫心臟功能檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂中英文名稱，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Resting cardiac function study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26048B",
      "display" : "壓力心臟功能檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告中、英文名稱更正，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stress cardiac function study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26049B",
      "display" : "核子斷層檢查術",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "SPECT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26050B",
      "display" : "動態腎/泌尿功能測定",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂中英文名稱及點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dynamic renal/urinary function study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26051B",
      "display" : "唾腺閃爍攝影",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sialoscintigraphy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26052B",
      "display" : "分流/腹膜腔/胸膜腔掃描",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂中英文名稱及點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Shunt/peritoneal/pleural scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26053B",
      "display" : "食道通過檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Esophageal transit study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26054B",
      "display" : "胃腸道運動性檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告中文譯名更正，英文譯名更正，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gastrointestinal motility study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26055B",
      "display" : "副甲狀腺掃描",
      "definition" : "限副甲狀腺腫瘤及術後復發功能亢進病患實施。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Parathyroid scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26056B",
      "display" : "過氯酸鉀釋放試驗",
      "definition" : "限甲狀腺碘化功能不良病患實施。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Perchlorate discharge test"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "26057B",
      "display" : "三相骨骼掃描",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Three-phase bone scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26058B",
      "display" : "薦腸關節定量檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Quantitative sacroiliac scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26059B",
      "display" : "全身肌肉攝影",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂中英文名稱及點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Whole body muscle scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26060B",
      "display" : "核醫出血檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bleeding scan"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26061B",
      "display" : "脂肪肝試驗",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fatty liver study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26062B",
      "display" : "胃排空測定",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂英文名稱及點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gastric emptying study"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26063B",
      "display" : "腦質斷層灌注掃描",
      "definition" : "不得同時申報26049B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cerebral perfusion scan with SPECT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26070B",
      "display" : "淋巴閃爍攝影",
      "definition" : "雙側肢體應合併以一次申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphoscintogram"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26071B",
      "display" : "介入性動態腎/泌尿功能測定",
      "definition" : "93.6.14健保醫字第0930060063號公告增列本項。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dynamic renal/urinary function study after intervention"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "26072B",
      "display" : "正子造影-全身",
      "definition" : "實施本項目須符合1.腫瘤部分之適應症:(1)乳癌、淋巴癌之分期、治療及懷疑復發或再分期。(2)大腸癌、直腸癌、食道癌、頭頸部癌(不包含腦瘤)、原發性肺癌、黑色素癌、甲狀腺癌及子宮頸癌之分期及懷疑復發或再分期。(3)上述(1)(2)之分期，治療及懷疑復發或再分期及相關規範如下:A.分期:評估腫瘤之期別。B.治療:評估腫瘤對治療之反應，擬改變治療方式時。C.懷疑復發或再分期:使用於患者已接受一階段之正統治療後，偵測疑似有復發或轉移及評估復發之程度(不得用於例行之追蹤檢查)。D.以上各階段須符合:經電腦斷層、核磁共振、核子醫學掃瞄等檢查仍無法分期者，或認定電腦斷層、核磁共振等檢查不足以提供足夠資訊以供治療所需者，且須於病歷中說明施行正子造影之必要性理由。E.配合腫瘤治療計畫者方得以正子造影作為療效評估項目，未有後續積極處置之計畫者，不得施行。2.非腫瘤部分之適應症:(1)存活心肌偵測:限LVEF≦40%以下且以(或認定)傳統心肌斷層灌注掃描無法做確切心肌存活者適用。(2)癲癇病灶術前評估:持續且規則性服用三種(含)以上抗癲癇藥物治療≧一年，且近一年內平均每月有一次以上發作合併意識喪失者之術前評估。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26073B",
      "display" : "正子造影-局部",
      "definition" : "實施本項目須符合1.腫瘤部分之適應症:(1)乳癌、淋巴癌之分期、治療及懷疑復發或再分期。(2)大腸癌、直腸癌、食道癌、頭頸部癌(不包含腦瘤)、原發性肺癌、黑色素癌、甲狀腺癌及子宮頸癌之分期及懷疑復發或再分期。(3)上述(1)(2)之分期，治療及懷疑復發或再分期及相關規範如下:A.分期:評估腫瘤之期別。B.治療:評估腫瘤對治療之反應，擬改變治療方式時。C.懷疑復發或再分期:使用於患者已接受一階段之正統治療後，偵測疑似有復發或轉移及評估復發之程度(不得用於例行之追蹤檢查)。D.以上各階段須符合:經電腦斷層、核磁共振、核子醫學掃瞄等檢查仍無法分期者，或認定電腦斷層、核磁共振等檢查不足以提供足夠資訊以供治療所需者，且須於病歷中說明施行正子造影之必要性理由。E.配合腫瘤治療計畫者方得以正子造影作為療效評估項目，未有後續積極處置之計畫者，不得施行。2.非腫瘤部分之適應症:(1)存活心肌偵測:限LVEF≦40%以下且以(或認定)傳統心肌斷層灌注掃描無法做確切心肌存活者適用。(2)癲癇病灶術前評估:持續且規則性服用三種(含)以上抗癲癇藥物治療≧一年，且近一年內平均每月有一次以上發作合併意識喪失者之術前評估。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26074C",
      "display" : "碘-131癌症追蹤檢查-施打Thyrogen",
      "definition" : "1.適應症:(1)甲狀腺癌復發或轉移之患者。(2)不適合停用T4之甲狀腺癌患者進行檢查或治療之準備。2.本項須個案申請事前審查。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26075B",
      "display" : "氟-18氟化鈉正子造影",
      "definition" : "1.限病患需施行全身骨骼掃描時，無法取得Tc-99m時申報。2.不得同時申報26029B。3.申報費用應檢附報告。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26076B",
      "display" : "全身骨骼掃描-Tc-99m",
      "definition" : "1.限施行26029B時，Tc-99m全球缺貨取得成本增加時併同26029B申報。2.不得同時申報26075B。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "26077B",
      "display" : "鎝-99mTRODAT-1腦部多巴神經元斷層造影",
      "definition" : "1.適應症:動作障礙疾病包括巴金森氏病、非典型巴金森症(含多發性神經系統退化症、血管性巴金森症、藥物誘發性巴金森症、重金屬中毒等)以及先天性多巴胺神經系統酵素異常之鑑別診斷。2.不得同時申報26049B。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "26078A",
      "display" : "鐳223治療處置費",
      "definition" : "1.適應症：去勢抗性攝護腺癌(castration-resistantprostatecancer)，合併有症狀的骨轉移且尚未有臟器轉移者(ICD-10-CM診斷為C61攝護腺惡性腫瘤、C79.5骨骼續發性惡性腫瘤)。2.執行頻率：每四週一次，每四週為一療程，共六次療程。3.使用規範及人員資格：(1)操作人員：A.核子醫學科專科醫師。B.受過核子醫學相關訓練之醫事放射師。C.受過核子醫學相關訓練之護理師。(2)上開人員均應符合游離輻射防護法相關規定。(3)特殊設備要求使用：經原子能委員會評估可操作「鐳-223」之場所，須檢具放射性物質許可證。(4)費用申報時須檢具癌症治療計畫書、治療去勢抗性攝護腺癌病歷紀錄及骨轉移之影像學報告等資料。4.本項不含鐳223注射液。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Radium-223 treatment"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27",
      "display" : "成人預防保健:身分別為原住民且五十五歲以上未滿六十五歲，每年補助一次(第一階段)",
      "definition" : "一、受檢者應先填寫「成人預防保健服務檢查紀錄結果表單」之基本資料、個人及家族疾病史、長期服藥、健康行為及憂鬱檢測。二、生化檢查:飯前血糖、總膽固醇、三酸甘油脂、高密度脂蛋白膽固醇、AST(GOT)、ALT(GPT)、肌酸酐。三、尿液檢查:蛋白質。四、腎絲球過濾率計算。五、低密度脂蛋白膽固醇計算。※國健局以公務預算支應，由本署代辦本項服務",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27001C",
      "display" : "甲狀腺原氨酸放射免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "T3 (Triidothyronine)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27002B",
      "display" : "甲狀腺原氨酸攝取率檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T3 uptake"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27003B",
      "display" : "甲狀腺素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T4 (Thyroxine)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27004C",
      "display" : "甲狀腺刺激素放射免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "TSH (thyroid stimulating hormone)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27005B",
      "display" : "游離甲狀腺素指數分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "FTI"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27006B",
      "display" : "皮質素放射免疫分析",
      "definition" : "游離皮質素(freecortisol)比照申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cortisol"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27007B",
      "display" : "球蛋白Ｅ放射免疫分析",
      "designation" : [
        {
          "language" : "en",
          "value" : "IgE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27008B",
      "display" : "生長激素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HGH (human growth hormone)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "27009B",
      "display" : "胎盤生乳激素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HPL (human placental lactegen)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27010B",
      "display" : "絨毛膜促性腺激素－乙亞單體",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂英文名稱，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "β-HCG(human chorionic gonadotropin-β)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27011B",
      "display" : "催乳激素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PRL (prolactin)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27012B",
      "display" : "春情素醇放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "E3 (estriol)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27013B",
      "display" : "濾胞刺激素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "FSH (follicle stimulating hormone)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "27014B",
      "display" : "黃體化激素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "LH (leuteinizing hormone)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27015C",
      "display" : "胰島素放射免疫分析",
      "definition" : "胰島素抗體效價(insulinAbtiter)比照申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Insulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27016B",
      "display" : "胃泌激素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gastrin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27017B",
      "display" : "鐵蛋白放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ferritin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27018B",
      "display" : "Ａ型肝炎放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HAV"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27019B",
      "display" : "二氫基春情素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Estradiol (E2)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27020B",
      "display" : "黃體脂酮放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Progesterone"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27021B",
      "display" : "睪丸脂醇放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Testosterone"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27022B",
      "display" : "Ｃ－胜鍊胰島素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "C-Peptide"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27023B",
      "display" : "免疫球蛋白Ｅ補體結合反應",
      "definition" : "包括家塵、黴菌、牛乳、蛋(includehousedust，fungi，milk，eggetc)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Reaginic IgE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27024B",
      "display" : "碳－端副甲狀腺素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "C-terminal PTH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27025B",
      "display" : "MM－副甲狀腺素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PTH－MM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27026B",
      "display" : "Intact副甲狀腺素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intact PTH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27027B",
      "display" : "游離甲狀腺素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Free T4"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27028B",
      "display" : "維生素B12放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vitamin B12"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27029B",
      "display" : "葉酸放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Folic acid"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27030B",
      "display" : "攝護腺酸性磷酸鹽酵素放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PAP Prostatic acid phosphatase"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27031B",
      "display" : "醛類脂醇放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aldosterone"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27032B",
      "display" : "血漿腎活素活性放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PRA (Plasma renin activity)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27033C",
      "display" : "Ｂ型肝炎表面抗原放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBsAg"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27034B",
      "display" : "Ｂ型肝炎表面抗體放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBs"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27035B",
      "display" : "Ｂ型肝炎e抗原放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "HBeAg"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27036B",
      "display" : "Ｂ型肝炎e抗體放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBe"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27037B",
      "display" : "Ｂ型肝炎核心抗體放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBc"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27038B",
      "display" : "Ｂ型肝炎核心抗體免疫球蛋白Ｍ檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBc IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27039C",
      "display" : "Ｂ型肝炎表面抗體效價檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HBs titer"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27040B",
      "display" : "Ａ型肝炎免疫球蛋白Ｍ放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-HAV IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27041B",
      "display" : "Ａ型肝炎抗體",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti HAV"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27042B",
      "display" : "D型肝炎抗體",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-Delta"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27043B",
      "display" : "普卡因醯胺放射免疫分析",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Procainamide (RIA)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27044B",
      "display" : "膽汁酸",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bile acid"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27045B",
      "display" : "環孢靈素Ａ",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cyclosporin-A"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "27046B",
      "display" : "全鐵結合量",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TIBC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27047B",
      "display" : "未飽合鐵結合量",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "UIBC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27048B",
      "display" : "毛地黃",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Digoxin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "27049C",
      "display" : "甲－胎兒蛋白",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "AFP"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27050C",
      "display" : "胚胎致癌抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "CEA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27051B",
      "display" : "β-2微小球蛋白",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "β-2 microglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27052C",
      "display" : "攝護腺特異抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "PSA(prostate specific antigen)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "27053C",
      "display" : "CA-125腫瘤標記",
      "designation" : [
        {
          "language" : "en",
          "value" : "CA-125"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27054B",
      "display" : "CA-153腫瘤標記",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CA-153"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27055C",
      "display" : "CA-199腫瘤標記",
      "designation" : [
        {
          "language" : "en",
          "value" : "CA-199"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27056B",
      "display" : "抗-SCC腫瘤標記",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂英文名稱，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-SCC"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27057B",
      "display" : "17α-氫氧基黃體脂酮",
      "designation" : [
        {
          "language" : "en",
          "value" : "17α-OHP"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27058B",
      "display" : "甲狀腺球蛋白抗體",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ab-thyroglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27059B",
      "display" : "甲狀腺球蛋白",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thyroglobulin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27060B",
      "display" : "甲狀腺素結合球蛋白",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TBG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27061B",
      "display" : "動情激素接受體",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Estrogen receptor (ER)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27062B",
      "display" : "黃體激素接受體",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Progesterone receptor (PR)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27063B",
      "display" : "脂蛋白酶元B分析",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別，中文名稱修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Apolipoprotein B"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27064B",
      "display" : "脂蛋白酶元A1分析",
      "definition" : "93.6.14健保醫字第0930060063號公告修訂中文名稱及點數，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Apolipoprotein A1"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27065B",
      "display" : "微白蛋白",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Microalbumin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27066B",
      "display" : "胃液素原Ⅰ",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pepsinogen-Ⅰ"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27067B",
      "display" : "前膠原Ⅲ",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "P-Ⅲ-P"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27068B",
      "display" : "降血鈣素",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Calaitonin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27069B",
      "display" : "甲促素結合體抗體",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ab-TSH receptor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27070B",
      "display" : "骨原蛋白",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Osteocalcin"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27071B",
      "display" : "環磷酸腺甘酸",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "C-AMP"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27072B",
      "display" : "抗利尿激素",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ADH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27073B",
      "display" : "去氧核糖核酸抗體",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-ds DNA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27074B",
      "display" : "血清促腎上腺皮質素",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ACTH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27076B",
      "display" : "腫瘤多胜肽抗原",
      "definition" : "93.6.14健保醫字第0930060063號公告中文名稱更正，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TPA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27077B",
      "display" : "紅血球生成因子檢驗",
      "definition" : "93.6.14健保醫字第0930060063號公告英文名稱更正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Erythropoietin"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "27078B",
      "display" : "顆粒球-巨噬球集落形成單位",
      "designation" : [
        {
          "language" : "en",
          "value" : "CFU-GM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27079B",
      "display" : "游離型人類絨毛膜刺激素",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Free beta HCG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27080B",
      "display" : "硫酸-DHEA",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "DHEA-SO4"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27081B",
      "display" : "雄睪酮",
      "designation" : [
        {
          "language" : "en",
          "value" : "Androstenedione"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27082B",
      "display" : "組織多胜肽特異性抗原",
      "definition" : "93.6.14健保醫字第0930060063號公告中文名稱更正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Polypeptide"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27083B",
      "display" : "游離攝護腺特異抗原",
      "designation" : [
        {
          "language" : "en",
          "value" : "Free PSA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "27084C",
      "display" : "二胺基酸攝護腺特異抗原前驅物(p2PSA)",
      "definition" : "1.適應症須符合下列各項條件：(1)PSA介於4.0ng/ml至10.0ng/ml間者。(2)尿液分析及臨床症狀已排除攝護腺感染或發炎。(3)肛門指診無異常。(4)五十歲以上，或未滿五十歲但有攝護腺癌家族史。2.每十二個月限執行一次。3.限由泌尿科專科醫師開立處方始可申報。4.須檢附八週內PSA報告及本次PHI指數於病歷紀錄備查。5.若PHI指數顯示為攝護腺癌低風險(PHI<30)，再檢測PSA至少間隔二十四週。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28",
      "display" : "成人預防保健:身分別為原住民且五十五歲以上未滿六十五歲，每年補助一次(第二階段)",
      "definition" : "一、第一階段之檢驗結果判讀與建議。二、身體檢查:身高、體重、血壓、脈搏、腰圍、身體質量指數、視力檢查、耳鼻喉及口腔檢查、頸部檢查、胸部檢查、心臟聽診、呼吸聽診、腹部檢查、四肢檢查。三、健康諮詢:戒菸、節酒、戒檳榔、規律運動、維持正常體重、健康飲食、事故傷害預防、口腔保健。※國健局以公務預算支應，由本署代辦本項服務",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28001C",
      "display" : "關節鏡檢查",
      "definition" : "含手術材料費在內。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Arthroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28002C",
      "display" : "鼻咽喉內視鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nasopharyngolaryngoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28003C",
      "display" : "鼻竇內視鏡檢查",
      "definition" : "可用於診斷鼻竇疾病，內視鏡鼻竇功能手術(functionalendoscopicsinussurgery,FESS)。手術前得申報一次，手術後三個月內最多申報三次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sinoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28004C",
      "display" : "喉鏡檢查",
      "definition" : "不得同時申報28005B",
      "designation" : [
        {
          "language" : "en",
          "value" : "Laryngoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28005B",
      "display" : "喉頻閃光源內視鏡檢查",
      "definition" : "不得同時申報28004C",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stroboscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28006C",
      "display" : "支氣管鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28007B",
      "display" : "術中膽道纖維鏡檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告中英文名稱及點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fiber choledochoscopy, intraoperative"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28008B",
      "display" : "經T形管或其它路徑,膽道纖維鏡檢查及截石術",
      "definition" : "93.6.14健保醫字第0930060063號公告中英文名稱及點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fiber choledochoscopy, percutaneous via T-tube or other tract,with removal of stones"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28009B",
      "display" : "肋膜腔鏡檢查合併切片",
      "definition" : "含一般材料費及特殊材料費。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thoracoscopy with biopsy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "28010B",
      "display" : "小腸鏡檢查",
      "definition" : "不得同時申報28046B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Enteroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28011C",
      "display" : "直腸鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rectoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28013C",
      "display" : "S狀結腸鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sigmoidoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28014C",
      "display" : "腹腔鏡檢查",
      "definition" : "含手術材料費在內。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Laparoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28015C",
      "display" : "食道鏡檢查",
      "definition" : "適應症：1.食道腫瘤(含惡性及良性)。2.頭頸部惡性腫瘤。3.食道異物或疑似食道異物。4.食道狹窄、損傷、腐蝕性傷害、出血、發炎。5.吞嚥困難。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Esophageal endoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28016C",
      "display" : "上消化道泛內視鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Upper GI panendoscopy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "28017C",
      "display" : "大腸鏡檢查",
      "definition" : "限由消化內科、消化外科、大腸直腸外科、兒科消化學及小兒外科專科醫師執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Colonoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28019C",
      "display" : "膀胱鏡檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告中英文名稱修正。。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cystoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28020C",
      "display" : "診斷性輸尿管鏡檢，包括輸尿管膀胱接合處，擴張術及膀胱鏡術",
      "definition" : "93.6.14健保醫字第0930060063號公告中英文名稱及點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Diagnostic ureteroscopy, including dilatation of ureterovesical junction and cystoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28021C",
      "display" : "尿道鏡檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urethroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28022C",
      "display" : "子宮鏡檢查",
      "definition" : "1.當次子宮鏡檢查結果為正常者，同一醫療院所以一年一次為限。2.子宮鏡檢查結果為異常而採取藥物或觀察處置者，追蹤以一次為限，應間隔三個月以上。3.子宮鏡手術治療者，術後三個月內得進行追蹤檢查，若結果為正常，應以一次為限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hysteroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28023C",
      "display" : "肛門鏡檢查",
      "definition" : "(詳90.5.29健保醫字第0900015326函)。93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28026B",
      "display" : "縱膈腔鏡檢查合併切片",
      "definition" : "含一般材料費及特殊材料費。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mediastinoscopy with biopsy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "28028C",
      "display" : "陰道鏡檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Colposcopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28029C",
      "display" : "內視鏡超音波",
      "definition" : "內視鏡另計",
      "designation" : [
        {
          "language" : "en",
          "value" : "Endoscopic ultrasonography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28030C",
      "display" : "經內視鏡切片(每一診次)",
      "definition" : "內含一般材料費及單一使用之拋棄式生檢針及組織夾費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Endoscopic biopsy , each exam."
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "28031C",
      "display" : "大腸或小腸鏡切片(每一診次)",
      "definition" : "內含一般材料費及單一使用之拋棄式生檢鉗及組織夾費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Colonoscopic or enteroscopic biopsy, each exam."
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28032B",
      "display" : "膽道子母鏡",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transduodenal choledochoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28033C",
      "display" : "診斷性肺泡灌洗術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Diagnostic bronchoalveolar lavage"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28034B",
      "display" : "經T形管或其它路徑,膽道纖維鏡檢查",
      "definition" : "93.6.14健保醫字第0930060063號公告增列本項。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fiber choledochoscopy, percutaneous via T-tube or other tract"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28035B",
      "display" : "術中,膽道纖維鏡檢查及截石術",
      "definition" : "93.6.14健保醫字第0930060063號公告增列本項。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fiber choledochoscopy, intraoperative,with removal of stones"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28036B",
      "display" : "經皮穿肝膽道鏡",
      "definition" : "93.6.14健保醫字第0930060063號公告增列本項，原33094B移列至28036B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous transhepatic choledochoscopy(PTCS)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28037B",
      "display" : "腦內視鏡",
      "definition" : "限神經外科專科醫師施行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intracerebral endoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28038B",
      "display" : "自體螢光支氣管鏡檢查",
      "definition" : "適應症:1.痰液細胞學檢查發現疑似惡性細胞且胸部影像學正常者。2.肺癌手術前確認病灶侵犯位置，以決定手術方式及切除範圍。3.肺癌手術後追蹤，當疑似切除位置有復發時，為確認病灶。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28039B",
      "display" : "支氣管鏡螢光透視檢查(含支氣管鏡檢查費用)",
      "definition" : "1.適應症：支氣管鏡直接目視下不可見之肺周邊病灶，並經螢光導引定位進行之切片(biopsy)、刷拭(brushing)、沖洗(washing,lavage)。2.不得與28006C支氣管鏡檢查合併申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchofluoroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28040B",
      "display" : "支氣管內視鏡超音波",
      "definition" : "註：1.不得同時申報28006C、28026B。2.需檢附胸腔電腦斷層報告。3.內含一般材料費及單一使用之拋棄式特殊材料。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchoscopic Ultrasonography; EBUS"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28041B",
      "display" : "支氣管內視鏡超音波導引縱膈淋巴節定位切片術",
      "definition" : "註：1.不得同時申報28006C、28009B、28026B及28040B。2.申報時須檢附當次病理報告。3.內含一般材料費及單一使用之拋棄式特殊材料。",
      "designation" : [
        {
          "language" : "en",
          "value" : "EBUS + Transbronchial node aspiration"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28042B",
      "display" : "支氣管內視鏡超音波導引周邊肺組織採檢切片術",
      "definition" : "1.不得同時申報28006C、33103B及28040B。2.申報時須檢附當次病理報告。3.內含一般材料費及單一使用之拋棄式特殊材料。",
      "designation" : [
        {
          "language" : "en",
          "value" : "EBUS + Peripheral lung transbronchial biopsy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28043B",
      "display" : "電子式內視鏡超音波",
      "definition" : "註：1.適應症：縱膈腔病兆、慢性胰臟炎、膽胰系統腫瘤及囊腫、膽源性黃疸或急性胰臟炎、膽胰管狹窄、縱膈腔及腹腔淋巴病變、消化道進行性癌分期、後腹腔病灶(腎上腺、腎等)及左肝及脾臟病灶。2.支付規範：(1)不得同時申報28029C、28016C等相關內視鏡檢查及28044B。(2)內含一般材料費及單一使用之拋棄式特殊材料。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electronic Endoscopic Ultrasonography，EUS"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28044B",
      "display" : "細徑(迷你)探頭式內視鏡超音波",
      "definition" : "註：1.適應症：食道癌前期病變與癌分期、胃癌前病變與惡性腫瘤分期、小腸癌前病變與癌分期、大腸癌前病變與癌分期、膽胰管狹窄、消化道黏膜下腫瘤(小於/等於3公分)、膽胰管內腫瘤。2.支付規範：(1)不得同時申報28029C、28016C等相關內視鏡檢查及28043B。(2)內含一般材料費及單一使用之拋棄式特殊材料。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Miniprobe Endoscopic Ultrasound"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28045B",
      "display" : "耳內視鏡檢查",
      "definition" : "註：1.適應症：(1)外耳道狹窄或異物。(2)中耳或外耳道腫瘤。(3)膽脂瘤。(4)慢性中耳炎或積液性中耳炎，且需評估耳科手術者。2.禁忌症：外耳道閉鎖。3.支付規範：(1)限耳鼻喉科專科醫師執行。(2)限手術前後各執行一次。(3)申報時檢附之病歷紀錄須包含鼓膜、耳道、中耳腔影像。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Otoendoscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "28046B",
      "display" : "深部小腸內視鏡",
      "definition" : "1.適應症(須符合以下任一條件)：(1)疑似小腸出血(suspectedsmallbowelbleeding)：慢性消化道出血且高度懷疑小腸病變，經一次以上完整胃鏡及大腸內視鏡檢查，仍無法找出出血原因，且持續性貧血或斷斷續續血便或黑便者；或急性消化道不明原因出血，經一次以上完整胃鏡及大腸內視鏡檢查後，仍無法找出出血原因，且持續有血便或黑便者。(2)小腸克隆氏症之診斷或治療(SmallbowelCrohn’sdisease)。(3)Celiacdisease之診斷或追蹤(AssessmentofCeliacdisease)。(4)遺傳性腸道息肉症之診斷或治療(Hereditarypolyposissyndrome)。(5)影像學上發現小腸病變，需病理學上確診或內視鏡治療者。(6)小腸淋巴瘤或其他惡性腫瘤之診斷、治療及追蹤。2.限住院使用。3.限消化系內視鏡專科、兒科消化學專科及消化內視鏡外科專科醫師執行。4.疑似小腸出血者，須檢附胃鏡及大腸內視鏡檢查報告資料。5.不得同時申報28010B。6.內含一般材料費及「小腸內視鏡外套管」比率為百分之四十八。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Deep enteroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29001C",
      "display" : "硬腦膜下穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Subdural puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29002C",
      "display" : "上顎竇穿刺(一側)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Maxillary sinus puncture,unilateral"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29003C",
      "display" : "前房穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Paracentesis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29004C",
      "display" : "鼓室抽吸",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tympanic aspiration"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29005C",
      "display" : "鼓膜穿刺(一側)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Myringeal puncture, unilateral"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29006C",
      "display" : "中耳腔穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Middle ear cavity puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29007B",
      "display" : "氣管食道穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T-E puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29008B",
      "display" : "淋巴腺穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymph nodes puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29009C",
      "display" : "乳房細針穿刺",
      "definition" : "1.以病灶為單位，單一病灶限申報一次，二處以上病灶限申報二次。2.無論側性或病灶數，影像導引設備僅得申報一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Breast fine needle puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29010C",
      "display" : "唾腺組纖穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sialic puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29011C",
      "display" : "甲狀腺穿刺",
      "definition" : "詳見91.04.23健保醫字第0910007178號公告.91.05.01起修訂適用表別為基層院所適用.。93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thyroid puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29012B",
      "display" : "胸腔穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thoracocentesis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29013B",
      "display" : "心包穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pericardial puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29014B",
      "display" : "骨髓穿刺",
      "definition" : "適應症：1.未明原因的血球減少(Unexplainedcytopenia)2.血癌的評估(Evaluationofleukemia)3.骨髓增殖性疾病的確認(Confirmationofmyeloproliferativedisorder)4.未明原因的淋巴腺腫(Unexplainedlymphadenopathy)5.未有明確診斷之脾腫大(Splenomegalywithoutadiagnosis)6.淋巴惡性疾病的診斷或分期(Diagnosisorstagingoflym)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bone marrow puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29015C",
      "display" : "關節穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Arthrocentesis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29016C",
      "display" : "脊椎穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Spinal puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29017C",
      "display" : "腹腔穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Abdominal puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29019C",
      "display" : "膀胱穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bladder puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29020C",
      "display" : "陰囊水腫抽吸",
      "definition" : "93.6.14健保醫字第0930060063號公告中英文名稱及點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Scrotal hydrocele aspiration"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29022C",
      "display" : "輸卵管通水、通色素或通氣檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Oviduct hydrotubation, rubin test, or insufflation of tube with air or CO2"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29023C",
      "display" : "陰道陷凹穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Culdocentesis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29024B",
      "display" : "腦室穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Ventricular punture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29025B",
      "display" : "第一、二頸椎後側穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cervical arachnoid puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29026B",
      "display" : "臟器穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂，開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Organ puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29027C",
      "display" : "睪丸穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Testicle puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29028C",
      "display" : "攝護腺穿刺",
      "designation" : [
        {
          "language" : "en",
          "value" : "Prostate puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29029B",
      "display" : "鎖骨穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Subclavian puncture"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29030B",
      "display" : "經皮穿胸肺組織穿刺",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lung aspiration"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29031B",
      "display" : "心房中膈穿刺術",
      "definition" : "合併施行P.T.M.V.(Percutaneoustransluminationofmitralvalve)者，不得另申報本項費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Atrium transseptal procedure"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29032B",
      "display" : "骨髓切片",
      "definition" : "適應症:急慢性白血病之確定診斷、骨髓穿刺無法確定診斷者、惡性非何杰金氏淋巴瘤及何杰金氏病分期檢查、疑有惡性腫瘤併有骨髓轉移者，其他骨髓造血失調疾病等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bone marrow biopsy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29033B",
      "display" : "骨髓穿刺併骨髓切片",
      "definition" : "29014B與29032B同時施行時，以本項申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bone marrow puncture with bone marrow biopsy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "29035B",
      "display" : "乳房病灶粗針穿刺組織切片",
      "definition" : "1.適應症：(1)乳房惡性腫瘤Malignantneoplasmofbreast。(2)良性乳房發育不良Benignmammarydysplasia。(3)乳房炎性疾患Inflammatorydisordersofbreast。(4)乳房肥大Hypertrophyofbreast。(5)乳房腫塊Unspecifiedlumpinbreast。(6)乳房其他疾患Otherdisordersofbreast。2.若須使用影像導引設備，得另申報編號19007C、33005B、33085B等導引項目。無論側性或病灶數僅得申報一次。3.申報時需檢附當次病理報告。4.以病灶為單位，單一病灶限申報一次，二處以上病灶限申報二次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Breast lesion core needle biopsy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03",
      "display" : "第三次兒童衛教指導費(可搭配第三次兒童預防保健申報)",
      "definition" : "於四個月至十個月；提供哺餵及營養指導、副食品添加、口腔清潔與乳牙照護、事故傷害預防等衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30001C",
      "display" : "皮膚試驗(每種抗原)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Skin test, (each Ag)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30002C",
      "display" : "接觸過敏試驗(每種抗原)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Patch test, (each Ag)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30005B",
      "display" : "痰過敏抹片",
      "designation" : [
        {
          "language" : "en",
          "value" : "Allergic sputum smear"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30006B",
      "display" : "鼻分泌物檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nasal smear"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30007B",
      "display" : "補體",
      "designation" : [
        {
          "language" : "en",
          "value" : "C1q"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30008B",
      "display" : "吞噬細胞染色劑還原試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "NBT nitro-blue tetrozolium"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30009B",
      "display" : "遲發性過敏度皮膚試驗(共四種)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Delayed type hypersensitivity skin test 4 Ags"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30010B",
      "display" : "呼吸道激發試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchopulmonory provocation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30011B",
      "display" : "黴菌平板試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mold piece (cone piece)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30012B",
      "display" : "免疫複合體",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immune complex"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30013B",
      "display" : "C1酯化抑制劑定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "C1 esterase inhibitor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30014B",
      "display" : "P-K試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "P-K test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30015C",
      "display" : "Shick試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Shick test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30016B",
      "display" : "轉移因子之裝備",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transfer factor preparation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30017B",
      "display" : "轉移因子之注射",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transfer factor administration"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30018B",
      "display" : "ENA抗體篩檢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-ENA screen"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30019B",
      "display" : "抗Histone",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-histone"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30020B",
      "display" : "抗心脂抗體—IgG",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-cardiolopin—IgG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30021C",
      "display" : "過敏原檢驗(定性)",
      "definition" : "限確診為Asthma、過敏性鼻炎者或未滿三歲有異位性皮膚炎。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Allergen test(qualitative)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30022C",
      "display" : "特異過敏原免疫檢驗",
      "definition" : "1.限免疫球蛋白IgE(12031C)大於其標準值或過敏原定性檢驗(30021C)異常，且為確認診斷氣喘、過敏性鼻炎、異位性皮膚炎、其他IgE-mediated疾病(含急性蕁麻疹、食物或藥物過敏或全身性過敏)者申報。2.一年內相同過敏原不可重複申報本項。3.一年申報一次，最多不超過二次，若有特殊情況需增加檢驗次數者，應於病歷記載檢查之適應症並檢附相關資料佐證，以四次為限。申報超過二次以上者，應加強審查。4.屬西醫基層總額部門院所，限確認診斷為氣喘、過敏性鼻炎者或未滿三歲有異位性皮膚炎者申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Specific Allergen Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30023B",
      "display" : "嗜伊紅血球陽離子蛋白檢驗",
      "definition" : "包括IgG、IgM。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ECP Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30024B",
      "display" : "遲發性過敏度皮膚試驗(共八種)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Delayed type hypersensitivity skin test,8 Ags (Multitest)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30025B",
      "display" : "NBTTest",
      "designation" : [
        {
          "language" : "en",
          "value" : "NBT Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30026B",
      "display" : "鼻誘發試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nasal provocation test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30027B",
      "display" : "抗磷脂抗體—IgG",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-phospholipid antibody—IgG"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "30028B",
      "display" : "抗心脂抗體—IgM",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-cardiolopin—IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30029B",
      "display" : "抗磷脂抗體—IgM",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anti-phospholipid antibody—IgM"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30030C",
      "display" : "自體血清皮內注射試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Autologous serum intradermal test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30101B",
      "display" : "肺癌表皮生長因子受體(EGFR)突變體外診斷醫療器材檢測(IVD)",
      "definition" : "1.適應症：(1)限復發或轉移性(第Ⅳ期)之非小細胞且非鱗狀上皮肺癌，於使用EGFR標靶藥物前得申請檢測。(2)第ⅢB期及第ⅢC期，經肺癌多專科團隊討論，無法以外科手術完全切除、且不適合放射化學治療，於使用EGFR標靶藥物前得申請檢測。2.支付規範：(1)本檢測應包含EGFR(外顯子[exon]18、19、20、21)之突變分析。(2)限使用已確診之腫瘤病理組織或細胞檢體做檢測，並於檢測報告上註明診斷與腫瘤細胞百分比。(3)限具肺癌EGFR基因檢測項目通過CAP(美國病理學家學會，TheCollegeofAmericanPathologists)、TAF(財團法人全國認證基金會，TaiwanAccreditationFoundation)或台灣病理學會之分子實驗室認證之實驗室。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(5)限使用食品藥物管理署核准之第三等級醫療器材檢測試劑操作，並於檢測報告上註明方法學與檢測平台。(6)限解剖病理專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(7)限符合適應症規範者用藥前之伴隨式檢測，每人終生限給付一次。(8)不得同時申報編號30102B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "EGFR mutation in vitro diagnostics testing"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30102B",
      "display" : "肺癌表皮生長因子受體(EGFR)突變實驗室開發檢測(LDTs)",
      "definition" : "1.適應症：(1)限復發或轉移性(第Ⅳ期)之非小細胞且非鱗狀上皮肺癌，於使用EGFR標靶藥物前得申請檢測。(2)第ⅢB期及第ⅢC期，經肺癌多專科團隊討論，無法以外科手術完全切除、且不適合放射化學治療，於使用EGFR標靶藥物前得申請檢測。2.支付規範：(1)本檢測應包含EGFR(外顯子[exon]18、19、20、21)之突變分析。(2)限使用已確診之腫瘤病理組織或細胞檢體做檢測，並於檢測報告上註明診斷與腫瘤細胞百分比。(3)限主管機關核定之實驗室開發檢測施行計畫表列醫療機構申報。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(5)檢測報告上應註明方法學與檢測平台。(6)限解剖病理專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(7)限符合適應症規範者用藥前之伴隨式檢測，每人終生限給付一次。(8)不得同時申報編號30101B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "EGFR mutation Laboratory Developed Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30103B",
      "display" : "PD-L1免疫組織化學染色",
      "definition" : "註：1.適應症：符合全民健康保險藥物給付項目及支付標準第6編第83條之藥品給付規定第9節抗癌瘤藥物9.69.免疫檢查點PD-1、PD-L1抑制劑之使用條件，且申請時需檢附生物標記(PD-L1)表現量檢測報告之疾病。2.支付規範：(1)限使用食品藥物管理署核准之第三等級醫療器材檢測試劑(IVD)操作，並於檢測報告上註明方法學與檢測平台。(2)應檢附經解剖病理或口腔病理專科醫師簽名與加註專科醫師證書字號之病理報告。(3)限符合適應症規範者用藥前之伴隨式檢測，每人終生限給付一次。(4)申報本項除依通則規定外，尚須上傳檢測試劑代碼，未上傳者不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "PD-L1 immunohistochemistry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30104B",
      "display" : "All-RAS及BRAF基因突變分析實驗室開發檢測(LDTs)",
      "definition" : "1.適應症：符合全民健康保險藥物給付項目及支付標準附件六藥品給付規定第九節抗癌瘤藥物9.27.Cetuximab及9.53.Panitumumab之轉移性直腸結腸癌病人。2.支付規範：(1)本檢測應包含KRAS(外顯子[exon]2、3與4)、NRAS(外顯子2、3與4)與BRAFV600E之突變分析。(2)限使用已確診之腫瘤病理組織或細胞檢體做檢測，並於檢測報告上註明診斷與腫瘤細胞百分比。(3)限主管機關核定之實驗室開發檢測施行計畫表列醫療機構申報。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請經核定。(5)檢測報告上應註明方法學與檢測平台。(6)限解剖病理專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(7)限符合適應症規範者用藥前之伴隨式檢測，每人終生限給付一次。(8)不得同時申報編號30106B、30107B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "All-RAS and BRAF mutation testing(LDTs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30105B",
      "display" : "間變性淋巴瘤激酶(ALK)突變體外診斷醫療器材檢測(IVD)-IHC法",
      "definition" : "1.適應症：(1)限復發或轉移性(第Ⅳ期)之非小細胞且非鱗狀上皮肺癌，於EGFR基因檢測為陰性時，得申請檢測。(2)第ⅢB期及第ⅢC期，經肺癌多專科團隊討論，無法以外科手術完全切除、且不適合放射化學治療，於EGFR基因檢測為陰性時，得申請檢測。2.支付規範：(1)限使用食品藥物管理署核准之第三等級醫療器材檢測試劑操作，並於檢測報告上註明方法學與檢測平台。(2)限解剖病理專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(3)限符合適應症規範者用藥前之伴隨式檢測，每人終生限給付一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "ALK in vitro diagnostics testing-IHC method"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30106B",
      "display" : "All-RAS及BRAF基因突變分析體外診斷醫療器材檢測(IVD)",
      "definition" : "1.適應症：符合全民健康保險藥物給付項目及支付標準附件六藥品給付規定第九節抗癌瘤藥物9.27.Cetuximab及9.53.Panitumumab之轉移性直腸結腸癌病人。2.支付規範：(1)本檢測應包含KRAS(外顯子[exon]2、3與4)、NRAS(外顯子2、3與4)與BRAFV600E之突變分析。(2)限使用已確診之腫瘤病理組織或細胞檢體做檢測，並於檢測報告上註明診斷與腫瘤細胞百分比。(3)限具大腸直腸癌ALL-RAS基因檢測項目通過美國病理學家學會(TheCollegeofAmericanPathologists,CAP)、財團法人全國認證基金會(TaiwanAccreditationFoundation,TAF)、台灣病理學會之分子實驗室認證或經衛生福利部食品藥物管理署精準醫療分子檢測實驗室認證(列冊登錄)之實驗室檢測，並須檢附IVD檢測試劑進貨證明，由特約醫事服務機構申報。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請經核定。(5)檢測報告上應註明方法學與檢測平台。(6)限解剖病理專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(7)限符合適應症規範者用藥前之伴隨式檢測，每人終生限給付一次。(8)不得同時申報編號30104B、30107B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "All-RAS and BRAF mutation testing(IVD)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30107B",
      "display" : "BRAF基因突變分析實驗室開發檢測(LDTs)",
      "definition" : "1.須符合下列任一條件適應症：(1)符合全民健康保險藥物給付項目及支付標準附件六藥品給付規定第九節抗癌瘤藥物9.52.Vemurafenib及9.91.Dabrafenib、Trametinib之黑色素瘤病人。(2)符合全民健康保險藥物給付項目及支付標準附件六藥品給付規定第九節抗癌瘤藥物9.27.Cetuximab及9.53.Panitumumab之轉移性直腸結腸癌病人，且KRAS及NRAS為wildtype者。(3)甲狀腺癌(不包含髓質癌)A.乳突性及濾泡性甲狀腺癌經碘131及抑制血管新生標靶藥物治療無效或不適合使用抑制血管新生標靶藥物者。B.無分化甲狀腺癌經多專科團隊評估無法接受根除手術者。2.支付規範：(1)本檢測於黑色素瘤應包含BRAFV600之突變分析、於結腸直腸癌及甲狀腺癌應包含BRAFV600E之突變分析。(2)限使用已確診之腫瘤病理組織或細胞檢體做檢測，並於檢測報告上註明診斷與腫瘤細胞百分比。(3)限主管機關核定之實驗室開發檢測施行計畫表列醫療機構申報。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(5)檢測報告上應註明方法學與檢測平台。(6)限解剖病理專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(7)限符合適應症規範者用藥前之伴隨式檢測，每人終生各癌別限給付一次。(8)不得同時申報編號30104B、30106B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "BRAF mutation testing (LDTs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30108B",
      "display" : "KIT及PDGFRA基因突變分析實驗室開發檢測(LDTs)",
      "definition" : "1.適應症：符合全民健康保險藥物給付項目及支付標準附件六藥品給付規定第九節抗癌瘤藥物9.22.Imatinib、9.31.Sunitinib、9.51.Regorafenib及9.97.Avapritinib之腸胃道間質瘤病人。2.支付規範：(1)本檢測應包含KIT(外顯子[exon]9、11、13與17)與PDGFRA(外顯子[exon]12、14、18)之突變分析。(2)限使用已確診之腫瘤病理組織或細胞檢體做檢測，並於檢測報告上註明診斷與腫瘤細胞百分比。(3)限主管機關核定之實驗室開發檢測施行計畫表列醫療機構申報。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(5)檢測報告上應註明方法學與檢測平台。(6)限解剖病理專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(7)限符合適應症規範者用藥前之伴隨式檢測，每人終生限給付一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "KIT and PDGFRA mutation testing (LDTs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30109B",
      "display" : "第十七對染色體缺失原位雜合檢驗",
      "definition" : "1.須符合下列任一條件適應症：(1)慢性淋巴性白血病/小淋巴細胞淋巴瘤(CLL/SLL)。(2)被套細胞淋巴癌(MCL)。2.支付規範：(1)本項應包含del(17p)之突變分析。(2)限使用已確診之血液腫瘤檢測。(3)限主管機關核定之實驗室開發檢測施行計畫表列醫療機構。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請經核定。(5)限專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(6)每人終生限給付一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "del(17p) in situ hybridization (ISH)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30110B",
      "display" : "侵襲性B細胞淋巴癌原位雜合檢驗",
      "definition" : "1.須符合下列任一條件適應症：(1)瀰漫性巨大B細胞淋巴瘤。(2)Burkitt淋巴瘤。2.支付規範：(1)本項應包含MYC、BCL2之突變分析。(2)限使用已確診之血液腫瘤檢測。(3)限主管機關核定之實驗室開發檢測施行計畫表列醫療機構。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請經核定。(5)限專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(6)每人終生限給付一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aggressive B-cell lymphoma in situ hybridization (ISH)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30111B",
      "display" : "多發性骨髓瘤原位雜合檢驗",
      "definition" : "1.適應症：多發性骨髓瘤及惡性漿細胞腫瘤。2.支付規範：(1)本項應包含del(17p)、t(4;14)、t(14;16)、1q21gain/amplification之突變分析。(2)限使用已確診之血液腫瘤檢測。(3)限主管機關核定之實驗室開發檢測施行計畫表列醫療機構。(4)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請經核定。(5)限專科醫師簽發報告，並於檢測報告上加註專科醫師證書字號。(6)每人終生限給付一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Multiple myeloma in situ hybridization (ISH)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30301B",
      "display" : "實體腫瘤次世代基因定序－BRCA1/2基因檢測",
      "definition" : "1.適應症：如附表2.2.1。2.支付規範：(1)醫院資格須符合下列各項條件：A.限區域級以上醫院或主管機關公告通過「癌症診療品質認證醫院」者。B.須院內設立或跨院聯合組成分子腫瘤委員會(MolecularTumorBoard,MTB)。C.限主管機關核定之實驗室開發檢測施行計畫表列醫療機構(檢測項目類別為「抗癌瘤藥物之伴隨檢測」或「癌症篩檢、診斷、治療及預後之基因檢測」)。(2)核發檢測報告人員及報告簽署醫師：依「特定醫療技術檢查檢驗醫療儀器施行或使用管理辦法」之規定辦理。(3)除GermlineBRCA1/2基因檢測使用血液檢體外，其他檢測限使用已確診之腫瘤病理組織，且檢測項目須包含附表2.2.1所列該癌別必須檢測之位點及變異別，始予給付。(4)每人各癌別限30301B、30302B或30303B擇一申報且終生給付一次。(5)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(6)檢測結果須於申報後一個月內依指定格式上傳至保險人，未上傳者本項不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Solid tumor next generation sequencing, NGS-BRCA testing (germline or somatic)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30302B",
      "display" : "實體腫瘤次世代基因定序－小套組(≦100個基因)",
      "definition" : "1.適應症：如附表2.2.1。2.支付規範：(1)醫院資格須符合下列各項條件：A.限區域級以上醫院或主管機關公告通過「癌症診療品質認證醫院」者。B.須院內設立或跨院聯合組成分子腫瘤委員會(MolecularTumorBoard,MTB)。C.限主管機關核定之實驗室開發檢測施行計畫表列醫療機構(檢測項目類別為「抗癌瘤藥物之伴隨檢測」或「癌症篩檢、診斷、治療及預後之基因檢測」)。(2)核發檢測報告人員及報告簽署醫師：依「特定醫療技術檢查檢驗醫療儀器施行或使用管理辦法」之規定辦理。(3)除GermlineBRCA1/2基因檢測使用血液檢體外，其他檢測限使用已確診之腫瘤病理組織，且檢測項目須包含附表2.2.1所列該癌別必須檢測之位點及變異別，始予給付。(4)每人各癌別限30301B、30302B或30303B擇一申報且終生給付一次。(5)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(6)檢測結果須於申報後一個月內依指定格式上傳至保險人，未上傳者本項不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Solid tumor next generation sequencing,NGS-Small panel(≦100 genes)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30303B",
      "display" : "實體腫瘤次世代基因定序－大套組(＞100個基因)",
      "definition" : "1.適應症：如附表2.2.1。2.支付規範：(1)醫院資格須符合下列各項條件：A.限區域級以上醫院或主管機關公告通過「癌症診療品質認證醫院」者。B.須院內設立或跨院聯合組成分子腫瘤委員會(MolecularTumorBoard,MTB)。C.限主管機關核定之實驗室開發檢測施行計畫表列醫療機構(檢測項目類別為「抗癌瘤藥物之伴隨檢測」或「癌症篩檢、診斷、治療及預後之基因檢測」)。(2)核發檢測報告人員及報告簽署醫師：依「特定醫療技術檢查檢驗醫療儀器施行或使用管理辦法」之規定辦理。(3)除GermlineBRCA1/2基因檢測使用血液檢體外，其他檢測限使用已確診之腫瘤病理組織，且檢測項目須包含附表2.2.1所列該癌別必須檢測之位點及變異別，始予給付。(4)每人各癌別限30301B、30302B或30303B擇一申報且終生給付一次。(5)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(6)檢測結果須於申報後一個月內依指定格式上傳至保險人，未上傳者本項不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Solid tumor next generation sequencing,NGS-Large panel(＞100 genes)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30304B",
      "display" : "血液腫瘤次世代基因定序－小套組(≦100個基因)",
      "definition" : "1.適應症：如附表2.2.2。2.支付規範：(1)醫院資格符合下列各項條件：A.區域級以上醫院或主管機關公告通過「癌症診療品質認證醫院」者。B.須院內設立或跨院聯合組成分子腫瘤委員會(MolecularTumorBoard,MTB)。C.限主管機關核定之實驗室開發檢測施行計畫表列醫療機構(檢測項目類別為「抗癌瘤藥物之伴隨檢測」或「癌症篩檢、診斷、治療及預後之基因檢測」)。(2)核發檢測報告人員及報告簽署醫師：依「特定醫療技術檢查檢驗醫療儀器施行或使用管理辦法」之規定辦理。(3)限使用已確診之血液腫瘤檢測，且檢測項目須包含附表2.2.2所列各該癌別檢測位點及變異別，始予給付。(4)每人各癌別限30304B或30305B擇一申報且終生給付一次。(5)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(6)檢測結果須於申報後一個月內依指定格式上傳至保險人，未上傳者本項不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hematologic malignancies next generation sequencing,NGS-Small panel(≦100 genes)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30305B",
      "display" : "血液腫瘤次世代基因定序－大套組(＞100個基因)",
      "definition" : "1.適應症：如附表2.2.2。2.支付規範：(1)醫院資格符合下列各項條件：A.區域級以上醫院或主管機關公告通過「癌症診療品質認證醫院」者。B.須院內設立或跨院聯合組成分子腫瘤委員會(MolecularTumorBoard,MTB)。C.限主管機關核定之實驗室開發檢測施行計畫表列醫療機構(檢測項目類別為「抗癌瘤藥物之伴隨檢測」或「癌症篩檢、診斷、治療及預後之基因檢測」)。(2)核發檢測報告人員及報告簽署醫師：依「特定醫療技術檢查檢驗醫療儀器施行或使用管理辦法」之規定辦理。(3)限使用已確診之血液腫瘤檢測，且檢測項目須包含附表2.2.2所列各該癌別檢測位點及變異別，始予給付。(4)每人各癌別限30304B或30305B擇一申報且終生給付一次。(5)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(6)檢測結果須於申報後一個月內依指定格式上傳至保險人，未上傳者本項不予支付。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hematologic malignancies next generation sequencing,NGS-Large panel(＞100 genes)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30306B",
      "display" : "TP53基因突變分析實驗室開發檢測(LDTs)",
      "definition" : "1.須符合下列任一條件適應症：(1)慢性淋巴性白血病/小淋巴細胞淋巴瘤(CLL/SLL)。(2)被套細胞淋巴癌(MCL)。2.支付規範：(1)醫院資格符合下列各項條件：A.區域級以上醫院或主管機關公告通過「癌症診療品質認證醫院」者。B.須院內設立或跨院聯合組成分子腫瘤委員會(MolecularTumorBoard,MTB)。C.限主管機關核定之實驗室開發檢測施行計畫表列醫療機構(檢測項目類別為「抗癌瘤藥物之伴隨檢測」或「癌症篩檢、診斷、治療及預後之基因檢測」)。(2)核發檢測報告人員及報告簽署醫師：依「特定醫療技術檢查檢驗醫療儀器施行或使用管理辦法」之規定辦理。(3)限使用已確診之血液腫瘤檢測，且檢測項目應包含TP53之突變分析。(4)每人終生限給付一次。(5)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(6)檢測報告上應註明方法學與檢測平台。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TP53 mutation testing (LDTs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30307B",
      "display" : "TCR基因重組單株性分析(LDTs)",
      "definition" : "1.適應症：經病理專科醫師與血液腫瘤科醫師多專科會議討論疑似為「T細胞或NK細胞之淋巴瘤或白血病」。2.支付規範：(1)醫院資格符合下列各項條件：A.區域級以上醫院或主管機關公告通過「癌症診療品質認證醫院」者。B.須院內設立或跨院聯合組成分子腫瘤委員會(MolecularTumorBoard,MTB)。C.限主管機關核定之實驗室開發檢測施行計畫表列醫療機構(檢測項目類別為「抗癌瘤藥物之伴隨檢測」或「癌症篩檢、診斷、治療及預後之基因檢測」)。(2)核發檢測報告人員及報告簽署醫師：依「特定醫療技術檢查檢驗醫療儀器施行或使用管理辦法」之規定辦理。(3)限使用符合上述適應症之血液腫瘤之病理組織檢測，且檢測項目應包含TCR(基因重組)之單株性分析。(4)每人終生限給付一次。(5)執行本項之醫事服務機構應報經保險人核定，如有異動，仍應重行報請核定。(6)檢測報告上應註明方法學與檢測平台。(7)應檢附病理專科與血液腫瘤科多專科討論會議紀錄。",
      "designation" : [
        {
          "language" : "en",
          "value" : "TCR clonality analysis (LDTs)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30501C",
      "display" : "羊齒植物狀試驗(子宮頸)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fern test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30502C",
      "display" : "子宮頸黏液檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Post-coital test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30503B",
      "display" : "皮脂定量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sebum quantitation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30504B",
      "display" : "紫外線致紅劑測試",
      "designation" : [
        {
          "language" : "en",
          "value" : "UV test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30505B",
      "display" : "電氣解析術",
      "designation" : [
        {
          "language" : "en",
          "value" : "LELC analysis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30506B",
      "display" : "食道機能檢查",
      "definition" : "兒童加成。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Manometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30507B",
      "display" : "二十四小時食道酸鹼度測定",
      "definition" : "內含一般材料費及單一使用拋棄式「二十四小時食道酸鹼度單次測量管」材料費。",
      "designation" : [
        {
          "language" : "en",
          "value" : "24 hours PH esophageal monitoring"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30508C",
      "display" : "皮膚貼布試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Patch test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30509B",
      "display" : "水泡液抹片檢查及判讀",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tzanck test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30510B",
      "display" : "APR後膀胱機能測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "Monometric study, bladder"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "30511B",
      "display" : "高頻肛門電療法",
      "designation" : [
        {
          "language" : "en",
          "value" : "High-voltage electrogalvanic anal stimul"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30512C",
      "display" : "碳-13尿素呼氣檢查幽門螺旋桿菌感染",
      "definition" : "適應症：1.出血、幼兒、孕婦、衰老等不適合做胃鏡檢查之消化性潰瘍患者治療前之幽門螺旋桿菌感染鑑定檢查。2.證實為潰瘍併幽門螺旋桿菌感染患者為除菌治療後之療效確認與追蹤，第一次於潰瘍治療(含PPI藥物)停藥後一個月施行一次。3.不得同時申報13018C、28016C、28030C及13007C。4.本項檢查採包裹式給付，不論方法皆不得另行申請材料費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "13C-urea breath test for Helicobacter pylori infection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30513C",
      "display" : "羊水酸鹼度反應",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amniotic PH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30514C",
      "display" : "嘔吐物潛血反應檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vomit occult blood test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30515B",
      "display" : "肌膜隔間壓力測量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Compatment pressure measurement"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30516B",
      "display" : "冷水試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cold Pressor Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30517C",
      "display" : "唾液分泌機能檢查",
      "definition" : "適應症為原發性或繼發性修格連氏症候群(Sjogren'ssyndrom)、老年性唾腺功能低下症及放射治療後唾液腺功能低下症。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Saliva production"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30518C",
      "display" : "甲褶血管鏡檢查",
      "definition" : "1.需由免疫風濕科醫師判讀。2.同一病患一年至多檢查二次3.申報時需附甲褶血管鏡檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nailfold capillaroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30519C",
      "display" : "棉墊試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pad test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30521B",
      "display" : "乙醯膽鹼刺激皮膚發汗測試",
      "definition" : "適應症：1.皮膚排汗異常。2.異位性皮膚炎。3.交感神經病變或副交感神經病變、糖尿病引起神經病變、周邊神經病變、及其他不明原因之神經病變引發的排汗功能異常。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Acetylcholine stimulated skin perspiration test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30522C",
      "display" : "幽門桿菌糞便抗原檢查",
      "definition" : "1.適應症:(1)出血、幼兒、孕婦、衰老等不適合做胃鏡檢查之消化性潰瘍患者治療前之幽門螺旋桿菌感染鑑定檢查。(2)證實為潰瘍併幽門螺旋桿菌感染患者為除菌治療後之療效確認與追蹤，第一次於潰瘍治療(含PPI藥物)停藥後一個月施行一次。2.支付規範(1)不得同時申報13007C、13018C、28016C、28030C及30512C。(2)限試劑抗原屬台灣本土菌株者申報。(3)本項檢查採包裹式給付，不論方法皆不得另行申請材料費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Helicobacter pylori stool antigen(HpSA)Test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30523B",
      "display" : "多管腔食道內阻抗及酸鹼度測定",
      "definition" : "1.適應症:(1)難治之胃食道逆流症典型症狀(如持續的火燒心或胃酸逆流)，經上消化道內視鏡或二十四小時食道酸鹼度測定檢查後，經藥物(如質子幫浦抑制劑，PPI)治療至少八週以上反應不佳者。(2)胃食道逆流症非典型症狀(如不明原因胸痛、慢性咳嗽、氣喘、喉嚨異物感或聲音沙啞)，經相關專科醫師診查後，經上消化道內視鏡或二十四小時食道酸鹼度測定檢查後，經藥物(如質子幫浦抑制劑，PPI)治療至少八週以上反應不佳者。(3)未滿十九歲兒童及嬰兒胃食道逆流症典型症狀(如持續性嘔吐、火燒心或胃酸逆流)，及胃食道逆流症之非典型症狀(如不明原因胸痛、慢性咳嗽、難治性兒童氣喘、喉嚨異物感、聲音沙啞、嬰幼兒呼吸中止或心搏過慢)。(4)未滿十九歲兒童及嬰兒因吞嚥困難，進行胃造瘻術(gastrostomy)之術前評估。(5)吞嚥困難，經上消化道內視鏡檢查或食道攝影檢查評估後，疑似食道蠕動功能異常疾病(如食道弛緩不能症者)。(6)胃食道逆流症患者接受外科逆流手術治療前之評估，及術後仍有符合前述症狀之追蹤。2.支付規範：(1)內含二十四小時食道阻抗酸鹼度單次用測量管。(2)限由消化內、消化外科、消化兒科及胸腔外科專科醫師執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Multi-channel Intraluminal Impedance and pH monitor, MII-pH"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30524B",
      "display" : "使用TRH注射液",
      "definition" : "註:1.本項係診斷性用藥，限執行對應檢驗診療項目須併用藥品時申報。2.上述對應檢驗診療項目為09112C、09120C、27004C、27008B、27011B。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30525B",
      "display" : "使用LH-RH注射液",
      "definition" : "註:1.本項係診斷性用藥，限執行對應檢驗診療項目須併用藥品時申報。2.上述對應檢驗診療項目為09125C、09126C、24027B、27008B、27013B、27014B。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "30526B",
      "display" : "高解析度食道壓力檢查",
      "definition" : "1.適應症：(1)吞嚥困難，經上消化道內視鏡檢查或食道攝影檢查評估後，疑似食道蠕動功能異常疾病(如食道弛緩不能症者)。(2)難治性之胃食道逆流症狀(持續的火燒心、胃酸逆流、不明原因胸痛、慢性咳嗽、氣喘、喉嚨異物感或聲音沙啞)，經相關專科醫師診查後，經上消化道內視鏡或二十四小時食道酸鹼度測定檢查後，且經藥物(如質子幫浦抑制劑，PPI)治療八週以上反應不佳者。(3)未滿十九歲兒童及嬰兒胃食道逆流症狀(如持續性嘔吐、火燒心或胃酸逆流、不明原因胸痛、慢性咳嗽、難治性兒童氣喘、喉嚨異物感、聲音沙啞、嬰幼兒呼吸中止或心搏過慢)，經相關專科醫師診治四週以上反應不佳者。(4)未滿十九歲兒童及嬰兒因吞嚥困難，進行胃造瘻術(gastrostomy)之術前評估。(5)食道蠕動功能異常疾病(如食道弛緩不能症)接受內視鏡治療或手術治療後之評估。(6)胃食道逆流症患者接受外科逆流手術治療前之評估，及術後仍有符合前述症狀之追蹤。2.禁忌症：(1)造成食道管腔狹窄或阻塞之良性食道疾病或惡性食道腫瘤。(2)食道破裂。(3)食道出血。(4)急性上呼吸道感染。3.支付規範：(1)執行頻率：每人每年限執行一次，如有接受內視鏡或手術治療者，則最多可執行二次。(2)限內科、外科、兒科、耳鼻喉科及復健科醫師執行。(3)不得同時申報30506B食道機能檢查。(4)內含一般材料費及「微晶片導管」材料費。",
      "designation" : [
        {
          "language" : "en",
          "value" : "High Resolution Esophageal Manometry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "31",
      "display" : "子宮頸抹片採樣/骨盤腔檢查(醫療院所)",
      "definition" : "三十歲以上婦女每年一次※國民健康署運用菸品健康福利捐經費補助",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32001C",
      "display" : "胸腔檢查(包括各種角度部位之胸腔檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chest view (including each view of chest film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32002C",
      "display" : "胸腔檢查(包括各種角度部位之胸腔檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chest view (including each view of chest film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32003C",
      "display" : "胸腔後前位及兩側斜位檢查(鋇餐)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chest P - A and both oblique view (with barium meal)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32004C",
      "display" : "胸鎖關節檢查，單側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sternoclavicular joint; one side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32005C",
      "display" : "胸鎖關節檢查，雙側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sternoclavicular joint; both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32006C",
      "display" : "腎臟、輸尿管、膀胱檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "K.U.B. examination"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32007C",
      "display" : "腹部檢查(包括各種姿勢之腹部檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plain abdomen (including each position of plain abdomen)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32008C",
      "display" : "腹部檢查(包括各種姿勢之腹部檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Plain abdomen (including each position of plain abdomen)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32009C",
      "display" : "頭顱檢查(包括各種角度部位之頭顱檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Skull film (including each view of skull film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32010C",
      "display" : "頭顱檢查(包括各種角度部位之頭顱檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Skull film (including each view of skull film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32011C",
      "display" : "脊椎檢查(包括各種角度部位之頸椎、胸椎、腰椎、薦椎、尾骨及薦髂關節等之檢查)",
      "definition" : "連續拍照第二張以上者，第一張250點，第二張以後一律八折支付，點數為200點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Spine view (including each view of cervica lspine, thoracic spine, lumbar spine, sacrum, coccyx and sacroiliac joint test)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32012C",
      "display" : "脊椎檢查(包括各種角度部位之頸椎、胸椎、腰椎、薦椎、尾骨及薦髂關節等之檢查)",
      "definition" : "連續拍照第二張以上者，第一張250點，第二張以後一律八折支付，點數為200點",
      "designation" : [
        {
          "language" : "en",
          "value" : "Spine view (including each view of cervica lspine, thoracic spine, lumbar spine, sacrum, coccyx and sacroiliac joint test)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32013C",
      "display" : "肩部骨頭及關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of bone and joint of shoulder (including each view of shoulder film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32014C",
      "display" : "肩部骨頭及關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of bone and joint of shoulder (including each view of shoulder film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32015C",
      "display" : "上肢骨各處骨頭及關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of bone and joint of upper extremities (including each view of film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32016C",
      "display" : "上肢骨各處骨頭及關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of bone and joint of upper extremities (including each view of film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32017C",
      "display" : "下肢骨各處骨頭及關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of bone and joint of lower extremities (including each view of film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32018C",
      "display" : "下肢骨各處骨頭及關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of bone and joint of lower extremities (including each view of film)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32019C",
      "display" : "關節測量術",
      "definition" : "股骨及下腿前後像",
      "designation" : [
        {
          "language" : "en",
          "value" : "Scanography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32020C",
      "display" : "分層關節測量術",
      "definition" : "包括關節測量",
      "designation" : [
        {
          "language" : "en",
          "value" : "Split scanography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32021B",
      "display" : "長骨普查攝影",
      "definition" : "包括肱骨、前臂股骨、下腿前後像、脊椎、骨盆及顱骨之檢查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Long bone survey"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32022C",
      "display" : "骨盆及髖關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of pelvis and hip joint (including each side)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32023C",
      "display" : "骨盆及髖關節檢查(包括各種角度與部位之檢查)",
      "definition" : "連續拍照第二張以上者，第一張200點，第二張以後一律八折支付，點數為160點",
      "designation" : [
        {
          "language" : "en",
          "value" : "View of pelvis and hip joint (including each side)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32024C",
      "display" : "骨盆測量術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pelvimetry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32025B",
      "display" : "骨骼關節之壓抑攝影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stress view of bone joint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "32026C",
      "display" : "Ｘ-光透視攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fluoroscopy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33",
      "display" : "子宮頸細胞病理檢驗",
      "definition" : "三十歲以上婦女每年一次※國民健康署運用菸品健康福利捐經費補助",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33001B",
      "display" : "支氣管造影術－單側",
      "definition" : "包括內視鏡費用在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchography-one side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33002B",
      "display" : "支氣管造影術－雙側",
      "definition" : "包括內視鏡費用在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bronchography-both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33003B",
      "display" : "選擇性支氣管造影術",
      "definition" : "包括內視鏡費用在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "Selective bronchography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33004B",
      "display" : "食道造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Esophagography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33005B",
      "display" : "乳房造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mammography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33006B",
      "display" : "上消化道攝影(食道、胃、十二指腸)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Upper G-I series"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33007B",
      "display" : "低漲性十二指腸造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hypotonic duodenography"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33008B",
      "display" : "小腸系統",
      "designation" : [
        {
          "language" : "en",
          "value" : "Small bowel series (intestine)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33009B",
      "display" : "上胃腸與小腸系統",
      "designation" : [
        {
          "language" : "en",
          "value" : "Upper G-I and small bowel series"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33010B",
      "display" : "大腸造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lower G-I series (colon)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33011B",
      "display" : "雙重對比大腸造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Double - contrast study of lower G-I series"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33012B",
      "display" : "靜脈注射泌尿系統造影術(點滴注射)",
      "definition" : "包括加解後造影術及快速系列includingpost-voidingandrapidsequenceI.V.P.",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intravenous urography (I.V.P.)(or infusion IVP)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33013B",
      "display" : "逆行性腎盂造影術－單側",
      "definition" : "包括鏡檢費在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "Retrograde pyelography (R.P.)-one side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33014B",
      "display" : "逆行性腎盂造影術－雙側",
      "definition" : "包括鏡檢費在內",
      "designation" : [
        {
          "language" : "en",
          "value" : "Retrograde pyelography (R.P.)-both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33015B",
      "display" : "膀胱造影術",
      "definition" : "人工膀胱造影術比照申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cystography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33016B",
      "display" : "尿道排泄造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Voiding urethrocystography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33017B",
      "display" : "膀胱放置鏈條造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Chain cystography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33018B",
      "display" : "腹膜後充氣造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pneumoretroperitoneum (P.R.P)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33019B",
      "display" : "順行性腎盂造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Antegrade pyelography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33020B",
      "display" : "口服膽囊造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Oral cholecystography (O.C./ O.G.T)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33021B",
      "display" : "靜脈注射膽道、膽囊造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "I.V. choledochocystography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33022B",
      "display" : "插入T型管子膽囊造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "T-tube cholecystography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33023B",
      "display" : "開刀時膽管X光造影法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Operative cholangiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33024B",
      "display" : "逆行性膽道及胰管造影",
      "definition" : "1.含膽道鏡費用在內。2.內含一般材料費及單一使用之拋棄式導引線或雙頭導線及拋棄式內視鏡造影導管費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "E.R.C.P. (Endoscopic retrograde cholangiopancreatography)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33025B",
      "display" : "經皮穿肝膽管造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.T.C. (Percutaneous transhepatic cholangiography)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33026B",
      "display" : "經皮穿肝膽管引流術",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.T.C.D. (Percutaneous transhepatic cholangiography-drainage )"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33027B",
      "display" : "經皮穿肝膽管引流修正術",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.T.C.D. revision"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33028B",
      "display" : "廔管造影術",
      "definition" : "病灶造影術比照申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fistulography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33029B",
      "display" : "子宮輸卵管造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hysterosalpingography (H.S.G)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33030B",
      "display" : "術中胰臟X光造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Operative pancreatography"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33031B",
      "display" : "尿道造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Urethrography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33032B",
      "display" : "皮下穿刺腎造廔術",
      "definition" : "單側",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.C.N. (Percutaneous nephrostomy)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33033B",
      "display" : "內視鏡逆行胰液引流術",
      "definition" : "1.包括鏡檢費在內。2.內含單次使用消化道導引線、導線/導線蓋和鎖比率為百分之七十六。",
      "designation" : [
        {
          "language" : "en",
          "value" : "E.R.P.D. (Endoscopic retrograde pancrea drainage)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33034B",
      "display" : "腦蛛膜下腔注氣造影",
      "definition" : "單純X光攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.E.G./PVG Pneumoence-phalography (Pneumoventriculography)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33035B",
      "display" : "鼻咽道造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Nasopharyngography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33036B",
      "display" : "喉部造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Laryngography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33037B",
      "display" : "唾液腺造影－單側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sialography-one side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33038B",
      "display" : "唾液腺造影－雙側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Sialography-both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33039B",
      "display" : "眼眶靜脈造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Orbitovenography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33040B",
      "display" : "淚囊造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dacryocystography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33041B",
      "display" : "頸動脈造影－單側",
      "definition" : "包括總頸動脈(commoncarotid)、內頸動脈(internalcarotid)或外頸動脈(externacarotid)均比照申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Common carotid artery- one side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33042B",
      "display" : "頸動脈造影－雙側",
      "definition" : "包括總頸動脈(commoncarotid)、內頸動脈(internalcarotid)或外頸動脈(externacarotid)均比照申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Common carotid artery-both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33043B",
      "display" : "椎動靜脈造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Vertebral angiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33044B",
      "display" : "脊椎動靜脈造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Spinal angiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33045B",
      "display" : "主動靜脈造影－胸腔主動靜脈",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aortography-Thoracic aortography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33046B",
      "display" : "內臟血管造影－一條血管",
      "definition" : "肝動脈攝影Hepaticangiography、上腸系膜動脈攝影Superiormesentericarteriography、脾動脈攝影Splenicarteriography、下腸系膜動脈攝影Inferiormesentericarteriography、左胃動脈攝影Leftgastricang-iography比照申報，胃十二指腸動脈攝影Gastroduodenalarteriography、橫膈下動脈攝影Inferiorphrenicarteriograp。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Visceral angiography-one vessel"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33047B",
      "display" : "腎動靜脈造影",
      "definition" : "包括單雙側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Renal angiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33048B",
      "display" : "四肢血管造影",
      "definition" : "不得同時申報33097B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Angiography of extremity"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33049B",
      "display" : "順行性靜脈X光攝影",
      "definition" : "不得同時申報33097B及18047B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Antegrade venography"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33050B",
      "display" : "逆行性靜脈X光攝影",
      "definition" : "不得同時申報33097B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Retrograde venography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33051B",
      "display" : "脾靜脈肝門脈造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Splenoportography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33052B",
      "display" : "輸精管造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Seminovasculography, (SVG)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33053B",
      "display" : "淋巴管造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lymphangiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33054B",
      "display" : "脊髓造影－頸椎",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cervical spine myelography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33055B",
      "display" : "脊髓造影－胸椎",
      "designation" : [
        {
          "language" : "en",
          "value" : "Thoracic spine myelography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33056B",
      "display" : "脊髓造影－腰椎",
      "designation" : [
        {
          "language" : "en",
          "value" : "Lumber spine myelography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33057B",
      "display" : "脊髓造影－頸椎+胸椎或胸椎+腰椎兩段造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Two segmental myelography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33058B",
      "display" : "脊髓造影－全部",
      "designation" : [
        {
          "language" : "en",
          "value" : "Whole spine myelography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33059B",
      "display" : "頸靜脈造影－單側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Jugular venography-one side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33060B",
      "display" : "頸靜脈造影－雙側",
      "designation" : [
        {
          "language" : "en",
          "value" : "Jugular venography-both side"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33061B",
      "display" : "骨盤動脈造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pelvic angiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33062B",
      "display" : "鎖骨下血管造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Subclavian angiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33063B",
      "display" : "關節造影術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Arthrography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33064B",
      "display" : "雙能量X光骨質密度檢查",
      "definition" : "1.適應症如下：(1)內分泌失調可能加速骨質流失者(限副甲狀腺機能過高須接受治療者、腎上腺皮質過高者、腦下垂體機能不全影響鈣代謝者、甲狀腺機能亢進症者、醫源性庫興氏症候群者)。(2)非創傷性之骨折者。(3)停經後婦女及五十歲以上接受骨質疏鬆症追蹤治療(符合全民健康保險藥物給付項目及支付標準第六編第八十三條之藥品給付規定第5節5.6骨質疏鬆症治療藥物)者。(4)攝護腺癌病人在接受男性賀爾蒙阻斷治療前與治療後，得因病情需要施行骨質密度檢查。(5)乳癌病人在接受AromataseInhibitors治療前與治療後，因病情需要施行骨質密度檢查。(6)成骨不全症。2.支付規範：(1)符合前述第(1)至(5)項適應症者，因病情需要再次施行骨質密度檢查時，間隔時間應為二年以上，且是項檢查以三次為限。(2)符合前述第(6)項適應症者，因病情需要再次施行骨質密度檢查時，間隔時間應為一年以上。3.篩檢性檢查不列入本保險給付範圍。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dual-energy X-ray absorptiometry, DXA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33065B",
      "display" : "電子造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Xerography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33066B",
      "display" : "斷層攝影術(每張)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tomography (each)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33070B",
      "display" : "電腦斷層造影－無造影劑",
      "definition" : "申報費用時應檢附報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Computed tomography (C. T.)-without contrast"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33071B",
      "display" : "電腦斷層造影－有造影劑",
      "definition" : "申報費用時應檢附報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Computed tomography (C. T.)-with contrast"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33072B",
      "display" : "電腦斷層造影－有/無造影劑",
      "definition" : "申報費用時應檢附報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Computed tomography (C. T.)- with/without contrast"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33073B",
      "display" : "肺動脈造影",
      "definition" : "支氣管動脈攝影Bronchialangiography，比照申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Pulmonary angiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33074B",
      "display" : "單純性血管整形術",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施。2.本項費用已包括選擇性血管造影(Includingselectiveangiography)。3.施行33074B或33115B「單純性/複雜性血管整形術」原則上應已含括33048B「四肢血管造影」及33062B「鎖骨下血管造影」(不得同時併報)，惟如因病情需要屬不同側時，得分別申報，其他特殊案例，則由專業審查認定。4.血管數計算方式：(1)動脈：A.上肢分為五部分(鎖骨下動脈、腋臂動脈、橈動脈、尺動脈、手部動脈)，每部分算同一條血管。B.下肢分六部分(腸骨動脈、股膕動脈、前脛動脈、後脛動脈、腓腸骨動脈、足部動脈)，每部分算同一條血管。C.動脈同一條血管內多處病灶，仍算同一條血管。D.33074B係指一條動脈血管之治療，33115B係指二條動脈血管(含)以上之治療。(2)靜脈：A.上肢分為二部位(前臂上臂靜脈、鎖骨下及頭臂靜脈)。B.下肢分為二部位(小腿大腿靜脈、腸骨靜脈)。C.33074B係指一部位靜脈血管之治療，33115B係指二部位靜脈血管之治療。(3)血管吻合處同動脈段或靜脈段(如動靜脈瘻管)，仍算同一條血管。(4)若同時執行一條動脈及同一部位靜脈之血管整形術(非血管吻合處同動脈段或靜脈段)，以33115B申報。5.提升兒童加成項目。6.施行本項原則上含括33048B及33062B，相同部位不得同時申報33097B、33133B、33147B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.T.A. (percutaneous transluminal angioplasty): simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33075B",
      "display" : "血管阻塞術",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施2.包括選擇性血管造影、診斷性血管造影及當日血管阻塞術後追蹤造影。3.不得同時申報33097B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T.A.E.(trans-arterial embolization)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33076B",
      "display" : "經皮冠狀動脈擴張術－一條血管",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施。2.包括選擇性血管造影(Includingselectiveangiography)。3.包括材料費。4.適應症如下：(1)心絞痛或其他冠狀動脈心臟病症狀經藥物治療後效果不佳者(2)血管狹窄70%(含)以上者(3)狹窄部份為血管近端、左前降枝、左迴旋枝或右冠狀動脈(4)左冠狀動脈主幹狹窄50%(含)以上者(5)血管經PCI後Restenosis50%(含)以上者。5.同次住院施行經皮冠狀動脈擴張術且同時或分段做「診斷性心導管檢查」者，以申報經皮冠狀動脈擴張術及一次心導管(18020B或18021B)為原則，惟病人因顯影劑或X光輻射用量限制、急性血栓或遲發性併發症等原因需執行二次以上，第二次起應於病歷詳細敘明執行原因。6.本項目所訂點數包含冠狀動脈造影(18022B)及冠狀動脈血管內超音波(18043B)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous coronary dilatation-one vessel"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33077B",
      "display" : "經皮冠狀動脈擴張術－二條血管",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施。2.包括選擇性血管造影(Includingselectiveangiography)。3.包括材料費。4.適應症如下：(1)心絞痛或其他冠狀動脈心臟病症狀經藥物治療後效果不佳者(2)血管狹窄70%(含)以上者(3)狹窄部份為血管近端、左前降枝、左迴旋枝或右冠狀動脈(4)左冠狀動脈主幹狹窄50%(含)以上者(5)血管經PCI後Restenosis50%(含)以上者。5.同次住院施行經皮冠狀動脈擴張術且同時或分段做「診斷性心導管檢查」者，以申報經皮冠狀動脈擴張術及一次心導管(18020B或18021B)為原則，惟病人因顯影劑或X光輻射用量限制、急性血栓或遲發性併發症等原因需執行二次以上，第二次起應於病歷詳細敘明執行原因。6.本項目所訂點數包含冠狀動脈造影(18022B)及冠狀動脈血管內超音波(18043B)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous coronary dilatation-two vessels"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33078B",
      "display" : "經皮冠狀動脈擴張術－三條血管",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施。2.包括選擇性血管造影(Includingselectiveangiography)。3.包括材料費。4.適應症如下：(1)心絞痛或其他冠狀動脈心臟病症狀經藥物治療後效果不佳者(2)血管狹窄70%(含)以上者(3)狹窄部份為血管近端、左前降枝、左迴旋枝或右冠狀動脈(4)左冠狀動脈主幹狹窄50%(含)以上者(5)血管經PCI後Restenosis50%(含)以上者。5.同次住院施行經皮冠狀動脈擴張術且同時或分段做「診斷性心導管檢查」者，以申報經皮冠狀動脈擴張術及一次心導管(18020B或18021B)為原則，惟病人因顯影劑或X光輻射用量限制、急性血栓或遲發性併發症等原因需執行二次以上，第二次起應於病歷詳細敘明執行原因。6.本項目所訂點數包含冠狀動脈造影(18022B)及冠狀動脈血管內超音波(18043B)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous coronary dilatation-three vessels"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33079B",
      "display" : "主動脈氣球裝置術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intra aorta balloon insertion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33081B",
      "display" : "食道狹窄氣球擴張術",
      "definition" : "1.提升兒童加成項目。2.本項102年支付標準調整按衛生福利部1031260015號函公告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Esophageal balloon dilatation"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33082B",
      "display" : "小腸系列對比劑檢查",
      "designation" : [
        {
          "language" : "en",
          "value" : "Double contrast small bowel series ( enteroclysis, S.B enema )"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33083B",
      "display" : "經皮穿肝膽道取石攝影術",
      "definition" : "經T-tube取石比照申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "PTCD-stone removal"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33084B",
      "display" : "磁振造影－無造影劑",
      "definition" : "1.本項須限經保險人同意之醫療院所實施。2.申報費用時必須附上報告結果。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Magnetic resonance imaging-without contrast"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33085B",
      "display" : "磁振造影－有造影劑",
      "definition" : "1.本項須限經保險人同意之醫療院所實施。2.申報費用時必須附上報告結果。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Magnetic resonance imaging-with contrast"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33086B",
      "display" : "主動靜脈造影－腹腔主動靜脈",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aortography-Abdominal aortography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33087B",
      "display" : "主動靜脈造影─兩項同時實施時以此項申報",
      "designation" : [
        {
          "language" : "en",
          "value" : "Aortography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33088B",
      "display" : "內臟血管造影－二條血管",
      "definition" : "肝動脈攝影Hepaticangiography、上腸系膜動脈攝影Superiormesentericarteriography、脾動脈攝影Splenicarteriography、下腸系膜動脈攝影Inferiormesentericarteriography、左胃動脈攝影Leftgastricang-iography比照申報，胃十二指腸動脈攝影Gastroduodenalarteriography、橫膈下動脈攝影Inferiorphrenicarteriograp。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Visceral angiography-two vessels"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33089B",
      "display" : "內臟血管造影－三條血管以上",
      "definition" : "肝動脈攝影Hepaticangiography、上腸系膜動脈攝影Superiormesentericarteriography、脾動脈攝影Splenicarteriography、下腸系膜動脈攝影Inferiormesentericarteriography、左胃動脈攝影Leftgastricang-iography比照申報，胃十二指腸動脈攝影Gastroduodenalarteriography、橫膈下動脈攝影Inferiorphrenicarteriograp。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Visceral angiography-over two vessels"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33090B",
      "display" : "使用低滲透壓或非離子性含碘對比劑",
      "definition" : "1.本項適用於電腦斷層造影及血管造影2.本項不得加計加成。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33091B",
      "display" : "不整脈經導管燒灼術－2-D定位",
      "definition" : "1.施行本項之醫院及醫師資格如下：(1)醫院資格：Ａ須具有心臟外科醫師支援之醫院。Ｂ須具備完善之心導管透視機、電生理檢查紀錄儀、電生理刺激器、高頻幅釋出機、心臟去顫器等。(2)醫師資格：具中華民國心臟學會專科醫師，曾接受一年完整之臨床電生理及不整脈經導管燒灼術之訓練，且至少完成五十例以上不整脈經導管燒灼術之經驗，其完成之病例數須經中華民國心臟學會審核認定。(3)醫院及主持醫師資格有變更時應重新報保險人核備。2.施行本項之適應症如下：(1)2-D立體定位：經心電圖及心臟電氣生理檢查經證實為室上頻脈(supraventriculartachycardia)。(2)複雜3-D立體定位：複雜性不整脈包括心房頻脈、「非」典型性心房撲動、心房顫動、心室不整脈等。3.本項目所訂點數包含心導管置入及造影、冠狀動脈及冠狀竇造影、燒灼前後完整之電氣生理檢查、心律不整燒灼定位、心律不整燒灼、血壓及心電圖監視、一般材料費等費用。4.醫院申請醫療費用時應一併檢附心臟電氣生理檢查證實為室上頻脈且確實施行本處置之相關資料。5.若術後三十天(含)內復發並再次使用者，按所訂支付點數之一半支付。6.提升兒童加成項目。3.本項102年支付標準調整按衛生福利部1031260015號函公告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcatheter Radiofrequency Ablation for Arrhythmia－2D Mapping"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33092B",
      "display" : "腸套疊透視灌腸復位",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fluoroscopic reduction of intussusception"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33093B",
      "display" : "雙側腎靜脈血液抽取術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bilateral reno-venous sampling"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33095B",
      "display" : "經皮腎造廔引流管重置術(重置經皮腎造廔引流管)",
      "definition" : "PCN特材請依實際使用核實申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Revision of percutaneous nephrostomy tube(Pigtail)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33096B",
      "display" : "螢光透視吞嚥錄影攝影檢查",
      "definition" : "申報費用時應檢附檢查報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Swallowing video fluorography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33097B",
      "display" : "數位減像血管攝影(靜脈)",
      "definition" : "1.適應症：(1)肝靜脈壓力梯度測量(HVPG)。(2)直接肝門靜脈攝影。(3)軀幹深層動靜脈畸形。(4)腎靜脈、卵巢靜脈病變診斷。2.一年至多申報二次，若有特殊情況需增加執行次數，應於病歷記載適應症並檢附相關資料佐證。3.同一部位已做導管介入治療者，不得申報本項。4.不得同時申報33048B、33049B、33050B、33074B、33115B、33075B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "IV-DSA"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33098B",
      "display" : "氙氣電腦斷層腦血流測定",
      "definition" : "1.適應症：(1)可能產生腦缺血之病變，例如腦血管狹窄、腦缺血、毛毛樣病，腦動靜脈畸形，腦血管孿縮等(2)正壓水腦症、部分失智症。2.不可重覆申報26049Ｂ核子斷層檢查術SPECT之腦血流測定。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Xenon CT for cerebral blood flow measurement"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33099B",
      "display" : "經皮輸尿管內管置放術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous placement of ureter stent"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33100B",
      "display" : "經皮穿肝脾門脈攝影及靜脈血抽檢",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous splenoportal venography and venous sampling"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33101B",
      "display" : "性腺靜脈攝影(單側)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gonadal venography, unilateral"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33102B",
      "display" : "性腺靜脈攝影(兩側)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Gonadal venography, bilateral"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33103B",
      "display" : "電腦斷層導引下組織切片,取樣剛針",
      "definition" : "1.須檢附報告2.該次不得再申報一次同部位CT費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "CT Guide biopsy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33104B",
      "display" : "肺靜脈造影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Direct pulmonary venography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33105B",
      "display" : "腸胃道出血栓塞治療",
      "definition" : "包括選擇性血管造影術、血管阻塞術、器材材料費及局部麻醉費，同時不可加報其他血管攝影費用。",
      "designation" : [
        {
          "language" : "en",
          "value" : "G-I Bleeding embolisation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33106B",
      "display" : "經皮穿刺膽囊引流術",
      "definition" : "施行過程中使用之超音波或透視X光不得另行申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous gall bladder drainage"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33107B",
      "display" : "經皮內視鏡胃造瘻管替換術",
      "definition" : "1.提升兒童加成項目。2.本項102年支付標準調整按衛生福利部1031260015號函公告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Replacement of percutaneous endoscopic gastrostomy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33108B",
      "display" : "經皮內視鏡胃造瘻術",
      "definition" : "1.限腦血管意外或車禍之植物人，須長年使用鼻胃管者。2.其他病變導致病患須長年使用鼻胃管者。3.本案不須事前專案申請，但申報費用時請附事前審查申報書及病歷摘要。4.提升兒童加成項目。5.本項102年支付標準調整按衛生福利部1031260015號函公告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.E.G(percutaneous endoscopic gastrostomy)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33110B",
      "display" : "放射線下經皮穿刺輸尿管成形術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous ureteroplasty"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33111B",
      "display" : "放射線下經皮穿刺取出斷裂輸尿管內管",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous retrieval of ureteral stent"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33112B",
      "display" : "經由心導管治療直徑小於2.0mm之開放性動脈導管",
      "definition" : "1.施行本項之醫院及醫師資格如下：(1)醫院資格：A具臨床心臟外科設備。B具心臟內、外科醫師人力。(2)醫師資格：具中華民國小兒心臟科專科醫師資格，且接受至少二年心導管經驗。(3)須報經保險人同意後實施，且醫院及主持醫師資格有變更時應重新報保險人同意。2.適應症：限開放性動脈導管之直徑小於2.0mm，無合併主動脈縮窄及肺高血壓症者。3.禁忌症：(1)合併不可逆之肺高血壓。(2)早產兒體重低於七百公克。(3)同時合併全身性感染者。4.提升兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcatheter closure of patent ductus arteriosus <2.0mm"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33113B",
      "display" : "經頸靜脈肝內門脈系統靜脈分流術",
      "definition" : "1.施行本項之醫院及醫師資格如下：(1)具放射線專科醫師且實際從事介入性放射線治療之主治醫師以上資格。(2)施行醫師應接受二年以上肝膽系統之血管攝影及血管系統之介入性放射線醫療訓練。(3)須報經保險人同意後實施，且醫院及主持醫師資格有變更時應重新報保險人核備。2.施行本項之適應症如下，並應由醫院申報事前審查：(1)經內視鏡或內科治療無法控制之急性或再發之胃、食道靜脈曲張出血。(2)經積極內科治療無改善之肝硬化合併大量腹水導致併發腎衰竭或電解質不平衡等。(3)Budd-chiarsyndrome。3.RTPS/RUPS組另計。4.本項治療屬於替代性或選擇性之第二線治療方式。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transjugular intrahepatic portosystemic shunt"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33114B",
      "display" : "經由心導管治療直徑2.0mm以上之開放性動脈導管",
      "definition" : "1.施行本項之醫院及醫師資格如下：(1)醫院資格：A具臨床心臟外科設備。B具心臟內、外科醫師人力。(2)醫師資格：具中華民國小兒心臟科專科醫師資格，且接受至少二年心導管經驗。(3)須報經保險人同意後實施，且醫院及主持醫師資格有變更時應重新報保險人同意。2.適應症：限開放性動脈導管之直徑2.0mm以上，無合併主動脈縮窄及肺高血壓症者。3.禁忌症：(1)嚴重肺高血壓導致右至左分流。(2)早產兒體重低於七百公克。(3)同時合併全身性感染者。4.提升兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcatheter closure of patent ductus arteriosus≧2.0mm"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33115B",
      "display" : "複雜性血管整形術",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施。2.本項費用已包括選擇性血管造影(Includingselectiveangiography)。3.施行33074B或33115B「單純性/複雜性血管整形術」原則上應已含括33048B「四肢血管造影」及33062B「鎖骨下血管造影」(不得同時併報)，惟如因病情需要屬不同側時，得分別申報，其他特殊案例，則由專業審查認定。4.血管數計算方式：(1)動脈：A.上肢分為五部分(鎖骨下動脈、腋臂動脈、橈動脈、尺動脈、手部動脈)，每部分算同一條血管。B.下肢分六部分(腸骨動脈、股膕動脈、前脛動脈、後脛動脈、腓腸骨動脈、足部動脈)，每部分算同一條血管。C.動脈同一條血管內多處病灶，仍算同一條血管。D.33074B係指一條動脈血管之治療，33115B係指二條動脈血管(含)以上之治療。(2)靜脈：A.上肢分為二部位(前臂上臂靜脈、鎖骨下及頭臂靜脈)。B.下肢分為二部位(小腿大腿靜脈、腸骨靜脈)。C.33074B係指一部位靜脈血管之治療，33115B係指二部位靜脈血管之治療。(3)血管吻合處同動脈段或靜脈段(如動靜脈瘻管)，仍算同一條血管。(4)若同時執行一條動脈及同一部位靜脈之血管整形術(非血管吻合處同動脈段或靜脈段)，以33115B申報。5.提升兒童加成項目。6.施行本項原則上含括33048B及33062B，相同部位不得同時申報33097B、33133B、33147B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "P.T.A. (percutaneous transluminal angioplasty): complex"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33116B",
      "display" : "經導管心室中膈缺損修補",
      "definition" : "1.適應症：心室中膈缺損病人(含心肌梗塞後)2.內含一般材料費及圈套器取回套組(Snare)費比率為百分之四十。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcatheter Closure of Ventricular Septal Defect"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33117B",
      "display" : "冠狀動脈旋磨斑塊切除術",
      "definition" : "1.適應症需符合下列條件之一：(1)因嚴重鈣化造成非順應性球囊擴張不良，可能導致支架置放無法良好張開和貼壁。(2)用於冠狀動脈介入治療中，當導引導絲通過病灶後，但球囊或其它導管醫材仍無法通過病灶。(3)用於冠狀動脈介入治療中，面對分叉病變，因開口嚴重鈣化，球囊擴張或是支架置放後，可能造成分支阻塞。2.執行頻率：每人每次住院限申報一次。3.醫師資格：(1)心臟內科、心臟外科醫師。(2)執行冠狀動脈成形術一百五十例以上臨床經驗，且曾任冠狀動脈旋轉研磨鑽用於經皮下冠狀動脈血管擴張術之第一助手訓練，及參與實際操作至少十例以上之臨床經驗。(3)完成中華民國心臟學會、臺灣介入性心臟血管醫學會辦理之冠狀動脈旋磨訓練課程，持有證明文件。(4)執行本項之醫師條件應向保險人申請同意。4.申報時應檢附資料：(1)本次經皮冠狀動脈擴張術前病灶之清晰影像照片。(2)本次冠狀動脈擴張術中使用與血管直徑比值一比一之氣球嘗試擴張後仍無法擴張之病灶影像照片。(3)旋磨切除術前後，植入支架前後之血管腔內影像照片。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Coronary artery rotational artherectomy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33125C",
      "display" : "乳房攝影立體定位組織切片術",
      "definition" : "含乳房攝影。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Mammography sterotactic biopsy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33126B",
      "display" : "經皮椎體成形術(第一節)",
      "definition" : "1.病人因病情需要，取部分組織進行化驗，得併報29032B、29033B或33103B，並於病歷敘明理由。2.不得同時申報64144B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous vertebroplasty (1st vertebra)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33127B",
      "display" : "經皮椎體成形術(第二節以上，每一節)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous vertebroplasty (any vertebra after the first)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33128B",
      "display" : "頭頸部血管支撐架置放術(一條血管)",
      "definition" : "特材另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stenting for head & neck vessel (one vessel)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33129B",
      "display" : "Amplatzer心房中膈缺損關閉器治療中膈缺損",
      "definition" : "提升兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Amplatzer septal occluder (ASO)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33130B",
      "display" : "經皮穿腔靜脈過濾裝置置放術",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous transluminal deployment of veinous device"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33131B",
      "display" : "經皮導管血管內\\心臟內異物移除術(適用於留置異物處血管大小直徑為>7mm者)",
      "definition" : "1.因遺失或移位而造成之血管內或心臟內異物。2.各種材質之診斷性或治療性器械，導管或導絲因斷落、掉落或移位而留置於血管或心臟內所形成之異物，需移除或取出至體外者。由於各類夾取器之實際選擇尚得考量待取出異物之大小、長度、材質及材料硬度，本項目使用時機原則如下：適合使用於留置異物處血管大小直徑為>7mm之異物夾取器(如standard、6-7Fr.等型號)。3.提升兒童加成項目。4.含一般材料費及單一使用拋棄式之心臟血管異物取出器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous transluminal catheter retrieval of vascular/intracardiac foreign body (For the vessel diameter where the foreign body stands > 7 mm)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33132B",
      "display" : "氣管支架置放術",
      "definition" : "含麻醉費，特材費另計。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33133B",
      "display" : "單純性周邊血管支架置放術",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施。2.本項費用已包括選擇性血管造影(Includingselectiveangiography)、診斷性血管造影及當日術後追蹤造影。3.如因病情需要屬不同側時，或屬同側之特殊案例，得分別申報，須於病歷註明原因，由專業審查認定。4.血管數計算方式：(1)動脈：A.上肢分為四部分(鎖骨下動脈、腋臂動脈、橈動脈、尺動脈)，每部分算同一條血管。B.下肢分六部分(腸骨動脈、股膕動脈、前脛動脈、後脛動脈、腓腸骨動脈、足部動脈)，每部分算同一條血管。C.動脈同一條血管內多處病灶，仍算同一條血管。D.33133B係指一條動脈血管之治療，33147B係指二條動脈血管以上之治療。(2)靜脈：A.上肢分為三部位(上腔靜脈、鎖骨下靜脈、頭臂靜脈)。B.下肢分為三部位(大腿靜脈、腸骨靜脈、下腔靜脈)。C.33133B係指一條靜脈血管之治療，33147B係指二條靜脈血管以上之治療。(3)排除洗腎瘻管。(4)若同時執行一條動脈及同一部位靜脈之血管支架置放術(非血管吻合處同動脈段或靜脈段)，以「複雜性周邊血管支架置放術」申報。5.施行本項原則上含括33048B及33062B，相同部位不得同時申報33097B、33074B、33115B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stenting for peripheral vessels, artery and vein：simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33135B",
      "display" : "經皮導管血管內\\心臟內異物移除術(適用於留置異物處血管大小直徑為≤7mm者)",
      "definition" : "1.因遺失或移位而造成之血管內或心臟內異物。2各種材質之診斷性或治療性器械，導管或導絲因斷落、掉落或移位而留置於血管或心臟內所形成之異物，需移除或取出至體外者。由於各類夾取器之實際選擇尚得考量待取出異物之大小、長度、材質及材料硬度，本項目使用時機原則如下：適合使用於留置異物處血管大小直徑為≤7mm之異物夾取器(如mini、micro、3Fr.等型號)。3.提升兒童加成項目。4.含一般材料費及單一使用拋棄式之心臟血管異物取出器。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous transluminal catheter retrieval of vascular/intracardiac foreign body (For the vessel diameter where the foreign body stands ≤ 7 mm)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33139B",
      "display" : "不整脈經導管燒灼術複雜3-D立體定位-單腔",
      "definition" : "1.施行本項之醫院及醫師資格如下：(1)醫院資格：Ａ須具有心臟外科醫師支援之醫院。Ｂ須具備完善之心導管透視機、電生理檢查紀錄儀、電生理刺激器、高頻幅釋出機、心臟去顫器等。(2)醫師資格：具中華民國心臟學會專科醫師，曾接受一年完整之臨床電生理及不整脈經導管燒灼術之訓練，且至少完成五十例以上不整脈經導管燒灼術之經驗，其完成之病例數須經中華民國心臟學會審核認定。(3)醫院及主持醫師資格有變更時應重新報保險人核備。2.施行本項之適應症如下：(1)2-D立體定位：經心電圖及心臟電氣生理檢查經證實為室上頻脈(supraventriculartachycardia)。(2)複雜3-D立體定位：複雜性不整脈包括心房頻脈、「非」典型性心房撲動、心房顫動、心室不整脈等。3.本項目所訂點數包含心導管置入及造影、冠狀動脈及冠狀竇造影、燒灼前後完整之電氣生理檢查、心律不整燒灼定位、心律不整燒灼、血壓及心電圖監視、一般材料費等費用。4.醫院申請醫療費用時應一併檢附心臟電氣生理檢查證實為室上頻脈且確實施行本處置之相關資料。5.若術後三十天(含)內復發並再次使用者，按所訂支付點數之一半支付。6.提升兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcatheter Radiofrequency Ablation for Arrhythmia 3D Mapping-Single Chamber"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33140B",
      "display" : "不整脈經導管燒灼術複雜3-D立體定位-雙腔",
      "definition" : "1.施行本項之醫院及醫師資格如下：(1)醫院資格：Ａ須具有心臟外科醫師支援之醫院。Ｂ須具備完善之心導管透視機、電生理檢查紀錄儀、電生理刺激器、高頻幅釋出機、心臟去顫器等。(2)醫師資格：具中華民國心臟學會專科醫師，曾接受一年完整之臨床電生理及不整脈經導管燒灼術之訓練，且至少完成五十例以上不整脈經導管燒灼術之經驗，其完成之病例數須經中華民國心臟學會審核認定。(3)醫院及主持醫師資格有變更時應重新報保險人核備。2.施行本項之適應症如下：(1)2-D立體定位：經心電圖及心臟電氣生理檢查經證實為室上頻脈(supraventriculartachycardia)。(2)複雜3-D立體定位：複雜性不整脈包括心房頻脈、「非」典型性心房撲動、心房顫動、心室不整脈等。3.本項目所訂點數包含心導管置入及造影、冠狀動脈及冠狀竇造影、燒灼前後完整之電氣生理檢查、心律不整燒灼定位、心律不整燒灼、血壓及心電圖監視、一般材料費等費用。4.醫院申請醫療費用時應一併檢附心臟電氣生理檢查證實為室上頻脈且確實施行本處置之相關資料。5.若術後三十天(含)內復發並再次使用者，按所訂支付點數之一半支付。6.提升兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcatheter Radiofrequency Ablation for Arrhythmia 3D Mapping-Double Chamber"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33141B",
      "display" : "左心耳閉合術",
      "definition" : "1.適應症：非瓣膜性心房顫動且臨床危險因子符合應使用抗凝血劑治療，同時有下列二者之一：(1)無法長期使用抗凝血劑治療。(2)使用抗凝血劑治療下仍有全身性栓塞症。2.醫師條件：(1)須具心臟專科醫師資格。(2)須具心房中膈穿刺經驗十五例以上。(3)須有國內、外專家指導下親自操作經驗五例以上。3.醫院條件：需有心導管室設備同時具有心臟內科訓練機構資格及專任心臟外科專科醫師即時支援。4.禁忌症：(1)心臟超音波影像(echocardiographicimaging)發現心腔內血栓。(2)左心耳(LAA)解剖構造不適合。5.不得同時申報之診療項目及編號：29031B「心房中膈穿刺術」、18033B「經食道超音波心圖T.E.E」及18026B「心室造影」。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Left Atrial Appendage occusion"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33142B",
      "display" : "膠囊內視鏡術",
      "definition" : "1.適應症:(1)不明原因消化道出血，經二次以上胃鏡及大腸內視鏡檢查仍無法找出出血原因，且經其他影像學檢查(如:CT/MRI，小腸攝影)及小腸內視鏡後或不適合小腸鏡者，仍無法確診者。(2)慢性或長期小腸病變患者(如小腸多發性息肉症，克隆氏症，celiacsprue，Behcet’sdisease，Henoch-Schonleinpurpura)不適合小腸鏡者需以內視鏡診斷或追蹤者。(3)兒童未滿十八歲，不明原因消化道出血者，經一次內視鏡及一次大腸內視鏡檢查仍無法找出出血原因，且經其他影像學檢查(如CT/MRI或血管攝影或核子醫學或小腸攝影)仍無法確診者。(4)兒童未滿十八歲，慢性或長期小腸病變患者(如小腸多發性息肉症，克隆氏症，celiacsprue，Behcet’sdisease，Henoch-Schonleinpurpura)。2.特殊專科別限制:消化內視鏡專科、兒科消化學專科、消化內視鏡外科。3.特殊材料費另計。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33143B",
      "display" : "急性缺血性腦中風機械取栓術",
      "definition" : "1.適應症：急性腦血管缺血性中風病人符合顱內血管支架取栓裝置使用條件，並使用該裝置進行機械性血管內血栓移除術治療，且同時符合下列條件：(1)發作後二十四小時內。(2)影像診斷為顱內大動脈阻塞，包括內頸動脈、大腦中動脈的第一及第二段、大腦前動脈、基底動脈和脊椎動脈。(3)美國國衛院腦中風評估表(NIHStrokeScale)評分≧6及≦30。2.禁忌症：(1)蜘蛛網膜下腔出血(2)腦內出血(3)硬腦膜下出血/顱內出血3.支付規範：(1)限接受並通過下列任一學會之相關腦神經血管內介入治療專長訓練與認證之醫師施行：A.中華民國放射線醫學會授權之中華民國神經放射線醫學會B.台灣神經外科醫學會授權之台灣神經血管外科與介入治療醫學會C.台灣神經學會授權之台灣腦中風學會(2)不得同時申報69001B、69002B、69003B。4.前循環若於發作後八小時至二十四小時執行，申報時須於病歷檢附影像報告(CTP、MR或CTAcollaterals)備查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Fee for neurovascular mechanical endovascular thrombectomy in acute ischemic stroke"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33144B",
      "display" : "血管阻塞術-Lipiodol",
      "definition" : "1.適應症：(1)HCCconventionalTACE。(2)HypervasculartumorTAE。(3)Glueembolizationforbleeding。(4)AVM/AVFembolization。2.含一般材料費及Lipiodol。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T.A.E.(trans-arterial embolization) -Lipiodol"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33145B",
      "display" : "診斷性乳房攝影",
      "definition" : "1.適應症：乳房攝影報告(BIRADS)為0、3、4、5，同時符合下列情形之一者：(1)乳房診斷性影像發現乳房攝影微鈣化／鈣化。(2)乳房攝影影像發現不對稱、結構扭曲及腫塊。2.限放射診斷科專科醫師執行。3.執行頻率：每人每年限執行二次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Diagnostic Mammography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "33146B",
      "display" : "磁振造影使用Primovist造影劑加計",
      "definition" : "1.適應症須符合下列任一條件：(1)肝癌高危險病人(含肝癌根除性治療後)合併AFP>100ng/ml，或AFP>20ng/ml且一年內呈現二倍以上上升趨勢，或PIVKA-II(>40mAU/mL)腫瘤標記上升，惟超音波、電腦斷層未偵測到肝癌。(2)肝硬化或肝癌經治療後病人，電腦斷層顯示疑似肝腫瘤，但無法確診或排除肝癌。2.每年以申報一次為限。3.本項適用於磁振造影。4.本項不適用其他加成。5.限放射診斷專科醫師執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Primovist for magnetic resonance imaging – additional payment"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "33147B",
      "display" : "複雜性周邊血管支架置放術",
      "definition" : "1.應有血管造影設備並報經保險人同意後實施。2.本項費用已包括選擇性血管造影(Includingselectiveangiography)、診斷性血管造影及當日術後追蹤造影。3.如因病情需要屬不同側時，或屬同側之特殊案例，得分別申報，須於病歷註明原因，由專業審查認定。4.血管數計算方式：(1)動脈：A.上肢分為四部分(鎖骨下動脈、腋臂動脈、橈動脈、尺動脈)，每部分算同一條血管。B.下肢分六部分(腸骨動脈、股膕動脈、前脛動脈、後脛動脈、腓腸骨動脈、足部動脈)，每部分算同一條血管。C.動脈同一條血管內多處病灶，仍算同一條血管。D.33133B係指一條動脈血管之治療，33147B係指二條動脈血管以上之治療。(2)靜脈：A.上肢分為三部位(上腔靜脈、鎖骨下靜脈、頭臂靜脈)。B.下肢分為三部位(大腿靜脈、腸骨靜脈、下腔靜脈)。C.33133B係指一條靜脈血管之治療，33147B係指二條靜脈血管以上之治療。(3)排除洗腎瘻管。(4)若同時執行一條動脈及同一部位靜脈之血管支架置放術(非血管吻合處同動脈段或靜脈段)，以「複雜性周邊血管支架置放術」申報。5.施行本項原則上含括33048B及33062B，相同部位不得同時申報33097B、33074B、33115B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stenting for peripheral vessels, artery and vein：complex"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-11-29"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "34001C",
      "display" : "根尖周X光攝影",
      "definition" : "同一月份費用已內含X光片的支付項目，不得另外重覆申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Periapical radiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "34002C",
      "display" : "咬翼式X光攝影",
      "definition" : "同一月份費用已內含X光片費用，不得重複申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Bite-Wing radiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "34003C",
      "display" : "咬合片X光攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occlusal radiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "34004C",
      "display" : "齒顎全景X光片攝影",
      "definition" : "1.每人限給付一張(含跨院所)，特殊傷病狀況不在此限。2.病歷應詳載符合特殊狀況之拍攝理由。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Panoramic radiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "34005B",
      "display" : "測顱X光攝影",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cephalometric radiography"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "34006B",
      "display" : "顳顎關節X光攝影(單側)",
      "definition" : "包括開口及閉口相。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T.M.J. radiography, unilateral"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "35",
      "display" : "子宮頸抹片採樣(助產所)",
      "definition" : "三十歲以上婦女每年一次※國民健署運用菸品健康福利捐經費補助",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "36001B",
      "display" : "電腦治療規劃--簡單",
      "definition" : "指使用電腦軟體計算放射治療劑量之給予，劑量之驗証等規劃。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Computerized treatment planning—simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36002B",
      "display" : "驗証片(每張)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Verification film(each)"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "36004B",
      "display" : "放射照野片一張",
      "designation" : [
        {
          "language" : "en",
          "value" : "Portal film"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36005B",
      "display" : "放射照野片二張",
      "designation" : [
        {
          "language" : "en",
          "value" : "Portal film"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36006B",
      "display" : "鈷六十遠隔治療—每一簡單照野",
      "definition" : "治療照野為規則形狀，沒有使用合金模塊，多葉式準直儀，楔形濾板，補償濾片及填充物等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cobalt 60 teletherapy—each portal,simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36009B",
      "display" : "鈷六十遠隔照射治療—每一複雜照野",
      "definition" : "治療照野為不規則形狀，有使用合金模塊，多葉式準直儀，楔形濾板，補償濾片及填充物等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cobalt 60 teletherapy, each portal , complicated"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36010B",
      "display" : "鈷六十遠隔照射治療，每一緊急照野",
      "designation" : [
        {
          "language" : "en",
          "value" : "Emergent cobalt 60 teletherapy, each portal"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36011B",
      "display" : "直線加速器遠隔照射治療，每一簡單照野",
      "definition" : "1.以光子photon或電子electron。2.治療照野為規則形狀，沒有使用合金模塊，多葉式準直儀，楔形濾板，補償濾片及填充物等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Linear accelerator teletherapy, each simple portal"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36012B",
      "display" : "直線加速器遠隔照射治療，每一複雜照野",
      "definition" : "1.以光子photon或電子electron。2.治療照野為不規則形狀，有使用合金模塊，多葉式準直儀，楔形濾板，補償濾片及填充物等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Linear accelerator teletherapy, each complex portal"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36013B",
      "display" : "直線加速器遠隔照射治療，每一緊急照野",
      "definition" : "1.以光子photon或電子electron。2.治療照野為不規則形狀，有使用合金模塊，多葉式準直儀，楔形濾板，補償濾片及填充物等。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Emergent linear accelerator teletherapy, each portal"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "36014B",
      "display" : "全身放射線治療(一療程)",
      "definition" : "1.限骨髓移植病人2.申報費用須檢附報告3.療程需包括36001Ｂ、36015B電腦治療規劃及36019B劑量計算；36004Ｂ、36005Ｂ放野照射片；37013Ｂ合金模塊之設計及製作。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Total body irradiation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36015B",
      "display" : "電腦治療規劃--複雜",
      "definition" : "1.指使用三度空間電腦軟體做放射治療之設計，包括順形放射治療、強度調控放射治療、立體定位放射治療等技術，以至近接治療之規劃等。2.需附治療計畫。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cumputerized treatment planning—complex"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36016B",
      "display" : "血品放射線處理",
      "definition" : "限下列情況使用：1.胎兒子宮內輸血、新生兒輸血或換血、早產而輸血2.免疫力效能不足、受損、減弱者3.骨髓或周邊血液細胞移植者及其它器官移植者4.血緣關係之親屬捐血5.其他可能因輸血而引起之移植物對抗宿主疾病者(GVHD)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Blood products irradiation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36017B",
      "display" : "血品急診放射線處理",
      "definition" : "限下列情況使用:1.胎兒子宮內輸血、新生兒輸血或換血、早產而輸血。2.免疫力效能不足、受損、減弱者。3.骨髓或周邊血液細胞移植者及其他器官移植者。4.血緣關係之親屬捐血。5.其他可能因輸血而引起之移植物對抗宿主疾病者(GVHD)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Emergency blood products irradiation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36018B",
      "display" : "模擬定位攝影",
      "definition" : "不得同時申報36002B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Simulation procedure"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36019B",
      "display" : "劑量計算",
      "definition" : "每週最多一次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Dosimetry"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36020B",
      "display" : "直線加速器半體放射治療",
      "designation" : [
        {
          "language" : "en",
          "value" : "Linear accelator hemi-body irradiation"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "36021C",
      "display" : "3D電腦斷層模擬攝影",
      "definition" : "1.適應症:放射治療前所實施之必要檢查及治療設計。2.含電腦斷層攝影費用。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36022B",
      "display" : "乳癌術後低分次全乳照射合併局部加強照射放射治療",
      "definition" : "1.適應症：早期乳癌或原位癌接受乳房腫瘤局部切除(+/-前哨或腋下淋巴結清除)後加上術後放射線治療，治療範圍包含全乳房(不包含鎖骨上淋巴結、腋下淋巴結或內乳淋巴結)。2.禁忌症：(1)淋巴結轉移。(2)遠端轉移。(3)與化學治療同步進行。(4)少見之病理形態，如：metaplasticcarcinoma、squamouscellcarcinoma、sarcomaoradenoidcysticcarcinoma。3.本療程採包裹給付，如未執行完全療程，依療程次數二十次，按等比例核扣點數。4.不得同時申報項目：33090B、36001B、36002B、36004B、36005B、36011B、36012B、36013B、36015B、36018B、36019B、36020B、36021C、37006B、37013B、37014B、37015B、37016B、37030B、37046B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hypofractionated whole breast irradiation with tumor bed boost"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36023B",
      "display" : "乳癌術後低分次全乳照射無合併局部加強照射放射治療",
      "definition" : "1.適應症：早期乳癌或原位癌接受乳房腫瘤局部切除(+/-前哨或腋下淋巴結清除)後加上術後放射線治療，治療範圍包含全乳房(不包含鎖骨上淋巴結、腋下淋巴結或內乳淋巴結)。2.禁忌症：(1)淋巴結轉移。(2)遠端轉移。(3)與化學治療同步進行。(4)少見之病理形態，如：metaplasticcarcinoma、squamouscellcarcinoma、sarcomaoradenoidcysticcarcinoma。3.本療程採包裹給付，如未執行完全療程，依療程次數十六次，按等比例核扣點數。4.不得同時申報項目：33090B、36001B、36002B、36004B、36005B、36011B、36012B、36013B、36015B、36018B、36019B、36020B、36021C、37006B、37013B、37014B、37015B、37016B、37030B、37046B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hypofractionated whole breast irradiation without tumor bed boost"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "36024B",
      "display" : "直腸癌術前低分次放射治療",
      "definition" : "1.適應症：(1)AJCC臨床分期大於等於T3、骨盆腔淋巴結陽性(N+)之直腸惡性腫瘤(C20)或直腸乙狀結腸連接處惡性腫瘤(C19)。(2)AJCC臨床分期T1N0或T2N0之下段直腸(距肛緣5cm以內)惡性腫瘤。2.支付規範：(1)申報時需於病歷檢附「治療計畫、病理和影像診斷報告」備查。(2)本療程採包裹給付，如未執行完全療程，依療程次數五次，按等比例核減點數。(3)執行頻率：每人終生限給付一次。(4)手術後復發之病人如須再次salvage骨盆腔放射治療，不得執行本項。(5)不得同時申報：33090B、36001B、36002B、36004B、36005B、36011B-36013B、36015B、36018B-36020B、36021C、37006B、37013B-37016B、37030B、37046B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Rectal cancer preoperative intensity-modulated hypofractionated radiotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37",
      "display" : "子宮頸抹片採樣(未含骨盆腔檢查)(衛生所執業，執業登記非屬婦產科或家庭醫學科專科之醫師)",
      "definition" : "三十歲以上婦女每年一次※國民健康署運用菸品健康福利捐經費補助",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37001B",
      "display" : "加熱治療每次",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hyperthermia"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37002B",
      "display" : "冷凍治療每次",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cryotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37003B",
      "display" : "免疫治療、皮膚試驗(藥費另計)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunotherapy, skin test"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37004B",
      "display" : "免疫治療、卡介苗皮膚畫痕治療(藥費另計)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Immunotherapy, B.C.G scarification"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37005B",
      "display" : "腫瘤內化學藥物直接注射",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intratumor chemotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37006B",
      "display" : "橫切面斷層攝影1張",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transverse tomography (portal)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37007B",
      "display" : "安裝近接治療器(複雜)—每次",
      "definition" : "於手術室或治療室中安裝多管之近接放射治療。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Insertion of applicator for brachytherapy (complex), each time"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37008B",
      "display" : "安裝近接治療器(簡單)－每次",
      "definition" : "於治療室中安裝單管之近接放射治療。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Insertion of applicator for brachytherapy (simple), each time"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37010B",
      "display" : "組織插種治療",
      "definition" : "包括鐳囊、鐳針或具他同位素費用(includingradiumneedle，radiumcapsula&otherisotope)。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Interstital brachytherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37011B",
      "display" : "特殊模體安裝，每次",
      "designation" : [
        {
          "language" : "en",
          "value" : "Special mold application for brachytherapy, each time"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37013B",
      "display" : "合金模塊之設計及製作",
      "definition" : "包括技術費及材料費在內。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Design & formulate of block"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37014B",
      "display" : "填充模塊之設計及製作",
      "designation" : [
        {
          "language" : "en",
          "value" : "Design & formulate of bolus"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37015B",
      "display" : "補償器之設計及製作",
      "designation" : [
        {
          "language" : "en",
          "value" : "Design & formulate of compensator"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37016B",
      "display" : "固定模具之設計及製作(大)",
      "definition" : "1.胸腔、腹腔、骨盆腔及四肢使用。2.包括技術費及材料費在內。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Design & formulate of cast (large)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37018B",
      "display" : "遙控後荷式近距治療(簡單)—每次",
      "definition" : "1.包括劑量術(dosimetry)在內。2.以遙控後荷治療設備，治療單管之近接治療部位。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Remote controled afterloading brachytherapy － each simple application"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37019B",
      "display" : "遙控後荷式近距治療(複雜)－每次",
      "definition" : "1.包括劑量術(dosimetry)在內。2.以遙控後荷治療設備，治療多管之近接治療部位。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Remote controled afterloading brachytherapy － each complex application"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "37025B",
      "display" : "癌症動脈注射化學療法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Cancer Intra-arterial Chemotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37026B",
      "display" : "放射治療之皮膚處理(一個療程)",
      "definition" : "1.以每週為一個療程(含括一週之治療次數)。2.申報時須註明所照部位範圍、劑量、次數。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Skin care during radiotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37028B",
      "display" : "三度空間立體定位Ｘ光刀照射治療",
      "definition" : "1.含括一般及特殊材料費。2.須符合適應症：(1)以顱內病灶直徑小於三公分或容積十五立方公分以下之病灶數目小於或等於三處之動靜脈畸型(含腦膜動靜脈瘻管)、聽神經瘤、腦膜瘤、腦下垂體瘤、顱咽管瘤或其他腫瘤(應附相關療效文獻佐證)，或顱內病灶(大小限制同前)數目小於或等於五處之轉移性腦瘤，惟轉移性腎臟細胞瘤及黑色素瘤不受病灶數目限制。且須符合以下條件之一：A.曾接受開顱手術，但有殘餘腫瘤或腫瘤復發者。B.開顱手術可能造成神經損傷或危險性大者。C.有嚴重心肺疾病或其他內科疾病，不適合侵入性手術或全身麻醉者。D.轉移性腦瘤，限KarnofskyPerformanceScale(KPS)≧70或ECOG0-1者，且含其他病灶部位屬少部分惡化者(oligoprogression/惡化病灶總數不超過五個且惡化器官不超過三處)。E.海綿狀血管瘤限病灶位於深部腦核或腦幹，曾有出血病史者。F.顱內單側小腦橋腦角聽神經瘤寬度小於2.5公分(不含內耳道)者。(2)不適用手術或其他傳統治療方式之三叉神經痛。3.全部個案須事前專案向保險人申請。4.須有專任放射線治療醫師與專任輻射劑量計算人員，並向保險人申請核可實施。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stereotactic radiosurgery with x-knife"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37029B",
      "display" : "加馬機立體定位放射手術",
      "definition" : "1.含括手術技術費、定位技術費、一般材料費及特殊材料費等。2.須符合適應症：(1)以顱內病灶之三度空間直徑不大於3.5×3.5×3.5公分或容積二十立方公分，病灶數目小於或等於三處之動靜脈畸型(含腦膜動靜脈瘻管)、聽神經瘤、腦膜瘤、腦下垂體瘤、顱咽管瘤或其他腫瘤(應附相關療效文獻佐證)、或顱內病灶(大小限制同前)數目小於或等於五處之轉移性腦瘤，惟轉移性腎臟細胞瘤及黑色素瘤不受病灶數目限制。且須符合以下條件之一：A.曾接受開顱手術，但有殘餘腫瘤或腫瘤復發者。B.開顱手術可能造成神經損傷或危險性大者。C.有嚴重心肺疾病或其他內科疾病，不適合侵入性手術或全身麻醉者。D.轉移性腦瘤，限KarnofskyPerformanceScale(KPS)≧70或ECOG0-1者，且含其他病灶部位屬少部分惡化者(oligoprogression/惡化病灶總數不超過五個且惡化器官不超過三處)。E.海綿狀血管瘤限病灶位於深部腦核或腦幹，曾有出血病史者。F.顱內單側小腦橋腦角之聽神經瘤寬度小於2.5公分(不含內耳道)者。(2)不適用手術或其他傳統治療方式之三叉神經痛。3.電腦刀影像導引立體定位放射手術(CyberKnifeImageGuidedStereotacticradiosurgery)項目比照申報。4.全部個案須事前專案向保險人申請。5.須有專任放射線治療醫師與專任輻射劑量計算人員，並向保險人申請核可實施。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stereotactic radiosurgery with γ knife"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "37030B",
      "display" : "固定模具之設計及製作(小)",
      "definition" : "1.頭、頸部使用。2.包括技術費及材料費在內。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Design & formulate of cast (small)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37031B",
      "display" : "皮下化學藥物注射",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Subcutaneous chemotherapy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "37032B",
      "display" : "腦室內注射留置器或脊髓腔內化學藥物注射",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intraventricular reservoir chemotherapy (Intrathecal chemotherapy)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37033B",
      "display" : "肋膜或腹膜腔內化學藥物注射",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intrapleural or Intraperitoneal chemotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37034B",
      "display" : "動脈血管內化學藥物注射一小時",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intraarterial chemotherapy ≦ 1 hour"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37035B",
      "display" : "動脈血管內化學藥物注射一至四小時",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intraarterial chemotherapy 1-4 hours"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37036B",
      "display" : "動脈血管內化學藥物注射四至八小時",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intraarterial chemotherapy 4-8 hours"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37037B",
      "display" : "動脈血管內化學藥物注射八小時以上",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intraarterial chemotherapy ＞ 8 hours"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37038B",
      "display" : "靜脈血管內化學藥物注射一小時內",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intravenous chemotherapy≦ 1 hour"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37039B",
      "display" : "靜脈血管內化學藥物注射一至四小時",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intravenous chemotherapy 1-4 hours"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37040B",
      "display" : "靜脈血管內化學藥物注射四至八小時",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intravenous chemotherapy 4-8 hours"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37041B",
      "display" : "靜脈血管內化學藥物注射八小時以上",
      "definition" : "1.藥費另計2.兒童加成項目。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intravenous chemotherapy＞ 8 hours"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "37042C",
      "display" : "肝腫瘤無線頻率電熱療法－小於二公分",
      "definition" : "1.含超音波及電腦斷層費用。2.特材另計。3.多顆腫瘤依公分數加總結果申報。4.無線電頻率燒灼僅使用一針且沒有多次進針，則以37042C申報，二針以37043C申報，三針以37044C申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Radiofrequency ablation in hepatic malignancy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37043C",
      "display" : "肝腫瘤無線頻率電熱療法－大於二公分(含)至小於四公分",
      "definition" : "1.含超音波及電腦斷層費用。2.特材另計。3.多顆腫瘤依公分數加總結果申報。4.無線電頻率燒灼僅使用一針且沒有多次進針，則以37042C申報，二針以37043C申報，三針以37044C申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Radiofrequency ablation in hepatic malignancy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37044C",
      "display" : "肝腫瘤無線頻率電熱療法－大於四公分(含)",
      "definition" : "1.含超音波及電腦斷層費用。2.特材另計。3.多顆腫瘤依公分數加總結果申報。4.無線電頻率燒灼僅使用一針且沒有多次進針，則以37042C申報，二針以37043C申報，三針以37044C申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Radiofrequency ablation in hepatic malignancy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37045B",
      "display" : "光動力療法",
      "designation" : [
        {
          "language" : "en",
          "value" : "Photodynamic therapy (PDT)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37046B",
      "display" : "多葉型準直儀合金模塊之設計及製作-每一照野",
      "definition" : "1.不得同時申報37013B「合金模塊之設計及製作」。2.每一療程限申報6(含)次以下為原則。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37047B",
      "display" : "身體立體定位放射治療",
      "definition" : "1.施行本項之適應症如下：(1)原發性早期肺部惡性腫瘤(依據2009AJCC分期定義為N0之≦stageⅡ)患者，病灶最大徑≦5公分，ECOGstatus≦2(或KarnofskyPerformanceScale/KPS≧70)，且須符合以下(highsurgicalrisk)條件之一：A.poorpulmonaryfunction，不適合接受lobectomy手術者(依外科醫師檢視或會診紀錄)。B.年齡七十五歲以上，致開胸手術可能造成嚴重損傷或危險性大，不適手術者(依外科醫師檢視或會診紀錄)。C.有嚴重心肺疾病或其它內科疾病，經麻醉科評估不適全身麻醉者。(2)原發性肝膽單一病灶(可為原發性肝癌或肝內膽道癌，同時無肝外淋巴侵犯和遠端轉移)，肝功能為Child-PughA至B級，ECOGstatus≦2(或KarnofskyPerformanceScale/KPS≧70)，病灶最大徑≦5公分。且經評估無法進行下列之一的治療或下列之一的治療失敗者(依病歷紀錄)：A.手術切除B.血管栓塞治療C.電燒灼治療2.支付規範：(1)需事前審查。(2)全療程為二週且分次治療以六次(含)為限，採包裹給付，如未執行完全療程，依治療計畫之治療次數按等比例核扣。(3)不得同時申報支付標準編號33090B、36001B、36004B、36005B、36015B、36011B、36012B、36014B、36018B、36019B、36021C、37007B、37008B、37013B、37014B、37016B、37018B、37019B、37029B、37030B、37046B",
      "designation" : [
        {
          "language" : "en",
          "value" : "Stereotactic body radiation therapy(SBRT)/Stereotactic ablative radiotherapy(SABR)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "37048B",
      "display" : "內視鏡射頻消融術(RFA)",
      "definition" : "1.適應症(須有病理切片證實)：(1)扁平性之食道癌前病變、食道鱗狀細胞高度分化不良病變。(2)巴瑞特氏食道合併分化不良病變。(3)長度大於三公分且有腸黏膜化生之巴瑞特氏食道。2.支付規範：(1)同一病患以申報一次為限，六個月內若需再次執行RFA者，需經事前審查同意，其條件如下：a.需符合原始內視鏡射頻消融術治療之適應症；且b.需檢附內視鏡影像及病理組織學切片報告，確認有腫瘤殘存或復發；且c.需進行腫瘤重新臨床分期，且與第一次治療前分期比較，不能有惡化現象。(2)內含一般材料費及單一使用拋棄式之guidewire及spraycatheter、內視鏡透明套。(3)不得同時申報72050B、28016C、47074C、47043B、47077B、71209B。(4)執行本項之麻醉費用另計。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Endoscopic Radiofrequency Ablation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "38",
      "display" : "子宮頸抹片採樣(設站篩檢，執業登記於特約醫事服務機構之專任助產人員或衛生所公衛護士)",
      "definition" : "三十歲以上婦女每年一次※國民健署運用菸品健康福利捐經費補助",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39001C",
      "display" : "動脈注射",
      "definition" : "脛動脈，鎖骨下動脈，股動脈，前膊動脈等。肺動脈起始部，大動脈弓，腹部動脈等深部動脈",
      "designation" : [
        {
          "language" : "en",
          "value" : "Arterial injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39002C",
      "display" : "內臟注射",
      "designation" : [
        {
          "language" : "en",
          "value" : "Inner organs injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39003C",
      "display" : "生物學藥劑注射(包括反應試驗注射)",
      "definition" : "限抗毒素或血清注射申報。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Biological preparation injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39004C",
      "display" : "大量液體點滴注射(林格兒氏液，Rock液，生理食鹽水，葡萄糖液，果糖液或血液代用劑等)注射。",
      "definition" : "1.本款目指一次注入液達100c.c.以上者，惟未滿七歲病人不在此限。2.點滴注射以「次」計算，即每天連續點滴者，僅核付第一次注技術費，超過500c.c.以上無加算之規定。3.點滴注射外漏重打時，不得申報注射技術費。4.包括IVset在內。5.兒童加成項目。6.適應症：(1)恢復或維持液體。(2)恢復或維持電解質之平衡。(3)靜脈注射藥品。(4)提供病人營養之需要。(5)為維持中央靜脈壓、動脈壓監視器維持量。",
      "designation" : [
        {
          "language" : "en",
          "value" : "IV drip"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39005C",
      "display" : "關節腔內注射",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intraarticular injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39006C",
      "display" : "結膜下注射",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Subconjunctival injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39008C",
      "display" : "球後注射",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Retrobulbar injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39009C",
      "display" : "Peyronie's病灶內注射",
      "definition" : "93.6.14健保醫字第0930060063號公告中英文名稱修正。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Peyronie's intral-lesional injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39010C",
      "display" : "藥物敏感反應試驗",
      "designation" : [
        {
          "language" : "en",
          "value" : "(Cytomack test , penicillin test 等)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39011C",
      "display" : "前房內注射",
      "definition" : "93.6.14健保醫字第0930060063號公告點數修訂。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Anerior chamber injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39012C",
      "display" : "靜脈曲張注射療法-單腳",
      "definition" : "1.包括藥費includingdrug。2.屬西醫基層總額部門院所，注射治療一年內(自第一次施行時間起算)，申報不得超過四次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Injection of sclerosing solution, multiple veins, unilateral leg"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39013C",
      "display" : "靜脈曲張注射療法-雙腳",
      "definition" : "1.包括藥費includingdrug。2.屬西醫基層總額部門院所，注射治療一年內(自第一次施行時間起算)，申報不得超過四次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Injection of sclerosing solution, multiple veins, bilateral legs"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39014C",
      "display" : "自體血液注射",
      "designation" : [
        {
          "language" : "en",
          "value" : "Autoblood injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39015B",
      "display" : "靜脈營養術(天)",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "T.P.N (total parenteral nutrition ,day)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39016B",
      "display" : "點滴幫浦(天)",
      "designation" : [
        {
          "language" : "en",
          "value" : "IV pump (day)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39017C",
      "display" : "腎上腺素注射",
      "designation" : [
        {
          "language" : "en",
          "value" : "Epinephrine injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39018C",
      "display" : "肌腱注射",
      "definition" : "93.6.14健保醫字第0930060063號公告開放表別。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Tendon injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39019B",
      "display" : "經造影導管灌注治療(天)",
      "definition" : "包含點滴幫浦IVpump",
      "designation" : [
        {
          "language" : "en",
          "value" : "Transcatheter infusion therapy (day)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39020B",
      "display" : "肝腫瘤內藥物注射",
      "definition" : "註：1.本項費用已包括超音波檢查費、材料費、藥費及麻醉費。2.本項治療之適應症為：(1)腫瘤小於三公分，數目少於四個之原發性肝細胞癌。(2)腫瘤大於三公分但小於八公分，合併血管阻塞術(TAE)治療。3.申報費用時請檢附治療後超音波照片備查。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Percutaneous drug injection therapy for liver tumor"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39021B",
      "display" : "居家注射排鐵劑幫浦–每日",
      "definition" : "使用超過二十四天(含)者，依39022B申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39022B",
      "display" : "居家注射排鐵劑幫浦–每月",
      "definition" : "使用超過二十四天(含)者，依39022B申報。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39023B",
      "display" : "肉毒桿菌素注射費",
      "definition" : "註：1.下列適應症，每個注射點得申報一次注射費，每個療程申報之注射費上限如下：(1)半面痙攣(ICD-10-CM：G51.3)：四點(次)。-ICD-10-CM(2023年版)：G51.31、G51.32、G51.33(自一百十四年一月一日起適用)。(2)眼瞼痙攣(ICD-10-CM：G24.5)：六點(次)。(3)斜頸症(ICD-10-CM：G24.3、M43.6)：八點(次)。2.非上述任一適應症，僅可申報一次。3.支付規範：(1)需符合全民健康保險藥物給付項目及支付標準附件六藥品給付規定第一節神經系統藥物1.6.2.BotulinumtoxintypeA-使用於眼瞼痙攣或半面痙攣或局部肌張力不全症之使用條件。(2)不得同時申報：39026C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Botolilum toxin local injection"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39024B",
      "display" : "激痛點注射調理(每一痛點)",
      "definition" : "1.每次門診注射以三點為限(三點以上以三點計)，每週至多注射一次，每一療程以三週為原則，每兩療程間隔至少兩個月。2.申報時須檢附病歷影本，並敘明︰(1)激痛點注射(TriggerpointINJ.)。(2)患者曾接受之相關治療(如藥物、物理治療)。(3)注射部位肌肉名稱。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Trigger point injection(one)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "39025B",
      "display" : "經皮甲狀腺腫瘤酒精注射",
      "definition" : "註:1.適應症:同一病灶之復發性良性甲狀腺囊腫，且有症狀、觸診明顯之良性甲狀腺囊腫，直徑大於二公分以上，囊液體體積大於5CC，經過兩次穿刺又復發者。2.須事前審查，同一病灶限申報二次。3.執行人員資格:限有一百例超音波或穿刺技術經驗之醫師。4.不得同時申報診療項目:19007C、19012C、29008B、29011C。5.內含超音波檢查費、材料費及麻醉費。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "39026C",
      "display" : "慢性偏頭痛肉毒桿菌素注射技術費",
      "definition" : "支付規範：1.需符合「全民健康保險藥物給付項目及支付標準第6編第83條之藥品給付規定第1節神經系統藥物1.6.2.BotulinumtoxintypeA-慢性偏頭痛之預防性治療」之使用條件。2.不得同時申報：39023B。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Botulinum toxin injection for chronic migraine"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04",
      "display" : "第四次兒童衛教指導費(可搭配第四次兒童預防保健服務申報)",
      "definition" : "於十個月至一歲半；提供幼兒哺餵、副食品添加、餵食習慣、口腔與視力保健、事故傷害預防等衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "40",
      "display" : "醫療院所-孕產婦檢查妊娠第一期第一次(妊娠未滿十三週)",
      "definition" : "檢查項目:1.例行產檢。2.流產徵兆、高危險妊娠及孕期營養衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "41",
      "display" : "醫療院所-孕產婦檢查妊娠第一期第二次(妊娠未滿十三週)",
      "definition" : "不含RubellaIgG及HBsAG及HBeAG",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "41002C",
      "display" : "肌肉強度時間測定",
      "designation" : [
        {
          "language" : "en",
          "value" : "STRENGTH DURATION CURVE TEST"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "41003B",
      "display" : "肌肉電刺激治療",
      "designation" : [
        {
          "language" : "en",
          "value" : "Muscle nerve stimulation therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "41005C",
      "display" : "抗痙攣阻斷術",
      "designation" : [
        {
          "language" : "en",
          "value" : "ANTI-SPASTICITY BLOCK"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "41006B",
      "display" : "等速肌力檢查",
      "definition" : "同一病人治療期間，一個月限申報一次，同一治療期間，至多申報三次。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Isokinetic evaluation"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42",
      "display" : "醫療院所-孕產婦檢查妊娠第二期第三次(妊娠十三週未滿二十九週)",
      "definition" : "註:本項業務自95.1.1起移歸國民健康局管理。檢查項目:1.例行產檢。2.早產防治衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42002B",
      "display" : "簡單治療－簡單",
      "definition" : "簡單治療項目PTS1.牽引Traction(Intermittent)PTS2.治療性冷\\熱敷Hot\\coldpackPTS3.紅外線InfraredPTS4.石蠟浴ParaffinbathPTS5.超音波UltrasoundPTS6.短波ShortwavediathermyPTS7.微波MicrowavediathermyPTS8.向量干擾InterferentialtherapyPTS9.經皮神經電剌激TENSPTS10.超高頻HighfrequencydischargePTS11.低能雷射治療LowpowerlaserPTS12.紫外線UltravioletPTS13.磁場治療MagneticfieldtherapyPTS14.循環治療CirculatorPTS15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "SIMPLE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42003C",
      "display" : "簡單治療－簡單",
      "definition" : "簡單治療項目PTS1.牽引Traction(Intermittent)PTS2.治療性冷\\熱敷Hot\\coldpackPTS3.紅外線InfraredPTS4.石蠟浴ParaffinbathPTS5.超音波UltrasoundPTS6.短波ShortwavediathermyPTS7.微波MicrowavediathermyPTS8.向量干擾InterferentialtherapyPTS9.經皮神經電剌激TENSPTS10.超高頻HighfrequencydischargePTS11.低能雷射治療LowpowerlaserPTS12.紫外線UltravioletPTS13.磁場治療MagneticfieldtherapyPTS14.循環治療CirculatorPTS15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "SIMPLE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42005B",
      "display" : "簡單治療－中度",
      "definition" : "指實施簡單治療項目二項以上，且合計時間超過三十分鐘。註：簡單治療項目PTS1.牽引Traction(Intermittent)PTS2.治療性冷\\熱敷Hot\\coldpackPTS3.紅外線InfraredPTS4.石蠟浴ParaffinbathPTS5.超音波UltrasoundPTS6.短波ShortwavediathermyPTS7.微波MicrowavediathermyPTS8.向量干擾InterferentialtherapyPTS9.經皮神經電剌激TENSPTS10.超高頻HighfrequencydischargePTS11.低能雷射治療LowpowerlaserPTS12.紫外線UltravioletPTS13.磁場治療MagneticfieldtherapyPTS14.循環治療CirculatorPTS15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Physical Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42006C",
      "display" : "簡單治療－中度",
      "definition" : "指實施簡單治療項目二項以上，且合計時間超過三十分鐘。註：簡單治療項目PTS1.牽引Traction(Intermittent)PTS2.治療性冷\\熱敷Hot\\coldpackPTS3.紅外線InfraredPTS4.石蠟浴ParaffinbathPTS5.超音波UltrasoundPTS6.短波ShortwavediathermyPTS7.微波MicrowavediathermyPTS8.向量干擾InterferentialtherapyPTS9.經皮神經電剌激TENSPTS10.超高頻HighfrequencydischargePTS11.低能雷射治療LowpowerlaserPTS12.紫外線UltravioletPTS13.磁場治療MagneticfieldtherapyPTS14.循環治療CirculatorPTS15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Physical Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42008B",
      "display" : "中度治療_中度",
      "definition" : "註：中度治療之治療內容代碼PTM1.肌肉電刺激MusclestimulationPTM2.上肢水療Hydrotherapy,U/EPTM3.下肢水療Hydrotherapy,L/EPTM4.全身水療Hydrotherapy,GeneralPTM5.被動性關節運動PassiveR.O.M.PTM6.牽拉運動StretchingExs.PTM7.運動治療TherapeuticExs.PTM8.傾斜台訓練TiltingtabletrainingPTM9.肌力訓練StrengtheningTxPTM10.耐力訓練EndurancetrainingPTM11.按摩MassagePTM12.鬆動術MobilizationPTM13.姿態訓練Posturetraining(含步態訓練及姿勢訓練)PTM14.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "MODERATE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42009C",
      "display" : "中度治療_中度",
      "definition" : "註：中度治療之治療內容代碼PTM1.肌肉電刺激MusclestimulationPTM2.上肢水療Hydrotherapy,U/EPTM3.下肢水療Hydrotherapy,L/EPTM4.全身水療Hydrotherapy,GeneralPTM5.被動性關節運動PassiveR.O.M.PTM6.牽拉運動StretchingExs.PTM7.運動治療TherapeuticExs.PTM8.傾斜台訓練TiltingtabletrainingPTM9.肌力訓練StrengtheningTxPTM10.耐力訓練EndurancetrainingPTM11.按摩MassagePTM12.鬆動術MobilizationPTM13.姿態訓練Posturetraining(含步態訓練及姿勢訓練)PTM14.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "MODERATE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42011B",
      "display" : "中度治療-複雜",
      "definition" : "指實施中度治療項目三項以上，且合計時間超過五十分鐘。中度治療之治療內容代碼PTM1.肌肉電刺激MusclestimulationPTM2.上肢水療Hydrotherapy,U/EPTM3.下肢水療Hydrotherapy,L/EPTM4.全身水療Hydrotherapy,GeneralPTM5.被動性關節運動PassiveR.O.M.PTM6.牽拉運動StretchingExs.PTM7.運動治療TherapeuticExs.PTM8.傾斜台訓練TiltingtabletrainingPTM9.肌力訓練StrengtheningTxPTM10.耐力訓練EndurancetrainingPTM11.按摩MassagePTM12.鬆動術MobilizationPTM13.姿態訓練Posturetraining(含步態訓練及姿勢訓練)PTM14.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Physical Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42012C",
      "display" : "中度治療-複雜",
      "definition" : "指實施中度治療項目三項以上，且合計時間超過五十分鐘。中度治療之治療內容代碼PTM1.肌肉電刺激MusclestimulationPTM2.上肢水療Hydrotherapy,U/EPTM3.下肢水療Hydrotherapy,L/EPTM4.全身水療Hydrotherapy,GeneralPTM5.被動性關節運動PassiveR.O.M.PTM6.牽拉運動StretchingExs.PTM7.運動治療TherapeuticExs.PTM8.傾斜台訓練TiltingtabletrainingPTM9.肌力訓練StrengtheningTxPTM10.耐力訓練EndurancetrainingPTM11.按摩MassagePTM12.鬆動術MobilizationPTM13.姿態訓練Posturetraining(含步態訓練及姿勢訓練)PTM14.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Physical Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42014B",
      "display" : "複雜治療",
      "definition" : "1.限復健專科醫師開具處方後，交由相關治療專業人員親自實施始可申報。2.複雜治療項目PTC1.促進技術FacilitationtechniquesPTC2.平衡訓練BalancetrainingPTC3.義肢訓練ProsthesistrainingPTC4.等速肌力訓練IsokinetictrainingPTC5.心肺功能訓練CardiopulmonarytrainingPTC6.行走訓練AmbulationtrainingPTC7.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "COMPLICATE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42015C",
      "display" : "複雜治療",
      "definition" : "1.限復健專科醫師開具處方後，交由相關治療專業人員親自實施始可申報。2.複雜治療項目PTC1.促進技術FacilitationtechniquesPTC2.平衡訓練BalancetrainingPTC3.義肢訓練ProsthesistrainingPTC4.等速肌力訓練IsokinetictrainingPTC5.心肺功能訓練CardiopulmonarytrainingPTC6.行走訓練AmbulationtrainingPTC7.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "COMPLICATE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42016C",
      "display" : "物理治療評估",
      "definition" : "註:物理治療評估須由復健科專科醫師或物理治療專業人員親自實施始可申報，同一病患治療期間一個月限申報一次，並須將評估項目、現有問題、短及長程治療目標及治療計畫記錄於病歷內。同一治療期間超過三個月者，不予支付。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42017C",
      "display" : "中度治療-中度",
      "definition" : "註：1.中度治療之治療內容代碼PTM1.肌肉電刺激MusclestimulationPTM2.上肢水療Hydrotherapy,U/EPTM3.下肢水療Hydrotherapy,L/EPTM4.全身水療Hydrotherapy,GeneralPTM5.被動性關節運動PassiveR.O.M.PTM6.牽拉運動StretchingExs.PTM7.運動治療TherapeuticExs.PTM8.傾斜台訓練TiltingtabletrainingPTM9.肌力訓練StrengtheningTxPTM10.耐力訓練EndurancetrainingPTM11.按摩MassagePTM12.鬆動術MobilizationPTM13.姿態訓練Posturetraining(含步態訓練及姿勢訓練)PTM14.其他經保險人核可者。42017C、42018C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "MODERATE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42018C",
      "display" : "中度治療-複雜",
      "definition" : "指實施中度治療項目三項以上，且合計時間超過五十分鐘。42017C、42018C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。中度治療之治療內容代碼PTM1.肌肉電刺激PTM2.上肢水療PTM3.下肢水療PTM4.全身水療PTM5.被動性關節運動PTM6.牽拉運動PTM7.運動治療PTM8.傾斜台訓練PTM9.肌力訓練PTM10.耐力訓練PTM11.按摩PTM12.鬆動術PTM13.姿態訓練(含步態訓練及姿勢訓練)PTM14.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Physical Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "42019C",
      "display" : "複雜治療",
      "definition" : "1.限復健專科醫師開具處方後，交由相關治療專業人員親自實施始可申報。2.複雜治療項目PTC1.促進技術FacilitationtechniquesPTC2.平衡訓練BalancetrainingPTC3.義肢訓練ProsthesistrainingPTC4.等速肌力訓練IsokinetictrainingPTC5.心肺功能訓練CardiopulmonarytrainingPTC6.行走訓練AmbulationtrainingPTC7.其他經保險人核可者3.42019C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "COMPLICATE"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43",
      "display" : "醫療院所-孕產婦檢查妊娠第二期第四次(妊娠十三週未滿二十九週)",
      "definition" : "註:1.本項業務自95.1.1起移歸國民健康局管理。2.不含超音波檢查項目:1.例行產檢。2.早產防治衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43002B",
      "display" : "簡單Simple：指治療項目一至二項，合計治療時間未滿三十分鐘之簡單治療。",
      "definition" : "治療項目OT1.姿態訓練OT2.被動性關節運動.OT3.坐站平衡訓練OT4.移位訓練OT5.日常生活訓練OT6.肌力訓練OT7.運動知覺訓練OT8.上肢(下肢)功能訓練OT9.上肢(下肢)義肢功能訓練OT10.手(足)功能訓練OT11.協調訓練OT12.知覺認知訓練OT13.團體治療OT14.娛樂治療OT15.活動治療OT16.減痙攣活動OT17.其他經保險人核可者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy-Simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43003C",
      "display" : "簡單Simple：指治療項目1~2項，合計治療時間未滿30分鐘之簡單治療。",
      "definition" : "治療項目OT1.姿態訓練OT2.被動性關節運動.OT3.坐站平衡訓練OT4.移位訓練OT5.日常生活訓練OT6.肌力訓練OT7.運動知覺訓練OT8.上肢(下肢)功能訓練OT9.上肢(下肢)義肢功能訓練OT10.手(足)功能訓練OT11.協調訓練OT12.知覺認知訓練OT13.團體治療OT14.娛樂治療OT15.活動治療OT16.減痙攣活動OT17.其他經保險人核可者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy-Simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43005B",
      "display" : "中度Moderate：指治療項目二至三項，合計治療時間超過三十分鐘至五十分鐘以內之中度治療。",
      "definition" : "治療項目OT1.姿態訓練OT2.被動性關節運動.OT3.坐站平衡訓練OT4.移位訓練OT5.日常生活訓練OT6.肌力訓練OT7.運動知覺訓練OT8.上肢(下肢)功能訓練OT9.上肢(下肢)義肢功能訓練OT10.手(足)功能訓練OT11.協調訓練OT12.知覺認知訓練OT13.團體治療OT14.娛樂治療OT15.活動治療OT16.減痙攣活動OT17.其他經保險人核可者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy-Moderate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43006C",
      "display" : "中度Moderate：指治療項目二至三項，合計治療時間超過三十分鐘至五十分鐘以內之中度治療。",
      "definition" : "治療項目OT1.姿態訓練OT2.被動性關節運動.OT3.坐站平衡訓練OT4.移位訓練OT5.日常生活訓練OT6.肌力訓練OT7.運動知覺訓練OT8.上肢(下肢)功能訓練OT9.上肢(下肢)義肢功能訓練OT10.手(足)功能訓練OT11.協調訓練OT12.知覺認知訓練OT13.團體治療OT14.娛樂治療OT15.活動治療OT16.減痙攣活動OT17.其他經保險人核可者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy-Moderate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43008B",
      "display" : "中度-複雜：1.指治療項目三項以上，合計治療時間三十分鐘以上之治療。2.且必須包含下列二項以上之治療項目(兒童病人從出生至未滿十二歲不予限制)",
      "definition" : "應包含二項治療項目之選項為OT1.姿態訓練、OT3.坐站平衡訓練、OT4.移位訓練、OT5.日常生活訓練、OT7.運動知覺訓練、OT8.上肢(下肢)功能訓練、OT9.上肢(下肢)義肢功能訓練、OT10.手(足)功能訓練、OT11.協調訓練、OT12.知覺認知訓練Cognitivetraining、OT13.團體治療Grouptherapy、OT14.娛樂治療Recreationtherapy、OT15.活動治療Activitytherapy、OT16.減痙攣活動Spasticityreductionmotion、OT17.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43009C",
      "display" : "中度-複雜：1.指治療項目三項以上，合計治療時間三十分鐘以上之治療。2.且必須包含下列二項以上之治療項目(兒童病人從出生至未滿十二歲不予限制):",
      "definition" : "應包含二項治療項目之選項為OT1.姿態訓練、OT3.坐站平衡訓練、OT4.移位訓練、OT5.日常生活訓練、OT7.運動知覺訓練、OT8.上肢(下肢)功能訓練、OT9.上肢(下肢)義肢功能訓練、OT10.手(足)功能訓練、OT11.協調訓練、OT12.知覺認知訓練、OT13.團體治療Grouptherapy、OT14.娛樂治療Recreationtherapy、OT15.活動治療Activitytherapy、OT16.減痙攣活動Spasticityreductionmotion、OT17.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43010C",
      "display" : "塑膠製短腿固定副木治療費",
      "designation" : [
        {
          "language" : "en",
          "value" : "RESTING SPLINT, SHORT LEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43011C",
      "display" : "塑膠製短腿固定副木材料費",
      "designation" : [
        {
          "language" : "en",
          "value" : "RESTING SPLINT, SHORT LEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43012C",
      "display" : "塑膠製長腿固定副木治療費",
      "designation" : [
        {
          "language" : "en",
          "value" : "RESTING SPLINT, LONG LEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43013C",
      "display" : "塑膠製長腿固定副木材料費",
      "designation" : [
        {
          "language" : "en",
          "value" : "RESTING SPLINT, LONG LEG"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43014C",
      "display" : "豎腕副木治療費",
      "designation" : [
        {
          "language" : "en",
          "value" : "COCK-UP, SPLINT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43015C",
      "display" : "豎腕副木材料費",
      "designation" : [
        {
          "language" : "en",
          "value" : "COCK-UP, SPLINT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43016C",
      "display" : "手部固定副木治療費",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hand splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43017C",
      "display" : "手部固定副木材料費",
      "designation" : [
        {
          "language" : "en",
          "value" : "Hand splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43018C",
      "display" : "手指伸展副木治療費",
      "designation" : [
        {
          "language" : "en",
          "value" : "INDIVIDUAL FINGER SPLINT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43019C",
      "display" : "手指伸展副木材料費",
      "designation" : [
        {
          "language" : "en",
          "value" : "INDIVIDUAL FINGER SPLINT"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43020C",
      "display" : "長型對掌副木治療費",
      "designation" : [
        {
          "language" : "en",
          "value" : "Long opponens splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43021C",
      "display" : "長型對掌副木材料費",
      "designation" : [
        {
          "language" : "en",
          "value" : "Long opponens splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43022C",
      "display" : "短型對掌副木治療費",
      "designation" : [
        {
          "language" : "en",
          "value" : "Short opponens splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43023C",
      "display" : "短型對掌副木材料費",
      "designation" : [
        {
          "language" : "en",
          "value" : "Short opponens splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43024C",
      "display" : "膝上截肢訓練用石膏義肢裝置費",
      "designation" : [
        {
          "language" : "en",
          "value" : "PYLON FILLING AK"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43025C",
      "display" : "膝下截肢訓練用石膏義肢裝置費",
      "designation" : [
        {
          "language" : "en",
          "value" : "PYLON FITTING BK"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43026C",
      "display" : "職能治療評估",
      "definition" : "註:1.職能治療評估須由復健科專科醫師或職能治療專業人員親自實施始可申報，同一病患治療期間一個月限申報一次，並須將評估項目、現有問題、短及長程治療目標及治療計畫記錄於病歷內。同一治療期間超過三個月者，不予支付。2.職能治療評估包括下列各項:(1)性向測驗(Aptitutetest)(2)智力測驗(Intelligencetest)(3)興趣測驗(Interesttest)(4)工作樣本測驗(5)手功能測驗(Handfunctiontest)(6)其他(Others)",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43027C",
      "display" : "中度Moderate：指治療項目二至三項，合計治療時間超過三十分鐘至五十分鐘以內之中度治療。",
      "definition" : "1.43027C、43028C、43031C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。2.治療項目OT1.姿態訓練OT2.被動性關節運動.OT3.坐站平衡訓練OT4.移位訓練OT5.日常生活訓練OT6.肌力訓練OT7.運動知覺訓練OT8.上肢(下肢)功能訓練OT9.上肢(下肢)義肢功能訓練OT10.手(足)功能訓練OT11.協調訓練OT12.知覺認知訓練OT13.團體治療OT14.娛樂治療OT15.活動治療OT16.減痙攣活動OT17.其他經保險人核可者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy-Moderate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43028C",
      "display" : "中度-複雜：1.指治療項目三項以上，合計治療時間三十分鐘以上之治療。2.且必須包含下列二項以上之治療項目(兒童病人從出生至未滿十二歲不予限制):",
      "definition" : "1.43027C、43028C、43031C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。2.應包含二項治療項目之選項為OT1.姿態訓練、OT3.坐站平衡訓練、OT4.移位訓練、OT5.日常生活訓練、OT7.運動知覺訓練、OT8.上肢(下肢)功能訓練、OT9.上肢(下肢)義肢功能訓練、OT10.手(足)功能訓練、OT11.協調訓練、OT12.知覺認知訓練、OT13.團體治療Grouptherapy、OT14.娛樂治療Recreationtherapy、OT15.活動治療Activitytherapy、OT16.減痙攣活動Spasticityreductionmotion、OT17.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43030B",
      "display" : "複雜Complicated：實施本項須符合於下列適應症及其項目規定",
      "definition" : "1.成人中樞神經系統疾患(含外傷造成)：須符合下列診斷代碼(ICD-10-CM)：A39、B20、C71、C72、G00-G09、G23、G11、G95、G35-G37、G81、G54、I60-I67、S14.1+S12.0-S12.6,S24.1+S22.0,S34.1+S22.0-S32.0、S06.2-S06.9、S12.0-S12.6、S22.0-S32.0、S14.1、S34.1、S14.2、S14.3、S34.4。-ICD-10-CM(2023年版)：A39、B20、C71、C72、G00-G09、G23、G11、G95、G35-G37、G81、G54、I60-I67、P91.821、P91.822、P91.823、P91.829、S14.1+S12.0-S12.6、S24.1+S22.0、S34.1+S22.0-S32.0、S06.2-S06.9、S12.0-S12.6、S22.0-S32.0、S14.1、S34.1、S14.2、S14.3、S34.4(自一百十四年一月一日起適用)。(1)限因上述診斷住院期間及出院後六個月內。(2)治療項目三項以上，合計治療時間三十分鐘以上。(3)必須包含下列二項以上之治療項目：OT1、OT3、OT4、OT5、OT7、OT8、OT9、OT10、OT11、OT12。2.兒童中樞神經系統疾患(含外傷造成及罕見疾病)：(1)限從出生至未滿十二歲。(2)治療項目三項以上，合計治療時間三十分鐘以上。3.外科手術患者(含骨骼、神經、肌肉、燒燙傷之疾患)：須符合下列診斷代碼(ICD-10-CM)：S62.3、S62.6、S68.0、S68.1、S68.4、S68.5、S68.6、S68.7、S47、S57.0、S57.8、S67.0、S67.1、S67.2、S67.3、S67.9、S77、T22-T25、S44。(1)限因上述診斷手術實施後三個月內。(2)治療項目三項以上，合計治療時間三十分鐘以上。(3)必須包含下列二項以上之治療項目：OT2、OT5、OT6、OT7、OT8、OT9、OT10、OT11。註：1.治療項目OT1.姿態訓練PosturetrainingOT2.被動性關節運動PassiveR.O.M.OT3.坐站平衡訓練BalancetrainingOT4.移位訓練MovingtrainingOT5.日常生活訓練ADLtrainingOT6.肌力訓練MusclestrengthtrainingOT7.運動知覺訓練Motion-sensorytrainingOT8.上肢(下肢)功能訓練U/EorL/EfunctiontrainingOT9.上肢(下肢)義肢功能訓練ProsthosisfunctiontrainingU/EorL/EOT10.手(足)功能訓練(Handorfootfunctiontraining)OT11.協調訓練CoordinationtrainingOT12.知覺認知訓練CognitivetrainingOT13.團體治療GrouptherapyOT14.娛樂治療RecreationtherapyOT15.活動治療ActivitytherapyOT16.減痙攣活動SpasticityreductionmotionOT17.其他經保險人核可者2.43030B、43031C、43032C限復健專科醫師開具處方後，交由相關治療專業人員親自實施始可申報。3.43027C、43028C、43031C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy-Complicated"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43031C",
      "display" : "複雜Complicated：實施本項須符合於下列適應症及其項目規定",
      "definition" : "1.成人中樞神經系統疾患(含外傷造成)：須符合下列診斷代碼(ICD-10-CM)：A39、B20、C71、C72、G00-G09、G23、G11、G95、G35-G37、G81、G54、I60-I67、S14.1+S12.0-S12.6,S24.1+S22.0,S34.1+S22.0-S32.0、S06.2-S06.9、S12.0-S12.6、S22.0-S32.0、S14.1、S34.1、S14.2、S14.3、S34.4。-ICD-10-CM(2023年版)：A39、B20、C71、C72、G00-G09、G23、G11、G95、G35-G37、G81、G54、I60-I67、P91.821、P91.822、P91.823、P91.829、S14.1+S12.0-S12.6、S24.1+S22.0、S34.1+S22.0-S32.0、S06.2-S06.9、S12.0-S12.6、S22.0-S32.0、S14.1、S34.1、S14.2、S14.3、S34.4(自一百十四年一月一日起適用)。(1)限因上述診斷住院期間及出院後六個月內。(2)治療項目三項以上，合計治療時間三十分鐘以上。(3)必須包含下列二項以上之治療項目：OT1、OT3、OT4、OT5、OT7、OT8、OT9、OT10、OT11、OT12。2.兒童中樞神經系統疾患(含外傷造成及罕見疾病)：(1)限從出生至未滿十二歲。(2)治療項目三項以上，合計治療時間三十分鐘以上。3.外科手術患者(含骨骼、神經、肌肉、燒燙傷之疾患)：須符合下列診斷代碼(ICD-10-CM)：S62.3、S62.6、S68.0、S68.1、S68.4、S68.5、S68.6、S68.7、S47、S57.0、S57.8、S67.0、S67.1、S67.2、S67.3、S67.9、S77、T22-T25、S44。(1)限因上述診斷手術實施後三個月內。(2)治療項目三項以上，合計治療時間三十分鐘以上。(3)必須包含下列二項以上之治療項目：OT2、OT5、OT6、OT7、OT8、OT9、OT10、OT11。註：1.治療項目OT1.姿態訓練PosturetrainingOT2.被動性關節運動PassiveR.O.M.OT3.坐站平衡訓練BalancetrainingOT4.移位訓練MovingtrainingOT5.日常生活訓練ADLtrainingOT6.肌力訓練MusclestrengthtrainingOT7.運動知覺訓練Motion-sensorytrainingOT8.上肢(下肢)功能訓練U/EorL/EfunctiontrainingOT9.上肢(下肢)義肢功能訓練ProsthosisfunctiontrainingU/EorL/EOT10.手(足)功能訓練(Handorfootfunctiontraining)OT11.協調訓練CoordinationtrainingOT12.知覺認知訓練CognitivetrainingOT13.團體治療GrouptherapyOT14.娛樂治療RecreationtherapyOT15.活動治療ActivitytherapyOT16.減痙攣活動SpasticityreductionmotionOT17.其他經保險人核可者2.43030B、43031C、43032C限復健專科醫師開具處方後，交由相關治療專業人員親自實施始可申報。3.43027C、43028C、43031C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Complicated"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43032C",
      "display" : "複雜Complicated：實施本項須符合於下列適應症及其項目規定",
      "definition" : "1.成人中樞神經系統疾患(含外傷造成)：須符合下列診斷代碼(ICD-10-CM)：A39、B20、C71、C72、G00-G09、G23、G11、G95、G35-G37、G81、G54、I60-I67、S14.1+S12.0-S12.6,S24.1+S22.0,S34.1+S22.0-S32.0、S06.2-S06.9、S12.0-S12.6、S22.0-S32.0、S14.1、S34.1、S14.2、S14.3、S34.4。-ICD-10-CM(2023年版)：A39、B20、C71、C72、G00-G09、G23、G11、G95、G35-G37、G81、G54、I60-I67、P91.821、P91.822、P91.823、P91.829、S14.1+S12.0-S12.6、S24.1+S22.0、S34.1+S22.0-S32.0、S06.2-S06.9、S12.0-S12.6、S22.0-S32.0、S14.1、S34.1、S14.2、S14.3、S34.4(自一百十四年一月一日起適用)。(1)限因上述診斷住院期間及出院後六個月內。(2)治療項目三項以上，合計治療時間三十分鐘以上。(3)必須包含下列二項以上之治療項目：OT1、OT3、OT4、OT5、OT7、OT8、OT9、OT10、OT11、OT12。2.兒童中樞神經系統疾患(含外傷造成及罕見疾病)：(1)限從出生至未滿十二歲。(2)治療項目三項以上，合計治療時間三十分鐘以上。3.外科手術患者(含骨骼、神經、肌肉、燒燙傷之疾患)：須符合下列診斷代碼(ICD-10-CM)：S62.3、S62.6、S68.0、S68.1、S68.4、S68.5、S68.6、S68.7、S47、S57.0、S57.8、S67.0、S67.1、S67.2、S67.3、S67.9、S77、T22-T25、S44。(1)限因上述診斷手術實施後三個月內。(2)治療項目三項以上，合計治療時間三十分鐘以上。(3)必須包含下列二項以上之治療項目：OT2、OT5、OT6、OT7、OT8、OT9、OT10、OT11。註：1.治療項目OT1.姿態訓練PosturetrainingOT2.被動性關節運動PassiveR.O.M.OT3.坐站平衡訓練BalancetrainingOT4.移位訓練MovingtrainingOT5.日常生活訓練ADLtrainingOT6.肌力訓練MusclestrengthtrainingOT7.運動知覺訓練Motion-sensorytrainingOT8.上肢(下肢)功能訓練U/EorL/EfunctiontrainingOT9.上肢(下肢)義肢功能訓練ProsthosisfunctiontrainingU/EorL/EOT10.手(足)功能訓練(Handorfootfunctiontraining)OT11.協調訓練CoordinationtrainingOT12.知覺認知訓練CognitivetrainingOT13.團體治療GrouptherapyOT14.娛樂治療RecreationtherapyOT15.活動治療ActivitytherapyOT16.減痙攣活動SpasticityreductionmotionOT17.其他經保險人核可者2.43030B、43031C、43032C限復健專科醫師開具處方後，交由相關治療專業人員親自實施始可申報。3.43027C、43028C、43031C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Occupational Therapy-Complicated"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43033C",
      "display" : "斜頸矯正(治療費)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Torticollis correction orthosis"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43034C",
      "display" : "頸部固定副木(治療費)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Neck splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43035C",
      "display" : "斜頸矯正(材料費)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Torticollis correction orthosis(material)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43036C",
      "display" : "頸部固定副木(材料費)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Neck splint(material)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43037C",
      "display" : "肩部固定副木(治療費)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Shoulder splint"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "43038C",
      "display" : "肩部固定副木(材料費)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Shoulder splint (material)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44",
      "display" : "醫療院所-孕產婦檢查妊娠第二期第五次(妊娠十三週未滿二十九週)",
      "definition" : "檢查項目:1.例行產檢。2.早產徵兆及孕期營養衛教指導。",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44002B",
      "display" : "簡單Simple：指治療項目1項以上，合計治療時間未滿三十分鐘之簡單治療。",
      "definition" : "註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法AudiovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44003C",
      "display" : "簡單Simple：指治療項目1項以上，合計治療時間未滿三十分鐘之簡單治療。",
      "definition" : "註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法AudiovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Simple"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44005B",
      "display" : "中度Moderate：指治療項目二項以上，合計治療時間三十分鐘至五十分鐘以內之中度治療。",
      "definition" : "註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法AudiovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Moderate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44006C",
      "display" : "中度Moderate：指治療項目2項以上，合計治療時間三十分鐘至五十分鐘以內之中度治療。",
      "definition" : "註：1.治療項目ST1.聽能瞭解訓練ST2.口語訓練ST3.輔導溝通法ST4.認讀訓練ST5.書寫訓練ST6.視知覺訓練ST7.高階層認知訓練ST8.觸覺肌動法ST9.口腔動作訓練ST10發音部位法ST11.聽辨訓練ST12.節律訓練ST13.視聽迴饋法ST14.語言分析ST15.其他經保險人核可者。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Moderate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44008B",
      "display" : "複雜Complicated",
      "definition" : "1.指治療項目四項以上，合計治療時間三十分鐘以上之複雜治療；若治療對象為未滿十三歲者，則無治療時間之限制。2.個案需符合下列任一適應症，其診斷代碼(ICD-10-CM)如下：(1)C00-C41、C43-C58、C60-C86、C88、C90-C96、C4A、C7A、C7B、D03、D45、J910、R180、G450-G468、I60-I69、J380、R49、S019、S021-S024、S026-S029、S060、S063-S066、S068-S069，且限因上述診斷住院期間及出院後十二個月內。-ICD-10-CM(2023年版)：C00-C41、C43-C58、C60-C86、C88、C90-C96、C4A、C7A、C7B、D03、D45、J91.0、R18.0、G45.0-G46.8、I60-I69、P91.821、P91.822、P91.823、P91.829、J38.0、R49、S01.9、S02.1-S02.4、S02.6-S02.9、S06.0、S06.3-S06.6、S06.8-S06.9、S06.8A1A、S06.8A2A、S06.8A3A、S06.8A4A、S06.8A5A、S06.8A6A、S06.8A7A及S06.8A8A，且限因上述診斷住院期間及出院後十二個月內(自一百十四年一月一日起適用)。(2)F840、G80、H90-H91、F80-F82、F88、F89、H9325、F480，且治療對象需為未滿十三歲。3.需包含下列二項以上之治療項目：ST1、ST2、ST3、ST7、ST9、ST13、ST14。註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法AudiovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者2.44011C、44012C、44015C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Complicated"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44009C",
      "display" : "複雜Complicated",
      "definition" : "1.指治療項目四項以上，合計治療時間三十分鐘以上之複雜治療；若治療對象為未滿十三歲者，則無治療時間之限制。2.個案需符合下列任一適應症，其診斷代碼(ICD-10-CM)如下：(1)C00-C41、C43-C58、C60-C86、C88、C90-C96、C4A、C7A、C7B、D03、D45、J910、R180、G450-G468、I60-I69、J380、R49、S019、S021-S024、S026-S029、S060、S063-S066、S068-S069，且限因上述診斷住院期間及出院後十二個月內。-ICD-10-CM(2023年版)：C00-C41、C43-C58、C60-C86、C88、C90-C96、C4A、C7A、C7B、D03、D45、J91.0、R18.0、G45.0-G46.8、I60-I69、P91.821、P91.822、P91.823、P91.829、J38.0、R49、S01.9、S02.1-S02.4、S02.6-S02.9、S06.0、S06.3-S06.6、S06.8-S06.9、S06.8A1A、S06.8A2A、S06.8A3A、S06.8A4A、S06.8A5A、S06.8A6A、S06.8A7A及S06.8A8A，且限因上述診斷住院期間及出院後十二個月內(自一百十四年一月一日起適用)。(2)F840、G80、H90-H91、F80-F82、F88、F89、H9325、F480，且治療對象需為未滿十三歲。3.需包含下列二項以上之治療項目：ST1、ST2、ST3、ST7、ST9、ST13、ST14。註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法AudiovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者2.44011C、44012C、44015C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Complicated"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44010C",
      "display" : "語言治療評估",
      "definition" : "註:語言治療評估須由復健科專科醫師或語言治療專業人員親自實施始可申報，同一病患治療期間一個月限申報一次，並須將評估項目、現有問題、短及長程治療目標及治療計畫記錄於病歷內。同一治療期間超過三個月者，不予支付。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "44011C",
      "display" : "中度Moderate：指治療項目二項以上，合計治療時間三十分鐘至五十分鐘以內之中度治療。",
      "definition" : "1.治療項目ST1.聽能瞭解訓練ST2.口語訓練ST3.輔導溝通法ST4.認讀訓練ST5.書寫訓練ST6.視知覺訓練ST7.高階層認知訓練ST8.觸覺肌動法ST9.口腔動作訓練ST10發音部位法ST11.聽辨訓練ST12.節律訓練ST13.視聽迴饋法ST14.語言分析ST15.其他經保險人核可者。2.44011C、44012C、44015C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Moderate"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44012C",
      "display" : "複雜Complicated",
      "definition" : "1.指治療項目四項以上，合計治療時間三十分鐘以上之複雜治療；若治療對象為未滿十三歲者，則無治療時間之限制。2.個案需符合下列任一適應症，其診斷代碼(ICD-10-CM)如下：(1)C00-C41、C43-C58、C60-C86、C88、C90-C96、C4A、C7A、C7B、D03、D45、J910、R180、G450-G468、I60-I69、J380、R49、S019、S021-S024、S026-S029、S060、S063-S066、S068-S069，且限因上述診斷住院期間及出院後十二個月內。-ICD-10-CM(2023年版)：C00-C41、C43-C58、C60-C86、C88、C90-C96、C4A、C7A、C7B、D03、D45、J91.0、R18.0、G45.0-G46.8、I60-I69、P91.821、P91.822、P91.823、P91.829、J38.0、R49、S01.9、S02.1-S02.4、S02.6-S02.9、S06.0、S06.3-S06.6、S06.8-S06.9、S06.8A1A、S06.8A2A、S06.8A3A、S06.8A4A、S06.8A5A、S06.8A6A、S06.8A7A及S06.8A8A，且限因上述診斷住院期間及出院後十二個月內(自一百十四年一月一日起適用)。(2)F840、G80、H90-H91、F80-F82、F88、F89、H9325、F480，且治療對象需為未滿十三歲。3.需包含下列二項以上之治療項目：ST1、ST2、ST3、ST7、ST9、ST13、ST14。註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法AudiovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者2.44011C、44012C、44015C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy-Complicated"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44014B",
      "display" : "中度-複雜：1.指治療項目三項以上，合計治療時間三十分鐘以上之中度治療；若治療對象為未滿十三歲者，則無治療時間之限制。2.需包含下列二項以上之治療項目：ST1、ST2、ST3、ST7、ST9、ST13、ST14。",
      "definition" : "註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法diovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44015C",
      "display" : "中度-複雜：1.指治療項目三項以上，合計治療時間三十分鐘以上之中度治療；若治療對象為未滿十三歲者，則無治療時間之限制。2.需包含下列二項以上之治療項目：ST1、ST2、ST3、ST7、ST9、ST13、ST14。",
      "definition" : "1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法diovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者2.44011C、44012C、44015C申報資格如下：(1)復健科專科醫師開設之基層院所。(2)聘有專任復健專科醫師之基層院所且由復健專科(含專任及支援)醫師所開立之處方。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44016C",
      "display" : "中度-複雜：1.指治療項目三項以上，合計治療時間三十分鐘以上之中度治療；若治療對象為未滿十三歲者，則無治療時間之限制。2.需包含下列二項以上之治療項目：ST1、ST2、ST3、ST7、ST9、ST13、ST14。",
      "definition" : "註：1.治療項目ST1.聽能瞭解訓練AuditorycomprehensiontrainingST2.口語訓練VerbalproductionST3.輔導溝通法AugmentativecemmunicationsystemST4.認讀訓練ReadinhgtrainingST5.書寫訓練WritingtrainingST6.視知覺訓練VisualperceptionST7.高階層認知訓練HighlevelcognitivefunctiontrainingST8.觸覺肌動法TactilestimulationST9.口腔動作訓練OralTx.ST10發音部位法PhoneticplacementST11.聽辨訓練AuditorydiscriminationST12.節律訓練RhythmtrainingST13.視聽迴饋法diovisualfeedbackmonitoringST14.語言分析AcousticanalysisST15.其他經保險人核可者",
      "designation" : [
        {
          "language" : "en",
          "value" : "Communication Therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44501B",
      "display" : "特殊心理社會治療－成人",
      "definition" : "註：從系統觀點探討個體本身與環境特質，運用心理治療原理介入，形成情緒、認知與行為的改變，以提昇病人社會心理適應能力。針對不同類型病人之治療內容包含：1.嬰幼兒發展治療(Neurodevelopmentaltherapy)2.遊戲治療(Playtherapy)3.認知行為治療(Rational-Emotivetherapy)4.行為功能分析與行為改變技術(Functionalbehavioralanalysisandbehavioraltherapy)5.神經心理復健策略(Neuropsychologicalrehabilitationstrategies)6.職業諮商(Vocationalcounseling)7.其他(Others)。本項治療限由臨床心理師執行，申報時應附復健科專科醫師醫囑及簽名。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Re-educative psychosocial individual psychotherapy－adult"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44502B",
      "display" : "特殊心理社會治療－六歲以上至未滿十六歲",
      "definition" : "從系統觀點探討個體本身與環境特質，運用心理治療原理介入，形成情緒、認知與行為的改變，以提昇病人社會心理適應能力。針對不同類型病人之治療內容包含：1.嬰幼兒發展治療(Neurodevelopmentaltherapy)2.遊戲治療(Playtherapy)3.認知行為治療(Rational-Emotivetherapy)4.行為功能分析與行為改變技術(Functionalbehavioralanalysisandbehavioraltherapy)5.神經心理復健策略(Neuropsychologicalrehabilitationstrategies)6.職業諮商(Vocationalcounseling)7.其他(Others)。本項治療限由臨床心理師執行，申報時應附復健科專科醫師醫囑及簽名。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Re-educative psychosocial individual psychotherapy－6 to 15 years old"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44503B",
      "display" : "特殊心理社會治療－未滿六歲",
      "definition" : "註：從系統觀點探討個體本身與環境特質，運用心理治療原理介入，形成情緒、認知與行為的改變，以提昇病人社會心理適應能力。針對不同類型病人之治療內容包含：1.嬰幼兒發展治療(Neurodevelopmentaltherapy)2.遊戲治療(Playtherapy)3.認知行為治療(Rational-Emotivetherapy)4.行為功能分析與行為改變技術(Functionalbehavioralanalysisandbehavioraltherapy)5.神經心理復健策略(Neuropsychologicalrehabilitationstrategies)6.職業諮商(Vocationalcounseling)7.其他(Others)。本項治療限由臨床心理師執行，申報時應附復健科專科醫師醫囑及簽名。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Re-educative psychosocial individual psychotherapy－under 6 years old"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44504B",
      "display" : "支持性心理社會治療",
      "definition" : "註：利用支持性心理治療技巧，以減輕症狀影響病人的程度，協助復健病人了解疾病及相關治療，應於復健科醫師指導下由復健醫療團隊之專業成員執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Supportive psychosocial individual psychotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "44505B",
      "display" : "特殊心理社會團體治療(每人次)",
      "definition" : "註：經由團體前準備、團體進行、團體後之整理、團體報告之撰寫，利用特殊團體心理治療原理、團體中結構特性、人際互動及活動參與過程，協助病人覺察不良行為、建立適應性行為模式、學習因應問題及解決問題技巧、獲得同儕支持之正向情緒。本項治療限由復健科醫師或臨床心理師執行，申報時應附復健科專科醫師之醫囑及簽名，一次最多以十五人為限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Re-educative psychosocial group psychotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45",
      "display" : "醫療院所-孕產婦檢查妊娠第二期第六次(妊娠十三週未滿二十九週)",
      "definition" : "註:本項業務自95.1.1起移歸國民健康局管理。檢查項目:1.例行產檢。",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "45004C",
      "display" : "痙攣性電療法",
      "definition" : "麻醉、護理、藥物費包含在內。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Electroconvulsive therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45010C",
      "display" : "支持性心理治療",
      "definition" : "註:利用支持性心理治療技巧，以減輕症狀影響病人的程度，協助精神疾病病人了解疾病及相關治療，應於精神科醫師指導下由精神治療團隊之各專業成員執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Supportive individual psychotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45013C",
      "display" : "深度心理治療(每四十分鐘)-成人",
      "definition" : "註:利用深度心理治療技術，以協助病人改善客體關係(objectrelation)、強化心理防衛機轉、解決內在衝突或改善其認知行為偏差。本項治療限由精神科專科醫師執行，申報時並應附治療紀錄。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intensive individual psychotherapy-adult"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45016C",
      "display" : "支持性團體心理治療(每人次)",
      "definition" : "註:經由團體前準備、團體進行、團體後之整理、團體報告之撰寫，利用一般團體治療技巧以協助病人了解疾病及相關治療，或引導病人面對現實的生活，作出負責的行為。本項治療應由精神科治療團隊之各專業成員執行。一次最多以二十五人為限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Supportive group psychotherapy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "45019C",
      "display" : "深度團體心理治療(每人次)",
      "definition" : "註:經由團體前準備、團體進行、團體後之討論、團體後之整理、團體報告之撰寫，利用深度團體心理治療技術及治療因子，以協助團體中的病人洞察心理發展過程、改善客體關係(objectrelation)、強化心理防衛機轉、解決內在衝突。本項治療限由精神科專科醫師執行，申報時並應附治療紀錄。一次最多以十人為限。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Intensive group psychotherapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45022C",
      "display" : "活動治療(天)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Activity therapy (day)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45031C",
      "display" : "一般職能治療(次)",
      "definition" : "註:1.一般治療項目1~2項。2.合計治療時間40分鐘者。3.一般治療項目包含：(1)娛樂治療。(2)產業治療。(3)日常生活功能訓練。(4)手眼協調訓練。(5)社交功能訓練。(6)休閒運動功能訓練。(7)運動感覺訓練。(8)平衡訓練。",
      "designation" : [
        {
          "language" : "en",
          "value" : "General Occupational therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45034C",
      "display" : "精神科藥物治療特別處理費(每日)",
      "definition" : "註:1.為增強不合作個案服藥順從性所需之相關處置。2.本項治療限醫師醫囑執行。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Psychiatric special drug therapy (day)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45037C",
      "display" : "精神科住院病人特別處理費(每日)",
      "definition" : "1.病人因受精神症狀影響，有攻擊或自傷之虞，治療團隊必須經常照護，並提供必要之心理、行為或藥物處置，以避免危險行為之發生。2.本項治療限精神科專科醫師之醫囑執行。3.不得同時申報45034C、45040C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Psychiatric inpatient special care (day)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45040C",
      "display" : "精神科特別護理(每日)",
      "definition" : "註：1.針對精神科住院病患之行為問題、自我照顧、情緒障礙、知覺障礙、思考障礙等，實施具體的護理照護、協助身體照顧、環境安排、及引導人際互動。2.本項治療限由精神專科醫師醫囑及簽名才能申報。3.加護病房病人不另申報本項目。4.不得同時申報45037C、45070C。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Psychiative nursing care (day)"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45043C",
      "display" : "生理回饋治療之執行(每次)",
      "definition" : "註:限曾經受過精神醫療訓練之醫事人員或社工師執行，每次療程限申報12次。申報時並需附個別之生理回饋儀之數據報告。",
      "designation" : [
        {
          "language" : "en",
          "value" : "Biofeedback therapy"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-07-01"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "45046C",
      "display" : "生理心理功能檢查-成人",
      "definition" : "註:包括MSE(MiniMentalStateTest,BDI等)",
      "designation" : [
        {
          "language" : "en",
          "value" : "Psychophysiological function examination- adult"
        }
      ],
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDa