# 臺灣健保署就醫科別 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署就醫科別 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw | *Version*:2024-05-27 |
| Active as of 2024-05-27 | *Computable Name*:TWMedicalConsultationDepartmentNHI |
| **Copyright/Legal**: 衛生福利部中央健康保險署 | |

 
臺灣健保署就醫科別，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「就醫科別（2022/8/2版本）」。 
代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWMedicalConsultationDepartmentNHI](ValueSet-medical-consultation-department-nhi-tw.md)
* [TWMedicalConsultationDepartment](ValueSet-medical-consultation-department-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medical-consultation-department-nhi-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw",
  "version" : "2024-05-27",
  "name" : "TWMedicalConsultationDepartmentNHI",
  "title" : "臺灣健保署就醫科別",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-05-27",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署就醫科別，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「就醫科別（2022/8/2版本）」。\n\n代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
  "copyright" : "衛生福利部中央健康保險署",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 50,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "00",
      "display" : "不分科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "01",
      "display" : "家醫科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "02",
      "display" : "內科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "03",
      "display" : "外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "04",
      "display" : "兒科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "05",
      "display" : "婦產科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "06",
      "display" : "骨科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "07",
      "display" : "神經外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "08",
      "display" : "泌尿科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "09",
      "display" : "耳鼻喉科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "10",
      "display" : "眼科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "11",
      "display" : "皮膚科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "12",
      "display" : "神經科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "13",
      "display" : "精神科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "14",
      "display" : "復健科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "15",
      "display" : "整形外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "22",
      "display" : "急診醫學科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "23",
      "display" : "職業醫學科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "2A",
      "display" : "結核科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "2B",
      "display" : "洗腎科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "40",
      "display" : "牙科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "60",
      "display" : "中醫科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "81",
      "display" : "麻醉科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "82",
      "display" : "放射線科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "83",
      "display" : "病理科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "84",
      "display" : "核醫科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AA",
      "display" : "消化內科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AB",
      "display" : "心臟血管內科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AC",
      "display" : "胸腔內科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AD",
      "display" : "腎臟內科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AE",
      "display" : "風濕免疫科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AF",
      "display" : "血液腫瘤科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AG",
      "display" : "內分泌科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AH",
      "display" : "感染科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AI",
      "display" : "潛醫科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AJ",
      "display" : "胸腔暨重症加護",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "AK",
      "display" : "老人醫學科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "直腸外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "BB",
      "display" : "心臟血管外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "BC",
      "display" : "胸腔外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "BD",
      "display" : "消化外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "小兒外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "CB",
      "display" : "新生兒科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "DA",
      "display" : "疼痛科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "EA",
      "display" : "居家照護",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "FA",
      "display" : "放射診斷科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "FB",
      "display" : "放射腫瘤科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "GA",
      "display" : "口腔顏面外科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "HA",
      "display" : "脊椎骨科",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "TB",
      "display" : "肺結核",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2024-05-27"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
