# 臺灣健保署2014年中文版ICD-10-CM - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣健保署2014年中文版ICD-10-CM 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2014-tw | *Version*:2017-07-19 |
| Active as of 2014-07-19 | *Computable Name*:TW2014ICD10CM |
| **Copyright/Legal**: World Health Organization (WHO) | |

 
臺灣健保署2014年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。
代碼出版日期：2022-07-19；資料所屬單位：衛生福利部中央健康保險署。 
**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。** 
因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TW2014ICD10CM](ValueSet-icd-10-cm-2014-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "icd-10-cm-2014-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2014-tw",
  "version" : "2017-07-19",
  "name" : "TW2014ICD10CM",
  "title" : "臺灣健保署2014年中文版ICD-10-CM",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-07-19",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署2014年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。    \n代碼出版日期：2022-07-19；資料所屬單位：衛生福利部中央健康保險署。\n\n*因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。*\n\n因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱\n\n",
  "copyright" : "World Health Organization (WHO)",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 5,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "A00",
      "display" : "霍亂",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2014-07-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "A00.0",
      "display" : "血清型01 cholerae霍亂弧菌所致之霍亂",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2014-07-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "A00.1",
      "display" : "血清型01 eltor霍亂弧菌所致之霍亂",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2014-07-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "A00.9",
      "display" : "霍亂",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2014-07-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "A01",
      "display" : "傷寒及副傷寒",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2014-07-19"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
