# 臺灣醫事司醫事人員類別 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CodeSystem: 臺灣醫事司醫事人員類別 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/health-professional-tw | *Version*:2022-01-28 |
| Active as of 2022-01-28 | *Computable Name*:TWHealthProfessional |
| **Copyright/Legal**: 衛生福利部統計處 | |

 
臺灣醫事司醫事人員類別，參照至[醫事人員基本資料檔](https://www.google.com/url?client=internal-element-cse&cx=012254495936870409035:lzvyrg0mtim&q=https://www.mohw.gov.tw/dl-40452-1441ca2e-cde9-4345-b681-f9a20d5176b5.html&sa=U&ved=2ahUKEwjg5MCYrZn5AhUTI6YKHV6mC_s4FBAWegQIBBAC&usg=AOvVaw1q62t2W0hhdi0WC6e_nh1m)中的「人員類別（2022/01/28修訂）」。 
代碼出版日期：2022-01-28；資料所屬單位：衛生福利部醫事司。 
**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TWHealthProfessionalSCT](ValueSet-health-professional-sct-tw.md)
* [TWHealthProfessional](ValueSet-health-professional-tw.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "health-professional-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/health-professional-tw",
  "version" : "2022-01-28",
  "name" : "TWHealthProfessional",
  "title" : "臺灣醫事司醫事人員類別",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-01-28",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣醫事司醫事人員類別，參照至[醫事人員基本資料檔](https://www.google.com/url?client=internal-element-cse&cx=012254495936870409035:lzvyrg0mtim&q=https://www.mohw.gov.tw/dl-40452-1441ca2e-cde9-4345-b681-f9a20d5176b5.html&sa=U&ved=2ahUKEwjg5MCYrZn5AhUTI6YKHV6mC_s4FBAWegQIBBAC&usg=AOvVaw1q62t2W0hhdi0WC6e_nh1m)中的「人員類別（2022/01/28修訂）」。\n\n代碼出版日期：2022-01-28；資料所屬單位：衛生福利部醫事司。\n\n*因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。*",
  "copyright" : "衛生福利部統計處",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 32,
  "property" : [
    {
      "code" : "effectiveDate",
      "uri" : "http://hl7.org/fhir/concept-properties#effectiveDate",
      "description" : "生效日期",
      "type" : "dateTime"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "狀態",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "語言治療師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "牙體技術師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "聽力師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "牙體技術生",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "5",
      "display" : "驗光師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "6",
      "display" : "驗光生",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "A",
      "display" : "西醫師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "B",
      "display" : "中醫師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "牙醫師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "藥師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "藥劑生",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "護理師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "G",
      "display" : "護士",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "助產士",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "助產師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "J",
      "display" : "醫事檢驗師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "K",
      "display" : "醫事檢驗生",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "鑲牙生",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "中藥員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "齒模員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "非醫事人員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "接骨員",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "Q",
      "display" : "物理治療師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "職能治療師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "醫事放射師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "醫事放射士",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "物理治療生",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "呼吸治療師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "W",
      "display" : "職能治療生",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "X",
      "display" : "諮商心理師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "Y",
      "display" : "臨床心理師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "Z",
      "display" : "營養師",
      "property" : [
        {
          "code" : "effectiveDate",
          "valueDateTime" : "2022-01-28"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
