# 臺灣核心-用戶端(TW Core Client) - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## CapabilityStatement: 臺灣核心-用戶端(TW Core Client) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/CapabilityStatement/CapabilityStatementTWCoreClient | *Version*:1.0.0 | |
| Active as of 2024-08-31 | *Responsible:*[衛生福利部](https://www.mohw.gov.tw/) | *Computable Name*:CapabilityStatementTWCoreClient |

 
臺灣核心實作指引（TW Core IG）用戶端（Client）之能力聲明 

 [Raw OpenAPI-Swagger Definition file](CapabilityStatementTWCoreClient.openapi.json) | [Download](CapabilityStatementTWCoreClient.openapi.json) 

## 臺灣核心-用戶端（TW Core Client）

* 實作指引版本：1.0.0
* FHIR版本：4.0.1
* 支援格式：`json`, `xml`
* 發佈日：2024-08-31
* 發佈者：衛生福利部

## Client的FHIR RESTful功能要求

### 模式：client

* 臺灣核心-用戶端（TW Core Client） **建議應該（SHOULD）**
1. 使用臺灣核心-伺服端（TW Core Server）能力聲明中的查詢參數，支援讀取和查詢一個或多個臺灣核心Profile（s）。

* **安全性**
1. 有關要求和建議，請參閱一般安全注意事項部分。

* **系統互動能力：**
* **可能可以（MAY）**支援交易互動（`transaction` interaction）。
* **可能可以（MAY）**支援批次互動（`batch` interaction）。
* **可能可以（MAY）**支援查詢系統互動（`search-system` interaction）。

### Resources或Profiles的RESTful功能

#### Summary

共有32類Resources支援查詢，查詢參數如表列：

* ✓ = 建議應該（SHOULD）
* ⚪ = 可能可以（MAY）

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AllergyIntolerance](#AllergyIntolerance1-1) | [臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, clinical-status |  |
| [Bundle](#Bundle1-2) | [臺灣核心-資料交換基本單位（TW Core Bundle）](StructureDefinition-Bundle-twcore.md)**支援的Profiles：**[臺灣核心-資料交換基本單位-文件 （TW Core Bundle Document）](StructureDefinition-Bundle-document-twcore.md)[臺灣核心-資料交換基本單位-訊息（TW Core Bundle Message）](StructureDefinition-Bundle-message-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, identifier |  |
| [CarePlan](#CarePlan1-3) | [臺灣核心-照護計畫（TW Core CarePlan）](StructureDefinition-CarePlan-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | patient + category,patient + category + date,patient + category + status,patient + category + status + date |  |
| [CareTeam](#CareTeam1-4) | [臺灣核心-照護團隊（TW Core CareTeam）](StructureDefinition-CareTeam-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | patient + status,patient + role |  |
| [Composition](#Composition1-5) | [臺灣核心-臨床文件架構（TW Core Composition）](StructureDefinition-Composition-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, type, subject |  |
| [Condition](#Condition1-6) | [臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, clinical-status, code, subject, onset-date, abatement-date, severity |  |
| [Coverage](#Coverage1-7) | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | patient |  |
| [Device](#Device1-8) | [臺灣核心-植入式裝置（TW Core Implantable Device）](StructureDefinition-Device-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | patient,patient + type,patient + status |  |
| [DiagnosticReport](#DiagnosticReport1-9) | [臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, subject, category, code, date |  |
| [DocumentReference](#DocumentReference1-10) | [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, subject |  |
| [Encounter](#Encounter1-11) | [臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, class, date, identifier, location, subject, status |  |
| [Goal](#Goal1-12) | [臺灣核心-目標（TW Core Goal）](StructureDefinition-Goal-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | patient,patient + lifecycle-status,patient + target-date,patient + description |  |
| [ImagingStudy](#ImagingStudy1-13) | [臺灣核心-影像檢查（TW Core ImagingStudy）](StructureDefinition-ImagingStudy-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, subject, encounter, started |  |
| [Immunization](#Immunization1-14) | [臺灣核心-疫苗接種（TW Core Immunization）](StructureDefinition-Immunization-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | patient,patient + date,patient + status |  |
| [Location](#Location1-15) | [臺灣核心-地點（TW Core Location)](StructureDefinition-Location-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, address, name |  |
| [Media](#Media1-16) | [臺灣核心-多媒體（TW Core Media）](StructureDefinition-Media-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, subject |  |
| [Medication](#Medication1-17) | [臺灣核心-藥品（TW Core Medication）](StructureDefinition-Medication-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, code |  |
| [MedicationRequest](#MedicationRequest1-18) | [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, intent, subject, medication, encounter, authoredon |  |
| [MedicationDispense](#MedicationDispense1-19) | [臺灣核心-配藥或藥品調劑（TW Core MedicationDispense）](StructureDefinition-MedicationDispense-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, subject, medication |  |
| [MedicationStatement](#MedicationStatement1-20) | [臺灣核心-用藥聲明（TW Core MedicationStatement）](StructureDefinition-MedicationStatement-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, subject, medication |  |
| [MessageHeader](#MessageHeader1-21) | [臺灣核心-訊息表頭（TW Core MessageHeader）](StructureDefinition-MessageHeader-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, author, sender |  |
| [Observation](#Observation1-22) | 支援的Profiles：[臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）](StructureDefinition-Observation-averageBloodPressure-twcore.md)[臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）](StructureDefinition-Observation-careExperiencePreference-twcore.md)[臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）](StructureDefinition-Observation-clinical-result-twcore.md)[臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)[臺灣核心-職業（TW Core Observation Occupation）](StructureDefinition-Observation-occupation-twcore.md)[臺灣核心-妊娠計畫（TW Core Observation Pregnancy Intent）](StructureDefinition-Observation-pregnancy-intent-twcore.md)[臺灣核心-妊娠狀態（TW Core Observation Pregnancy Status）](StructureDefinition-Observation-pregnancy-status-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-性傾向（TW Core Observation Sexual Orientation）](StructureDefinition-Observation-sexual-orientation-twcore.md)[臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-吸菸狀態（TW Core Smoking Status Observation）](StructureDefinition-Observation-smoking-status-twcore.md)[臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference）](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)[臺灣核心-生命體徵（TW Core Observation Vital Signs）](StructureDefinition-Observation-vitalSigns-twcore.md)[臺灣核心-兒童及青少年身體質量指數（TW Core Pediatric BMI for Age Observation）](StructureDefinition-Observation-pediatric-bmi-age-twcore.md)[臺灣核心-血壓（TW Core Observation Blood Pressure）](StructureDefinition-Observation-bloodPressure-twcore.md)[臺灣核心-身體質量指數（TW Core Observation BMI）](StructureDefinition-Observation-bmi-twcore.md)[臺灣核心-身高（TW Core Observation Body Height）](StructureDefinition-Observation-body-height-twcore.md)[臺灣核心-體溫（TW Core Observation Body Temperature）](StructureDefinition-Observation-body-temperature-twcore.md)[臺灣核心-體重（TW Core Observation Body Weight）](StructureDefinition-Observation-body-weight-twcore.md)[臺灣核心-頭圍（TW Core Observation Head Circumference）](StructureDefinition-Observation-head-circumference-twcore.md)[臺灣核心-心率（TW Core Observation Heart Rate）](StructureDefinition-Observation-heart-rate-twcore.md)[臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）](StructureDefinition-Observation-pulse-oximetry-twcore.md)[臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）](StructureDefinition-Observation-respiratory-rate-twcore.md)[臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile）](StructureDefinition-Observation-pediatric-head-circumference-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, category, code, date, performer, status, subject,patient + category,patient + code,patient + category + date,patient + category + status,patient + category + _lastUpdated,patient + code + date | |
| [Organization](#Organization1-23) | [臺灣核心-機構（TW Core Organization）](StructureDefinition-Organization-twcore.md)**支援的Profiles：**[臺灣核心-政府機構（TW Core Organization Government）](StructureDefinition-Organization-govt-twcore.md)[臺灣核心-醫事機構（TW Core Organization Hospital Department）](StructureDefinition-Organization-hosp-twcore.md)[臺灣核心-公司行號（TW Core Organization Company）](StructureDefinition-Organization-co-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, identifier, name, type |  |
| [Patient](#Patient1-24) | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, birthdate, gender, identifier, name | $everything |
| [Practitioner](#Practitioner1-25) | [臺灣核心-健康照護服務提供者（TW Core Practitioner）](StructureDefinition-Practitioner-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, identifier, name |  |
| [PractitionerRole](#PractitionerRole1-26) | [臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）](StructureDefinition-PractitionerRole-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, identifier, specialty |  |
| [Procedure](#Procedure1-27) | [臺灣核心-處置或手術（TW Core Procedure）](StructureDefinition-Procedure-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, code, status, subject, date |  |
| [Provenance](#Provenance1-28) | [臺灣核心-出處（TW Core Provenance）](StructureDefinition-Provenance-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ |  |  |
| [QuestionnaireResponse](#QuestionnaireResponse1-29) | [臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, patient,patient + status,patient + authored,patient + questionnaire |  |
| [RelatedPerson](#RelatedPerson1-30) | [臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, patient,patient + name |  |
| [ServiceRequest](#ServiceRequest1-31) | [臺灣核心-服務請求（TW Core ServiceRequest）](StructureDefinition-ServiceRequest-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, patient,patient + category,patient + category + authored,patient + status,patient + code + authored |  |
| [Specimen](#Specimen1-32) | [臺灣核心-檢體（TW Core Specimen）](StructureDefinition-Specimen-twcore.md) | ⚪ | ✓ | ✓ | ✓ | ⚪ | ⚪ | ⚪ | _id, status, identifier, subject |  |

-------

#### 預期的遵從度： 建議應該（SHOULD） AllergyIntolerance

Base System Profile

[臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-AllergyIntolerance-id.md) | token | `GET [base]/AllergyIntolerance?_id=[id]`,`GET [base]/AllergyIntolerance/[id]` |
| **建議應該（SHOULD）** | [clinical-status](SearchParameter-AllergyIntolerance-clinical-status.md) | token | `GET [base]/AllergyIntolerance?clinical-status=[code]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Bundle

Base System Profile

[臺灣核心-資料交換基本單位（TW Core Bundle）](StructureDefinition-Bundle-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

支援的Profiles
[臺灣核心-資料交換基本單位-文件（TW Core Bundle Document）](StructureDefinition-Bundle-document-twcore.md)
[臺灣核心-資料交換基本單位-訊息（TW Core Bundle Message）](StructureDefinition-Bundle-message-twcore.md)

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Bundle-id.md) | token | `GET [base]/Bundle?_id=[id]`,`GET [base]/Bundle/[id]` |
| **建議應該（SHOULD）** | [identifier](SearchParameter-Bundle-identifier.md) | token | `GET [base]/Bundle?identifier={system|}[code]` |

 

#### 預期的遵從度： 建議應該（SHOULD） CarePlan

Base System Profile

[臺灣核心-照護計畫（TW Core CarePlan）](StructureDefinition-CarePlan-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） CareTeam

Base System Profile

[臺灣核心-照護團隊（TW Core CareTeam）](StructureDefinition-CareTeam-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） Composition

Base System Profile

[臺灣核心-臨床文件架構（TW Core Composition）](StructureDefinition-Composition-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Composition-id.md) | token | `GET [base]/Composition?_id=[id]`,`GET [base]/Composition/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-Composition-status.md) | token | `GET [base]/Composition?status=[code]` |
| **建議應該（SHOULD）** | [type](SearchParameter-Composition-type.md) | token | `GET [base]/Composition?type=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-Composition-subject.md) | reference | `GET [base]/Composition?subject=[subject]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Condition

Base System Profile

[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Condition-id.md) | token | `GET [base]/Condition?_id=[id]`,`GET [base]/Condition/[id]` |
| **建議應該（SHOULD）** | [clinical-status](SearchParameter-Condition-clinical-status.md) | token | `GET [base]/Condition?clinical-status=[code]` |
| **建議應該（SHOULD）** | [code](SearchParameter-Condition-code.md) | token | `GET [base]/Condition?code={system|}[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-Condition-subject.md) | reference | `GET [base]/Condition?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [onset-date](SearchParameter-Condition-onset-date.md) | date | `GET [base]/Condition?onset-date={gt|lt|ge|le}[date]` |
| **建議應該（SHOULD）** | [abatement-date](SearchParameter-Condition-abatement-date.md) | date | `GET [base]/Condition?abatement-date={gt|lt|ge|le}[date]` |
| **建議應該（SHOULD）** | [severity](SearchParameter-Condition-severity.md) | token | `GET [base]/Condition?severity={system|}[code]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Coverage

Base System Profile

[臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） Device

Base System Profile

[臺灣核心-植入式裝置（TW Core Implantable Device）](StructureDefinition-Device-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） DiagnosticReport

Base System Profile

[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-DiagnosticReport-id.md) | token | `GET [base]/DiagnosticReport?_id=[id]`,`GET [base]/DiagnosticReport/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-DiagnosticReport-status.md) | token | `GET [base]/DiagnosticReport?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-DiagnosticReport-subject.md) | reference | `GET [base]/DiagnosticReport?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [category](SearchParameter-DiagnosticReport-category.md) | token | `GET [base]/DiagnosticReport?category={system|}[code]` |
| **建議應該（SHOULD）** | [code](SearchParameter-DiagnosticReport-code.md) | token | `GET [base]/DiagnosticReport?code={system|}[code]` |
| **建議應該（SHOULD）** | [date](SearchParameter-DiagnosticReport-date.md) | date | `GET [base]/DiagnosticReport?date={gt|lt|ge|le}[date]` |

 

#### 預期的遵從度： 建議應該（SHOULD） DocumentReference

Base System Profile

[臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-DocumentReference-id.md) | token | `GET [base]/DocumentReference?_id=[id]`,`GET [base]/DocumentReference/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-DocumentReference-status.md) | token | `GET [base]/DocumentReference?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-DocumentReference-subject.md) | reference | `GET [base]/DocumentReference?subject={Type/}[id]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Encounter

Base System Profile

[臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Encounter-id.md) | token | `GET [base]/Encounter?_id=[id]`,`GET [base]/Encounter/[id]` |
| **建議應該（SHOULD）** | [class](SearchParameter-Encounter-class.md) | token | `GET [base]/Encounter?class=[code]` |
| **建議應該（SHOULD）** | [date](SearchParameter-Encounter-date.md) | date | `GET [base]/Encounter?date={gt|lt|ge|le}[date]` |
| **建議應該（SHOULD）** | [identifier](SearchParameter-Encounter-identifier.md) | token | `GET [base]/Encounter?identifier={system|}[code]` |
| **建議應該（SHOULD）** | [location](SearchParameter-Encounter-location.md) | reference | `GET [base]/Encounter?location={Type/}[id]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-Encounter-subject.md) | reference | `GET [base]/Encounter?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-Encounter-status.md) | token | `GET [base]/Encounter?status=[code]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Goal

Base System Profile

[臺灣核心-目標（TW Core Goal）](StructureDefinition-Goal-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） ImagingStudy

Base System Profile

[臺灣核心-影像檢查（TW Core ImagingStudy）](StructureDefinition-ImagingStudy-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-ImagingStudy-id.md) | token | `GET [base]/ImagingStudy?_id=[id]`,`GET [base]/ImagingStudy/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-ImagingStudy-status.md) | token | `GET [base]/ImagingStudy?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-ImagingStudy-subject.md) | reference | `GET [base]/ImagingStudy?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [encounter](SearchParameter-ImagingStudy-encounter.md) | reference | `GET [base]/ImagingStudy?encounter={Type/}[id]` |
| **建議應該（SHOULD）** | [started](SearchParameter-ImagingStudy-started.md) | date | `GET [base]/ImagingStudy?started={gt|lt|ge|le}[date]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Immunization

Base System Profile

[臺灣核心-疫苗接種（TW Core Immunization）](StructureDefinition-Immunization-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） Location

Base System Profile

[臺灣核心-地點（TW Core Location)](StructureDefinition-Location-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Location-id.md) | token | `GET [base]/Location?_id=[id]`,`GET [base]/Location/[id]` |
| **建議應該（SHOULD）** | [address](SearchParameter-Location-address.md) | string | `GET [base]/Location?address=[string]` |
| **建議應該（SHOULD）** | [name](SearchParameter-Location-name.md) | string | `GET [base]/Location?name=[string]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Media

Base System Profile

[臺灣核心-多媒體（TW Core Media）](StructureDefinition-Media-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Media-id.md) | token | `GET [base]/Media?_id=[id]`,`GET [base]/Media/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-Media-status.md) | token | `GET [base]/Media?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-Media-subject.md) | reference | `GET [base]/Media?subject={Type/}[id]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Medication

Base System Profile

[臺灣核心-藥品（TW Core Medication）](StructureDefinition-Medication-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Medication-id.md) | token | `GET [base]/Medication?_id=[id]`,`GET [base]/Medication/[id]` |
| **建議應該（SHOULD）** | [code](SearchParameter-Medication-code.md) | token | `GET [base]/Medication?code={system|}[code]` |

 

#### 預期的遵從度： 建議應該（SHOULD） MedicationRequest

Base System Profile

[臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-MedicationRequest-id.md) | token | `GET [base]/MedicationRequest?_id=[id]`,`GET [base]/MedicationRequest/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-MedicationRequest-status.md) | token | `GET [base]/MedicationRequest?status=[code]` |
| **建議應該（SHOULD）** | [intent](SearchParameter-MedicationRequest-intent.md) | token | `GET [base]/MedicationRequest?intent={system|}[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-MedicationRequest-subject.md) | reference | `GET [base]/MedicationRequest?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [medication](SearchParameter-MedicationRequest-medication.md) | reference | `GET [base]/MedicationRequest?medication={Type/}[id]` |
| **建議應該（SHOULD）** | [encounter](SearchParameter-MedicationRequest-encounter.md) | reference | `GET [base]/MedicationRequest?encounter={Type/}[id]` |
| **建議應該（SHOULD）** | [authoredon](SearchParameter-MedicationRequest-authoredon.md) | date | `GET [base]/MedicationRequest?authoredon={gt|lt|ge|le}[date]` |

 

#### 預期的遵從度： 建議應該（SHOULD） MedicationDispense

Base System Profile

[臺灣核心-配藥或藥品調劑（TW Core MedicationDispense）](StructureDefinition-MedicationDispense-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-MedicationDispense-id.md) | token | `GET [base]/MedicationDispense?_id=[id]`,`GET [base]/MedicationDispense/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-MedicationDispense-status.md) | token | `GET [base]/MedicationDispense?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-MedicationDispense-subject.md) | reference | `GET [base]/MedicationDispense?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [medication](SearchParameter-MedicationDispense-medication.md) | reference | `GET [base]/MedicationDispense?medication={Type/}[id]` |

 

#### 預期的遵從度： 建議應該（SHOULD） MedicationStatement

Base System Profile

[臺灣核心-用藥聲明（TW Core MedicationStatement）](StructureDefinition-MedicationStatement-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-MedicationStatement-id.md) | token | `GET [base]/MedicationStatement?_id=[id]`,`GET [base]/MedicationStatement/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-MedicationStatement-status.md) | token | `GET [base]/MedicationStatement?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-MedicationStatement-subject.md) | reference | `GET [base]/MedicationStatement?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [medication](SearchParameter-MedicationStatement-medication.md) | reference | `GET [base]/MedicationStatement?medication={Type/}[id]` |

 

#### 預期的遵從度： 建議應該（SHOULD） MessageHeader

Base System Profile

[臺灣核心-訊息表頭（TW Core MessageHeader）](StructureDefinition-MessageHeader-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-MessageHeader-id.md) | token | `GET [base]/MessageHeader?_id=[id]`,`GET [base]/MessageHeader/[id]` |
| **建議應該（SHOULD）** | [author](SearchParameter-MessageHeader-author.md) | reference | `GET [base]/MessageHeader?author={Type/}[id]` |
| **建議應該（SHOULD）** | [sender](SearchParameter-MessageHeader-sender.md) | reference | `GET [base]/MessageHeader?sender={Type/}[id]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

支援的Profiles
[臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）](StructureDefinition-Observation-averageBloodPressure-twcore.md)
[臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）](StructureDefinition-Observation-careExperiencePreference-twcore.md)
[臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）](StructureDefinition-Observation-clinical-result-twcore.md)
[臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)
[臺灣核心-職業（TW Core Observation Occupation）](StructureDefinition-Observation-occupation-twcore.md)
[臺灣核心-妊娠計畫（TW Core Observation Pregnancy Intent）](StructureDefinition-Observation-pregnancy-intent-twcore.md)
[臺灣核心-妊娠狀態（TW Core Observation Pregnancy Status）](StructureDefinition-Observation-pregnancy-status-twcore.md)
[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)
[臺灣核心-性傾向（TW Core Observation Sexual Orientation）](StructureDefinition-Observation-sexual-orientation-twcore.md)
[臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)
[臺灣核心-吸菸狀態（TW Core Smoking Status Observation）](StructureDefinition-Observation-smoking-status-twcore.md)
[臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference）](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)
[臺灣核心-生命體徵（TW Core Observation Vital Signs）](StructureDefinition-Observation-vitalSigns-twcore.md)
[臺灣核心-兒童及青少年身體質量指數（TW Core Pediatric BMI for Age Observation）](StructureDefinition-Observation-pediatric-bmi-age-twcore.md)
[臺灣核心-血壓（TW Core Observation Blood Pressure）](StructureDefinition-Observation-bloodPressure-twcore.md)
[臺灣核心-身體質量指數（TW Core Observation BMI）](StructureDefinition-Observation-bmi-twcore.md)
[臺灣核心-身高（TW Core Observation Body Height）](StructureDefinition-Observation-body-height-twcore.md)
[臺灣核心-體溫（TW Core Observation Body Temperature）](StructureDefinition-Observation-body-temperature-twcore.md)
[臺灣核心-體重（TW Core Observation Body Weight）](StructureDefinition-Observation-body-weight-twcore.md)
[臺灣核心-頭圍（TW Core Observation Head Circumference）](StructureDefinition-Observation-head-circumference-twcore.md)
[臺灣核心-心率（TW Core Observation Heart Rate）](StructureDefinition-Observation-heart-rate-twcore.md)
[臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）](StructureDefinition-Observation-pulse-oximetry-twcore.md)
[臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）](StructureDefinition-Observation-respiratory-rate-twcore.md)
[臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile）](StructureDefinition-Observation-pediatric-head-circumference-twcore.md)

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Observation-id.md) | token | `GET [base]/Observation?_id=[id]`,`GET [base]/Observation/[id]` |
| **建議應該（SHOULD）** | [category](SearchParameter-Observation-category.md) | token | `GET [base]/Observation?category={system|}[code]` |
| **建議應該（SHOULD）** | [code](SearchParameter-Observation-clinical-code.md) | token | `GET [base]/Observation?code={system|}[code]` |
| **建議應該（SHOULD）** | [date](SearchParameter-Observation-date.md) | date | `GET [base]/Observation?date={gt|lt|ge|le}[date]` |
| **建議應該（SHOULD）** | [performer](SearchParameter-Observation-performer.md) | reference | `GET [base]/Observation?performer={Type/}[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-Observation-status.md) | token | `GET [base]/Observation?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-Observation-subject.md) | reference | `GET [base]/Observation?subject={Type/}[id]` |
| **必須（SHALL）** | [patient](SearchParameter-Observation-patient.md)+[category](SearchParameter-Observation-category.md) | reference+token | `GET [base]/Observation?patient={Type/}[id]&category={system|}[code]` |
| **必須（SHALL）** | [patient](SearchParameter-Observation-patient.md)+[code](SearchParameter-Observation-clinical-code.md) | reference+token | `GET [base]/Observation?patient={Type/}[id]&code={system|}[code]` |
| **必須（SHALL）** | [patient](SearchParameter-Observation-patient.md)+[category](SearchParameter-Observation-category.md)+[date](SearchParameter-Observation-date.md) | reference+token+date | `GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&date={gt|lt|ge|le}[date]` |
| **建議應該（SHOULD）** | [patient](SearchParameter-Observation-patient.md)+[category](SearchParameter-Observation-category.md)+[status](SearchParameter-Observation-status.md) | reference+token | `GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&status=[code]` |
| **建議應該（SHOULD）** | [patient](SearchParameter-Observation-patient.md)+[category](SearchParameter-Observation-category.md)+[_lastUpdated](SearchParameter-Observation-lastupdated.md) | reference+token+date | `GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]` |
| **建議應該（SHOULD）** | [patient](SearchParameter-Observation-patient.md)+[code](SearchParameter-Observation-clinical-code.md)+[date](SearchParameter-Observation-date.md) | reference+token+date | `GET [base]/Observation?patient={Type/}[id]&code={system|}[code]&date={gt|lt|ge|le}[date]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Organization

Base System Profile

[臺灣核心-機構（TW Core Organization）](StructureDefinition-Organization-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

支援的Profiles
[臺灣核心-政府機構（TW Core Organization Government）](StructureDefinition-Organization-govt-twcore.md)
[臺灣核心-醫事機構（TW Core Organization Hospital Department）](StructureDefinition-Organization-hosp-twcore.md)
[臺灣核心-公司行號（TW Core Organization Company）](StructureDefinition-Organization-co-twcore.md)

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Organization-id.md) | token | `GET [base]/Organization?_id=[id]`,`GET [base]/Organization/[id]` |
| **建議應該（SHOULD）** | [identifier](SearchParameter-Organization-identifier.md) | token | `GET [base]/Organization?identifier={system|}[code]` |
| **建議應該（SHOULD）** | [name](SearchParameter-Organization-name.md) | string | `GET [base]/Organization?name=[name]` |
| **建議應該（SHOULD）** | [type](SearchParameter-Organization-type.md) | token | `GET [base]/Organization?type={system|}[code]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Patient

Base System Profile

[臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Patient-id.md) | token | `GET [base]/Patient?_id=[id]`,`GET [base]/Patient/[id]` |
| **建議應該（SHOULD）** | [birthdate](SearchParameter-Patient-birthdate.md) | date | `GET [base]/Patient?birthdate={gt|lt|ge|le}[date]` |
| **建議應該（SHOULD）** | [gender](SearchParameter-Patient-gender.md) | token | `GET [base]/Patient?gender=[code]` |
| **建議應該（SHOULD）** | [identifier](SearchParameter-Patient-identifier.md) | token | `GET [base]/Patient?identifier={system|}[code]` |
| **建議應該（SHOULD）** | [name](SearchParameter-Patient-name.md) | string | `GET [base]/Patient?name=[name]` |

 

Operation

| | | |
| :--- | :--- | :--- |
| **建議應該（SHOULD）** | [$everything](OperationDefinition-Patient-everything.md) | `GET [base]/Patient/$everything`,`GET [base]/Patient/[id]/$everything` |

 

#### 預期的遵從度： 建議應該（SHOULD） Practitioner

Base System Profile

[臺灣核心-健康照護服務提供者（TW Core Practitioner）](StructureDefinition-Practitioner-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Practitioner-id.md) | token | `GET [base]/Practitioner?_id=[id]`,`GET [base]/Practitioner/[id]` |
| **建議應該（SHOULD）** | [identifier](SearchParameter-Practitioner-identifier.md) | token | `GET [base]/Practitioner?identifier={system|}[code]` |
| **建議應該（SHOULD）** | [name](SearchParameter-Practitioner-name.md) | string | `GET [base]/Practitioner?name=[name]` |

 

#### 預期的遵從度： 建議應該（SHOULD） PractitionerRole

Base System Profile

[臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）](StructureDefinition-PractitionerRole-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-PractitionerRole-id.md) | token | `GET [base]/PractitionerRole?_id=[id]`,`GET [base]/PractitionerRole/[id]` |
| **建議應該（SHOULD）** | [identifier](SearchParameter-PractitionerRole-identifier.md) | token | `GET [base]/PractitionerRole?identifier={system|}[code]` |
| **建議應該（SHOULD）** | [specialty](SearchParameter-PractitionerRole-specialty.md) | token | `GET [base]/PractitionerRole?specialty={system|}[code]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Procedure

Base System Profile

[臺灣核心-處置或手術（TW Core Procedure）](StructureDefinition-Procedure-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Procedure-id.md) | token | `GET [base]/Procedure?_id=[id]`,`GET [base]/Procedure/[id]` |
| **建議應該（SHOULD）** | [code](SearchParameter-Procedure-code.md) | token | `GET [base]/Procedure?code={system|}[code]` |
| **建議應該（SHOULD）** | [status](SearchParameter-Procedure-status.md) | token | `GET [base]/Procedure?status=[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-Procedure-subject.md) | reference | `GET [base]/Procedure?subject={Type/}[id]` |
| **建議應該（SHOULD）** | [date](SearchParameter-Procedure-date.md) | date | `GET [base]/Procedure?date={gt|lt|ge|le}[date]` |

 

#### 預期的遵從度： 建議應該（SHOULD） Provenance

Base System Profile

[臺灣核心-出處（TW Core Provenance）](StructureDefinition-Provenance-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

#### Resource Conformance: SHOULD QuestionnaireResponse

Base System Profile

[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） RelatedPerson

Base System Profile

[臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） ServiceRequest

Base System Profile

[臺灣核心-服務請求（TW Core ServiceRequest）](StructureDefinition-ServiceRequest-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要


 

#### 預期的遵從度： 建議應該（SHOULD） Specimen

Base System Profile

[臺灣核心-檢體（TW Core Specimen）](StructureDefinition-Specimen-twcore.md)

支援的參照政策（Reference policy）

`resolves`，Server會嘗試將邏輯參照（logical reference）解析為文字參照，意即轉換Reference.identifier為Reference.reference（但如果解析失敗，Server仍然會接收這個resource，請參閱
`logical`）。

能力摘要

* **建議應該（SHOULD）**支援 `search-type`、 `read`、 `vread`
* **可能可以（MAY）**支援 `create`、 `update`、 `delete`、`patch`

查詢參數摘要

| | | | |
| :--- | :--- | :--- | :--- |
| **建議應該（SHOULD）** | [_id](SearchParameter-Specimen-id.md) | token | `GET [base]/Specimen?_id=[id]`,`GET [base]/Specimen/[id]` |
| **建議應該（SHOULD）** | [status](SearchParameter-Specimen-status.md) | token | `GET [base]/Specimen?status=[code]` |
| **建議應該（SHOULD）** | [identifier](SearchParameter-Specimen-identifier.md) | token | `GET [base]/Specimen?identifier={system|}[code]` |
| **建議應該（SHOULD）** | [subject](SearchParameter-Specimen-subject.md) | reference | `GET [base]/Specimen?subject={Type/}[id]` |

 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "CapabilityStatementTWCoreClient",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/CapabilityStatement/CapabilityStatementTWCoreClient",
  "version" : "1.0.0",
  "name" : "CapabilityStatementTWCoreClient",
  "title" : "臺灣核心-用戶端（TW Core Client）",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-08-31",
  "publisher" : "衛生福利部",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心實作指引（TW Core IG）用戶端（Client）之能力聲明",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "https://twcore.mohw.gov.tw/ig/twcore/ImplementationGuide/tw.gov.mohw.twcore"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "臺灣核心-用戶端（TW Core Client） 建議應該（SHOULD）\n1. 使用臺灣核心-伺服端（TW Core Server）能力聲明中的查詢參數，支援讀取和查詢一個或多個臺灣核心Profile（s）。\n\n安全性：\n1. 有關要求和建議，請參閱一般安全注意事項部分。\n\n系統互動能力：\n - 可能可以（MAY）支援交易（transaction interaction）\n - 可能可以（MAY）支援批次（batch interaction）\n - 可能可以（MAY）支援查詢系統（search-system interaction）",
      "resource" : [
        {
          "type" : "AllergyIntolerance",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/AllergyIntolerance-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/AllergyIntolerance-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "clinical-status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/AllergyIntolerance-clinical-status",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Bundle",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "supportedProfile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-document-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-message-twcore"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            }
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Bundle-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Bundle-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "CarePlan",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/CarePlan-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "category",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/CarePlan-category",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/CarePlan-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/CarePlan-status",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "CareTeam",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/CareTeam-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/CareTeam-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "role",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/CareTeam-role",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Composition",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Composition-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Composition-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "type",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Composition-type",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Composition-subject",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Condition",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "clinical-status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Condition-clinical-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Condition-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Condition-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "onset-date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Condition-onset-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "abatement-date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Condition-abatement-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "severity",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Condition-severity",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Condition-id",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Coverage",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coverage-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Coverage-patient",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Device",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Device-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "type",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Device-type",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Device-status",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "DiagnosticReport",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DiagnosticReport-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DiagnosticReport-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "category",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DiagnosticReport-category",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DiagnosticReport-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DiagnosticReport-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DiagnosticReport-id",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "DocumentReference",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DocumentReference-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DocumentReference-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/DocumentReference-subject",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Encounter",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "class",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Encounter-class",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Encounter-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Encounter-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "location",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Encounter-location",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Encounter-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Encounter-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Encounter-id",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Goal",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Goal-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Goal-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "lifecycle-status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Goal-lifecycle-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "target-date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Goal-target-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "description",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Goal-description",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "ImagingStudy",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ImagingStudy-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ImagingStudy-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ImagingStudy-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "encounter",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ImagingStudy-encounter",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "started",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ImagingStudy-started",
              "type" : "date"
            }
          ]
        },
        {
          "type" : "Immunization",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Immunization-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Immunization-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Immunization-date",
              "type" : "date"
            }
          ]
        },
        {
          "type" : "Location",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Location-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "address",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Location-address",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Location-name",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "Media",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Media-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Media-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Media-subject",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Medication",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Medication-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Medication-code",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "MedicationRequest",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationRequest-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationRequest-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "intent",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationRequest-intent",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationRequest-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "encounter",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationRequest-encounter",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "authoredon",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationRequest-authoredon",
              "type" : "date"
            }
          ]
        },
        {
          "type" : "MedicationDispense",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationDispense-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationDispense-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationDispense-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "medication",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationDispense-medication",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "MedicationStatement",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationStatement-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationStatement-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationStatement-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "medication",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MedicationStatement-medication",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "MessageHeader",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MessageHeader-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MessageHeader-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "author",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MessageHeader-author",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "sender",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/MessageHeader-sender",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Observation",
          "supportedProfile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-averageBloodPressure-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-careExperiencePreference-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-occupation-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-intent-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-status-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-screening-assessment-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-sexual-orientation-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-simple-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-smoking-status-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-treatment-intervention-preference-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pediatric-bmi-age-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bloodPressure-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bmi-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-height-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-temperature-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-body-weight-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-head-circumference-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-heart-rate-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pulse-oximetry-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-respiratory-rate-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pediatric-head-circumference-twcore"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            }
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "category",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-category",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-clinical-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "performer",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-performer",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_lastUpdated",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-lastupdated",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Observation-patient",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Organization",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "supportedProfile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-hosp-twcore",
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-co-twcore"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            }
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Organization-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Organization-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Organization-name",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "type",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Organization-type",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Patient",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Patient-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "birthdate",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Patient-birthdate",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "gender",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Patient-gender",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Patient-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Patient-name",
              "type" : "string"
            }
          ],
          "operation" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "everything",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/OperationDefinition/Patient-everything"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Practitioner-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Practitioner-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Practitioner-name",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "PractitionerRole",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/PractitionerRole-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/PractitionerRole-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "specialty",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/PractitionerRole-specialty",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Procedure",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Procedure-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Procedure-code",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Procedure-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Procedure-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "date",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Procedure-date",
              "type" : "date"
            }
          ]
        },
        {
          "type" : "Provenance",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Provenance-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"]
        },
        {
          "type" : "QuestionnaireResponse",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/QuestionnaireResponse-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/QuestionnaireResponse-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/QuestionnaireResponse-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "authored",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/QuestionnaireResponse-authored",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "questionnaire",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/QuestionnaireResponse-questionnaire",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "RelatedPerson",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/RelatedPerson-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/RelatedPerson-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/RelatedPerson-name",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "ServiceRequest",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ServiceRequest-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ServiceRequest-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "category",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ServiceRequest-category",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "authored",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ServiceRequest-authored",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ServiceRequest-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "code",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/ServiceRequest-code",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Specimen",
          "profile" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch"
            }
          ],
          "referencePolicy" : ["resolves"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "_id",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Specimen-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "status",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Specimen-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Specimen-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "subject",
              "definition" : "https://twcore.mohw.gov.tw/ig/twcore/SearchParameter/Specimen-subject",
              "type" : "reference"
            }
          ]
        }
      ]
    }
  ]
}

```
