# Message request(傳送) - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Bundle: Message request(傳送)



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bun-message-request-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-message-twcore"
    ]
  },
  "identifier" : {
    "system" : "https://www.tph.mohw.gov.tw",
    "value" : "01014857930415100000000"
  },
  "type" : "message",
  "timestamp" : "2023-12-01T12:34:56.000Z",
  "entry" : [
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/MessageHeader/mes-request-example",
      "resource" : {
        "resourceType" : "MessageHeader",
        "id" : "mes-request-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MessageHeader-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MessageHeader_mes-request-example\"> </a><h3><b>訊息表頭－request</b></h3><p><b>訊息事件代碼</b>: Laboratory report <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://loinc.org\">LOINC</a>#11502-2)</span></p><p><b>訊息發送來源</b>: https://tpech.gov.taipei/</p><p><b>訊息內容</b>：</p><blockquote><p><b>檢驗報告</b>：<a href=\"DiagnosticReport-dia-example.html\">DiagnosticReport/dia-example</a></p><p><b>病人</b>：<a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>檢驗檢查資料</b>：<a href=\"Observation-obs-lab-example.html\">Observation/obs-lab-example</a></p></blockquote></div>"
        },
        "eventCoding" : {
          "system" : "http://loinc.org",
          "code" : "11502-2",
          "display" : "Laboratory report"
        },
        "source" : {
          "endpoint" : "https://tpech.gov.taipei/"
        },
        "focus" : [
          {
            "reference" : "DiagnosticReport/dia-example"
          },
          {
            "reference" : "Patient/pat-example"
          },
          {
            "reference" : "Observation/obs-lab-example"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Patient/pat-example",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "pat-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_pat-example\"> </a><h3><b>病人基本資料-身分證字號及病歷號</b></h3><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx <b>[extension: <a href=\"StructureDefinition-identifier-suffix.html\">Identifier Suffix</a>]：</b>TWN）</span><br/><b>身分證字號（official）</b>：A123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical record number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MR）</span><br/><b>病歷號（official）</b>：8862168 （https://www.tph.mohw.gov.tw）</p></blockquote><p><b>病人的紀錄（active）</b>：使用中</p><p><b>姓名（official）</b>：陳加玲 Chan, Chia Lin</p><p><b>性別</b>：女性</p><p><b>出生日期</b>：1990-01-01</p><p><b>年齡[extension: <a href=\"StructureDefinition-person-age.html\">person-age</a>]</b>：32</p><p><b>國籍[extension: <a href=\"http://hl7.org/fhir/StructureDefinition/patient-nationality\">patient-nationality</a>]</b>：<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://terminology.hl7.org/CodeSystem-ISO3166Part1.html\">ISO3166Part1</a>#TW）</span></p><p><b>聯絡方式</b>：Phone <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0911327999 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>聯絡地址</b>：(103)臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室<br/><b>郵遞區號（postalCode） [extension: <a href=\"StructureDefinition-tw-postal-code.html\">tw-postal-code</a>] </b>： <a href=\"CodeSystem-postal-code3-tw.html\">103</a><br/><b>縣/市（district）</b>：臺北市<br/><b>鄉/鎮/市/區（city）</b>：大同區<br/><b>村(里)（village） [extension: <a href=\"StructureDefinition-tw-village.html\">tw-village</a>] </b>：大有里<br/><b>鄰（neighborhood） [extension: <a href=\"StructureDefinition-tw-neighborhood.html\">tw-neighborhood</a>] </b>：19鄰<br/><b>路/街（line）</b>：承德路<br/><b>段(section) [extension: <a href=\"StructureDefinition-tw-section.html\">tw-section</a>] </b>：三段<br/><b>巷/衖（lane） [extension: <a href=\"StructureDefinition-tw-lane.html\">tw-lane</a>] </b>：52巷<br/><b>弄（alley） [extension: <a href=\"StructureDefinition-tw-alley.html\">tw-alley</a>] </b>：6弄<br/><b>號（number） [extension: <a href=\"StructureDefinition-tw-number.html\">tw-number</a>] </b>：210號<br/><b>樓（floor） [extension: <a href=\"StructureDefinition-tw-floor.html\">tw-floor</a>] </b>：2樓<br/><b>室（room） [extension: <a href=\"StructureDefinition-tw-room.html\">tw-room</a>] </b>：B室<br/><b>國家（country）</b>：臺灣<br/><br/></p><p><b>婚姻狀態</b>：unmarried <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v3-MaritalStatus\">臺灣婚姻狀態值集</a>#U）</span></p><p><b>聯絡人（official）</b>：李立偉 Li, Li Wei<br/><b>關係</b>：father <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v3-RoleCode\">PatientRelationshipType</a>#FTH）</span><br/><b>聯絡方式</b>：Phone <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0917159753 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>向病人說明健康狀態時所使用的語言</b>：中文</p><p><b>紀錄的保管機構</b>： <a href=\"Organization-org-hosp-example.html\">Organization/org-hosp-example</a> &quot;衛生福利部臺北醫院&quot;</p><p><b>病人影像</b>： <a href=\"https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png\">patient.png</a><br/><img src=\"https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png\" width=\"250px\"/></p></div>"
        },
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age",
            "valueAge" : {
              "value" : 32,
              "system" : "http://unitsofmeasure.org",
              "code" : "a"
            }
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "TW"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
          }
        ],
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx",
                  "_code" : {
                    "extension" : [
                      {
                        "extension" : [
                          {
                            "url" : "suffix",
                            "valueString" : "TWN"
                          },
                          {
                            "url" : "valueSet",
                            "valueCanonical" : "http://hl7.org/fhir/ValueSet/iso3166-1-3"
                          }
                        ],
                        "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
                      }
                    ]
                  }
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "A123456789"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR"
                }
              ]
            },
            "system" : "https://www.tph.mohw.gov.tw",
            "value" : "8862168"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "text" : "陳加玲",
            "family" : "Chen",
            "given" : ["Chia Lin"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0911327999",
            "use" : "mobile",
            "period" : {
              "start" : "2022-07-31",
              "end" : "2024-07-31"
            }
          }
        ],
        "gender" : "female",
        "birthDate" : "1990-01-01",
        "address" : [
          {
            "extension" : [
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-section",
                "valueString" : "三段"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
                "valueString" : "210號"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-village",
                "valueString" : "大有里"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-neighborhood",
                "valueString" : "19鄰"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-lane",
                "valueString" : "52巷"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-alley",
                "valueString" : "6弄"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-floor",
                "valueString" : "2樓"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-room",
                "valueString" : "B室"
              }
            ],
            "text" : "臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室",
            "line" : ["承德路"],
            "city" : "大同區",
            "district" : "臺北市",
            "_postalCode" : {
              "extension" : [
                {
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                        "code" : "103"
                      }
                    ]
                  }
                }
              ]
            },
            "country" : "TW"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "U"
            }
          ]
        },
        "photo" : [
          {
            "contentType" : "image/jpeg",
            "url" : "patient.png"
          }
        ],
        "contact" : [
          {
            "relationship" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                    "code" : "FTH"
                  }
                ]
              }
            ],
            "name" : {
              "use" : "official",
              "text" : "李立偉",
              "family" : "Li",
              "given" : ["Li Wei"]
            },
            "telecom" : [
              {
                "system" : "phone",
                "value" : "0917159753",
                "use" : "mobile",
                "period" : {
                  "start" : "2022-07-31",
                  "end" : "2024-07-31"
                }
              }
            ]
          }
        ],
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "zh-TW"
                }
              ]
            }
          }
        ],
        "managingOrganization" : {
          "reference" : "Organization/org-hosp-example"
        }
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Observation/obs-lab-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-lab-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_obs-lab-example\"> </a><h3><b>檢驗檢查資料</b></h3><p><b>狀態</b>：最終版(final)</p><p><b>分類</b>：Laboratory <span style=\"background: LightGoldenRodYellow; margin：4px; border：1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-observation-category.html\">Observation Category Codes</a>#laboratory)</span></p><p><b>檢驗項目</b>：血中尿素氮 <span style=\"background: LightGoldenRodYellow; margin：4px; border：1px solid khaki\">( <a href=\"CodeSystem-medical-service-payment-tw.html\">臺灣醫療服務給付項目</a>#09002C)</span></p><p><b>病人</b>： <a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>執行日期</b>：2022-07-31</p><p><b>負責機構</b>： <a href=\"Organization-org-hosp-example.html\">Organization/org-hosp-example</a> &quot;衛生福利部臺北醫院&quot;</p><p><b>檢驗值</b>：16.6 mg/dL</p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
              "code" : "09002C"
            }
          ],
          "text" : "血中尿素氮"
        },
        "subject" : {
          "reference" : "Patient/pat-example"
        },
        "effectiveDateTime" : "2022-07-31",
        "performer" : [
          {
            "reference" : "Organization/org-hosp-example"
          }
        ],
        "valueQuantity" : {
          "value" : 16.6,
          "unit" : "mg/dL"
        }
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/DiagnosticReport/dia-example",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "dia-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_dia-example\"> </a><h3><b>診斷報告</b></h3><p><b>診斷狀態</b>：Remission <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/valueset-diagnostic-report-status.html\">DiagnosticReportStatus</a>#registered)</span></p><p><b>診斷分類</b>：Laboratory <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/valueset-diagnostic-service-sections.html\">DiagnosticServiceSectionCodes</a>#LAB)</span></p><p><b>病人</b>：<a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>臨床相關報告時間</b>：2022-08-01 05:00:14-0500</p><p><b>診斷報告時間</b>：2022-08-01 06:00:14-0500</p><p><b>病情、問題或診斷識別</b>：血中尿素氮<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> ( <a href=\"http://loinc.org\">LOINC</a>#09002C)</span></p><p><b>診斷結果</b>：<a href=\"Observation-obs-lab-example.html\">Observation/obs-lab-example</a></p><p><b>診斷者</b>：<a href=\"Practitioner-pra-dr-example.html\">Practitioner/pra-dr-example</a> &quot;王依昇&quot;</p></div>"
        },
        "status" : "registered",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "LAB",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
              "code" : "09002C",
              "display" : "血中尿素氮"
            }
          ],
          "text" : "血中尿素氮"
        },
        "subject" : {
          "reference" : "Patient/pat-example"
        },
        "effectiveDateTime" : "2022-08-01T17:00:14+08:00",
        "issued" : "2022-08-01T18:00:14+08:00",
        "performer" : [
          {
            "reference" : "Practitioner/pra-dr-example"
          }
        ],
        "result" : [
          {
            "reference" : "Observation/obs-lab-example"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Practitioner/pra-dr-example",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "pra-dr-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_pra-dr-example\"> </a><h3><b>醫師基本資料</b></h3><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx）</span><br/><b>身分證字號（official）</b>：D123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical License number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MD）</span><br/><b>員工編號（official）</b>：KP00017 （https://www.tph.mohw.gov.tw）</p></blockquote><p><b>健康照護服務提供者的紀錄（active）</b>：使用中</p><p><b>姓名（official）</b>：王依昇 Wang, Yi Sheng</p><p><b>性別</b>：男性</p><p><b>出生日期</b>：1980-11-11</p><p><b>聯絡方式</b>：Phone<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0993277826<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>聯絡地址</b>：(330)桃園市桃園區五福五街31號<br/><b>郵遞區號（postalCode）[extension: <a href=\"StructureDefinition-tw-postal-code.html\">tw-postal-code</a>]</b>：<a href=\"CodeSystem-postal-code3-tw.html\">330</a><br/><b>縣/市（district）</b>：桃園市<br/><b>鄉/鎮/市/區（city）</b>：桃園區<br/><b>路/街（line）</b>：五福五街<br/><b>號（number）[extension: <a href=\"StructureDefinition-tw-number.html\">tw-number</a>]</b>：31號<br/><b>國家（country）</b>：臺灣<br/></p><p><b>資格證書的型別</b>：西醫師 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://snomed.info/sct\">SNOMED CT</a>#394802001）</span><br/><b>資格證書的開始日期</b>：2005-05-25</p><p><b>照護服務提供人員影像</b>： <a href=\"https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png\">doctor.png</a><br/><img src=\"https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png\" width=\"250px\"/></p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx"
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "D123456789"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MD"
                }
              ]
            },
            "system" : "https://www.tph.mohw.gov.tw",
            "value" : "KP00017"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "text" : "王依昇",
            "family" : "Wang",
            "given" : ["Yi Sheng"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0993277826",
            "use" : "mobile",
            "period" : {
              "start" : "2022-07-31",
              "end" : "2024-07-31"
            }
          }
        ],
        "address" : [
          {
            "extension" : [
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
                "valueString" : "31號"
              }
            ],
            "text" : "桃園市桃園區五福五街31號",
            "line" : ["五福五街"],
            "city" : "桃園區",
            "district" : "桃園市",
            "_postalCode" : {
              "extension" : [
                {
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                        "code" : "330"
                      }
                    ]
                  }
                }
              ]
            },
            "country" : "TW"
          }
        ],
        "gender" : "male",
        "birthDate" : "1980-11-11",
        "photo" : [
          {
            "contentType" : "image/png",
            "data" : "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=",
            "url" : "doctor.png"
          }
        ],
        "qualification" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "394802001",
                  "display" : "General medicine"
                }
              ]
            },
            "period" : {
              "start" : "2005-05-25"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Organization/org-hosp-example",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "org-hosp-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-hosp-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_org-hosp-example\"> </a><h3><b>醫事機構基本資料</b></h3><p><b>機構名稱</b>：衛生福利部臺北醫院</p><p><b>識別碼型別</b>：Provider number<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">IdentifierType</a>#PRN）</span><br/><b>機構代碼（official）</b>：0131060029 (https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw)</p><p><b>機構種類</b>：Healthcare Provider <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-organization-type.html\">OrganizationType</a>#prov)</span></p><p><b>聯絡方式</b>：Phone<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：0222765566</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN"
                }
              ]
            },
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw",
            "value" : "0131060029"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "prov"
              }
            ]
          }
        ],
        "name" : "衛生福利部臺北醫院",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0222765566"
          }
        ]
      }
    }
  ]
}

```
