# Document(uuid) - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Bundle: Document(uuid)



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bun-document-uuid-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-document-twcore"
    ]
  },
  "identifier" : {
    "system" : "https://www.mohw.gov.tw/",
    "value" : "urn:uuid:d8b288cc-7a2b-4c30-b878-300d4ddd0ac0"
  },
  "type" : "document",
  "timestamp" : "2024-05-18T12:34:56.000Z",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:110860b4-9ab4-4595-9f03-7dca4c1021f8",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "Inline-Composition-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_Inline-Composition-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition Inline-Composition-example</b></p><a name=\"Inline-Composition-example\"> </a><a name=\"hcInline-Composition-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Composition-twcore.html\">TW Core Composition</a></p></div><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 11503-0}\">Medical records</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 47039-3}\">Hospital Admission history and physical note</span></p><p><b>date</b>: 2023-09-10 10:30:00+0000</p><p><b>author</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-0511b38b-2841-473c-9843-4d04c0c9c30e\">Practitioner 王依昇(official)</a></p><p><b>title</b>: 陳加玲的病摘</p><p><b>confidentiality</b>: restricted</p><h3>Attesters</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Mode</b></td><td><b>Time</b></td><td><b>Party</b></td></tr><tr><td style=\"display: none\">*</td><td>Personal</td><td>2023-09-10 11:00:00+0000</td><td><a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-0511b38b-2841-473c-9843-4d04c0c9c30e\">Practitioner 王依昇(official)</a></td></tr></table><p><b>custodian</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-c89f7cb5-8755-4848-b96a-a9fa34120588\">Organization 衛生福利部臺北醫院</a></p><h3>Events</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Period</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode MEDLIST}\">medication list</span></td><td>2023-09-10 08:00:00+0000 --&gt; 2023-09-15 09:30:00+0000</td></tr></table></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11503-0",
              "display" : "Medical records"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "47039-3"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "urn:uuid:38bc075a-2e1d-4f8c-b623-4d15770d9844"
        },
        "date" : "2023-09-10T10:30:00Z",
        "author" : [
          {
            "reference" : "urn:uuid:0511b38b-2841-473c-9843-4d04c0c9c30e"
          }
        ],
        "title" : "陳加玲的病摘",
        "confidentiality" : "R",
        "attester" : [
          {
            "mode" : "personal",
            "time" : "2023-09-10T11:00:00Z",
            "party" : {
              "reference" : "urn:uuid:0511b38b-2841-473c-9843-4d04c0c9c30e"
            }
          }
        ],
        "custodian" : {
          "reference" : "urn:uuid:c89f7cb5-8755-4848-b96a-a9fa34120588"
        },
        "event" : [
          {
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                    "code" : "MEDLIST",
                    "display" : "medication list"
                  }
                ]
              }
            ],
            "period" : {
              "start" : "2023-09-10T08:00:00Z",
              "end" : "2023-09-15T09:30:00Z"
            }
          }
        ],
        "section" : [
          {
            "entry" : [
              {
                "reference" : "urn:uuid:0511b38b-2841-473c-9843-4d04c0c9c30e"
              },
              {
                "reference" : "urn:uuid:e874d417-c6e5-4872-8dd7-62e6c5a9d08e"
              },
              {
                "reference" : "urn:uuid:7127fcd8-c858-4824-802b-51e0d472c6d2"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:0511b38b-2841-473c-9843-4d04c0c9c30e",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Inline-Practitioner-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Inline-Practitioner-example\"> </a><h3><b>醫師基本資料</b></h3><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx）</span><br/><b>身分證字號（official）</b>：D123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical License number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MD）</span><br/><b>員工編號（official）</b>：KP00017 （https://www.tph.mohw.gov.tw）</p></blockquote><p><b>健康照護服務提供者的紀錄（active）</b>：使用中</p><p><b>姓名（official）</b>：王依昇 Wang, Yi Sheng</p><p><b>性別</b>：男性</p><p><b>出生日期</b>：1980-11-11</p><p><b>聯絡方式</b>：Phone<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0993277826<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>聯絡地址</b>：(330)桃園市桃園區五福五街31號<br/><b>郵遞區號（postalCode）[extension: <a href=\"StructureDefinition-tw-postal-code.html\">tw-postal-code</a>]</b>：<a href=\"CodeSystem-postal-code3-tw.html\">330</a><br/><b>縣/市（district）</b>：桃園市<br/><b>鄉/鎮/市/區（city）</b>：桃園區<br/><b>路/街（line）</b>：五福五街<br/><b>號（number）[extension: <a href=\"StructureDefinition-tw-number.html\">tw-number</a>]</b>：31號<br/><b>國家（country）</b>：臺灣<br/></p><p><b>資格證書的型別</b>：西醫師 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://snomed.info/sct\">SNOMED CT</a>#394802001）</span><br/><b>資格證書的開始日期</b>：2005-05-25</p><p><b>照護服務提供人員影像</b>： <a href=\"https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png\">doctor.png</a><br/><img src=\"https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png\" width=\"250px\"/></p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx"
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "D123456789"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MD"
                }
              ]
            },
            "system" : "https://www.tph.mohw.gov.tw",
            "value" : "KP00017"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "text" : "王依昇",
            "family" : "Wang",
            "given" : ["Yi Sheng"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0993277826",
            "use" : "mobile",
            "period" : {
              "start" : "2022-07-31",
              "end" : "2024-07-31"
            }
          }
        ],
        "address" : [
          {
            "extension" : [
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
                "valueString" : "31號"
              }
            ],
            "text" : "桃園市桃園區五福五街31號",
            "line" : ["五福五街"],
            "city" : "桃園區",
            "district" : "桃園市",
            "_postalCode" : {
              "extension" : [
                {
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                        "code" : "330"
                      }
                    ]
                  }
                }
              ]
            },
            "country" : "TW"
          }
        ],
        "gender" : "male",
        "birthDate" : "1980-11-11",
        "photo" : [
          {
            "contentType" : "image/png",
            "data" : "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=",
            "url" : "doctor.png"
          }
        ],
        "qualification" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "394802001",
                  "display" : "General medicine"
                }
              ]
            },
            "period" : {
              "start" : "2005-05-25"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:38bc075a-2e1d-4f8c-b623-4d15770d9844",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "Inline-Patient-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_Inline-Patient-example\"> </a><h3><b>病人基本資料-身分證字號</b></h3><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx <b>[extension: <a href=\"StructureDefinition-identifier-suffix.html\">Identifier Suffix</a>]：</b>TWN）</span><br/><b>身分證字號（official）</b>：A123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical record number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MR）</span><br/><b>病歷號（official）</b>：8862168 （https://www.tph.mohw.gov.tw）</p></blockquote><p><b>病人的紀錄（active）</b>：使用中</p><p><b>姓名（official）</b>：陳加玲 Chan, Chia Lin</p><p><b>性別</b>：女性</p><p><b>出生日期</b>：1990-01-01</p><p><b>年齡[extension: <a href=\"StructureDefinition-person-age.html\">person-age</a>]</b>：32</p><p><b>國籍[extension: <a href=\"http://hl7.org/fhir/StructureDefinition/patient-nationality\">patient-nationality</a>]</b>：<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://terminology.hl7.org/CodeSystem-ISO3166Part1.html\">ISO3166Part1</a>#TW）</span></p><p><b>聯絡方式</b>：Phone <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0911327999 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>聯絡地址</b>：(103)臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室<br/><b>郵遞區號（postalCode） [extension: <a href=\"StructureDefinition-tw-postal-code.html\">tw-postal-code</a>] </b>： <a href=\"CodeSystem-postal-code3-tw.html\">103</a><br/><b>縣/市（city）</b>：臺北市<br/><b>鄉/鎮/市/區（district）</b>：大同區<br/><b>村(里)（village） [extension: <a href=\"StructureDefinition-tw-village.html\">tw-village</a>] </b>：大有里<br/><b>鄰（neighborhood） [extension: <a href=\"StructureDefinition-tw-neighborhood.html\">tw-neighborhood</a>] </b>：19鄰<br/><b>路/街（line）</b>：承德路<br/><b>段(section) [extension: <a href=\"StructureDefinition-tw-section.html\">tw-section</a>] </b>：三段<br/><b>巷/衖（lane） [extension: <a href=\"StructureDefinition-tw-lane.html\">tw-lane</a>] </b>：52巷<br/><b>弄（alley） [extension: <a href=\"StructureDefinition-tw-alley.html\">tw-alley</a>] </b>：6弄<br/><b>號（number） [extension: <a href=\"StructureDefinition-tw-number.html\">tw-number</a>] </b>：210號<br/><b>樓（floor） [extension: <a href=\"StructureDefinition-tw-floor.html\">tw-floor</a>] </b>：2樓<br/><b>室（room） [extension: <a href=\"StructureDefinition-tw-room.html\">tw-room</a>] </b>：B室<br/><b>國家（country）</b>：臺灣<br/><br/></p><p><b>婚姻狀態</b>：unmarried <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v3-MaritalStatus\">臺灣婚姻狀態值集</a>#U）</span></p><p><b>聯絡人（official）</b>：李立偉 Li, Li Wei<br/><b>關係</b>：father <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v3-RoleCode\">PatientRelationshipType</a>#FTH）</span><br/><b>聯絡方式</b>：Phone <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0917159753 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>向病人說明健康狀態時所使用的語言</b>：中文</p><p><b>紀錄的保管機構</b>： <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-c89f7cb5-8755-4848-b96a-a9fa34120588\">Organization Inline-Organization-example</a> &quot;衛生福利部臺北醫院&quot;</p><p><b>病人影像</b>： <a href=\"https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png\">patient.png</a><br/><img src=\"https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png\" width=\"250px\"/></p></div>"
        },
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age",
            "valueAge" : {
              "value" : 32,
              "system" : "http://unitsofmeasure.org",
              "code" : "a"
            }
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "TW"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
          }
        ],
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx",
                  "_code" : {
                    "extension" : [
                      {
                        "extension" : [
                          {
                            "url" : "suffix",
                            "valueString" : "TWN"
                          },
                          {
                            "url" : "valueSet",
                            "valueCanonical" : "http://hl7.org/fhir/ValueSet/iso3166-1-3"
                          }
                        ],
                        "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
                      }
                    ]
                  }
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "A123456789"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR"
                }
              ]
            },
            "system" : "https://www.tph.mohw.gov.tw",
            "value" : "8862168"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "text" : "陳加玲",
            "family" : "Chen",
            "given" : ["Chia Lin"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0911327999",
            "use" : "mobile",
            "period" : {
              "start" : "2022-07-31",
              "end" : "2024-07-31"
            }
          }
        ],
        "gender" : "female",
        "birthDate" : "1990-01-01",
        "address" : [
          {
            "extension" : [
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-section",
                "valueString" : "三段"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
                "valueString" : "210號"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-village",
                "valueString" : "大有里"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-neighborhood",
                "valueString" : "19鄰"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-lane",
                "valueString" : "52巷"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-alley",
                "valueString" : "6弄"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-floor",
                "valueString" : "2樓"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-room",
                "valueString" : "B室"
              }
            ],
            "text" : "臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室",
            "line" : ["承德路"],
            "city" : "臺北市",
            "district" : "大同區",
            "_postalCode" : {
              "extension" : [
                {
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                        "code" : "103"
                      }
                    ]
                  }
                }
              ]
            },
            "country" : "TW"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "U"
            }
          ]
        },
        "photo" : [
          {
            "contentType" : "image/png",
            "data" : "R0lGODlhEwARAPcAAAAAAAAA/+9aAO+1AP/WAP/eAP/eCP/eEP/eGP/nAP/nCP/nEP/nIf/nKf/nUv/nWv/vAP/vCP/vEP/vGP/vIf/vKf/vMf/vOf/vWv/vY//va//vjP/3c//3lP/3nP//tf//vf///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////yH5BAEAAAEALAAAAAATABEAAAi+AAMIDDCgYMGBCBMSvMCQ4QCFCQcwDBGCA4cLDyEGECDxAoAQHjxwyKhQAMeGIUOSJJjRpIAGDS5wCDly4AALFlYOgHlBwwOSNydM0AmzwYGjBi8IHWoTgQYORg8QIGDAwAKhESI8HIDgwQaRDI1WXXAhK9MBBzZ8/XDxQoUFZC9IiCBh6wEHGz6IbNuwQoSpWxEgyLCXL8O/gAnylNlW6AUEBRIL7Og3KwQIiCXb9HsZQoIEUzUjNEiaNMKAAAA7",
            "url" : "patient.png"
          }
        ],
        "contact" : [
          {
            "relationship" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                    "code" : "FTH"
                  }
                ]
              }
            ],
            "name" : {
              "use" : "official",
              "text" : "李立偉",
              "family" : "Li",
              "given" : ["Li Wei"]
            },
            "telecom" : [
              {
                "system" : "phone",
                "value" : "0917159753",
                "use" : "mobile",
                "period" : {
                  "start" : "2022-07-31",
                  "end" : "2024-07-31"
                }
              }
            ]
          }
        ],
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "zh-TW"
                }
              ]
            }
          }
        ],
        "managingOrganization" : {
          "reference" : "urn:uuid:c89f7cb5-8755-4848-b96a-a9fa34120588"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:6b744ffd-c264-4353-89ae-e9df7132536e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Observation-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Observation-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Observation-example</b></p><a name=\"Inline-Observation-example\"> </a><a name=\"hcInline-Observation-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-laboratoryResult-twcore.html\">TW Core Observation Laboratory Result</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw 09002C}\">血中尿素氮</span></p><p><b>subject</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-38bc075a-2e1d-4f8c-b623-4d15770d9844\">陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))</a></p><p><b>effective</b>: 2022-07-31</p><p><b>performer</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-c89f7cb5-8755-4848-b96a-a9fa34120588\">Organization 衛生福利部臺北醫院</a></p><p><b>value</b>: 16.6 mg/dL</p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
              "code" : "09002C"
            }
          ],
          "text" : "血中尿素氮"
        },
        "subject" : {
          "reference" : "urn:uuid:38bc075a-2e1d-4f8c-b623-4d15770d9844"
        },
        "effectiveDateTime" : "2022-07-31",
        "performer" : [
          {
            "reference" : "urn:uuid:c89f7cb5-8755-4848-b96a-a9fa34120588"
          }
        ],
        "valueQuantity" : {
          "value" : 16.6,
          "unit" : "mg/dL"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:e874d417-c6e5-4872-8dd7-62e6c5a9d08e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-ObservationBloodPressure-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bloodPressure-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-ObservationBloodPressure-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-ObservationBloodPressure-example</b></p><a name=\"Inline-ObservationBloodPressure-example\"> </a><a name=\"hcInline-ObservationBloodPressure-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Observation-bloodPressure-twcore.html\">TW Core Observation Blood Pressure</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 85354-9}\">Blood pressure panel with all children optional</span></p><p><b>subject</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-38bc075a-2e1d-4f8c-b623-4d15770d9844\">陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))</a></p><p><b>effective</b>: 2022-07-31</p><p><b>performer</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-0511b38b-2841-473c-9843-4d04c0c9c30e\">Practitioner 王依昇(official)</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8480-6}\">Systolic blood pressure</span></p><p><b>value</b>: 110 mmHg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8462-4}\">Diastolic blood pressure</span></p><p><b>value</b>: 56 mmHg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85354-9",
              "display" : "Blood pressure panel with all children optional"
            }
          ],
          "text" : "Blood pressure panel with all children optional"
        },
        "subject" : {
          "reference" : "urn:uuid:38bc075a-2e1d-4f8c-b623-4d15770d9844"
        },
        "effectiveDateTime" : "2022-07-31",
        "performer" : [
          {
            "reference" : "urn:uuid:0511b38b-2841-473c-9843-4d04c0c9c30e"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6",
                  "display" : "Systolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 110,
              "unit" : "mmHg",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4",
                  "display" : "Diastolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 56,
              "unit" : "mmHg",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:c89f7cb5-8755-4848-b96a-a9fa34120588",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "Inline-Organization-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_Inline-Organization-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization Inline-Organization-example</b></p><a name=\"Inline-Organization-example\"> </a><a name=\"hcInline-Organization-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Organization-twcore.html\">TW Core Organization</a></p></div><p><b>identifier</b>: Provider number/0131060029 (use: official, )</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/organization-type prov}\">Healthcare Provider</span></p><p><b>name</b>: 衛生福利部臺北醫院</p><p><b>telecom</b>: ph: 0222765566</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN"
                }
              ]
            },
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw",
            "value" : "0131060029"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "prov"
              }
            ]
          }
        ],
        "name" : "衛生福利部臺北醫院",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0222765566"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:7127fcd8-c858-4824-802b-51e0d472c6d2",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "Inline-MedicationRequest-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_Inline-MedicationRequest-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest Inline-MedicationRequest-example</b></p><a name=\"Inline-MedicationRequest-example\"> </a><a name=\"hcInline-MedicationRequest-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-MedicationRequest-twcore.html\">TW Core MedicationRequest</a></p></div><p><b>identifier</b>: <code>http://www.moi.gov.tw</code>/7077</p><p><b>status</b>: Active</p><p><b>statusReason</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason clarif}\">Prescription requires clarification</span></p><p><b>intent</b>: Order</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/medicationrequest-category discharge}\">Discharge</span></p><p><b>medication</b>: <span title=\"Codes:{https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw 衛署藥輸字第025485號}\">阿立批挫</span></p><p><b>subject</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-38bc075a-2e1d-4f8c-b623-4d15770d9844\">陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))</a></p><p><b>encounter</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-bde4b381-a715-4a2e-a95a-abb52407aba1\">Encounter: identifier = http://healthcare.example.org/identifiers/enocunter#E22081702; status = finished; class = pre-admission (ActCode#PRENC); type = Annual diabetes mellitus screening; serviceType = Nephrology; period = 2022-08-01 17:00:14+0800 --&gt; 2022-08-01 18:00:14+0800; reasonCode = FH: Diabetes mellitus</a></p><p><b>authoredOn</b>: 2022-08-01 18:00:14+0800</p><p><b>requester</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-0511b38b-2841-473c-9843-4d04c0c9c30e\">Practitioner 王依昇(official)</a></p><p><b>reasonReference</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-6b744ffd-c264-4353-89ae-e9df7132536e\">Observation 血中尿素氮</a></p><blockquote><p><b>dosageInstruction</b></p><p><b>text</b>: 三餐飯後，口服</p><p><b>timing</b>: Code </p><p><b>route</b>: <span title=\"Codes:{https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw PO}\">口服</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/dose-rate-type ordered}\">Ordered</span></td></tr></table></blockquote><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ValidityPeriod</b></td></tr><tr><td style=\"display: none\">*</td><td>2022-08-01 18:00:14+0800 --&gt; 2022-08-08 18:00:14+0800</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.moi.gov.tw",
            "value" : "7077"
          }
        ],
        "status" : "active",
        "statusReason" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason",
              "code" : "clarif"
            }
          ]
        },
        "intent" : "order",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code" : "discharge"
              }
            ]
          }
        ],
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw",
              "code" : "衛署藥輸字第025485號",
              "display" : "阿立批挫"
            }
          ],
          "text" : "阿立批挫"
        },
        "subject" : {
          "reference" : "urn:uuid:38bc075a-2e1d-4f8c-b623-4d15770d9844"
        },
        "encounter" : {
          "reference" : "urn:uuid:bde4b381-a715-4a2e-a95a-abb52407aba1"
        },
        "authoredOn" : "2022-08-01T18:00:14+08:00",
        "requester" : {
          "reference" : "urn:uuid:0511b38b-2841-473c-9843-4d04c0c9c30e"
        },
        "reasonReference" : [
          {
            "reference" : "urn:uuid:6b744ffd-c264-4353-89ae-e9df7132536e"
          }
        ],
        "dosageInstruction" : [
          {
            "text" : "三餐飯後，口服",
            "timing" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "PC"
                  }
                ],
                "text" : "三餐飯後"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw",
                  "code" : "PO"
                }
              ]
            },
            "doseAndRate" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                      "code" : "ordered"
                    }
                  ]
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2022-08-01T18:00:14+08:00",
            "end" : "2022-08-08T18:00:14+08:00"
          }
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:bde4b381-a715-4a2e-a95a-abb52407aba1",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "Inline-Encounter-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_Inline-Encounter-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter Inline-Encounter-example</b></p><a name=\"Inline-Encounter-example\"> </a><a name=\"hcInline-Encounter-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Encounter-twcore.html\">TW Core Encounter</a></p></div><p><b>identifier</b>: <code>http://healthcare.example.org/identifiers/enocunter</code>/E22081702</p><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-PRENC\">ActCode: PRENC</a> (pre-admission)</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/encounter-type ADMS}\">Annual diabetes mellitus screening</span></p><p><b>serviceType</b>: <span title=\"Codes:{http://snomed.info/sct 394589003}\">腎臟內科</span></p><p><b>subject</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-38bc075a-2e1d-4f8c-b623-4d15770d9844\">陳加玲(official) Female, DoB: 1990-01-01 ( Medical record number (use: official, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Period</b></td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ParticipationType PPRF}\">primary performer</span></td><td>2022-08-01 17:00:14+0800 --&gt; 2022-08-01 18:00:14+0800</td><td><a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-0511b38b-2841-473c-9843-4d04c0c9c30e\">Practitioner 王依昇(official)</a></td></tr></table><p><b>period</b>: 2022-08-01 17:00:14+0800 --&gt; 2022-08-01 18:00:14+0800</p><p><b>reasonCode</b>: <span title=\"Codes:{http://snomed.info/sct 160303001}\">FH: Diabetes mellitus</span></p><h3>Hospitalizations</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>DischargeDisposition</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/discharge-disposition home}\">Home</span></td></tr></table><h3>Locations</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Location</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-347ae3ea-82f3-41c8-9c95-88519f50a7c9\">Location 衛生福利部臺北醫院耳鼻喉科</a></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://healthcare.example.org/identifiers/enocunter",
            "value" : "E22081702"
          }
        ],
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "PRENC"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/encounter-type",
                "code" : "ADMS"
              }
            ]
          }
        ],
        "serviceType" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "394589003",
              "display" : "Nephrology"
            }
          ],
          "text" : "腎臟內科"
        },
        "subject" : {
          "reference" : "urn:uuid:38bc075a-2e1d-4f8c-b623-4d15770d9844"
        },
        "participant" : [
          {
            "type" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                    "code" : "PPRF"
                  }
                ]
              }
            ],
            "period" : {
              "start" : "2022-08-01T17:00:14+08:00",
              "end" : "2022-08-01T18:00:14+08:00"
            },
            "individual" : {
              "reference" : "urn:uuid:0511b38b-2841-473c-9843-4d04c0c9c30e"
            }
          }
        ],
        "period" : {
          "start" : "2022-08-01T17:00:14+08:00",
          "end" : "2022-08-01T18:00:14+08:00"
        },
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "160303001",
                "display" : "FH: Diabetes mellitus"
              }
            ]
          }
        ],
        "hospitalization" : {
          "dischargeDisposition" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/discharge-disposition",
                "code" : "home"
              }
            ]
          }
        },
        "location" : [
          {
            "location" : {
              "reference" : "urn:uuid:347ae3ea-82f3-41c8-9c95-88519f50a7c9"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:347ae3ea-82f3-41c8-9c95-88519f50a7c9",
      "resource" : {
        "resourceType" : "Location",
        "id" : "Inline-Location-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Location_Inline-Location-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Location Inline-Location-example</b></p><a name=\"Inline-Location-example\"> </a><a name=\"hcInline-Location-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-Location-twcore.html\">TW Core  Location</a></p></div><p><b>status</b>: Active</p><p><b>name</b>: 衛生福利部臺北醫院耳鼻喉科</p><p><b>description</b>: 診治各種耳、鼻、咽、喉等上呼吸道疾病及頭頸部腫瘤 , 包括 : 感冒、咳嗽、頭痛、喉嚨痛、聲音沙啞、吞嚥困難、呼吸不順、鼻塞、鼻竇炎、鼻過敏、鼻息肉、扁桃腺肥大、耳鳴、耳痛、中耳炎、顏面神經麻痺、顎顳關節痛、口乾舌燥、打鼾、語言障礙、食道異物取出、頭頸部腫瘤、舌及口咽腫瘤手術</p><p><b>mode</b>: Kind</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-RoleCode ENT}\">Otorhinolaryngology clinic</span></p><p><b>telecom</b>: ph: 02-2276-5566(Work)</p><p><b>address</b>: 242新北市新莊區思源路127號(work)</p><h3>Positions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Longitude</b></td><td><b>Latitude</b></td></tr><tr><td style=\"display: none\">*</td><td>25.043085494729105</td><td>121.45941895179722</td></tr></table><p><b>managingOrganization</b>: <a href=\"Bundle-bun-document-uuid-example.html#urn-uuid-c89f7cb5-8755-4848-b96a-a9fa34120588\">Organization 衛生福利部臺北醫院</a></p><blockquote><p><b>hoursOfOperation</b></p><p><b>daysOfWeek</b>: Monday, Tuesday, Wednesday, Thursday, Friday</p><p><b>allDay</b>: true</p></blockquote></div>"
        },
        "status" : "active",
        "name" : "衛生福利部臺北醫院耳鼻喉科",
        "description" : "診治各種耳、鼻、咽、喉等上呼吸道疾病及頭頸部腫瘤 , 包括 : 感冒、咳嗽、頭痛、喉嚨痛、聲音沙啞、吞嚥困難、呼吸不順、鼻塞、鼻竇炎、鼻過敏、鼻息肉、扁桃腺肥大、耳鳴、耳痛、中耳炎、顏面神經麻痺、顎顳關節痛、口乾舌燥、打鼾、語言障礙、食道異物取出、頭頸部腫瘤、舌及口咽腫瘤手術",
        "mode" : "kind",
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "ENT",
                "display" : "Otorhinolaryngology clinic"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "02-2276-5566",
            "use" : "work"
          }
        ],
        "address" : {
          "use" : "work",
          "type" : "both",
          "text" : "242新北市新莊區思源路127號",
          "line" : ["思源路127號"],
          "city" : "新莊區",
          "district" : "新北市",
          "postalCode" : "242"
        },
        "position" : {
          "longitude" : 25.043085494729105,
          "latitude" : 121.45941895179722
        },
        "managingOrganization" : {
          "reference" : "urn:uuid:c89f7cb5-8755-4848-b96a-a9fa34120588"
        },
        "hoursOfOperation" : [
          {
            "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
            "allDay" : true
          }
        ]
      }
    }
  ]
}

```
